{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 17 64 "Times-Bold" 17}{FONT
 4 "-adobe-times-bold-r-normal--17-*" "times" "Times-Bold" 8 17 
64 "Times-Bold" 17}{FONT 5 "-adobe-times-bold-r-normal--17-*" "ti
mes" "Times-Bold" 8 17 64 "Times-Bold" 17}{FONT 6 "-adobe-times-b
old-r-normal--17-*" "times" "Times-Bold" 8 17 64 "Times-Bold" 17}
{SCP_R 1 0 33{COM_R 2 0{TEXT 3 15 "Double Pendulum"}}{COM_R 3 0
{TEXT 1 9 "May, 1993"}}{COM_R 4 0{TEXT 1 15 "Daniel Schwalbe"}}
{COM_R 5 0{TEXT 1 115 "We consider in this worksheet an idealized
 model of a pendulum attached to a pendulum.  The picture is as f
ollows:\015"}}{INP_R 6 0 "> "{TEXT 0 178 "plot(\{[0,0,sin(Pi/3),-
cos(Pi/3),sin(Pi/3)+sin(Pi/6), -cos(Pi/3)-cos(Pi/6)],\012        
  [0,0,0,-1],[sin(Pi/3),-cos(Pi/3), sin(Pi/3),-cos(Pi/3)-1]\},-2.
.2,-2..0,scaling=constrained);"}}{COM_R 7 0{TEXT 1 272 "\015x wil
l represent the angle the top pendulum makes with the vertical an
d y willrepresent the angle the bottome pendulum makes with the v
ertical.  By appropriately choosingthe lengths, masses, and units
 used we assume the system satisifies the following system ofequa
tions:"}}{COM_R 8 0{TEXT 1 23 "x'' = -2sin(x) + sin(y)"}}{COM_R 9
 0{TEXT 1 23 "y'' = 2sin(x) - 2sin(y)"}}{COM_R 10 0{TEXT 1 64 "We
 numerically solve the system assuming the initial conditions:"}}
{COM_R 11 0{TEXT 1 9 "x(0)=Pi/2"}}{COM_R 12 0{TEXT 1 6 "y(0)=0"}}
{COM_R 13 0{TEXT 1 7 "x'(0)=0"}}{COM_R 14 0{TEXT 1 8 "y'(0)=0\015
"}}{COM_R 15 0{TEXT 1 227 "We first need to read in the ODE file 
which contains a 4th order Runge/Kutta solver called rungekuttahf
.  If you don't have the ODE.m file, change this to simply read O
DE;  You need the ODE or ODE.m file from the share library."}}
{INP_R 16 0 "> "{TEXT 0 70 "with(share): readshare(ODE,plots):  #
 load code from the share library"}}{INP_R 17 0 "> "{TEXT 0 15 "#
 read `ODE.m`;"}}{COM_R 18 0{TEXT 1 141 "We then express the syst
em of equations as a system of 4 first order equationswith an ini
tial condition in the form required by rungekuttahf."}}{INP_R 19 
0 "> "{TEXT 0 68 "dpeq:=(t,x,xp,y,yp)->[ xp, -2*sin(x)+sin(y), yp
,-2*sin(y)+2*sin(x)];"}}{OUT_R 20 0 19{DAG :3n4\`dpeq`@8,6n3\`t`n
3\`x`n3\`xp`n3\`y`n3\`yp`,1,3n5\`operator`n4\`arrow`p10[2,5a2x000
3+5(3n3\`sin`,2a2x0002i2x0002(3p20,2a2x0004j2x0001a2x0005+5p27p25
p1Fj2x0002p10p10}}{INP_R 21 0 "> "{TEXT 0 23 "dpinit:=[0,Pi/2,0,0
,0];"}}{OUT_R 22 0 21{DAG :3n4\`dpinit`[2,6j2x0000+3n3\`Pi`/3j2x0
001j2x0002p6p6p6}}{COM_R 23 0{TEXT 1 148 "Next we use rungekuttah
f to numerically solve the system.  We use a step sizeof 0.005 an
d take 1000 steps.  Note that only every 10th step is saved."}}
{INP_R 24 0 "> "{TEXT 0 44 "dppts:=rungekuttahf(dpeq,dpinit,.05,1
00,10):"}}{COM_R 25 0{TEXT 1 65 "One way to view the result is to
 produce an animation as follows:"}}{INP_R 26 0 "> "{TEXT 0 203 "
plots[display]([seq( plot([0,0, sin(dppts[i][2]),-cos(dppts[i][2]
), sin(dppts[i][2])+sin(dppts[i][4]), -cos(dppts[i][2])-cos(dppts
[i][4])], -2..2,-2..0,scaling=constrained), i=0..100)], insequenc
e=true);"}}{COM_R 27 0{TEXT 1 22 "\015Suggested follow-ups:"}}
{COM_R 28 0{TEXT 1 190 "1)  Derive the general model for a double
 pendulum, allowing for different masses attached to each pendulu
m and different lengths for each pendulum.  Also include the forc
eof air resistance."}}{COM_R 29 0{TEXT 1 71 "2)  Use Maple to fin
d an analytic solution to the linearized equations:"}}{COM_R 30 0
{TEXT 1 12 "x'' = -2x +y"}}{COM_R 31 0{TEXT 1 13 "y'' = 2x - 2y"}
}{COM_R 32 0{TEXT 1 34 "and compare with the above system."}}
{SEP_R 33 0}{INP_R 34 0 "> "{TEXT 0 0 ""}}}{END}
