{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-courier-medium-r-normal--17-*" "courier" "Cour
ier" 4 17 192 "Courier" 17}{FONT 4 "-adobe-times-bold-r-normal--1
7-*" "times" "Times-Bold" 8 17 64 "Times-Bold" 17}{FONT 5 "-adobe
-times-bold-r-normal--17-*" "times" "Times-Bold" 8 17 64 "Times-B
old" 17}{FONT 6 "-adobe-times-bold-r-normal--17-*" "times" "Times
-Bold" 8 17 64 "Times-Bold" 17}{SCP_R 1 0 39{COM_R 2 0{TEXT 1 68 
"Daniel Schwalbe\012Macalester College\012schwalbe@macalstr.edu\0
12July, 1993\015"}}{COM_R 3 0{TEXT 1 537 "In this worksheet we st
udy the logistic model of population growth, (dP/dt) = aP(t) - bP
(t)^2.  a and b are known as the vital coefficients of the popula
tion growth. In the exponential growth model (dP/dt) = kP(t), we 
can find a value for kif we are given the population at two diffe
rent times. We use Maple to show that in the logistics model we c
an calculate a and b if we are given the population at three diff
erent values which are equally spaced.  We use the U.S. populatio
n from 1790 to 1990 as a test case for theresulting model.\015"}}
{COM_R 4 0{TEXT 1 106 "We first make a table of the actual popula
tion of U.S. taken from a publication of the U.S. census bureau."
}}{INP_R 5 0 "> "{TEXT 0 342 "population:=table([\0121790=3929214
,\0121800=5308483,\0121810=7239881,\0121820=9638453,\0121830=1286
6020,\0121840=17069453,\0121850=23191876,\0121860=31433321,\01218
70=39818449,\0121880=50155783,\0121890=62947714,\0121900=75994575
,\0121910=91972266,\0121920=105710620,\0121930=122775046,\0121940
=131669275,\0121950=151325798,\0121960=179323175,\0121970=2033020
31,\0121980=226545805,\0121990=248709873\012]):\012"}}{COM_R 6 0
{TEXT 1 238 "We then define a function which represents the right
 hand side  of the differential equation. Before doing this, we a
ssume that a and b are positive real numbers.  Maplewill need thi
s information to compute a limit later in the worksheet."}}{INP_R
 7 0 "> "{TEXT 0 25 "assume(a>0); assume(b>0);"}}{INP_R 8 0 "> "
{TEXT 0 34 "logeq := unapply(a*P - b*P^2,t,P);"}}{OUT_R 9 0 8{DAG
 :3n4\`logeq`@8,3n3\`t`n3\`P`,1,3n5\`operator`n4\`arrow`pA+5*5n3\
`a~~`j2x0001a2x0002p18p18*5n3\`b~~`p18p1Aj2x0002i2x0001pApA}}
{COM_R 10 0{TEXT 1 516 "Before using Maple to analyze this equati
on we read in a file of procedures which are designed to analyze 
differential equations. The file is located in the share library.
 If you have an old version of the share library you may need to 
update it before some of  the commands in this worksheet will wor
k.  The following command will read in the file from the share li
brary.  It is assumed to be in the current working directory.  Yo
u may need to change this command to simply read ODE; if you don'
t have the .m file.\012"}}{INP_R 11 0 "> "{TEXT 0 34 "with(share)
: readshare(ODE,plots);"}}{INP_R 12 0 "> "{TEXT 0 15 "# read `ODE
.m`;"}}{COM_R 13 0{TEXT 1 112 "We can use Maple to look at a  dir
ection field for particular values of a and b, here we choose\012
a=2 and b = 1/2."}}{INP_R 14 0 "> "{TEXT 0 54 "directionfield(sub
s(a=2,b=1/2,eval(logeq)),0..8,0..6);"}}{COM_R 15 0{TEXT 1 184 "We
 can see from the direction field that the model predicts that th
e population levels off at 4. Can you verify that in general the 
model predicts the population leveling off at a/b ? "}}{COM_R 16 
0{TEXT 1 54 "Maple is then used to solve the equation symbolicall
y."}}{INP_R 17 0 "> "{TEXT 0 63 "logsol := dsolve(\{diff(P(t),t)=
logeq(t,P(t)), P(t0)=P0\}, P(t));"}}{OUT_R 18 0 17{DAG :3n4\`logs
ol`=3(3n3\`P`,2n3\`t`+3*5n3\`a~~`j2x0001+5n3\`b~~`i2x0001*9(3n3\`
exp`,2+3*5pDpFp9pFp14pF+5pDpF*5n3\`P0`pFp12pFp14pFp27p14(3p18,2+3
*5pDpFn3\`t0`pFp14p14p14p14p14}}{COM_R 19 0{TEXT 1 76 "We next ve
rify that this solution approaches a/b for t approaching infinity
."}}{INP_R 20 0 "> "{TEXT 0 30 "limit(rhs(logsol),t=infinity);"}}
{OUT_R 21 0 20{DAG *9n3\`b~~`i2x0001(3n3\`exp`,2*5n3\`a~~`j2x0001
n3\`t0`pCpC(3p6,2+3p9p3pCpApC}}{COM_R 22 0{TEXT 1 234 "What we ar
e after next is a way to find the values of a and b based on the 
known population values.  To motivate the steps we must take to d
o this we first recall how we find the growth rate for the simple
r case of exponential growth."}}{COM_R 23 0{TEXT 1 161 "In the ex
ponential growth model, (dP)/(dt) = kP(t), we can find the growth
 rate k, by using two actual values from the population, P(t0)=P0
 and P(t0+delta) = P1."}}{INP_R 24 0 "> "{TEXT 0 52 "expsol:=dsol
ve(\{diff(P(t),t)=k*P(t),P(t0)=P0\},P(t));"}}{OUT_R 25 0 24{DAG :
3n4\`expsol`=3(3n3\`P`,2n3\`t`*7(3n3\`exp`,2*5n3\`k`j2x0001p9p13p
13n3\`P0`p13(3pD,2*5p11p13n3\`t0`p13i2x0001}}{INP_R 26 0 "> "
{TEXT 0 43 "solve(subs(P(t)=P1,t=t0+delta,expsol),\{k\});"}}
{OUT_R 27 0 26{DAG %2,2=3n3\`k`*5(3n3\`ln`,2*5n3\`P1`j2x0001n3\`P
0`i2x0001pDn4\`delta`p11}}{COM_R 28 0{TEXT 1 179 "For the case of
 the logistics population model we need three equally spacedvalue
s,P(t0), P(t0+delta), P(t0+2*delta) and we get two equations to s
olve for the two unknowns a and b."}}{INP_R 29 0 "> "{TEXT 0 92 "
eq:=\{subs(P(t)=P1,t=t0+delta,logsol), subs(P(t)=P2,P0=P1,t0=t0+d
elta, t=t0+2*delta,logsol)\};"}}{OUT_R 30 0 29{DAG :3n3\`eq`%2,3=
3n3\`P1`+3*5n3\`a~~`j2x0001+5n3\`b~~`i2x0001*9(3n3\`exp`,2+3*5pAp
C+5n3\`t0`pCn4\`delta`pCpCp11pC+5pApC*5n3\`P0`pCpFpCp11pCp2Bp11(3
p15,2+3*5pApCp1DpCp11p11p11p11p11=3n3\`P2`+3*5pApC+5pFp11*9(3p15,
2+3*5pApC+5p1DpCp20j2x0002pCp11pC+5pApC*5p6pCpFpCp11pCp6p11p14p11
p11p11p11}}{INP_R 31 0 "> "{TEXT 0 23 "absol:=solve(eq,\{a,b\});"
}}{OUT_R 32 0 31{DAG :3n4\`absol`%2,3=3n3\`a~~`*5(3n3\`ln`,2+3*9n
3\`P2`j2x0001+5n3\`P1`p12n3\`P0`i2x0001p12p18p1A+5p10p1Ap15p12p1A
p1Ap12n4\`delta`p1A=3n3\`b~~`*DpAp12+5*5p15p12(3n3\`exp`,2+3*7pAp
12p27p1A+5n3\`t0`p12p27p12p12p1Ap12p12*5p18p12(3p36,2+3*7pAp12p27
p1Ap40p12p1Ap12p1Ap12p27p1Ap15p1Ap18p1A+5p4Cp1Ap35p12p1A}}{COM_R 
33 0{TEXT 1 131 "To find a and b for the U.S. population, we use 
three values from the table of U.S. populations for the years 179
0, 1850, and 1910."}}{INP_R 34 0 "> "{TEXT 0 112 "absol1 := evalf
(subs(P0=population[1790],P1=population[1850], P2=population[1910
], delta=60, t0 = 1790, absol));"}}{OUT_R 35 0 34{DAG :3n4\`absol
1`%2,3=3n3\`a~~`e3j4x003133829342i2x0011=3n3\`b~~`e3j4x0015883849
73i2x0019}}{COM_R 36 0{TEXT 1 149 "We then use these values of a 
and b to plot the population predicted by the logistics model.  W
e also include a plot of the actual population values."}}{INP_R 
37 0 "> "{TEXT 0 139 "plot(\{[seq([1790+i*10,population[1790+i*10
]],i=0..20)], subs(op(absol1),t0=1790,P0=population[1790],rhs(log
sol))\}, t=1790..2100,0..3*10^8);"}}{COM_R 38 0{TEXT 1 311 "Notic
e that the population closely agree with the model up to around 1
945 meaning that the model accurately predicted the population fo
r about 35 years past 1910.  What happened in 1945 is that WWII a
nd the resulting population boom resulted in the values of the vi
tal population coefficients a and b changing.\012"}}{SEP_R 39 0}
{INP_R 40 0 "> "{TEXT 0 0 ""}}}{END}
