{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{SCP_R 1 0 10{COM_R 2 0{TEXT 1 1604 "This routine is intended 
to show how one can program one's own plotting routines using the
 PLOT3D structure in Maple.  The main help file for this is ?plot
3d,structure.  The example we have chosen is to  plot a subgroup 
lattice in 3-dimensions.  But this code can serve as an example f
or how to plot an arbitrary graph G = V,E\015\015Michael Monagan\
015October 1993.\015\015The lattice is a graph (V,E) input as fol
lows:\015\015V:list(list(list(integer)))\015E:list(integer=\{inte
ger,set(integer),list(integer)\})\015\015The vertices V are input
 in a predetermined spacial arrangement as a  layers (or planes) 
of rows of vertices.  This is list of  planes where each plane is
 a list of  rows and each row is a list of vertices and each vert
ex is just an integer.  So that means V is a list of lists of lis
ts of integers.  The output will place the vertices in the order 
described by V.  This will become clear (hopefully) when you look
 at the pictures.\012\015The edges E are input as an adjacency li
st, namely a list of equations where the left hand side is the ve
rtex (an integer), and the  right hand side is the adjacent verti
ces, specified by either a single integer, or a list or set of in
tegers.\015\015The output is a PLOT3D structure corresponding to 
the lattice. Vertices are drawn as points and edges as lines. The
 points in the PLOT3D data structure are just output as\012\012  
  POINTS( [v1, v2, ..., vn] )\012\015 and the edges v2,v3,...,vm 
adjacent to vertex v1 are put together to form a curve as\012\015
    CURVELIST([v1,v2,v1,v3,...,v1,vm]).\015\015Here is the progra
m which converts the (V,E) representation of the lattice into a P
LOT3D data structure.\015"}}{INP_R 3 0 "> "{TEXT 0 1214 "sglplot 
:= proc( V:list(list(list(integer))),\012                 E:list(
integer=\{integer,list(integer),set(integer)\})\012              
 )\012        local i,j,k, x,y,z, l,m,n, C,P,xyz, e,s,t, X,Y,Z, l
1,l2;\012\012        l := nops(V);\012        for i to l do\012  
          l1 := V[i];\012            m := nops(l1);\012          
  for j to m do\012                l2 := l1[j];\012              
  n := nops(l2);\012                for k to n do\012            
        x := i + (k+1)/(n+3) - 1/2;\012                    y := i
/2 - j/(m+1) + 1/2;\012                    z := i - 1/2;\012     
               xyz[l2[k]] := [z,x,y];\012                od\012  
          od\012        od;\012\012        P := POINTS( map(op,[e
ntries(xyz)]) );\012\012        n := nops(E);\012        for i to
 n do\012            s := lhs(E[i]);\012            t := NULL;\01
2            e := rhs(E[i]);\012            if type(e,numeric) th
en t := xyz[s], xyz[e]\012            else for e in rhs(E[i]) do 
t := t, xyz[s], xyz[e], xyz[s] od\012            fi;\012         
   C[i] := CURVELIST( [t] );\012        od;\012\012        C := s
eq( C[i], i=1..n );\012\012        PLOT3D( P, C,\012             
   STYLE(WIREFRAME), LABELS([X,Y,Z]), AXES(FRAME),\012           
     ORIENTATION(5,80),\012                VIEW(1/3..l-1/3,1/2..l
+1/2,0..(l+1)/2 ) )\012end:\012"}}{COM_R 4 0{TEXT 1 35 "Here is t
he first subgroup lattice\015"}}{INP_R 5 0 "> "{TEXT 0 1186 "Grou
p.44.43 :=\012\012# The vertex adjacencies\012\012     [ [ [46,47
,48],\012         [38,39,40,33,35,36,37],\012         [17,18,19,1
6,20,21,15,23,24,25,26,27,28],\012         [$1..13],\012         
[0] ],\012\012       [ [51],\012         [50,45,49],\012         
[44,43,34,41,42],\012         [22,29,30,31,32],\012         [14] 
]\012     ],\012\012# The edge adjacencies E\012\012     [\012   
     51=\{50,45,49,46,47,48\},\012\012        44=\{17,18,19,50,43
,22\},\012        43=\{16,20,21,50,22\},\012        34=\{15,50,45
,49,22\},\012        41=\{23,24,25,29,42,49,30,22\},\012        4
2=\{26,27,28,49,32,31,22\},\012\012        46=47, 47=48,\012\012 
       29=30, 30=31, 31=32,\012\012        14=\{22,29,30,31,32,0\
},\012\012        38=\{46,17,16,15,50\},\012        39=\{38,40,47
,18,20,15,50\},\012        40=\{48,19,21,15,50\},\012        33=\
{46,47,48,15,45\},\012        35=\{46,15,23,26,49\},\012        3
6=\{35,37,47,15,24,27,49\},\012        37=\{48,15,25,28,49\},\012
\012        17=18, 18=19, 19=16, 16=20, 20=21,\012        23=24, 
24=25, 25=26, 26=27, 27=28,\012\012        1=\{0,17,18,19,16,20,2
1,15,$23..28\},\012        2=\{0,23,29,3\}, 3=\{0,24,29,4\}, 4=\{
0,25,29,5\},\012        5=\{0,23,30,6\}, 6=\{0,24,30,7\}, 7=\{0,2
5,30,8\},\012        8=\{0,26,31,9\}, 9=\{0,27,31,10\}, 10=\{0,28
,31,11\},\012        11=\{0,26,32,12\}, 12=\{0,27,32,13\}, 13=\{0
,28,32\}\012\012     ]:\012"}}{COM_R 6 0{TEXT 1 34 "Here is the n
ext subgroup lattice\015"}}{INP_R 7 0 "> "{TEXT 0 813 "Group.48.4
4 :=\012\012# The vertex planes\012\012     [ [ [30,31,32],\012  
       [19,20,21,17,22,23,24],\012         [$4..9,3,10,14,15,11,1
2,13],\012         [1],\012         [0] ],\012\012       [ [35],\
012         [33,29,34],\012         [25,26,18,27,28],\012        
 [16],\012         [2] ]\012     ],\012\012# The edge adjacecies\
012\012     [\012        35=\{30,31,32,33,29,34\},\012        25=
\{4,5,6,33,26,16\},\012        26=\{7,8,9,33,16\},\012        18=
\{3,33,29,34,16\},\012        27=\{10,14,15,34,16,28\},\012      
  28=\{11,12,13,34,16\},\012\012        30=31,31=32,\012\012     
   2=\{16,0\},\012        19=\{20,30,33,4,7,3\},\012        20=\{
31,33,5,8,3\},\012        21=\{20,32,33,6,9,3\},\012        17=\{
30,31,32,29,3\},\012        22=\{30,23,34,3,10,11\},\012        2
3=\{31,34,3,14,12\},\012        24=\{32,23,34,3,15,13\},\012\012 
       1=\{16,0,$3..15\},\012        4=5,5=6,6=7,7=8,8=9,\012    
    10=14,14=15,15=11,11=12,12=13\012\012     ]:\012"}}{INP_R 8 0
 "> "{TEXT 0 23 "sglplot( Group.44.43 );"}}{INP_R 9 0 "> "{TEXT 0
 23 "sglplot( Group.48.44 );"}}{SEP_R 10 0}{INP_R 11 0 "> "{TEXT 
0 0 ""}}}{END}
