{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--*-180-*-
*-*-*-*-*" "new century schoolbook" "Times-Bold" 8 18 64 "Times-B
old" 18}{SCP_R 1 0 43{COM_R 2 0{TEXT 3 28 "Homonuclear AX COSY sp
ectrum"}}{COM_R 3 0{TEXT 1 60 "\015Copyright (1994) Rene P.F. Kan
ters\012KANTERS@urvax.urich.edu\012"}}{COM_R 4 0{TEXT 1 144 "We a
re going to look at the COSY spectrum of a homonuclear AX spinsys
tem.\012The COSY sequence is:\012            (Pi/2)y - t1 - (Pi/2
)y - observation"}}{COM_R 5 0{TEXT 1 0 ""}}{INP_R 6 0 "> "{TEXT 0
 53 "with(share): readshare(pof, science); # read `pof.m`;"}}
{OUT_R 7 0 6{TEXT 2 71 "See ?share and ?share,contents for inform
ation about the share library\012"}}{OUT_R 8 0 6{DAG n3\`pof`}}
{INP_R 9 0 "> "{TEXT 0 18 "spinsystem([A,X]):"}}{INP_R 10 0 "> "
{TEXT 0 52 "ypulse(\",T,Pi/2): evolve(\",\{\},t1): ypulse(\",T,Pi
/2):"}}{INP_R 11 0 "> "{TEXT 0 19 "observe(\",\{\},t2,0);"}}
{OUT_R 12 0 11{DAG +11*Bn3\`I`j2x0001(3n3\`Sin`,2+3*7n3\`Pi`p4b3n
3\`W`,2n3\`A`p4n3\`t1`p4j2x0002p4(3n3\`Cos`,2*7pCp4b3n3\`J`,3p13n
3\`X`p4p16p4p4(3p1D,2+3*7pCp4pFp4n3\`t2`p4p19p4(3p1D,2*7pCp4p23p4
p37p4p4/3p4p19*9p6p4p1Cp4(3p7p30p4p3Cp4/3i2x0001p19*Bp2p4p6p4(3p7
p1Fp4(3p1D,2+3*7pCp4b3p10,2p28p4p37p4p19p4(3p7p3Ep4p47*9p6p4p5Ep4
(3p7p64p4p72p4p55*Bp2p4(3p7,2+3*7pCp4p69p4p16p4p19p4p1Cp4p62p4p3C
p4p47*9p86p4p1Cp4p7Cp4p3Cp4p55*Bp2p4p86p4p5Ep4p2Ep4p72p4p47*9p86p
4p5Ep4p4Fp4p72p4p55}}{COM_R 13 0{TEXT 1 500 "\015In order to simu
late phase sensitivity in the t1 domain, we will only perform a r
eal, or cosine, Fourier transform on that time domain. We can do \+
this since we effectively only obtained the real part, or complex
 part (only a phase shift), of the spectrum for that time domain.
\012\012Since we are only interested in the real part of the spec
trum anda cosine transform will not introduce imaginary terms, we
 can perform a cosine transform for t1 on only the real part of t
he complex transformed t2 domain\012\000"}}{INP_R 14 0 "> "{TEXT 
0 47 "spec:=CosFT(evalc(Re(FT(\",0,t2,v2))),0,t1,v1);\012"}}
{OUT_R 15 0 14{DAG :3n4\`spec`+21*5(3n3\`Ab`,3+5b3n3\`W`,2n3\`A`j
2x0001b3n3\`J`,3pFn3\`X`/3i2x0001j2x0002n3\`v2`p11(3p7,3+5b3pC,2p
18p11p13p1An3\`v1`p11/3p1Bj2x0016*5p6p11(3p7,3+5p26p11p13/3p11p1D
p2Dp11/3p11p32*5(3n3\`Di`p9p11(3p48,3+5pBp11p13p3Ep2Dp11p30*5p47p
11(3p48,3pAp2Dp11p30*5(3p7,3p4Fp1Fp11p22p11p43*5p62p11p37p11p30*5
(3p7,3p25p1Fp11(3p7p5Cp11p30*5p72p11(3p7p4Ep11p43*5(3p48p64p11p4C
p11p30*5p86p11p5Ap11p30*5(3p48,3p3Ap1Fp11(3p48p39p11p30*5p94p11(3
p48p24p11p30*5(3p7p96p11p78p11p43*5pA8p11p80p11p30*5(3p48p74p11p9
Ap11p30*5pB6p11pA2p11p30}}{COM_R 16 0{TEXT 1 519 "\015We  see tha
t the diagonal peaks, i.e. peaks with the same chemical shift arg
uments for v1and v2, are pure dispersion peaks.\012\012The crossp
eaks, peaks with different chemical shift arguments for v1 than f
or v2, are pure absorption peaks.\012\012We will show that by plo
tting the one-dimensional subspectrum for v1 = Wv[A]-Jv[A,X]/2, s
o that the absorption lines are at a maximum, and the dispersion \+
lines practically zero. The dispersion lines are not completely z
ero due to tails of other dispersion signals in their vicinity.\0
00"}}{INP_R 17 0 "> "{TEXT 0 74 "Wv:=table([A=3,X=12]):Jv:=table(
symmetric,[(A,X)=2]):T2:=table([A=1,X=1]):"}}{INP_R 18 0 "> "
{TEXT 0 83 "nmrplot(subs(v1=Wv[A]-Jv[A,X]/2,spec),v2=0..15,title=
`AX cosy, v1=W[A]-J[A,X]/2`);\015"}}{COM_R 19 0{TEXT 1 0 ""}}
{COM_R 20 0{TEXT 1 120 "In order to see the dispersion peaks alon
g the diagonal a little better, we will plot the subspectrum shif
ted by 0.2Hz.\000"}}{INP_R 21 0 "> "{TEXT 0 90 "nmrplot(subs(v1=W
v[A]-Jv[A,X]/2+0.2,spec),v2=0..15,title=`AX cosy, v1=W[A]-J[A,X]/
2+0.2`);"}}{COM_R 22 0{TEXT 1 0 ""}}{COM_R 23 0{TEXT 1 401 "To pe
rform a whole COSY experiment with only one command, we will defi
ne the procedure COSY(system,dom1,dom2) where 'system' is the spi
nsystem list, and'dom1' and 'dom2' are the sets of spins that we \+
want evolved during the t1 and t2 domains, respectively.\012\012S
ince we obtainedpeaks with a negative amplitude on the diagonal, \+
we will observethis time with a phase shift of Pi (along -x, not \+
along x).\000\000\000"}}{INP_R 24 0 "> "{TEXT 0 141 "COSY:=proc(s
ystem,dom1,dom2)\012  spinsystem(system):\012  ypulse(\",T,Pi/2):
\012  evolve(\",dom1,t1):\012  ypulse(\",T,Pi/2):\012  observe(\"
,dom2,t2,Pi):\012end:"}}{COM_R 25 0{TEXT 1 126 "\015We will also \+
define the procedure COSYFT that will perform the Fourier transfo
rm of the FID obtained with the COSY procedure."}}{INP_R 26 0 "> \+
"{TEXT 0 61 "COSYFT:=proc(s) CosFT(evalc(Re(FT(s,0,t2,v2))),0,t1,
v1): end:"}}{COM_R 27 0{TEXT 1 96 "\015In order to calculate the \+
diagonal peaks that have chemical shift dependance of A we can is
sue:"}}{INP_R 28 0 "> "{TEXT 0 20 "COSY([A,X],\{A\},\{A\});"}}
{OUT_R 29 0 28{DAG +5*Bn3\`I`j2x0001(3n3\`Sin`,2+3*7n3\`Pi`p4b3n3
\`W`,2n3\`A`p4n3\`t1`p4j2x0002p4(3n3\`Cos`,2*7pCp4b3n3\`J`,3p13n3
\`X`p4p16p4p4(3p1D,2+3*7pCp4pFp4n3\`t2`p4p19p4(3p1D,2*7pCp4p23p4p
37p4p4/3i2x0001p19*9p6p4p1Cp4(3p7p30p4p3Cp4/3p4p19}}{COM_R 30 0
{TEXT 1 362 "We see that the FID has cosine modulation depending \+
J[A,X] in both dimensions. This will give rise to an in-phase pat
tern (all peaks same sign),since the convolution principle tells \+
us that a cosine modulation with argument m gives rise to a peaks
 with the same amplitude at -m/(2*Pi) and one at +m/(2*Pi).\012\0
12We can check that by performing the Fourier transform\000"}}
{INP_R 31 0 "> "{TEXT 0 10 "COSYFT(\");"}}{OUT_R 32 0 31{DAG +9*5
(3n3\`Di`,3+5b3n3\`W`,2n3\`A`j2x0001b3n3\`J`,3pBn3\`X`/3pDj2x0002
n3\`v2`pD(3p3,3p6n3\`v1`pD/3pDj2x0016*5p2pD(3p3,3+5p7pDpF/3i2x000
1p18p21pDp24*5(3p3,3p2Ep1ApDp1DpDp24*5p3ApDp2BpDp24}}{COM_R 33 0
{TEXT 1 176 "We will look at thosediagonal peaks using super2d, b
ut in order to get absorption peaks we will substitute Di with Ab
 (this is equivalent to performing a phase shift of Pi/2).\000"}}
{INP_R 34 0 "> "{TEXT 0 118 "super2d(subs(Di=Ab,\"),v2,v1,orienta
tion=[120,60],axes=FRAME,shading=Z, title=`AX COSY diagonal peak \+
(phase shifted)`);"}}{COM_R 35 0{TEXT 1 0 ""}}{COM_R 36 0{TEXT 1 
33 " for the crosspeakswe can issue:\377"}}{INP_R 37 0 "> "{TEXT 
0 20 "COSY([A,X],\{A\},\{X\});"}}{OUT_R 38 0 37{DAG +5*Bn3\`I`j2x
0001(3n3\`Sin`,2+3*7n3\`Pi`p4b3n3\`W`,2n3\`A`p4n3\`t1`p4j2x0002p4
(3p7,2*7pCp4b3n3\`J`,3p13n3\`X`p4p16p4p4(3n3\`Cos`,2+3*7pCp4b3p10
,2p27p4n3\`t2`p4p19p4(3p7,2*7pCp4p22p4p3Ap4p4/3i2x0001p19*9p6p4p1
Cp4(3p7p30p4p3Fp4/3p4p19}}{COM_R 39 0{TEXT 1 304 "The FID has sin
e modulation of J[A,X] inboth dimension. This gives rise to an an
ti-phase pattern, since the convolution principle tells us that a
 sine modulation with argument m gives rise to a peaks at -m/(2*P
i) and +m/(2*Pi) with opposite amplitudes.\012\012We will check t
hat again by Fourier transforming.\001"}}{INP_R 40 0 "> "{TEXT 0 
10 "COSYFT(\");"}}{OUT_R 41 0 40{DAG +9*5(3n3\`Ab`,3+5b3n3\`W`,2n
3\`X`j2x0001b3n3\`J`,3n3\`A`pB/3pDj2x0002n3\`v2`pD(3p3,3+5b3p8,2p
13pDpF/3i2x0001p18n3\`v1`pD/3p28j2x0016*5p2pD(3p3,3+5p21pDpFp16p2
BpD/3pDp30*5(3p3,3+5p7pDpFp27p1ApDp1DpDp3F*5p43pDp35pDp2E}}{INP_R
 42 0 "> "{TEXT 0 85 "super2d(\",v2,v1,orientation=[120,60],axes=
FRAME,shading=Z,title=`AX COSY crosspeak`);"}}{COM_R 43 0{TEXT 1 
0 ""}}{INP_R 44 0 "> "{TEXT 0 0 ""}}}{END}
