{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 14}{FONT 1 "-adobe-times-medium-r-normal--17-*" "ti
mes" "Times-Roman" 4 17 64 "Times-Roman" 17}{FONT 2 "-adobe-couri
er-medium-r-normal--18-*" "courier" "Courier" 4 18 192 "Courier" 
18}{FONT 3 "-b&h-lucidatypewriter-bold-r-normal-sans-14-*" "lucid
atypewriter" "Courier-Bold" 8 14 192 "Courier-Bold" 14}{FONT 4 "-
adobe-times-medium-r-normal--11-*" "times" "Times-Roman" 4 11 64 
"Times-Roman" 11}{FONT 5 "-adobe-times-medium-r-normal--12-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 6 "-adobe-couri
er-bold-r-normal--24-*" "courier" "Courier-Bold" 8 24 192 "Courie
r-Bold" 24}{FONT 7 "-adobe-times-bold-r-normal--18-*" "times" "Ti
mes-Bold" 8 18 64 "Times-Bold" 18}{FONT 8 "-adobe-times-medium-i-
normal--18-*" "times" "Times-Italic" 4 18 96 "Times-Italic" 18}
{FONT 9 "-adobe-times-bold-r-normal--18-*" "times" "Times-Bold" 8
 18 64 "Times-Bold" 18}{FONT 10 "-adobe-times-bold-r-normal--17-*
" "times" "Times-Bold" 8 17 64 "Times-Bold" 17}{FONT 11 "-adobe-c
ourier-medium-r-normal--18-*" "courier" "Courier" 4 18 192 "Couri
er" 18}{SCP_R 1 0 78{COM_R 2 0{TEXT 7 54 "\015On Solving the McCo
nnell Equations in Biochemistry\012 \015"}}{COM_R 3 0{TEXT 8 140 
"Johannes Grotendorst, Paul Jansen, and Siegfried M. Schoberth\01
2\012Research Center Juelich\012\012Mail should be sent to: j.gro
tendorst@kfa-juelich.de"}}{COM_R 4 0{TEXT 1 1326 "\012In recent y
ears, in vivo nuclear magnetic resonance (NMR) spectroscopy has a
llowed to measure rate constants of transport and diffusion acros
s living cell membranes [1-2]. One of the authors (S.M.S.) is int
erested in a special NMR technique -inversion transfer- to study 
bacterial systems [3]. The theoretical basis for the analysis of 
inversion transfer experiments is a system of differential equati
ons first formulated by McConnell [4]. These  equations describe 
the rate of change of nuclear spin magnetization of a single nucl
ear species which is transferred back and forth between two diffe
rent magnetic environments (A, B) by kinetic processes. In this w
orksheet we show, how the McConnell equations, a linear inhomogen
eous system of differential equations with constant coefficients,
 can be solved elegantly by using symbolic matrix algebra only, i
n particular by using matrix exponentials. This method utilizes t
he special structure of the ODE system and  therefore is faster a
nd more direct than simply using dsolve, the solver for different
ial equations in Maple. It is also an independent method compared
 to the solution techniques found in the literature [5-7]. In add
ition, methods of mixed symbolic-numeric type for the determinati
on of the formal parameters involved in the analytical solutions 
are indicated."}}{COM_R 5 0{TEXT 1 116 " \012The McConnell equati
ons as formulated by Led and Gesmar [5] to study chemical exchang
e rates are given as follows\012"}}{INP_R 6 0 "> "{TEXT 0 116 "eq
1 := diff(MA(t),t) = -k[A1]*MA(t) + k[-1]*MB(t) + k[A]; \012eq2 :
= diff(MB(t),t) =  k[1] *MA(t) - k[B1]*MB(t) + k[B];"}}{OUT_R 7 0
 6{DAG :3n3\`eq1`=3(3n4\`diff`,3(3n3\`MA`,2n3\`t`pD+7*5b3n3\`k`,2
n3\`A1`j2x0001p9p18i2x0001*5b3p13,2p1Cp18(3n3\`MB`pCp18p18b3p13,2
n3\`A`p18}}{OUT_R 8 0 6{DAG :3n3\`eq2`=3(3n4\`diff`,3(3n3\`MB`,2n
3\`t`pD+7*5b3n3\`k`,2j2x0001p16(3n3\`MA`pCp16p16*5b3p13,2n3\`B1`p
16p9p16i2x0001b3p13,2n3\`B`p16}}{COM_R 9 0{TEXT 1 618 "\012Here, 
MA(t) and MB(t) describe the time-dependent peak heights of the m
agnetic resonance signals in A and B, respectively. These signals
 are measured in NMR experiments. The parameters k[1] and k[-1], 
interpreted as indexed names in Maple, characterize the first-ord
er rate constants for the forward and reverse reactions. The mean
ing of the other parameters will become clear in the sequel. From
 linear algebra we know that linear systems of differential equat
ions with constant coefficients can be solved with the help of ma
trix exponentials [8]. To do it in Maple we first have to define 
the appropriate matrices.\015"}}{INP_R 10 0 "> "{TEXT 0 150 "with
(linalg): #load the linear algebra package\012A  := matrix([[-k[A
1], k[-1]], [k[1], -k[B1]]]);\012C  := vector([k[A], k[B]]);\012Y
0 := vector([MA0, MB0]);\012"}}{OUT_R 11 0 10{TEXT 2 71 "Warning:
 new definition for   norm\012Warning: new definition for   trace
\012"}}{OUT_R 12 0 10{DAG :3n3\`A`(3n4\`MATRIX`,2[2,3[2,3+3b3n3\`
k`,2n3\`A1`i2x0001b3pE,2p13[2,3b3pE,2j2x0001+3b3pE,2n3\`B1`p13}}
{OUT_R 13 0 10{DAG :3n3\`C`(3n4\`VECTOR`,2[2,3b3n3\`k`,2n3\`A`b3p
B,2n3\`B`}}{OUT_R 14 0 10{DAG :3n3\`Y0`(3n4\`VECTOR`,2[2,3n3\`MA0
`n3\`MB0`}}{COM_R 15 0{TEXT 1 136 "\012Applying the Maple functio
n for the evaluation of matrix exponentials leads to the followin
g solution of the inhomogeneous ODE system:\012"}}{INP_R 16 0 "> 
"{TEXT 0 132 "F := multiply(exponential(A,t), Y0):\012f := s -> m
ultiply(exponential(A, t-s), C);\012P := [Int(f(s)[1], s=0..t), I
nt(f(s)[2], s=0..t)];\012"}}{OUT_R 17 0 16{DAG :3n3\`f`@7,2n3\`s`
,1,3n5\`operator`n4\`arrow`p7(3n5\`multiply`,3(3n5\`exponential`,
3n3\`A`+5n3\`t`j2x0001a2x0001i2x0001n3\`C`p7}}{OUT_R 18 0 16{DAG 
:3n3\`P`[2,3(3n3\`Int`,3+3*5+11*7b3n3\`k`,2n3\`A`j2x0001(3n3\`exp
`,2+3*5+7b3pE,2n3\`A1`p13b3pE,2n3\`B1`p13*3+9*3p1Cj2x0002p13*5p1C
p13p22p13i2x0002*3p22p2Cp13*5b3pE,2i2x0001p13b3pE,2p13p13j2x0004/
3p13p2Cp3Ep13+5n3\`t`p13n3\`s`p3Ep13/3p3Ep2Cp13p29p48p3E*7pDp13p1
Cp13(3p16,2+3*5+7p1Cp13p22p13p28p13p13p4Dp13p55p13p3E*7pDp13p1Cp1
3p15p13p13*7pDp13p22p13p61p13p13*7pDp13p22p13p15p13p3E*7pDp13p29p
48p61p13p3E*7p3Bp13b3pE,2n3\`B`p13p61p13p2C*7p3Bp13p96p13p15p13p3
4p13p29p55p55=3p51~3j2x0000p4E(3p6,3+3*5+11*7p41p13pDp13p61p13p34
*7p41p13pDp13p15p13p2C*7p96p13p15p13p29p48p13*7p96p13p22p13p61p13
p13*7p96p13p22p13p15p13p3E*7p96p13p1Cp13p61p13p3E*7p96p13p1Cp13p1
5p13p13*7p96p13p29p48p61p13p13p13p29p55p48pAB}}{COM_R 19 0{TEXT 1
 587 "\012Here,  the % label signifies common subexpressions in t
he output, a way Maple makes output more compact. The matrix expo
nential of a d x d square matrix A is defined by\015  \015       
                  exp(A) = I + A + 1/2!*A^2 + 1/3!*A^3 + ... + 1/
n!*A^n + ...,\015 \015where I is the identity matrix and the matr
ix series on the right hand side can be considered as d^2 (scalar
) series,  one for each of the elements of exp(A) [8]. Now, the s
olution of the inhomogeneous ODE system is obtained by adding the
 solution F of the corresponding homogeneous ODE system and the p
articular solution P. \015"}}{INP_R 20 0 "> "{TEXT 0 26 "S1:= add
(F, map(value,P)):"}}{COM_R 21 0{TEXT 1 183 "\012It should be not
ed that the solution of the equivalent one dimensional ODE is fou
nd in a formal identical manner. The correctness of the one dimen
sional solution is easily verified.\012"}}{INP_R 22 0 "> "{TEXT 0
 80 "exp(a*t)*y0 + int(exp(a*(t-s))*c, s=0..t):\012evalb(expand(d
iff(\",t) = a*\" + c));  "}}{OUT_R 23 0 22{DAG n4\`true`}}{COM_R 
24 0{TEXT 1 127 "\012If matrix A is invertible then the solution 
of the inhomogeneous ODE system can be computed with matrix algeb
ra only. We have\015"}}{INP_R 25 0 "> "{TEXT 0 87 "AC := multiply
(inverse(A), C):\012S2 := add(multiply(exponential(A,t), add(Y0, 
AC)), -AC):"}}{COM_R 26 0{TEXT 1 77 "\012Again,  this direct solu
tion can be  motivated by the one dimensional case:\012"}}{INP_R 
27 0 "> "{TEXT 0 46 "dsolve(\{diff(y(t),t)=a*y(t)+c,y(0)=y0\}, y(
t));"}}{OUT_R 28 0 27{DAG =3(3n3\`y`,2n3\`t`+5*5n3\`a`i2x0001n3\`
c`j2x0001pB*5(3n3\`exp`,2*5p9pFp5pFpF+5p8pFn3\`y0`pFpFpF}}{COM_R 
29 0{TEXT 1 42 "\012Comparing the solutions S1 and S2 yields\012"
}}{INP_R 30 0 "> "{TEXT 0 27 "map(simplify, add(S1,-S2));"}}
{OUT_R 31 0 30{DAG (3n4\`VECTOR`,2[2,3j2x0000p7}}{COM_R 32 0{TEXT
 1 364 "\012Next,  we introduce physical boundary conditions to o
btain a special solution. Let MeA and MeB denote the unperturbed 
equilibrium magnetizations of A and B respectively, i.e. the limi
ts of  MA(t) and MB(t) for t  ->  +infinity.  These limits are gi
ven by the components of the constant vector -AC in solution S2, 
provided that both eigenvalues of A are negative.\012"}}{INP_R 33
 0 "> "{TEXT 0 97 "MeA = -AC[1], MeB = -AC[2];                   
                                              # (*)"}}{OUT_R 34 0
 33{DAG ,3=3n3\`MeA`*5+5*5b3n3\`k`,2n3\`A`j2x0001b3p8,2n3\`B1`pDp
D*5b3p8,2i2x0001pDb3p8,2n3\`B`pDpDpD+5*5b3p8,2n3\`A1`pDpFpDpD*5p1
7pDb3p8,2pDpDp1Ap1A=3n3\`MeB`*5+5*5p7pDp33pDpD*5p1DpDp27pDpDpDp25
p1A}}{COM_R 35 0{TEXT 1 36 " \012Solving for k[A] and k[B] yields
 \015"}}{INP_R 36 0 "> "{TEXT 0 36 "solve(\{\"\}, \{k[A], k[B]\})
;\012assign(\"):"}}{OUT_R 37 0 36{DAG %2,3=3b3n3\`k`,2n3\`B`+5*5n
3\`MeB`j2x0001b3p4,2n3\`B1`pDpD*5b3p4,2pDpDn3\`MeA`pDi2x0001=3b3p
4,2n3\`A`+5*5b3p4,2p1FpDpBpDp1F*5b3p4,2n3\`A1`pDp1CpDpD}}{COM_R 
38 0{TEXT 1 126 "\015Inserting these expressions into the system 
of ODEs and collecting coefficients results in the following syst
em of equations:"}}{COM_R 39 0{TEXT 1 0 ""}}{INP_R 40 0 "> "{TEXT
 0 75 "eq1 := collect (eq1, [k[A1], k[-1]]);\012eq2 := collect (e
q2, [k[B1],  k[1]]);"}}{OUT_R 41 0 40{DAG :3n3\`eq1`=3(3n4\`diff`
,3(3n3\`MA`,2n3\`t`pD+5*5+5p9i2x0001n3\`MeA`j2x0001p18b3n3\`k`,2n
3\`A1`p18p18*5+5(3n3\`MB`pCp18n3\`MeB`p14p18b3p1C,2p14p18p18}}
{OUT_R 42 0 40{DAG :3n3\`eq2`=3(3n4\`diff`,3(3n3\`MB`,2n3\`t`pD+5
*5+5p9i2x0001n3\`MeB`j2x0001p18b3n3\`k`,2n3\`B1`p18p18*5+5(3n3\`M
A`pCp18n3\`MeA`p14p18b3p1C,2p18p18p18}}{COM_R 43 0{TEXT 1 126 "\0
12Now, the inhomogeneous ODE system is transformed to a homogeneo
us system by\015MA(t) -> MA1(t) + MeA and MB(t) -> MB1(t) + MeB.\
015"}}{INP_R 44 0 "> "{TEXT 0 217 "neweq1:=eval(subs(MA(t)=MA1(t)
+MeA, \012                  MB(t)=MB1(t)+MeB, eq1));             
                                        #(**)\012neweq2:=eval(sub
s(MA(t)=MA1(t)+MeA, \012                  MB(t)=MB1(t)+MeB, eq2))
;"}}{OUT_R 45 0 44{DAG :3n4\`neweq1`=3(3n4\`diff`,3(3n3\`MA1`,2n3
\`t`pE+5*5pAj2x0001b3n3\`k`,2n3\`A1`p14i2x0001*5(3n3\`MB1`pDp14b3
p17,2p1Dp14p14}}{OUT_R 46 0 44{DAG :3n4\`neweq2`=3(3n4\`diff`,3(3
n3\`MB1`,2n3\`t`pE+5*5pAj2x0001b3n3\`k`,2n3\`B1`p14i2x0001*5(3n3\
`MA1`pDp14b3p17,2p14p14p14}}{COM_R 47 0{TEXT 1 67 "\012For the so
lution of this system we use matrix exponentials again.\012"}}
{INP_R 48 0 "> "{TEXT 3 197 "time1   := time():\012Y1      := vec
tor([MA10, MB10]):\012fundsys := multiply(exponential(A,t), Y1):\
012# adding the boundary values\012linsol  := add(fundsys, vector
([MeA, MeB])); \012time1   := time() - time1;\012"}}{OUT_R 49 0 
48{DAG :3n4\`linsol`(3n4\`VECTOR`,2[2,3+5*5+11*7n4\`MA10`j2x0001(
3n3\`exp`,2+3*5+7b3n3\`k`,2n3\`A1`p12b3p1C,2n3\`B1`p12*3+9*3p1Bj2
x0002p12*5p1Bp12p22p12i2x0002*3p22p2Cp12*5b3p1C,2i2x0001p12b3p1C,
2p12p12j2x0004/3p12p2Cp3Ep12n3\`t`p12/3p3Ep2Cp12p29p48p12*7pFp12p
1Bp12(3p15,2+3*5+7p1Bp12p22p12p28p12p12p4Dp12p50p12p12*7pFp12p1Bp
12p14p12p3E*7pFp12p22p12p5Cp12p3E*7pFp12p22p12p14p12p12*7pFp12p29
p48p5Cp12p12*7p3Bp12n4\`MB10`p12p5Cp12p34*7p3Bp12p91p12p14p12p2Cp
12p29p50p48n3\`MeA`p12+5*5+11*7p41p12pFp12p5Cp12p34*7p41p12pFp12p
14p12p2C*7p91p12p14p12p29p48p12*7p91p12p22p12p5Cp12p12*7p91p12p22
p12p14p12p3E*7p91p12p1Bp12p5Cp12p3E*7p91p12p1Bp12p14p12p12*7p91p1
2p29p48p5Cp12p12p12p29p50p48n3\`MeB`p12}}{OUT_R 50 0 48{DAG :3n4\
`time1`e3j2x0310i2x0003}}{COM_R 51 0{TEXT 1 497 "Thus, under cond
ition (*) the solution of the original inhomogeneous ODE system i
s  simplified to a sum where one term is the solution of the homo
geneous ODE system (**) and the other term, usually the particula
r solution, is constant. Applying the collect function recursivel
y to each component of the vector linsol provides a compact analy
tical solution of the following general form:\012\012MA(t) = C1 *
 exp(lam1 * t) + C2 * exp(lam2 * t) + MeA\015MB(t)  = C3 * exp(la
m1 * t) + C4 * exp(lam2 * t) + MeB\012"}}{INP_R 52 0 "> "{TEXT 0 
54 "linsol := map(collect, linsol, [%2, %3, MA10, MB10]);\012"}}
{OUT_R 53 0 52{DAG :3n4\`linsol`(3n4\`VECTOR`,2[2,3+7*5+5*7+7b3n3
\`k`,2n3\`A1`j2x0001b3p11,2n3\`B1`i2x0001*3+9*3p10j2x0002p16*5p10
p16p18p16i2x0002*3p18p23p16*5b3p11,2p1Dp16b3p11,2p16p16j2x0004/3p
16p23p16p16p20/3p1Dp23n4\`MA10`p16p3E*7p32p16n4\`MB10`p16p20p44p1
Dp16(3n3\`exp`,2+3*5+7p10p16p18p16p1Fp16p16n3\`t`p16p44p16p16*5+5
*7+7p18p16p10p1Dp1Fp16p16p20p44p47p16p3Ep4Cp16p16(3p58,2+3*5+7p10
p16p18p16p1Fp1Dp16p65p16p44p16p16n3\`MeA`p16+7*5+5*7p37p16p20p44p
47p16p1D*7p6Ep16p20p44p4Fp16p3Ep16p57p16p16*5+5p96p16*7pFp16p20p4
4p4Fp16p3Ep16p7Ep16p16n3\`MeB`p16}}{COM_R 54 0{TEXT 1 144 "\012It
 is easily verified that the parameters lam1 and lam2 are the  ei
genvalues of the  coefficient matrix of the homogeneous ODE syste
m. We have\015"}}{INP_R 55 0 "> "{TEXT 0 13 "eigenvals(A);"}}
{OUT_R 56 0 55{DAG ,3+7b3n3\`k`,2n3\`A1`/3i2x0001j2x0002b3p3,2n3\
`B1`p8*3+9*3p2pBj2x0001*5p2p18pDp18i2x0002*3pDpBp18*5b3p3,2p9p18b
3p3,2p18p18j2x0004/3p18pBp32+7p2p8pDp8p13p8}}{COM_R 57 0{TEXT 1 0
 ""}}{COM_R 58 0{TEXT 1 134 "Next, we solve the homogeneous ODE s
ystem (**) by applying the Maple function dsolve, the solver for 
differential equations in Maple.\012"}}{INP_R 59 0 "> "{TEXT 0 
279 "time2  := time():\012start   := MA1(0) = MA10, MB1(0) = MB10
:\012 fcns   := \{MA1(t), MB1(t)\}:\012dsol    := dsolve(\{neweq1
, neweq2, start\}, fcns):\012assign(dsol):\012#adding the boundar
y values\012dsol    := vector([MA1(t) + MeA, MB1(t) + MeB]):\012t
ime2   := time() - time2;\012speedup := time2/time1;"}}{OUT_R 60 
0 59{DAG :3n4\`time2`e3j3x00022290i2x0003}}{OUT_R 61 0 59{DAG :3n
4\`speedup`e3j4x007190322581i2x0008}}{COM_R 62 0{TEXT 1 349 "\012
Thus, dsolve needs much more time to find the solution compared t
o the method using the matrix exponentials. This is explained by 
the more general algorithms used in dsolve which work for nonline
ar equations and may not be efficient for homogeneous linear syst
ems. Comparing the result of dsolve with that found by using matr
ix exponentials yields\012"}}{INP_R 63 0 "> "{TEXT 0 34 "map(simp
lify, add(dsol, -linsol));"}}{OUT_R 64 0 63{DAG (3n4\`VECTOR`,2[2
,3j2x0000p7}}{COM_R 65 0{TEXT 1 31 "\012 If we define  the parame
ters\012"}}{INP_R 66 0 "> "{TEXT 0 95 "MA10  := MA0 - MeA:       
MB10 := MB0 - MeB:\012k[A1] := 1/T[A1] + k[1]: k[B1] := 1/T[B1] +
 k[-1]:"}}{COM_R 67 0{TEXT 1 1068 "\012we get analytical solution
s for MA(t) and MB(t) which depend on the eight parameters MA0, M
B0, MeA, MeB, T[A1], T[B1], k[1], k[-1]. Here, 1/T[A1] and 1/T[B1
] denote the relaxation rates of the spins in the two sites, wher
eas MA0 and MB0 denote the initial values of MA(t) and MB(t) at t
ime 0. Usually, the parameters involved in MA(t) and MB(t) are de
termined by a nonlinear least-squares analysis, i.e. by fitting t
he model parameters to experimental data for MA(t) and MB(t) obta
ined at different values of time [5-7]. The symbolic evaluation o
f the Jacobian matrix, required for the numerical fit program, is
 readily done with the help of the Maple procedure jacobian. For 
the translation into optimized FORTRAN code and the generation of
 a driver program for the fitting routine we used Macrofort [9], 
a  package of the Maple Share Library for FORTRAN code generation
. The numerical parameter-fitting itself is accomplished  by the 
ACM algorithm NL2SOL [10] which is based on the Levenberg-Marquar
dt algorithm and which needs analytic Jacobian matrices as input.
 "}}{COM_R 68 0{TEXT 1 181 "\012Now, for plotting the functions M
A(t) and MB(t) we substitute special fitted values obtained from 
NMR data to investigate transport processes in a special biologic
al system [3].  \015"}}{INP_R 69 0 "> "{TEXT 0 118 "k[1] := 6.6: 
k[-1] := 10.5:  MeA   := 153.5:   MeB := 78.8:\012MA0  := 130.4: 
MB0 := 27.08: T[A1] := 1.4:   T[B1] := 1.8:"}}{COM_R 70 0{TEXT 1 
79 "\012The parameter values lead to the following negative eigen
values of matrix A:\012 "}}{INP_R 71 0 "> "{TEXT 0 14 "eigenvals(
A);\012"}}{OUT_R 72 0 71{DAG ,3e3i4x000652671519i2x0009e3i4x00177
1716975i2x0008}}{COM_R 73 0{TEXT 1 88 "\012The given boundary con
ditions of MA(t) and MB(t) for t -> +infinity are reproduced by \
012"}}{INP_R 74 0 "> "{TEXT 0 33 "map(limit, linsol, t=+infinity)
;\012"}}{OUT_R 75 0 74{DAG (3n4\`VECTOR`,2[2,3e3j4x001535000000i2
x0007e3j4x007880000000i2x0008}}{INP_R 76 0 "> "{TEXT 0 163 "with(
plots):\012pl := plot(\{seq(linsol[i], i=1..2)\}, t=0..5):\012t1 
:= textplot([4, 79, `MB(t)`], align=ABOVE):\012t2 := textplot([4,
 147, `MA(t)`]):\012display(\{pl, t1, t2\});"}}{COM_R 77 0{TEXT 
10 12 "\012References\012"}}{COM_R 78 0{TEXT 1 934 "    [1] K. Ki
rk, NMR Biomed. 3, 1-16, (1990).\012\012    [2] P. W. Kuchel, NMR
 Biomed. 3, 102-119, (1990).  \015\015    [3] S. M. Schoberth, A.
 A. de Graaf, B. E. Chapman, P. W. Kuchel, and H. Sahm, \015     
      XV International Conference on Magnetic Resonance in Biolog
ical Systems,\015           Jerusalem, Israel, August 16-21, (199
3).\015 \012    [4] H. M. McConnell, J. Chem. Phys. 28, 430-431, 
(1958).\015    \012    [5] J. J. Led and H. Gesmar, J. Magn. Res.
 49, 444-464, (1982).\012    \015    [6] P. W. Kuchel and B. E. C
hapman, J. Theor. Biol. 105, 569-589, (1983).\015\015    [7] G. R
obinson, B. E. Chapman, and P. W. Kuchel, Eur. J. Biochem. 143, 6
43-649, (1984).\015\015    [8] P. Hartman, ``Ordinary Differentia
l Equations'',  John Wiley & Sons, Inc., (1964).\015    \012    [
9] C. Gomez, ``Macrofort: a FORTRAN code generator in Maple'', Ma
ple Share Library.\015\015 [10] J. E. Dennis, D. M. Gay, and R. E
. Welsch, ACM Trans. Math. Software, Vol. 7, No. 3,\015          
(1981).  "}}{INP_R 79 0 "> "{TEXT 0 0 ""}}}{END}

