{VERSION 1 1 "MS-Windows" "1.0"}{GLOBALS 3 2}{FONT 0 "Arial" "Ari
al" "Helvetica-Bold" 7 10 0 "Helvetica-Bold" 10{COLOR "ff0000"}}
{FONT 1 "Times New Roman" "Times New Roman" "Times-Roman" 4 12 64
 "Times-Roman" 12{COLOR "000000"}}{FONT 2 "Courier New" "Courier 
New" "Courier" 4 10 192 "Courier" 10{COLOR "000000"}}{SCP_R 0 0 
121{SCP_R 1 0 12{COM_R 3 0{TEXT 1 71 "Thermodynamics with Maple: 
IV - Activity Coefficients in Binary Systems"}}{COM_R 6 0{TEXT 1 
0 ""}}{COM_R 9 0{TEXT 1 11 "Ross Taylor"}}{COM_R 12 0{TEXT 1 85 "
Department of Chemical Engineering, Clarkson University, Potsdam,
 New York 13699-5705"}}{COM_R 15 0{TEXT 1 0 ""}}{COM_R 18 0{TEXT 
1 12 "Introduction"}}{COM_R 21 0{TEXT 1 0 ""}}{COM_R 24 0{TEXT 1 
412 "In a prior episode of this series we have encountered quanti
ties that we called activity coefficients.  In this worksheet we 
discuss these quantities in more detail.  Practical expressions f
or the activity coefficients come from models of the Gibbs excess
 energy.  Several such models have been developed.  Below we pres
ent a simple model in order to show in detail how the activity co
efficients may be obtained."}}{COM_R 27 0{TEXT 1 0 ""}}{COM_R 30 
0{TEXT 1 615 "It should be pointed out that although all the resu
lts we shall obtain with Maple are mathematically equivalent to t
hose in the literature, they do not always look the same.  We sha
ll see that it is easy for Maple to get the correct expression bu
t it can be quite difficult to make the results obtained with Map
le look the same as the elegant expressions given in textbooks.  
We will not show how to transform the Maple expressions to the mo
re widely recognized forms (unless it is easy to accomplish); to 
do so requires quite considerable skill in expression manipulatio
n and is not the objective of this document."}}{COM_R 33 0{TEXT 1
 0 ""}}{COM_R 36 0{TEXT 1 105 "The Gibbs free energy of mixing is
 made of the ideal free energy of mixing and an excess free energ
y term"}}}{SCP_R 38 0 2{INP_R 40 0 "> "{TEXT 0 50 "restart: inter
face(labelling=false); with(linalg):"}}{OUT_R 43 0 40{TEXT 2 72 "
Warning: new definition for   norm\012Warning: new definition for
   trace\012\012"}}}{SCP_R 45 0 2{INP_R 47 0 "> "{TEXT 0 22 "G[mi
x]=G[ideal]+G[ex];"}}{OUT_R 50 8192 47{DAG =3b3n3\`G`,2n3\`mix`+5
b3p2,2n4\`ideal`j2x0001b3p2,2n3\`ex`pE}}}{SCP_R 52 0 3{COM_R 54 0
{TEXT 1 0 ""}}{COM_R 57 0{TEXT 1 40 "with the ideal free energy t
erm given by"}}{COM_R 60 0{TEXT 1 0 ""}}}{SCP_R 62 0 2{INP_R 64 0
 "> "{TEXT 0 49 "i:='i': G[ideal]/(R*T)=sum(x[i]*ln(x[i]),i=1..c)
;"}}{OUT_R 67 8192 64{DAG =3*7b3n3\`G`,2n4\`ideal`j2x0001n3\`R`i2
x0001n3\`T`pD(3n3\`sum`,3*5b3n3\`x`,2n3\`i`p9(3n3\`ln`,2p17p9=3p1
B~3p9n3\`c`}}}{SCP_R 69 0 1{COM_R 71 0{TEXT 1 138 "where R is the
 gas constant and T is the (absolute) temperature. The mole fract
ions are related to the numbers of moles (molar amounts) by"}}}
{SCP_R 73 0 2{INP_R 75 0 "> "{TEXT 0 43 "i:='i': Molefrac:=x[i]=n
[i]/n[t]: Molefrac;"}}{OUT_R 78 8192 75{DAG =3b3n3\`x`,2n3\`i`*5b
3n3\`n`p4j2x0001b3p9,2n3\`t`i2x0001}}}{SCP_R 80 0 1{COM_R 82 0
{TEXT 1 37 "The total number of moles is given by"}}}{SCP_R 84 0 
2{INP_R 86 0 "> "{TEXT 0 44 "i:='i': ntdef:=n[t]=sum(n[i],i=1..c)
: ntdef;"}}{OUT_R 89 8192 86{DAG =3b3n3\`n`,2n3\`t`(3n3\`sum`,3b3
p2,2n3\`i`=3pE~3j2x0001n3\`c`}}}{SCP_R 91 0 2{INP_R 93 0 "> "
{TEXT 0 28 "ln(gamma[i])=Diff(n[t]*Q,y);"}}{OUT_R 96 8192 93{DAG 
=3(3n3\`ln`,2b3n4\`gamma`,2n3\`i`(3n4\`Diff`,3*5b3n3\`n`,2n3\`t`j
2x0001n3\`Q`p18n3\`y`}}}{SCP_R 98 0 1{COM_R 100 0{TEXT 1 108 "whe
re y represents the number of moles of the i-th component and Q i
s the dimensionless Gibb's excess energy"}}}{SCP_R 102 0 2{INP_R 
104 0 "> "{TEXT 0 14 "Q=G[ex]/(R*T);"}}{OUT_R 107 8192 104{DAG =3
n3\`Q`*7b3n3\`G`,2n3\`ex`j2x0001n3\`R`i2x0001n3\`T`pE}}}{SCP_R 
109 0 3{COM_R 111 0{TEXT 1 55 "Here we need a set of data for the
 excess Gibbs energy."}}{COM_R 114 0{TEXT 1 0 ""}}{COM_R 117 0
{TEXT 1 424 "The simple shape of the curves in these figures sugg
ests that the data can be fit by relatively simple expressions.  
One requirement is that our chosen expression must go to zero whe
never we have a pure liquid (i.e. when the mole fraction of any c
omponent is zero).  However, not just any mathematical expression
 that meets this simple requirement will do; the chosen expressio
n must also satisfy the Gibbs-Duhem equation.  "}}}{SCP_R 119 0 2
{INP_R 121 0 "> "{TEXT 0 50 "GDeqn:=sum(x[i]*Diff(ln(x[i]),y),i=1
..c)=0: GDeqn;"}}{OUT_R 124 8192 121{DAG =3(3n3\`sum`,3*5b3n3\`x`
,2n3\`i`j2x0001(3n4\`Diff`,3(3n3\`ln`,2p6n3\`y`pC=3pA~3pCn3\`c`j2
x0000}}}{SCP_R 126 0 3{COM_R 128 0{TEXT 1 112 "Here y represents 
the number of moles of any component (the temperature and pressur
e are assumed constant here)."}}{COM_R 131 0{TEXT 1 0 ""}}{COM_R 
134 0{TEXT 1 104 "The simplest model for the Gibbs excess energy 
in a two component system that meets both requirements is"}}}
{SCP_R 136 0 2{INP_R 138 0 "> "{TEXT 0 60 "c:=2: x:=linalg[vector
](c): QRegSol:=Q=A*x[1]*x[2]: QRegSol;"}}{OUT_R 141 8192 138{DAG 
=3n3\`Q`*7n3\`A`j2x0001b3n3\`x`,2p6p6b3p9,2j2x0002p6}}}{SCP_R 143
 0 3{COM_R 145 0{TEXT 1 57 "where A is a parameter to be fitted t
o experimental data."}}{COM_R 148 0{TEXT 1 0 ""}}{COM_R 151 0
{TEXT 1 169 "To obtain the activity coefficientswe proceed as fol
lows: first we express the mole fractions in the expression for t
he Gibbs excess energy in terms of the mole numbers."}}}{SCP_R 
153 0 2{INP_R 155 0 "> "{TEXT 0 49 "QQ:=subs(seq(x[i]=n[i]/n[t],i
=1..c),QRegSol): QQ;"}}{OUT_R 158 8192 155{DAG =3n3\`Q`*9n3\`A`j2
x0001b3n3\`n`,2p6p6b3p9,2n3\`t`i2x0002b3p9,2j2x0002p6}}}{SCP_R 
160 0 1{COM_R 162 0{TEXT 1 212 "Since we will have to differentia
te this expression with respect to the mole numbers we need to mu
ltiply Q by the total number of moles and to replace that quantit
y by the sum of the mole numbers of each species."}}}{SCP_R 164 0
 2{INP_R 166 0 "> "{TEXT 0 44 "QQ:=subs(n[t]=sum(n[j],j=1..c),n[t
]*QQ): QQ;"}}{OUT_R 169 8192 166{DAG =3*5+5b3n3\`n`,2j2x0001p7b3p
4,2j2x0002p7p7n3\`Q`p7*9p2i2x0001n3\`A`p7p3p7pAp7}}}{SCP_R 171 0 
1{COM_R 173 0{TEXT 1 94 "We may now differentiate with respect to
 mole numbers to get the mole fraction of component 1."}}}{SCP_R 
175 0 2{INP_R 177 0 "> "{TEXT 0 40 "t1:=ln(gamma[1])=diff(rhs(QQ)
,n[1]): t1;"}}{OUT_R 180 8192 177{DAG =3(3n3\`ln`,2b3n4\`gamma`,2
j2x0001+5*9+5b3n3\`n`p9pAb3p10,2j2x0002pAi2x0002n3\`A`pApFpAp14pA
i2x0001*7pEp23p1CpAp14pApA}}}{SCP_R 182 0 1{COM_R 184 0{TEXT 1 
206 "Expressions for the activity coefficients usually are expres
sed as functions of the mole fractions.  This means we have to us
e the relationship between mole fractions and mole numbers in rev
erse as follows:"}}}{SCP_R 186 0 2{INP_R 188 0 "> "{TEXT 0 47 "i:
='i': t1:=subs(sum(n[i],i=1..c)=n[t],t1): t1;"}}{OUT_R 191 8192 
188{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x0001+5*9n3\`A`pAb3n3\`n`p9p
Ab3p12,2n3\`t`i2x0002b3p12,2j2x0002pAi2x0001*7p16p23pEpAp1DpApA}}
}{SCP_R 193 0 2{INP_R 195 0 "> "{TEXT 0 44 "t2:=subs(seq(n[i]=x[i
]*n[t],i=1..c),t1): t2;"}}{OUT_R 198 8192 195{DAG =3(3n3\`ln`,2b3
n4\`gamma`,2j2x0001+5*7n3\`A`pAb3n3\`x`p9pAb3p12,2j2x0002pAi2x000
1*5pEpAp16pApA}}}{SCP_R 200 0 1{COM_R 202 0{TEXT 1 236 "This is t
he result we need but it does not look very elegant and it is not
 in a form that you will find in any thermodynamics textbook.  To
 recover a more familiar form we need to make use of the fact tha
t the mole fractions sum to one."}}}{SCP_R 204 0 2{INP_R 206 0 ">
 "{TEXT 0 39 "t3:=simplify(subs(x[1]=1-x[2],t2)): t3;"}}{OUT_R 
209 8192 206{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x0001*5n3\`A`pAb3n3
\`x`,2j2x0002p14}}}{SCP_R 211 0 1{COM_R 213 0{TEXT 1 2 "or"}}}
{SCP_R 215 0 2{INP_R 217 0 "> "{TEXT 0 29 "t4:=subs(x[2]=1-x[1],t
3): t4;"}}{OUT_R 220 8192 217{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x0
001*5n3\`A`pA+5pApAb3n3\`x`p9i2x0001j2x0002}}}{SCP_R 222 0 3
{COM_R 224 0{TEXT 1 0 ""}}{COM_R 227 0{TEXT 1 90 "We can repeat t
he above series of steps to obtain the activity coefficient of co
mponent 2."}}{COM_R 230 0{TEXT 1 0 ""}}}{SCP_R 232 0 5{INP_R 234 
0 "> "{TEXT 0 36 "r1:=ln(gamma[2])=diff(rhs(QQ),n[2]):"}}{INP_R 
237 0 "> "{TEXT 0 43 "i:='i': r1:=subs(sum(n[i],i=1..c)=n[t],r1):
"}}{INP_R 240 0 "> "{TEXT 0 40 "r2:=subs(seq(n[i]=x[i]*n[t],i=1..
c),r1):"}}{INP_R 243 0 "> "{TEXT 0 38 "r3:=simplify(subs(x[2]=1-x
[1],r2)):r3;"}}{OUT_R 246 8192 243{DAG =3(3n3\`ln`,2b3n4\`gamma`,
2j2x0002*5n3\`A`j2x0001b3n3\`x`,2pFpA}}}{SCP_R 248 0 2{INP_R 250 
0 "> "{TEXT 0 29 "r4:=subs(x[1]=1-x[2],r3): r4;"}}{OUT_R 253 8192
 250{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x0002*5n3\`A`j2x0001+5pFpFb
3n3\`x`p9i2x0001pA}}}{SCP_R 255 0 1{COM_R 257 0{TEXT 1 286 "We ma
ke functions of these results (and of the expression for the exce
ss Gibbs energy) for plotting purposes (note that as only one of 
the mole fractions is independent we must use the form that makes
 both of the activity coefficients a function of the mole fractio
n of species 1 only)."}}}{SCP_R 259 0 4{INP_R 261 0 "> "{TEXT 0 
114 "lng1:=unapply(rhs(t4), A, x[1]); lng2:=unapply(rhs(r3),A,x[1
]); q:=unapply(subs(x[2]=1-x[1],rhs(QRegSol)),A,x[1]);"}}{OUT_R 
264 8192 261{DAG :3n4\`lng1`@7,3n3\`y1`n3\`y2`,1,3n5\`operator`n4
\`arrow`pA*5a2x0001j2x0001+5p17p17a2x0002i2x0001j2x0002pA}}{OUT_R
 267 8192 261{DAG :3n4\`lng2`@7,3n3\`y1`n3\`y2`,1,3n5\`operator`n
4\`arrow`pA*5a2x0001j2x0001a2x0002j2x0002pA}}{OUT_R 270 8192 261
{DAG :3n3\`q`@7,3n3\`y1`n3\`y2`,1,3n5\`operator`n4\`arrow`p9*7a2x
0001j2x0001a2x0002p16+5p16p16p18i2x0001p16p9}}}{SCP_R 272 0 2
{INP_R 274 0 "> "{TEXT 0 58 "plot(\{lng1(2,x),lng2(2,x),q(2,x)\},
x=0..1,0..2,axes=boxed);"}}{OUT_R 277 0 274{TEXT 2 1 "\012"}}}
{SCP_R 279 0 1{COM_R 281 0{TEXT 1 0 ""}}}{SCP_R 283 0 2{COM_R 285
 0{TEXT 1 195 "where we have plotted the natural logarithm of the
 activity coefficients of components 1 and 2 and the dimensionles
s excess Gibbs energy for a binary system where the parameter A h
as the value 2."}}{COM_R 288 0{TEXT 1 661 "The x-axis is the mole
 fraction of component 1 (the mole fraction of component 2 goes f
rom 0 to 1 on the same axis in reverse - i.e. from right to left)
.  The dimensionless Gibbs excess energy is the curve that is zer
o at each end.  Note the symmetry in the curves (a necessary cons
equence of this simple model for Q).  Note further that all three
 curves intersect at the same point. (The fact that all three cur
ves interesect at the same place will be found for other models o
f the Gibbs excess energy as well; the fact that the mole fractio
n is 0.5 is peculiar to this model.  The values of the activity c
oefficients at the edges of the graph are of interest:"}}}{SCP_R 
290 0 3{INP_R 292 0 "> "{TEXT 0 66 "ln(gamma[1][infinity])=lng1(A
,0);ln(gamma[2][infinity])=lng2(A,1);"}}{OUT_R 295 8192 292{DAG =
3(3n3\`ln`,2b3b3n4\`gamma`,2j2x0001,2n5\`infinity`n3\`A`}}{OUT_R 
298 8192 292{DAG =3(3n3\`ln`,2b3b3n4\`gamma`,2j2x0002,2n5\`infini
ty`n3\`A`}}}{SCP_R 300 0 9{COM_R 302 0{TEXT 1 322 "which shows th
at the parameter A is equal to the limiting values of the logarit
hm of the activity coefficients at zero concentration. A more com
mon name for this condition is infinite dilution.  This result al
lows us to identify the curves in the figure with the (logarithm 
of the) activity coefficients of each component."}}{COM_R 305 0
{TEXT 1 0 ""}}{COM_R 308 0{TEXT 1 101 "Exercise: Plot the activit
y coefficients and Gibbs excess energy for other values of the pa
rameter A."}}{COM_R 311 0{TEXT 1 0 ""}}{COM_R 314 0{TEXT 1 173 "E
xercise: Prove to yourself that, for this simple model of the exc
ess Gibbs energy, the activity coefficients and the excess Gibbs 
energy always intersect at the same point."}}{COM_R 317 0{TEXT 1 
0 ""}}{COM_R 320 0{TEXT 1 327 "Not many mixtures of real chemical
s obey this very simple model of the Gibbs excess energy.  Exampl
es of systems that do include mixtures of ethylbenzene with vario
us isomers of xylene (Redlich, 1976).  For these systems the para
meter A has values in the range 0.0035 to 0.0003 which means the 
mixtures are very close to ideal."}}{COM_R 323 0{TEXT 1 0 ""}}
{COM_R 326 0{TEXT 1 664 "What this means is that the simple model
 of the Gibbs excess energy that we have used here to show how ac
tivity coefficient expressions may be derived is not good enough 
for most practical thermodynamic calculations.  Many other models
 have been proposed and we shall consider them in due course.  In
 all cases, however, we may use the method established above as t
he way to derive expressions for the activity coefficients.  It w
ould, therefore, make sense to automate the procedure.  Here is a
 Maple procedure that returns an expression for the natural logar
ithm of the activity coefficient of component k given a model for
 the dimensionless excess Gibbs energy."}}}{SCP_R 328 0 14{INP_R 
330 0 "> "{TEXT 0 21 "actcof := proc(Q,x,k)"}}{INP_R 333 0 "> "
{TEXT 0 62 "# Arguments: Q - Expression for the dimensionless Gib
bs energy"}}{INP_R 336 0 "> "{TEXT 0 51 "#                      x
 - vector of mole fractions"}}{INP_R 339 0 "> "{TEXT 0 86 "#     
                 k - Component index number whose activity coeffi
cient is sought"}}{INP_R 342 0 "> "{TEXT 0 37 "local QQ, i, j, t1
, t2, t3, t4, n, c;"}}{INP_R 345 0 "> "{TEXT 0 22 "c:=linalg[vect
dim](x);"}}{INP_R 348 0 "> "{TEXT 0 44 "QQ:=n[t]*subs(seq(x[i]=n[
i]/n[t],i=1..c),Q);"}}{INP_R 351 0 "> "{TEXT 0 35 "QQ:=subs(n[t]=
sum(n[j],j=1..c),QQ);"}}{INP_R 354 0 "> "{TEXT 0 26 "i:='i': t1:=
diff(QQ,n[k]);"}}{INP_R 357 0 "> "{TEXT 0 35 "t1:=subs(sum(n[i],i
=1..c)=n[t],t1);"}}{INP_R 360 0 "> "{TEXT 0 40 "t2:=subs(seq(n[i]
=x[i]*n[t],i=1..c),t1);"}}{INP_R 363 0 "> "{TEXT 0 21 "t3:=collec
t(t2,n[t]);"}}{INP_R 366 0 "> "{TEXT 0 4 "end;"}}{OUT_R 369 0 366
{TEXT 2 459 "actcof := proc(Q,x,k)\012          local QQ,i,j,t1,t
2,t3,t4,n,c;\012              c := linalg[vectdim](x);\012       
       QQ := n[t]*subs(seq(x[i] = n[i]/n[t],i = 1 .. c),Q);\012  
            QQ := subs(n[t] = sum(n[j],j = 1 .. c),QQ);\012      
        i := 'i';\012              t1 := diff(QQ,n[k]);\012      
        t1 := subs(sum(n[i],i = 1 .. c) = n[t],t1);\012          
    t2 := subs(seq(n[i] = x[i]*n[t],i = 1 .. c),t1);\012         
     t3 := collect(t2,n[t])\012          end\012\012\012"}}}
{SCP_R 371 0 3{COM_R 373 0{TEXT 1 81 "This procedure will also wo
rk when we have more than two components to deal with."}}{COM_R 
376 0{TEXT 1 0 ""}}{COM_R 379 0{TEXT 1 107 "Exercise: Check that 
the routine does what it is claimed for it by testing it on the m
odel discussed above."}}}{SCP_R 381 0 3{INP_R 383 0 "> "{TEXT 0 
24 "save actcof, `actcof.m`;"}}{COM_R 386 0{TEXT 1 0 ""}}{OUT_R 
389 0 383{TEXT 2 1 "\012"}}}{SCP_R 391 0 3{COM_R 393 0{TEXT 1 21 
"The Margules Equation"}}{COM_R 396 0{TEXT 1 0 ""}}{COM_R 399 0
{TEXT 1 116 "The Margules equation (more precisely known as the 2
-parameter Margules model) for two component systems is given by"
}}}{SCP_R 401 0 2{INP_R 403 0 "> "{TEXT 0 92 "A[1,2]:='A[1,2]': A
[2,1]:='A[2,1]': QMargul:=Q=x[1]*x[2]*(A[1,2]*x[2]+A[2,1]*x[1]): 
QMargul;"}}{OUT_R 406 8192 403{DAG =3n3\`Q`*7b3n3\`x`,2j2x0001p8b
3p5,2j2x0002p8+5*5b3n3\`A`,3p8pEp8pBp8p8*5b3p14,3pEp8p8p4p8p8p8}}
}{SCP_R 408 0 5{COM_R 410 0{TEXT 1 0 ""}}{COM_R 413 0{TEXT 1 47 "
where A and B are the parameters in the model. "}}{COM_R 416 0
{TEXT 1 0 ""}}{COM_R 419 0{TEXT 1 74 "To obtain the activity coef
ficients we invoke the procedure created above."}}{COM_R 422 0
{TEXT 1 0 ""}}}{SCP_R 424 0 2{INP_R 426 0 "> "{TEXT 0 46 "g1:=ln(
gamma[1])=actcof(rhs(QMargul),x,1): g1;"}}{OUT_R 429 8192 426{DAG
 =3(3n3\`ln`,2b3n4\`gamma`,2j2x0001+7*7b3n3\`x`p9pAb3pF,2j2x0002p
A+5*5b3n3\`A`,3pAp16pAp13pApA*5b3p1C,3p16pApApEpApApAi2x0001*5p13
pAp19pApA*7pEpAp13pA+7p1Ap30p26pAp25p30pApA}}}{SCP_R 431 0 3
{COM_R 433 0{TEXT 1 0 ""}}{COM_R 436 0{TEXT 1 173 "which is perfe
ctly correct but not very attractive.  We shall endeavor to make 
the results a little more appealing by making use of the fact the
 mole fractions sum to unity."}}{COM_R 439 0{TEXT 1 0 ""}}}{SCP_R
 441 0 2{INP_R 443 0 "> "{TEXT 0 25 "g1:=subs(x[1]=1-x[2],g1);"}}
{OUT_R 446 8192 443{DAG :3n3\`g1`=3(3n3\`ln`,2b3n4\`gamma`,2j2x00
01+7*7+5pDpDb3n3\`x`,2j2x0002i2x0001pDp14pD+5*5b3n3\`A`,3pDp18pDp
14pDpD*5b3p22,3p18pDpDp11pDpDpDp1A*5p14pDp1FpDpD*7p11pDp14pD+7p20
p1Ap2CpDp2Bp1ApDpD}}}{SCP_R 448 0 2{INP_R 450 0 "> "{TEXT 0 27 "g
1:=collect(g1,x[2]):  g1; "}}{OUT_R 453 8192 450{DAG =3(3n3\`ln`,
2b3n4\`gamma`,2j2x0001+5*5+5b3n3\`A`,3pAj2x0002p14b3p10,3p14pAi2x
0002pAb3n3\`x`,2p14j2x0003pA*5+5pFi2x0001p17p14pAp1Fp14pA}}}
{SCP_R 455 0 2{INP_R 457 0 "> "{TEXT 0 28 "g1:=subs(x[2]=1-x[1],\
"): g1;"}}{OUT_R 460 8192 457{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x0
001+5*5+5b3n3\`A`,3pAj2x0002p14b3p10,3p14pAi2x0002pA+5pApAb3n3\`x
`p9i2x0001j2x0003pA*5+5pFp26p17p14pAp1Fp14pA}}}{SCP_R 462 0 3
{COM_R 464 0{TEXT 1 0 ""}}{COM_R 467 0{TEXT 1 67 "The acivity coe
fficient of component 2 is obtained in the same way:"}}{COM_R 470
 0{TEXT 1 0 ""}}}{SCP_R 472 0 2{INP_R 474 0 "> "{TEXT 0 46 "g2:=l
n(gamma[2])=actcof(rhs(QMargul),x,2): g2;"}}{OUT_R 477 8192 474
{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x0002+7*7b3n3\`x`,2j2x0001p12b3
pFp9p12+5*5b3n3\`A`,3p12pAp12p15p12p12*5b3p1C,3pAp12p12pEp12p12p1
2i2x0001*5pEp12p19p12p12*7pEp12p15p12+7p1Bp12p1Ap30p25p30p12p12}}
}{SCP_R 479 0 3{INP_R 481 0 "> "{TEXT 0 25 "g2:=subs(x[2]=1-x[1],
g2):"}}{INP_R 484 0 "> "{TEXT 0 25 "g2:=collect(g2,x[1]): g2;"}}
{OUT_R 487 8192 484{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x0002+5*5+5b
3n3\`A`,3j2x0001pAi2x0002b3p10,3pAp13pAp13b3n3\`x`,2p13j2x0003p13
*5+5pFpAp18i2x0001p13p1FpAp13}}}{SCP_R 489 0 3{COM_R 491 0{TEXT 1
 91 "Note the antisymmetry in the coefficients of the expressions
 of both activity coefficients."}}{COM_R 494 0{TEXT 1 0 ""}}
{COM_R 497 0{TEXT 1 53 "We make functions of these expressions fo
r later use."}}}{SCP_R 499 0 2{INP_R 501 0 "> "{TEXT 0 44 "lng1:=
unapply(rhs(g1), A[1,2],A[2,1], x[1]);"}}{OUT_R 504 8192 501{DAG 
:3n4\`lng1`@7,4n3\`y1`n3\`y2`n3\`y3`,1,3n5\`operator`n4\`arrow`pC
+5*5+5a2x0001j2x0002a2x0002i2x0002j2x0001+5p21p21a2x0003i2x0001j2
x0003p21*5+5p19p28p1Dp1Bp21p23p1Bp21pC}}}{SCP_R 506 0 2{INP_R 508
 0 "> "{TEXT 0 44 "lng2:=unapply(rhs(g2), A[1,2],A[2,1], x[1]);"}
}{OUT_R 511 8192 508{DAG :3n4\`lng2`@7,4n3\`y1`n3\`y2`n3\`y3`,1,3
n5\`operator`n4\`arrow`pC+5*5+5a2x0001i2x0002a2x0002j2x0002j2x000
1a2x0003j2x0003p21*5+5p19p1Fp1Di2x0001p21p23p1Fp21pC}}}{SCP_R 513
 0 2{INP_R 515 0 "> "{TEXT 0 65 "Qfun:=unapply(subs(x[2]=1-x[1],r
hs(QMargul)),A[1,2],A[2,1],x[1]);"}}{OUT_R 518 8192 515{DAG :3n4\
`Qfun`@7,4n3\`y1`n3\`y2`n3\`y3`,1,3n5\`operator`n4\`arrow`pC*7a2x
0003j2x0001+5p19p19p17i2x0001p19+5*5a2x0001p19p1Bp19p19*5a2x0002p
19p17p19p19p19pC}}}{SCP_R 520 0 1{COM_R 522 0{TEXT 1 70 "The acti
vity coefficients at infinite dilution are obtained as before:"}}
}{SCP_R 524 0 3{INP_R 526 0 "> "{TEXT 0 90 "ln(gamma[1][infinity]
)=lng1(A[1,2],A[2,1],0);ln(gamma[2][infinity])=lng2(A[1,2],A[2,1]
,1);"}}{OUT_R 529 8192 526{DAG =3(3n3\`ln`,2b3b3n4\`gamma`,2j2x00
01,2n5\`infinity`b3n3\`A`,3pBj2x0002}}{OUT_R 532 8192 526{DAG =3(
3n3\`ln`,2b3b3n4\`gamma`,2j2x0002,2n5\`infinity`b3n3\`A`,3pBj2x00
01}}}{SCP_R 534 0 7{COM_R 536 0{TEXT 1 118 "which shows how the p
arameters may be estimated quite simply if the infinite dilution 
activity coefficients are known."}}{COM_R 539 0{TEXT 1 0 ""}}
{COM_R 542 0{TEXT 1 52 "The parameters for some binary system are
 given here"}}{COM_R 545 0{TEXT 1 0 ""}}{COM_R 548 0{TEXT 1 122 "
Exercise: The Margules equations sometimes are obtained by starti
ng with the excess Gibbs energy expressed as a polynomial"}}
{COM_R 551 0{TEXT 1 0 ""}}{COM_R 554 0{TEXT 1 0 ""}}}{SCP_R 556 0
 3{INP_R 558 0 "> "{TEXT 0 23 "A:='A': B:='B': C:='C':"}}{INP_R 
561 0 "> "{TEXT 0 68 "N:='N':Qpoly:=Q=x[1]*x[2]*sum(C[k]*(x[1]-x[
2])^(k-1),k=1..N): Qpoly;"}}{OUT_R 564 8192 561{DAG =3n3\`Q`*7b3n
3\`x`,2j2x0001p8b3p5,2j2x0002p8(3n3\`sum`,3*5b3n3\`C`,2n3\`k`p8^3
+5p4p8pBi2x0001+5p1Ap8p22p8p8=3p1A~3p8n3\`N`p8}}}{SCP_R 566 0 4
{COM_R 568 0{TEXT 1 0 ""}}{COM_R 571 0{TEXT 1 80 "Exercise: Show 
that with N equal to 1 we recover the simplest  model used above.
"}}{COM_R 574 0{TEXT 1 0 ""}}{COM_R 577 0{TEXT 1 29 "For N set eq
ual to 2 we find "}}}{SCP_R 579 0 2{INP_R 581 0 "> "{TEXT 0 38 "N
:=2: QM:=Qpoly: C[1]:=A: C[2]:=B: QM;"}}{OUT_R 584 8192 581{DAG =
3n3\`Q`*7b3n3\`x`,2j2x0001p8b3p5,2j2x0002p8+5n3\`A`p8*5n3\`B`p8+5
p4p8pBi2x0001p8p8p8}}}{SCP_R 586 0 7{COM_R 588 0{TEXT 1 46 "where
 A and B are the parameters in the model."}}{COM_R 591 0{TEXT 1 0
 ""}}{COM_R 594 0{TEXT 1 258 "Use the above expression and obtain
 expressions for the activity coefficients.  Show that the result
s are equivalent to those we have obtained here.  What is the rel
ationship between the parameters in this formulation and those in
 the formulation used above?"}}{COM_R 597 0{TEXT 1 0 ""}}{COM_R 
600 0{TEXT 1 7 "Example"}}{COM_R 603 0{TEXT 1 0 ""}}{COM_R 606 0
{TEXT 1 269 "Parameters in the above formulation have been publis
hed in the DECHEMA series for many different binary mixtures.  Co
nvert these parameters to the first form that we used and hence p
lot the the activity coefficients and the excess energy as a func
tion of mole fraction."}}}{SCP_R 608 0 2{INP_R 610 0 "> "{TEXT 0 
42 "p1:=A[1,2]=1.58: p2:=A[2,1]=0.9307: p1,p2;"}}{OUT_R 613 8192 
610{DAG ,3=3b3n3\`A`,3j2x0001j2x0002e3j2x0158i2x0002=3b3p3,3p8p6e
3j2x9307i2x0004}}}{SCP_R 615 0 2{INP_R 617 0 "> "{TEXT 0 39 "solv
e(\{rhs(p1)=A-B,rhs(p2)=A+B\},\{A,B\});"}}{OUT_R 620 8192 617{DAG
 %2,3=3n3\`B`e3i4x003246500000i2x0010=3n3\`A`e3j4x001255350000i2x
0009}}}{SCP_R 622 0 3{INP_R 624 0 "> "{TEXT 0 10 "assign(\");"}}
{INP_R 627 0 "> "{TEXT 0 67 "plot(\{Qfun(A,B,x),lng1(A,B,x),lng2(
A,B,x)\},x=0..1,0..2,axes=boxed);"}}{COM_R 630 0{TEXT 1 0 ""}}}
{SCP_R 632 0 3{COM_R 634 0{TEXT 1 14 "Van Laar Model"}}{COM_R 637
 0{TEXT 1 0 ""}}{COM_R 640 0{TEXT 1 129 "Our next model is that o
f Van Laar (1910, 1913).  In this model  the excess Gibbs energy 
is given by the reciprocal relationship:"}}}{SCP_R 642 0 2{INP_R 
644 0 "> "{TEXT 0 71 "A:=linalg[matrix](2,2): QVL:= 1/Q=1/(A[1,2]
*x[1])+1/(A[2,1]*x[2]): QVL;"}}{OUT_R 647 8192 644{DAG =3*3n3\`Q`
i2x0001+5*5b3n3\`x`,2j2x0001p4b3n3\`A`,3pCj2x0002p4pC*5b3p9,2p14p
4b3p10,3p14pCp4pC}}}{SCP_R 649 0 3{COM_R 651 0{TEXT 1 0 ""}}
{COM_R 654 0{TEXT 1 63 "which may be rearranged as follows to get
 a more familiar form."}}{COM_R 657 0{TEXT 1 0 ""}}}{SCP_R 659 0 
2{INP_R 661 0 "> "{TEXT 0 65 "solve(QVL,Q): numer(\")*(-1) / deno
m(\")*(-1): QVL:=Q=sort(\"): QVL;"}}{OUT_R 664 8192 661{DAG =3n3\
`Q`*B+5*5b3n3\`x`,2j2x0001pAb3n3\`A`,3pAj2x0002pApA*5b3p7,2p12pAb
3pE,3p12pApApAi2x0001p6pAp17pApDpAp1CpA}}}{SCP_R 666 0 2{COM_R 
668 0{TEXT 1 75 "Invoking the procedure to obtain the activity co
efficients may now be done:"}}{COM_R 671 0{TEXT 1 0 ""}}}{SCP_R 
673 0 2{INP_R 675 0 "> "{TEXT 0 42 "g1:=ln(gamma[1])=actcof(rhs(Q
VL),x,1): g1;"}}{OUT_R 678 8192 675{DAG =3(3n3\`ln`,2b3n4\`gamma`
,2j2x0001+7*B+5*5b3n3\`x`p9pAb3n3\`A`,3pAj2x0002pApA*5b3p11,2p1Ap
Ab3p16,3p1ApApApAi2x0001p10pAp1FpAp15pAp24pAp2B*DpEi2x0002p10pAp1
FpAp15pAp24pA+7p15pApFp2Bp1Ep2BpAp2B*9pEp2Bp1FpAp15pAp24pApA}}}
{SCP_R 680 0 3{COM_R 682 0{TEXT 1 0 ""}}{COM_R 685 0{TEXT 1 64 "T
his model may be expressed in a recognizable form quite simply."}
}{COM_R 688 0{TEXT 1 0 ""}}}{SCP_R 690 0 2{INP_R 692 0 "> "{TEXT 
0 21 "g1:=simplify(g1): g1;"}}{OUT_R 695 8192 692{DAG =3(3n3\`ln`
,2b3n4\`gamma`,2j2x0001*9b3n3\`A`,3pAj2x0002pAb3pE,3p12pAp12b3n3\
`x`,2p12p12+5*5b3p1Cp9pApDpApA*5p1BpAp15pApAi2x0002}}}{SCP_R 697 
0 1{COM_R 699 0{TEXT 1 38 "The coefficient of component 2 follows
"}}}{SCP_R 701 0 3{INP_R 703 0 "> "{TEXT 0 38 "g2:=ln(gamma[2])=a
ctcof(rhs(QVL),x,2):"}}{INP_R 706 0 "> "{TEXT 0 21 "g2:=simplify(
g2): g2;"}}{OUT_R 709 8192 706{DAG =3(3n3\`ln`,2b3n4\`gamma`,2j2x
0002*9b3n3\`x`,2j2x0001pAb3n3\`A`,3p11pApAb3p15,3pAp11p11+5*5pDp1
1p14p11p11*5b3pEp9p11p1Bp11p11i2x0002}}}{SCP_R 711 0 1{COM_R 713 
0{TEXT 1 50 "Once again, we make function for plotting purposes"}
}}{SCP_R 715 0 3{INP_R 717 0 "> "{TEXT 0 25 "t1:=subs(x[2]=1-x[1]
,g1):"}}{INP_R 720 0 "> "{TEXT 0 44 "lng1:=unapply(rhs(t1), A[1,2
],A[2,1], x[1]);"}}{OUT_R 723 8192 720{DAG :3n4\`lng1`@7,4n3\`y1`
n3\`y2`n3\`y3`,1,3n5\`operator`n4\`arrow`pC*9a2x0001j2x0001a2x000
2j2x0002+5p19p19a2x0003i2x0001p1D+5*5p22p19p17p19p19*5p1Fp19p1Bp1
9p19i2x0002pC}}}{SCP_R 725 0 3{INP_R 727 0 "> "{TEXT 0 25 "t2:=su
bs(x[2]=1-x[1],g2):"}}{INP_R 730 0 "> "{TEXT 0 44 "lng2:=unapply(
rhs(t2), A[1,2],A[2,1], x[1]);"}}{OUT_R 733 8192 730{DAG :3n4\`ln
g2`@7,4n3\`y1`n3\`y2`n3\`y3`,1,3n5\`operator`n4\`arrow`pC*9a2x000
3j2x0002a2x0001p19a2x0002j2x0001+5*5p17p20p1Bp20p20*5+5p20p20p17i
2x0001p20p1Ep20p20i2x0002pC}}}{SCP_R 735 0 2{INP_R 737 0 "> "
{TEXT 0 61 "Qfun:=unapply(subs(x[2]=1-x[1],rhs(QVL)),A[1,2],A[2,1
],x[1]);"}}{OUT_R 740 8192 737{DAG :3n4\`Qfun`@7,4n3\`y1`n3\`y2`n
3\`y3`,1,3n5\`operator`n4\`arrow`pC*B+5*5a2x0003j2x0001a2x0001p1B
p1B*5+5p1Bp1Bp19i2x0001p1Ba2x0002p1Bp1Bp26p19p1Bp22p1Bp1Dp1Bp29p1
BpC}}}{SCP_R 742 0 2{INP_R 744 0 "> "{TEXT 0 119 "plot(\{Qfun(1.6
167,0.9878,x),lng1(1.6167,0.9878,x),lng2(1.6167,0.9878,x),Qfun(1.
6167,0.9878,x)\},x=0..1,0..2,axes=boxed);"}}{OUT_R 747 0 744{TEXT
 2 1 "\012"}}}{SCP_R 749 0 1{COM_R 751 0{TEXT 1 0 ""}}}{SCP_R 753
 0 1{COM_R 755 0{TEXT 1 101 "As before we find that the model par
ameters are equal to the infinite dilution activity coefficients.
"}}}{SCP_R 757 0 2{INP_R 759 0 "> "{TEXT 0 22 "lng1(A[1,2],A[2,1]
,0);"}}{OUT_R 762 8192 759{DAG b3n3\`A`,3j2x0001j2x0002}}}{SCP_R 
764 0 2{INP_R 766 0 "> "{TEXT 0 22 "lng2(A[1,2],A[2,1],1);"}}
{OUT_R 769 8192 766{DAG b3n3\`A`,3j2x0002j2x0001}}}{SCP_R 771 0 1
{COM_R 773 0{TEXT 1 131 "Chao, in his PhD thesis of 1956, publish
ed the following vapor-liquid equilibrium data for the benzene-cy
clohexane system at 1 atm:"}}}{SCP_R 775 0 3{INP_R 777 0 "> "
{TEXT 0 484 "dataset:=matrix([ [79.7,0.088,0.133,1.300,1.003], [7
9.1, 0.156, 0.190, 1.256, 1.008], [78.5, 0.231, 0.268, 1.219, 1.0
19],[78.0, 0.308, 0.343, 1.189, 1.032], [77.7, 0.400, 0.422, 1.13
6, 1.056], [ 77.6, 0.470, 0.482, 1.108, 1.075], [77.6, 0.545, 0.5
44, 1.079, 1.102], [77.6, 0.625, 0.612, 1.058, 1.138], [77.8, 0.7
01, 0.678, 1.039, 1.178], [78.0, 0.757, 0.727, 1.025, 1.221], [78
.3, 0.822, 0.791, 1.018, 1.263], [78.9, 0.891, 0.863, 1.005, 1.32
8], [79.5, 0.953, 0.938, 1.003, 1.369] ]):"}}{INP_R 780 0 "> "
{TEXT 0 15 "print(dataset);"}}{OUT_R 783 8192 780{DAG (3n4\`MATRI
X`,2[2,E[2,6e3j2x0797i2x0001e3j2x0088i2x0003e3j2x0133p11e3j2x1300
p11e3j2x1003p11[2,6e3j2x0791pCe3j2x0156p11e3j2x0190p11e3j2x1256p1
1e3j2x1008p11[2,6e3j2x0785pCe3j2x0231p11e3j2x0268p11e3j2x1219p11e
3j2x1019p11[2,6e3j2x0780pCe3j2x0308p11e3j2x0343p11e3j2x1189p11e3j
2x1032p11[2,6e3j2x0777pCe3j2x0400p11e3j2x0422p11e3j2x1136p11e3j2x
1056p11[2,6e3j2x0776pCe3j2x0470p11e3j2x0482p11e3j2x1108p11e3j2x10
75p11[2,6p79e3j2x0545p11e3j2x0544p11e3j2x1079p11e3j2x1102p11[2,6p
79e3j2x0625p11e3j2x0612p11e3j2x1058p11e3j2x1138p11[2,6e3j2x0778pC
e3j2x0701p11e3j2x0678p11e3j2x1039p11e3j2x1178p11[2,6p4De3j2x0757p
11e3j2x0727p11e3j2x1025p11e3j2x1221p11[2,6e3j2x0783pCe3j2x0822p11
e3p22p11e3j2x1018p11e3j2x1263p11[2,6e3j2x0789pCe3j2x0891p11e3j2x0
863p11e3j2x1005p11e3j2x1328p11[2,6e3j2x0795pCe3j2x0953p11e3j2x093
8p11p1Be3j2x1369p11}}}{SCP_R 785 0 2{COM_R 787 0{TEXT 1 426 "wher
e the columns of data are the temperature (in Celcius), the mole 
fraction of benzene in the liquid, the mole fraction of benzene i
n the vapor, the activity coefficient of benzene, and the activit
y coefficient of cyclohexane.  We show here how the data might be
 plotted.  The first step is to extract the columns of data we wi
sh to plot; in this case the activity coefficients as a function 
of the mole fraction of benzene."}}{COM_R 790 0{TEXT 1 0 ""}}}
{SCP_R 792 0 2{INP_R 794 0 "> "{TEXT 0 18 "X:=col(dataset,2);"}}
{OUT_R 797 8192 794{DAG :3n3\`X`(3n4\`VECTOR`,2[2,Ee3j2x0088i2x00
03e3j2x0156pDe3j2x0231pDe3j2x0308pDe3j2x0400pDe3j2x0470pDe3j2x054
5pDe3j2x0625pDe3j2x0701pDe3j2x0757pDe3j2x0822pDe3j2x0891pDe3j2x09
53pD}}}{SCP_R 799 0 3{INP_R 801 0 "> "{TEXT 0 39 "Y1:=col(dataset
,4); Y2:=col(dataset,5);"}}{OUT_R 804 8192 801{DAG :3n3\`Y1`(3n4\
`VECTOR`,2[2,Ee3j2x1300i2x0003e3j2x1256pDe3j2x1219pDe3j2x1189pDe3
j2x1136pDe3j2x1108pDe3j2x1079pDe3j2x1058pDe3j2x1039pDe3j2x1025pDe
3j2x1018pDe3j2x1005pDe3j2x1003pD}}{OUT_R 807 8192 801{DAG :3n3\`Y
2`(3n4\`VECTOR`,2[2,Ee3j2x1003i2x0003e3j2x1008pDe3j2x1019pDe3j2x1
032pDe3j2x1056pDe3j2x1075pDe3j2x1102pDe3j2x1138pDe3j2x1178pDe3j2x
1221pDe3j2x1263pDe3j2x1328pDe3j2x1369pD}}}{SCP_R 809 0 1{COM_R 
811 0{TEXT 1 172 "However, we will wish to plot the natural logar
ithm of the activity coefficients so we create two new vectors to
 hold these values and use the map function to compute them."}}}
{SCP_R 813 0 2{INP_R 815 0 "> "{TEXT 0 17 "lnY1:=map(ln,Y1);"}}
{OUT_R 818 8192 815{DAG :3n4\`lnY1`(3n4\`VECTOR`,2[2,Ee3j4x002623
642645i2x0010e3j4x002279320680p10e3j4x001980308505p10e3j4x0017311
26177p10e3j4x001275133203p10e3j4x001025565883p10e3j4x007603468628
i2x0011e3j4x005638033344p35e3j4x003825871212p35e3j4x002469261259p
35e3j4x001783991813p35e3j4x004987541511i2x0012e3j4x002995508980p5
4}}}{SCP_R 820 0 2{INP_R 822 0 "> "{TEXT 0 17 "lnY2:=map(ln,Y2);"
}}{OUT_R 825 8192 822{DAG :3n4\`lnY2`(3n4\`VECTOR`,2[2,Ee3j4x0029
95508980i2x0012e3j4x007968169649p10e3j4x001882175424i2x0011e3j4x0
03149866706p1De3j4x005448818528p1De3j4x007232066158p1De3j4x009712
671073p1De3j4x001292723357i2x0010e3j4x001638180852p3Ce3j4x0019967
01951p3Ce3j4x002334898434p3Ce3j4x002836740511p3Ce3j4x003140805463
p3C}}}{SCP_R 827 0 3{COM_R 829 0{TEXT 1 0 ""}}{COM_R 832 0{TEXT 1
 193 "We now create a set of points that can be plotted.  Note th
at to save ourselves the trouble of counting the number of rows i
n the matrix of data we use the Maple command rowdim to count for
 us."}}{COM_R 835 0{TEXT 1 0 ""}}}{SCP_R 837 0 4{INP_R 839 0 "> "
{TEXT 0 25 "numrows:=rowdim(dataset):"}}{INP_R 842 0 "> "{TEXT 0 
85 "line1:=[seq([X[i],lnY1[i]],i=1..numrows)]: line2:=[seq([X[i],
lnY2[i]],i=1..numrows)]:"}}{INP_R 845 0 "> "{TEXT 0 69 "plot1:=pl
ot(\{line1,line2\},0..1,0..0.4,style=point,axes=boxed): plot1;"}}
{OUT_R 848 0 845{TEXT 2 1 "\012"}}}{SCP_R 850 0 1{COM_R 852 0
{TEXT 1 0 ""}}}{SCP_R 854 0 2{COM_R 856 0{TEXT 1 376 "We will wis
h to compare the measured values of the activity coefficients wit
h those computed from the Margules equations.  First, though, we 
need a set of model parameters.  The simplest way to obtain a set
 of  parameters is to use the infinite dilution activity coeffiic
ients.  The set of data points can be extrapolated back when the 
mole fraction of benzene is zero to give"}}{COM_R 859 0{TEXT 1 0 
""}}}{SCP_R 861 0 2{INP_R 863 0 "> "{TEXT 0 58 "A[1,2]:=0.31; #Ap
proximate value by inspection of the data"}}{OUT_R 866 8192 863
{DAG :3b3n3\`A`,3j2x0001j2x0002e3j2x0031i2x0002}}}{SCP_R 868 0 2
{COM_R 870 0{TEXT 1 0 ""}}{COM_R 873 0{TEXT 1 142 "In the same we
 we can extrapolate the data points for the logarithm of the acti
vity coefficient of cyclohexane to the right hand axis to find:"}
}}{SCP_R 875 0 2{INP_R 877 0 "> "{TEXT 0 58 "A[2,1]:=0.35; #Appro
ximate value by inspection of the data"}}{OUT_R 880 8192 877{DAG 
:3b3n3\`A`,3j2x0002j2x0001e3j2x0035i2x0002}}}{SCP_R 882 0 2{INP_R
 884 0 "> "{TEXT 0 91 "plot2:=plot(\{lng1(A[1,2],A[2,1],x),lng2(A
[1,2],A[2,1],x)\},x=0..1,0..0.4,axes=boxed): plot2:"}}{OUT_R 887 
0 884{TEXT 2 1 "\012"}}}{SCP_R 889 0 1{COM_R 891 0{TEXT 1 130 "Th
e plots of experimentally determined and calculated activity coef
ficients are displayed together so that we can compare the two."}
}}{SCP_R 893 0 2{INP_R 895 0 "> "{TEXT 0 30 "plots[display](\{plo
t1,plot2\});"}}{OUT_R 898 0 895{TEXT 2 1 "\012"}}}{SCP_R 900 0 1
{COM_R 902 0{TEXT 1 0 ""}}}{SCP_R 904 0 2{COM_R 906 0{TEXT 1 205 
"which shows reasonable agreement between the two sets of results
.  Not surprisingly perhaps, the agreement is best at the sides o
f the diagram; i.e. when the mole fraction of one or other compon
ent is low."}}{COM_R 909 0{TEXT 1 0 ""}}}{SCP_R 911 0 4{COM_R 913
 0{TEXT 1 266 "The parameters in the Van Laar equations can also 
be estimated from just a single data point.  Here we illustrate t
he approach by using the data at the azeotropic composition (line
 7 in the above matrix of data) although any other line of data w
ould do just as well."}}{COM_R 916 0{TEXT 1 0 ""}}{COM_R 919 0
{TEXT 1 48 "First we unassign the existing parameter values."}}
{COM_R 922 0{TEXT 1 0 ""}}}{SCP_R 924 0 5{INP_R 926 0 "> "{TEXT 0
 35 "A[1,2]:='A[1,2]': A[2,1]:='A[2,1]':"}}{INP_R 929 0 "> "{TEXT
 0 12 "datarow:=5: "}}{INP_R 932 0 "> "{TEXT 0 24 "xaz:=dataset[d
atarow,2]:"}}{INP_R 935 0 "> "{TEXT 0 59 "Eqn1:=ln(dataset[dataro
w,4])=lng1(A[1,2],A[2,1],xaz): Eqn1;"}}{OUT_R 938 8192 935{DAG =3
e3j4x001275133203i2x0010+3*7b3n3\`A`,3j2x0001j2x0002pEb3pB,3p10pE
p10+5pAe3j2x0400i2x0003p13e3j2x0600p1Ei2x0002e3j3x00360000i2x0006
}}}{SCP_R 940 0 2{INP_R 942 0 "> "{TEXT 0 59 "Eqn2:=ln(dataset[da
tarow,5])=lng2(A[1,2],A[2,1],xaz): Eqn2;"}}{OUT_R 945 8192 942
{DAG =3e3j4x005448818528i2x0011+3*7b3n3\`A`,3j2x0001j2x0002p10b3p
B,3p10pEpE+5pAe3j2x0400i2x0003p13e3j2x0600p1Ei2x0002e3j3x00160000
i2x0006}}}{SCP_R 947 0 2{COM_R 949 0{TEXT 1 529 "We use Maple's b
uilt in solver to compute the parameters.  Note that we must rest
rict the range in which fsolve is allowed to search for the corre
ct parameter values.  If we do not do this fsolve will often fail
 to find the solution.  In this case we can be guided by the para
meters determined from the infinite dilution activity coefficient
s as shown above.  Thus, inspection of the columns of data lnY1 a
nd lnY2 tells us approximate values and we merely enlarged the se
arch area to make sure that fsolve doesn't miss the roots."}}
{COM_R 952 0{TEXT 1 0 ""}}}{SCP_R 954 0 2{INP_R 956 0 "> "{TEXT 0
 62 "fsolve(\{Eqn1,Eqn2\},\{A[1,2],A[2,1]\},\{A[1,2]=0..5,A[2,1]=
0..5\});"}}{OUT_R 959 8192 956{DAG %2,3=3b3n3\`A`,3j2x0001j2x0002
e3j4x003433658560i2x0010=3b3p4,3p9p7e3j4x003571312052p10}}}{SCP_R
 961 0 5{INP_R 963 0 "> "{TEXT 0 10 "assign(\");"}}{INP_R 966 0 "
> "{TEXT 0 106 "plot3:=plot(\{Qfun(A[1,2],A[2,1],x),lng1(A[1,2],A
[2,1],x),lng2(A[1,2],A[2,1],x)\},x=0..1,0..0.4,axes=boxed):"}}
{INP_R 969 0 "> "{TEXT 0 30 "plots[display](\{plot1,plot3\});"}}
{COM_R 972 0{TEXT 1 0 ""}}{OUT_R 975 0 969{TEXT 2 1 "\012"}}}
{SCP_R 977 0 1{COM_R 979 0{TEXT 1 0 ""}}}{SCP_R 981 0 2{COM_R 983
 0{TEXT 1 223 "which shows that there is quite good agreement bet
ween the calculated and measured activity coefficients over most 
of the composition range except at the sides of the diagram where
 the mole fraction of one component is low."}}{COM_R 986 0{TEXT 1
 0 ""}}}{SCP_R 988 0 2{COM_R 990 0{TEXT 1 428 "Exercise: Estimate
 the parameters using some of the other data points (this can be 
done simply by changing the value of datarow). Plot the activity 
coefficients as a function of mole fraction for the other paramet
er sets you calculate.  Does the choice of parameter set make muc
h difference to the computed activity coefficients?  How might we
 determine a pair of parameter values that, in some sense, repres
ents the \"best\" set."}}{COM_R 993 0{TEXT 1 0 ""}}}{SCP_R 995 0 
4{COM_R 997 0{TEXT 1 266 "There are still other models of the exc
ess Gibbs energy that are useful when the mixture contains more t
han two components.  We shall work with these models in another w
orksheet.  By way of a preview we present two final exercises tha
t introduce two of these models."}}{COM_R 1000 0{TEXT 1 0 ""}}
{COM_R 1003 0{TEXT 1 133 "Exercise: The Wilson model for the dime
nsionless excess Gibbs energy in a two component mixture is given
 by the following expression."}}{COM_R 1006 0{TEXT 1 0 ""}}}
{SCP_R 1008 0 2{INP_R 1010 0 "> "{TEXT 0 75 "QW:=Q=-x[1]*ln(x[1]+
Lambda[1,2]*x[2]) - x[2]*ln(x[2]+Lambda[2,1]*x[1]): QW;"}}{OUT_R 
1013 8192 1010{DAG =3n3\`Q`+5*5b3n3\`x`,2j2x0001p9(3n3\`ln`,2+5p5
p9*5b3n4\`Lambda`,3p9j2x0002p9b3p6,2p1Ap9p9p9i2x0001*5p1Dp9(3pD,2
+5p1Dp9*5b3p15,3p1Ap9p9p5p9p9p9p24}}}{SCP_R 1015 0 1{COM_R 1017 0
{TEXT 1 47 "Find expressions for the activity coefficients."}}}
{SCP_R 1019 0 3{COM_R 1021 0{TEXT 1 0 ""}}{COM_R 1024 0{TEXT 1 
155 "Exercise: The Non-Random-Two-Liquid (NRTL) model for the dim
ensionless excess Gibbs energy in a two component mixture is give
n by the following expression."}}{COM_R 1027 0{TEXT 1 0 ""}}}
{SCP_R 1029 0 2{INP_R 1031 0 "> "{TEXT 0 87 "Q:=x[1]*x[2]*(tau[2,
1]*G[2,1]/(x[1]+G[2,1]*x[2]) + tau[1,2]*G[1,2]/(G[1,2]*x[1]+x[2])
);"}}{OUT_R 1034 8192 1031{DAG :3n3\`Q`*7b3n3\`x`,2j2x0001p8b3p5,
2j2x0002p8+5*7b3n3\`tau`,3pEp8p8b3n3\`G`p16p8+5p4p8*5p1Ap8pBp8p8i
2x0001p8*7b3p14,3p8pEp8b3p1Bp2Ep8+5*5p32p8p4p8p8pBp8p28p8p8}}}
{SCP_R 1036 0 2{COM_R 1038 0{TEXT 1 47 "Find expressions for the 
activity coefficients."}}{COM_R 1041 0{TEXT 1 0 ""}}}}{END}

