{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 14}{FONT 1 "-adobe-times-medium-r-normal--17-*" "ti
mes" "Times-Roman" 4 17 64 "Times-Roman" 17}{FONT 2 "-adobe-helve
tica-bold-o-normal--14-*" "helvetica" "Helvetica-BoldOblique" 8 
14 32 "Helvetica-BoldOblique" 14}{FONT 3 "-adobe-times-bold-r-nor
mal--18-*" "times" "Courier-Bold" 8 18 192 "Times-Bold" 18}{FONT 
4 "-adobe-times-medium-i-normal--17-*" "times" "Times-Italic" 4 
17 96 "Times-Italic" 17}{FONT 5 "-adobe-times-bold-r-normal--14-*
" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 6 "-adobe-co
urier-bold-r-normal--24-*" "courier" "Courier-Bold" 8 24 192 "Cou
rier-Bold" 24}{FONT 7 "-adobe-times-bold-r-normal--18-*" "times" 
"Courier-Bold" 8 18 192 "Times-Bold" 18}{FONT 8 "-adobe-times-med
ium-i-normal--12-*" "times" "Courier-Oblique" 4 12 224 "Times-Ita
lic" 12}{FONT 9 "-adobe-times-bold-r-normal--12-*" "times" "Couri
er-Bold" 8 12 192 "Times-Bold" 12}{FONT 10 "-adobe-times-bold-r-n
ormal--12-*" "times" "Courier-Bold" 8 12 192 "Times-Bold" 12}
{FONT 11 "-adobe-courier-medium-r-normal--18-*" "courier" "Courie
r" 4 18 192 "Courier" 18}{SCP_R 1 0 119{COM_R 2 0{TEXT 3 49 "Calc
ulation of Chemical Equilibrium Compositions "}}{COM_R 3 0{TEXT 3
 0 ""}}{COM_R 4 0{TEXT 4 124 "Johannes Grotendorst and Juergen Do
rnseiffer\012\012Research Centre Juelich\012\012Mail should be se
nt to:  j.grotendorst@kfa-juelich.de"}}{COM_R 5 0{TEXT 3 0 ""}}
{COM_R 6 0{TEXT 1 0 ""}}{COM_R 7 0{TEXT 1 572 "The catalytic reac
tion between steam and hydrocarbon into mixtures of hydrogen, car
bon monoxide, carbon dioxide and methane forms the basic feedstoc
k (synthesis gas) to produce ammonia, methanol and other chemical
s. For reactor design and to find the most economic reaction cond
itions it is necessary to study theoretically the reaction behavi
our with respect to the operating parameters. In the present ther
modynamic study we examine the temperature dependence of chemical
 compositions at equilibrium. We consider the following simple sy
stem of steam reforming reactions:"}}{COM_R 8 0{TEXT 1 0 ""}}
{COM_R 9 0{TEXT 1 29 "1. The methane-steam equality"}}{COM_R 10 0
{TEXT 1 0 ""}}{COM_R 11 0{TEXT 1 26 "CH4 + H2O  <->    CO + 3H2"}
}{COM_R 12 0{TEXT 1 0 ""}}{COM_R 13 0{TEXT 1 22 "2. The water-gas
 shift"}}{COM_R 14 0{TEXT 1 0 ""}}{COM_R 15 0{TEXT 1 23 "CO + H2O
  <->  CO2 + H2"}}{COM_R 16 0{TEXT 1 308 "\015To set up a practic
al computation model we formulate the equilibrium condition for e
ach separate reaction in terms of the reaction extents xi[1] and 
xi[2]. If ne[j] is the number of moles of chemical species B[j] (
j=1..5) present at equilibrium and n[j] is the initial number of 
moles of that species, then\012"}}{INP_R 17 0 "> "{TEXT 0 43 "ne[
j] = n[j]+Sum(alpha[i,j]*xi[i], i=1..2);"}}{OUT_R 18 0 17{DAG =3b
3n3\`ne`,2n3\`j`+5b3n3\`n`p4j2x0001(3n3\`Sum`,3*5b3n4\`alpha`,3n3
\`i`p5pCb3n3\`xi`,2p18pC=3p18~3pCj2x0002pC}}{COM_R 19 0{TEXT 1 
212 "holds, where alpha[i,j] are the stoichiometric coefficients 
of species B[j] in each of the equations (i) [O&W, 80]. The matri
x of stoichiometric coefficients for these molecular mass balance
 equations is given by"}}{COM_R 20 0{TEXT 1 0 ""}}{INP_R 21 0 "> 
"{TEXT 0 77 "with(linalg):\012alpha := matrix ([[-1, 0], [-1, -1]
, [1, -1], [3, 1], [0, 1]]);"}}{COM_R 22 0{TEXT 1 71 "\012Warning
: new definition for   norm\012Warning: new definition for   trac
e"}}{OUT_R 23 0 21{DAG :3n4\`alpha`(3n4\`MATRIX`,2[2,6[2,3i2x0001
j2x0000[2,3pDpD[2,3j2x0001pD[2,3j2x0003p17[2,3pFp17}}{COM_R 24 0
{TEXT 1 149 "A feed mixture of n[1] moles of methane with n[2] mo
les of steam results in the following composition of the particip
ating components at equilibrium:"}}{COM_R 25 0{TEXT 1 0 ""}}
{INP_R 26 0 "> "{TEXT 0 127 "xi   := vector(2): print(xi);\012n  
 := vector(5): for k from 3 to 5 do n[k]:=0 od: print(n);\012ne :
= add(n, multiply (alpha, xi));\012"}}{OUT_R 27 0 26{DAG (3n4\`VE
CTOR`,2[2,3b3n3\`xi`,2j2x0001b3p8,2j2x0002}}{OUT_R 28 0 26{DAG (3
n4\`VECTOR`,2[2,6b3n3\`n`,2j2x0001b3p8,2j2x0002j2x0000p12p12}}
{OUT_R 29 0 26{DAG :3n3\`ne`(3n4\`VECTOR`,2[2,6+5b3n3\`n`,2j2x000
1pFb3n3\`xi`pEi2x0001+7b3pC,2j2x0002pFp12p16b3p13p1Bp16+5p12pFp21
p16+5p12j2x0003p21pFp21}}{COM_R 30 0{TEXT 1 76 "The equilibrium c
onstants of the reactions in terms of the partial pressures"}}
{COM_R 31 0{TEXT 1 0 ""}}{INP_R 32 0 "> "{TEXT 0 52 "p := vector(
[P[CH4], P[H2O], P[CO], P[H2], P[CO2]]);"}}{OUT_R 33 0 32{DAG :3n
3\`p`(3n4\`VECTOR`,2[2,6b3n3\`P`,2n3\`CH4`b3pB,2n3\`H2O`b3pB,2n3\
`CO`b3pB,2n3\`H2`b3pB,2n3\`CO2`}}{COM_R 34 0{TEXT 1 17 "are calcu
lated by"}}{COM_R 35 0{TEXT 1 0 ""}}{INP_R 36 0 "> "{TEXT 0 29 "u
nprotect(eqn); # ignore this"}}{INP_R 37 0 "> "{TEXT 0 120 "for i
 from 1 to 2 do   \012   eqn[i] := K[i] = Product(p[j]^alpha[j,i]
, j=1..5);   \012   print(\");   \012   print(value(\"));\012od:"
}}{OUT_R 38 0 37{DAG =3b3n3\`K`,2j2x0001(3n4\`Product`,3^3b3n3\`p
`,2n3\`j`b3n4\`alpha`,3p11p5=3p11~3p5j2x0005}}{OUT_R 39 0 37{DAG 
=3b3n3\`K`,2j2x0001*9b3n3\`P`,2n3\`CH4`i2x0001b3p9,2n3\`H2O`pEb3p
9,2n3\`CO`p5b3p9,2n3\`H2`j2x0003}}{OUT_R 40 0 37{DAG =3b3n3\`K`,2
j2x0002(3n4\`Product`,3^3b3n3\`p`,2n3\`j`b3n4\`alpha`,3p11p5=3p11
~3j2x0001j2x0005}}{OUT_R 41 0 37{DAG =3b3n3\`K`,2j2x0002*9b3n3\`P
`,2n3\`H2O`i2x0001b3p9,2n3\`CO`pEb3p9,2n3\`H2`j2x0001b3p9,2n3\`CO
2`p1B}}{COM_R 42 0{TEXT 1 178 "Now, if we insert the relation p[j
] = x[j]*P, where p[j] denotes the partial pressure, P the total 
pressure and x[j] the mole fraction of chemical component B[j], t
hen we obtain "}}{COM_R 43 0{TEXT 1 0 ""}}{INP_R 44 0 "> "{TEXT 0
 104 "for j from 1 to 5 do p[j] := x[j]*P od: j:='j':\012   for i
 from 1 to 2 do   \012   print(value(eqn[i])); \012od:"}}{OUT_R 
45 0 44{DAG =3b3n3\`K`,2j2x0001*Bb3n3\`x`p4i2x0001n3\`P`j2x0002b3
p9,2p10pCb3p9,2j2x0003p5b3p9,2j2x0004p1A}}{OUT_R 46 0 44{DAG =3b3
n3\`K`,2j2x0002*9b3n3\`x`p4i2x0001b3p9,2j2x0003pCb3p9,2j2x0004j2x
0001b3p9,2j2x0005p19}}{COM_R 47 0{TEXT 1 156 "The individual mole
 fractions x[j] are calculated by dividing ne[j] by the total num
ber of moles. Thus, the sum over the component index should yield
 unity."}}{COM_R 48 0{TEXT 1 0 ""}}{INP_R 49 0 "> "{TEXT 0 104 "n
sum := sum(ne[j], j=1..5);\012x := map (y -> y/nsum, ne);\012Sum(
x[j], j=1..5) = simplify(sum(x[j], j=1..5));"}}{OUT_R 50 0 49{DAG
 :3n4\`nsum`+7b3n3\`n`,2j2x0001p9b3n3\`xi`p8j2x0002b3p6,2p10p9}}
{OUT_R 51 0 49{DAG :3n3\`x`(3n4\`VECTOR`,2[2,6*5+5b3n3\`n`,2j2x00
01p10b3n3\`xi`pFi2x0001p10+7pCp10p13j2x0002b3pD,2p1Ep10p17*5+7p20
p10p13p17b3p14p22p17p10p1Ap17*5+5p13p10p2Cp17p10p1Ap17*5+5p13j2x0
003p2Cp10p10p1Ap17*5p2Cp10p1Ap17}}{OUT_R 52 0 49{DAG =3(3n3\`Sum`
,3b3n3\`x`,2n3\`j`=3p9~3j2x0001j2x0005pE}}{COM_R 53 0{TEXT 1 210 
"The equilibrium mixture defined by xi[1] and xi[2] must simultan
eously satisfy the equilibrium condition for each reaction, i.e. 
we have to solve the following equations for the reaction extents
 simultaneously:"}}{COM_R 54 0{TEXT 1 0 ""}}{INP_R 55 0 "> "{TEXT
 0 94 "for i from 1 to 2 do\012    f[i] := ln(value(rhs(eqn[i])))
 - ln(lhs(eqn[i]))=0;\012    print(\");\012od:"}}{OUT_R 56 0 55
{DAG =3+5(3n3\`ln`,2*D+5b3n3\`n`,2j2x0001pCb3n3\`xi`pBi2x0001p13+
7p8pCpFj2x0002b3p9,2p1ApCi2x0002n3\`P`p1A+7p1CpCpFp13b3p10p1Ep13p
13+5pFpCp2Bp13pC+5pFj2x0003p2BpCp38pC(3p3,2b3n3\`K`pBp13j2x0000}}
{OUT_R 57 0 55{DAG =3+5(3n3\`ln`,2*9+7b3n3\`n`,2j2x0002j2x0001b3n
3\`xi`,2pEi2x0001b3p11pBp15p15+5p10pEp17p15p15+5p10j2x0003p17pEpE
p17pEpE(3p3,2b3n3\`K`pBp15j2x0000}}{COM_R 58 0{TEXT 1 277 "Before
 solving this system of nonlinear equations we determine the temp
erature dependence of the constants K[1] and K[2]. To obtain an e
xpression for the reaction enthalpy we apply Kirchhoff's law with
 a polynomial ansatz for the description of the molar heat capaci
ty. We have"}}{COM_R 59 0{TEXT 1 0 ""}}{INP_R 60 0 "> "{TEXT 0 84
 "diff(H[P](T), T) = sum(A[j]*(s*T)^j, j=0..6);\012expand(dsolve(
\", H[P](T)));\012assign(\");"}}{OUT_R 61 0 60{DAG =3(3n4\`diff`,
3(3b3n3\`H`,2n3\`P`,2n3\`T`pE+Fb3n3\`A`,2j2x0000j2x0001*7b3p13,2p
18p18n3\`s`p18pEp18p18*7b3p13,2j2x0002p18p20p2ApEp2Ap18*7b3p13,2j
2x0003p18p20p36pEp36p18*7b3p13,2j2x0004p18p20p42pEp42p18*7b3p13,2
j2x0005p18p20p4EpEp4Ep18*7b3p13,2j2x0006p18p20p5ApEp5Ap18}}{OUT_R
 62 0 60{DAG =3(3b3n3\`H`,2n3\`P`,2n3\`T`+11*5b3n3\`A`,2j2x0000j2
x0001p9p13p13*7b3pE,2p13p13n3\`s`p13p9j2x0002/3p13p22*7b3pE,2p22p
13p1Ep22p9j2x0003/3p13p30*7b3pE,2p30p13p1Ep30p9j2x0004/3p13p3E*7b
3pE,2p3Ep13p1Ep3Ep9j2x0005/3p13p4C*7b3pE,2p4Cp13p1Ep4Cp9j2x0006/3
p13p5A*7b3pE,2p5Ap13p1Ep5Ap9j2x0007/3p13p68n3\`_C1`p13}}{COM_R 63
 0{TEXT 1 196 "Here, s (=10^(-3)) denotes a scaling factor of the
 temperature T as used in thermochemical tables.  Inserting the e
xpression for H[P](T) into the equation of van't Hoff and then in
tegrating yields"}}{COM_R 64 0{TEXT 1 0 ""}}{INP_R 65 0 "> "{TEXT
 0 77 "diff(lnK[P](T),T)='H[P](T)'/(R*T^2);\012expand(dsolve(\", 
lnK[P](T)));\012assign(\");"}}{OUT_R 66 0 65{DAG =3(3n4\`diff`,3(
3b3n3\`lnK`,2n3\`P`,2n3\`T`pE*7(3b3n3\`H`pApDj2x0001n3\`R`i2x0001
pEi2x0002}}{OUT_R 67 0 65{DAG =3(3b3n3\`lnK`,2n3\`P`,2n3\`T`+13*9
n3\`R`i2x0001b3n3\`A`,2j2x0006j2x0001n3\`s`p15p9p15/3p17j2x0042*9
pDpFb3p12,2j2x0005p17p19p28p9p28/3p17j2x0030*9pDpFb3p12,2j2x0004p
17p19p39p9p39/3p17j2x0020*9pDpFb3p12,2j2x0003p17p19p4Ap9p4A/3p17j
2x0012*9pDpFb3p12,2j2x0002p17p19p5Bp9p5B/3p17p15*9pDpFb3p12,2p17p
17p19p17p9p17/3p17p5B*7pDpFb3p12,2j2x0000p17(3n3\`ln`p8p17p17*7pD
pFn3\`_C1`p17p9pFpFn3\`_C2`p17}}{COM_R 68 0{TEXT 1 123 "The coeff
icients A[j] are determined by the corresponding coefficients of 
the pure substances in each reaction [Pro, 69].  "}}{COM_R 69 0
{TEXT 1 0 ""}}{INP_R 70 0 "> "{TEXT 0 449 "U0:=matrix([[a0[CH4], 
a0[H2O], a0[CO], a0[H2], a0[CO2]],\012                    [a1[CH4
], a1[H2O], a1[CO], a1[H2], a1[CO2]],\012                    [a2[
CH4], a2[H2O], a2[CO], a2[H2], a2[CO2]],\012                    [
a3[CH4], a3[H2O], a3[CO], a3[H2], a3[CO2]],\012                  
  [a4[CH4], a4[H2O], a4[CO], a4[H2], a4[CO2]],\012               
     [a5[CH4], a5[H2O], a5[CO], a5[H2], a5[CO2]],\012            
        [a6[CH4], a6[H2O], a6[CO], a6[H2], a6[CO2]]]);\012"}}
{OUT_R 71 0 70{DAG :3n3\`U0`(3n4\`MATRIX`,2[2,8[2,6b3n3\`a0`,2n3\
`CH4`b3pD,2n3\`H2O`b3pD,2n3\`CO`b3pD,2n3\`H2`b3pD,2n3\`CO2`[2,6b3
n3\`a1`pFb3p29p14b3p29p19b3p29p1Eb3p29p23[2,6b3n3\`a2`pFb3p3Bp14b
3p3Bp19b3p3Bp1Eb3p3Bp23[2,6b3n3\`a3`pFb3p4Dp14b3p4Dp19b3p4Dp1Eb3p
4Dp23[2,6b3n3\`a4`pFb3p5Fp14b3p5Fp19b3p5Fp1Eb3p5Fp23[2,6b3n3\`a5`
pFb3p71p14b3p71p19b3p71p1Eb3p71p23[2,6b3n3\`a6`pFb3p83p14b3p83p19
b3p83p1Eb3p83p23}}{INP_R 72 0 "> "{TEXT 0 867 "U:=subs(a0[CH4]=7.
918404, a0[H2O]=7.988860,   a0[CO]=7.812249,\012                a
0[H2]=6.183042, a0[CO2]=4.324933,\012                a1[CH4]=-11.
41722, a1[H2O]=-1.506271, a1[CO]=-6.668293,\012                a1
[H2]=4.710657, a1[CO2]=20.80895,\012                a2[CH4]=63.73
457, a2[H2O]=6.661376, a2[CO]=17.28296,\012                a2[H2]
=-10.92135, a2[CO2]=-22.94590,\012                a3[CH4]=-75.256
91, a3[H2O]=-4.655970, a3[CO]=-17.28709,\012                a3[H2
]=12.54086, a3[CO2]=16.84483,\012                a4[CH4]=43.29269
, a4[H2O]=1.696464, a4[CO]=8.860125,\012                a4[H2]=-7
.016263, a4[CO2]=-7.935665,\012                a5[CH4]=-12.56732,
 a5[H2O]=-0.3706212, a5[CO]=-2.314819,\012                a5[H2]=
1.923395, a5[CO2]=2.121672, \012                a6[CH4]=1.469695,
 a6[H2O]=0.03992444, a6[CO]=0.2447785,\012                a6[H2]=
-0.2084091, a6[CO2]=-0.2408713, eval(U0));\012"}}{OUT_R 73 0 72
{DAG :3n3\`U`(3n4\`MATRIX`,2[2,8[2,6e3j3x07918404i2x0006e3j3x0798
8860p10e3j3x07812249p10e3j3x06183042p10e3j3x04324933p10[2,6e3i3x0
1141722i2x0005e3i3x01506271p10e3i3x06668293p10e3j3x04710657p10e3j
3x02080895p2C[2,6e3j3x06373457p2Ce3j3x06661376p10e3j3x01728296p2C
e3i3x01092135p2Ce3i3x02294590p2C[2,6e3i3x07525691p2Ce3i3x04655970
p10e3i3x01728709p2Ce3j3x01254086p2Ce3j3x01684483p2C[2,6e3j3x04329
269p2Ce3j3x01696464p10e3j3x08860125p10e3i3x07016263p10e3i3x079356
65p10[2,6e3i3x01256732p2Ce3i3x03706212i2x0007e3i3x02314819p10e3j3
x01923395p10e3j3x02121672p10[2,6e3j3x01469695p10e3j3x03992444i2x0
008e3j3x02447785p9Ee3i3x02084091p9Ee3i3x02408713p9E}}{INP_R 74 0 
"> "{TEXT 0 21 "V:=multiply(U,alpha);"}}{OUT_R 75 0 74{DAG :3n3\`
V`(3n4\`MATRIX`,2[2,8[2,3e3j3x10454111i2x0006e3i3x05293134p10[2,3
e3j3x20387169p10e3j3x33694171p10[2,3e3i3x85877036p10e3i3x57811586
p10[2,3e3j4x000100248370p10e3j3x51328750p10[2,3e3i3x57177818p10e3
i3x25508517p10[2,3e3j4x000163933072i2x0007e3j3x67305072p4F[2,3e3i
4x000189006824i2x0008e3i3x73398334p5D}}{COM_R 76 0{TEXT 1 356 "Th
e integration constants _C1 and _C2 can be calculated by using sp
ecial values for K[1] and K[2] at the temperature T=298.15 Kelvin
 [Bar, 93].  Inserting the value for the gas constant R and takin
g into account the conversion factor F between the unit cal (used
 in Prothero's  termochemical table [Pro, 69]) and the SI unit Jo
ule  we eventually arrive at:"}}{COM_R 77 0{TEXT 1 0 ""}}{INP_R 
78 0 "> "{TEXT 0 95 "R:=8.314: H[1]:=206185: H[2]:=-41165: lnK[1]
:=-57.3621: lnK[2]:=11.546:\012s:=10^(-3): F:=4.1868: "}}{OUT_R 
79 0 0{TEXT 2 1 "\012"}}{INP_R 80 0 "> "{TEXT 0 328 " for i from 
1 to 2 do\012     for k from 0 to 6 do\012         A[k]:=F*V[k+1,
 i]\012     od;\012     solve(\{H[i]=subs(T=298.15, H[P](T))\},_C
1);\012     print(op(\"));assign(\");\012     solve(\{lnK[i]=subs
(T=298.15,lnK[P](T))\},_C2);\012     print(op(\"));assign(\");\01
2     ln(K[i])=eval(lnK[P](T));\012     print(\");assign(\");\012
    _C1:='_C1':_C2:='_C2':\012 od:"}}{OUT_R 81 0 80{DAG =3n3\`_C1
`e3j4x001917936485i2x0004}}{OUT_R 82 0 80{DAG =3n3\`_C2`e3i4x0010
97479514i2x0008}}{OUT_R 83 0 80{DAG =3(3n3\`ln`,2b3n3\`K`,2j2x000
1+13*3n3\`T`j2x0006e3i4x002266211241i2x0029*3pDj2x0005e3j4x002751
804129i2x0025*3pDj2x0004e3i4x001439692618i2x0021*3pDj2x0003e3j4x0
04206958900i2x0018*3pDj2x0002e3i4x007207721401i2x0015pDe3j4x00513
3329275i2x0012(3p2,2pDe3j4x005264526333i2x0009*3pDi2x0001e3i4x002
306875734i2x0005e3i4x001097479514i2x0008p9}}{OUT_R 84 0 80{DAG =3
n3\`_C1`e3i4x003906681111i2x0005}}{OUT_R 85 0 80{DAG =3n3\`_C2`e3
j4x000882248534i2x0008}}{OUT_R 86 0 80{DAG =3(3n3\`ln`,2b3n3\`K`,
2j2x0002+13*3n3\`T`j2x0006e3i4x008800535667i2x0030*3pDj2x0005e3j4
x001129792621i2x0025*3pDj2x0004e3i4x006422844540i2x0022*3pDj2x000
3e3j4x002154029453i2x0018*3pDp9e3i4x004852167998i2x0015pDe3j4x008
483928020i2x0012(3p2,2pDe3i4x002665539263i2x0009*3pDi2x0001e3j4x0
04698918825i2x0006e3j4x000882248534i2x0008j2x0001}}{COM_R 87 0
{TEXT 1 85 "Thus, the complete expressions for the reactions exte
nts xi[1] and xi[2] are given by"}}{COM_R 88 0{TEXT 1 0 ""}}
{INP_R 89 0 "> "{TEXT 0 29 "f1:=lhs(f[1]); f2:=lhs(f[2]);"}}
{OUT_R 90 0 89{DAG :3n3\`f1`+15(3n3\`ln`,2*D+5b3n3\`n`,2j2x0001pE
b3n3\`xi`pDi2x0001p15+7pApEp11j2x0002b3pB,2p1CpEi2x0002n3\`P`p1C+
7p1EpEp11p15b3p12p20p15p15+5p11pEp2Dp15pE+5p11j2x0003p2DpEp3ApE*3
n3\`T`j2x0006e3j4x002266211241i2x0029*3p41j2x0005e3i4x00275180412
9i2x0025*3p41j2x0004e3j4x001439692618i2x0021*3p41p3Ae3i4x00420695
8900i2x0018*3p41p1Ce3j4x007207721401i2x0015p41e3i4x005133329275i2
x0012(3p5,2p41e3i4x005264526333i2x0009*3p41p15e3j4x002306875734i2
x0005e3j4x001097479514i2x0008pE}}{OUT_R 91 0 89{DAG :3n3\`f2`+15(
3n3\`ln`,2*9+7b3n3\`n`,2j2x0002j2x0001b3n3\`xi`,2p10i2x0001b3p13p
Dp17p17+5p12p10p19p17p17+5p12j2x0003p19p10p10p19p10p10*3n3\`T`j2x
0006e3j4x008800535667i2x0030*3p2Fj2x0005e3i4x001129792621i2x0025*
3p2Fj2x0004e3j4x006422844540i2x0022*3p2Fp26e3i4x002154029453i2x00
18*3p2FpEe3j4x004852167998i2x0015p2Fe3i4x008483928020i2x0012(3p5,
2p2Fe3j4x002665539263i2x0009*3p2Fp17e3i4x004698918825i2x0006e3i4x
000882248534i2x0008p10}}{COM_R 92 0{TEXT 1 76 "Next, we assume P=
5 bar and a steam to carbon atom ratio H2O : C = 2:1, i.e."}}
{COM_R 93 0{TEXT 1 0 ""}}{INP_R 94 0 "> "{TEXT 0 24 "P:=5; n[1]:=
1; n[2]:=2; "}}{OUT_R 95 0 94{DAG :3n3\`P`j2x0005}}{OUT_R 96 0 94
{DAG :3b3n3\`n`,2j2x0001p5}}{OUT_R 97 0 94{DAG :3b3n3\`n`,2j2x000
2p5}}{COM_R 98 0{TEXT 1 273 "Now, solving the nonlinear equations
 for xi[1] and xi[2] at different values of T (800..1200 Kelvin) 
results in the following temperature dependence of the reaction e
xtents and of the various mole fractions for steam, hydrogen, car
bon monoxide, carbon dioxide, and methane."}}{COM_R 99 0{TEXT 1 0
 ""}}{INP_R 100 0 "> "{TEXT 0 69 "for k from 1 to 2 do l1[k]:=[] 
od:\012for k from 1 to 5 do l2[k]:=[] od:"}}{OUT_R 101 0 0{TEXT 2
 1 "\012"}}{INP_R 102 0 "> "{TEXT 0 359 "for j from 0 to 20 do\01
2   T := 800 + j*20:\012   fsolve(\{f1, f2\}, \{xi[1], xi[2]\}, \
{xi[1]=0.2..1, xi[2]=0.12..0.3\});\012   assign(\");\012   xiT:=m
ap(eval, xi);\012   for k from 1 to 2 do\012          l1[k] := [o
p(l1[k]), [T, xiT[k]]];\012   od;\012   xT:=map(eval, x);\012   f
or k from 1 to 5 do\012          l2[k] := [op(l2[k]), [T, xT[k]]]
;\012   od;\012  xi[1]:='xi[1]'; xi[2]:='xi[2]';\012od:\012"}}
{INP_R 103 0 "> "{TEXT 0 22 "with(plots): T:='T': \012"}}{INP_R 
104 0 "> "{TEXT 0 47 " pl1:=plot(\{seq(l1[k], k=1..2)\}, T=800..1
200):\012"}}{INP_R 105 0 "> "{TEXT 0 164 " t1[1]:=textplot([1050,
 0.88, `xi[1]`], align=ABOVE):\012 t1[2]:=textplot([950, 0.3, `xi
[2]`], align=ABOVE):\012 t1[3]:=textplot([1030, -0.045, `(Kelvin)
`], align=BELOW):"}}{OUT_R 106 0 0{TEXT 2 1 "\012"}}{INP_R 107 0 
"> "{TEXT 0 37 " display(\{pl1, seq(t1[i], i=1..3)\});\012"}}
{INP_R 108 0 "> "{TEXT 0 50 " pl2:=plot(\{seq(l2[k], k=1..5), 1\}
, T=800..1200):\012"}}{INP_R 109 0 "> "{TEXT 0 426 " t2[1]:=textp
lot([930, 0.14, `CH4`], align=ABOVE):\012 t2[2]:=textplot([1000, 
0.25, `H2O`], align=ABOVE):\012 t2[3]:=textplot([1040, 0.13, `CO`
], align=ABOVE):\012 t2[4]:=textplot([1000, 0.555, `H2`], align=A
BOVE):\012 t2[5]:=textplot([850, 0.08, `CO2`], align=ABOVE):\012 
t2[6]:=textplot([1000, 1.02, `Sum of x[j]`], align=ABOVE):\012 t2
[7]:=textplot([800, 1.04, `x[j]`], align=LEFT):\012 t2[8]:=textpl
ot([1030, -0.045, `(Kelvin)`], align=BELOW):"}}{OUT_R 110 0 0
{TEXT 2 1 "\012"}}{INP_R 111 0 "> "{TEXT 0 36 "display(\{pl2, seq
(t2[i], i=1..8)\});\012"}}{COM_R 112 0{TEXT 5 10 "References"}}
{COM_R 113 0{TEXT 5 0 ""}}{COM_R 114 0{TEXT 1 85 "    [O&W, 80] A
. Ovenston and J.R. Walls, Chem. Engineering Sci. 35, 627-633, (1
980)."}}{COM_R 115 0{TEXT 1 0 ""}}{COM_R 116 0{TEXT 1 65 "    [Pr
o, 69]      A. Prothero, Comb. Flame. 13, 399-408, (1969)."}}
{COM_R 117 0{TEXT 1 0 ""}}{COM_R 118 0{TEXT 1 98 "    [Bar, 93]  
    I. Barin ``Thermochemical Data of Pure Substances'',  VCH Ver
lagsgesellschaft, "}}{COM_R 119 0{TEXT 1 42 "                    
      Weinheim (1993)."}}{INP_R 120 0 "> "{TEXT 0 0 ""}}}{END}
