{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "Courier New"
 "Courier New" "Courier" 4 12 192 "Courier" 16}{SCP_R 1 0 467
{COM_R 2 0{TEXT 1 52 "Thermodynamics with Maple.  III - Flash Cal
culations"}}{COM_R 3 0{TEXT 1 0 ""}}{COM_R 4 0{TEXT 1 11 "Ross Ta
ylor"}}{COM_R 5 0{TEXT 1 85 "Department of Chemical Engineering, 
Clarkson University, Potsdam, New York 13699-5705"}}{COM_R 6 0
{TEXT 1 0 ""}}{COM_R 7 0{TEXT 1 12 "Introduction"}}{COM_R 8 0
{TEXT 1 0 ""}}{COM_R 9 0{TEXT 1 716 "Flash calculations are used 
to determine the phase condition of a mixture at a specified temp
erature and pressure.  Such computations lie at the heart of many
 process engineering calculations and are of central importance i
n many other applications as well (oil reservoir simulation for e
xample).  It goes without saying that any method  to solve these 
problems must be exceptionally reliable and yet not take an unrea
sonable length of time to find an answer.  In fact, the vast majo
rity of flash calculations are quite simple to solve.  There rema
in, however, many difficult cases and the flash equations possess
 many interesting properties that make them a continued source of
 fascination and frustration for many."}}{COM_R 10 0{TEXT 1 0 ""}
}{COM_R 11 0{TEXT 1 71 "The mathematical model of the flash inclu
des the total material balance"}}{COM_R 12 0{TEXT 1 0 ""}}{INP_R 
13 0 "> "{TEXT 0 25 "restart: TMB:=F=V+L: TMB;"}}{OUT_R 14 0 13
{DAG =3n3\`F`+5n3\`V`j2x0001n3\`L`p6}}{COM_R 15 0{TEXT 1 60 "and 
the component material balances, one for each component:"}}{COM_R
 16 0{TEXT 1 0 ""}}{INP_R 17 0 "> "{TEXT 0 37 "CMB[i]:=F*z[i]=V*y
[i]+L*x[i]: CMB[i];"}}{OUT_R 18 0 17{DAG =3*5n3\`F`j2x0001b3n3\`z
`,2n3\`i`p4+5*5n3\`V`p4b3n3\`y`p9p4p4*5n3\`L`p4b3n3\`x`p9p4p4}}
{COM_R 19 0{TEXT 1 5 "where"}}{INP_R 20 0 "> "{TEXT 0 23 "'F,V,L,
z[i],y[i],x[i]';"}}{OUT_R 21 0 20{DAG ,7n3\`F`n3\`V`n3\`L`b3n3\`z
`,2n3\`i`b3n3\`y`pAb3n3\`x`pA}}{COM_R 22 0{TEXT 1 380 "are, respe
ctively, the feed flow, the vapor product flow, the liquid produc
t flow, and the mole faction of component i in the feed, vapor pr
oduct and liquid product.  The mole fractions sum over the compon
ent index to unity.  However, mole fractions do not sum to unity 
of their own accord and it is necessary to include the mole fract
ion summation equations as part of the model."}}{COM_R 23 0{TEXT 
1 0 ""}}{INP_R 24 0 "> "{TEXT 0 93 "Sumx:=sum(x[i],i=1..c)=1:  Su
my:=sum(y[i],i=1..c)=1: Sumz:=sum(z[i],i=1..c)=1:Sumx,Sumy,Sumz;"
}}{OUT_R 25 0 24{DAG ,4=3(3n3\`sum`,3b3n3\`x`,2n3\`i`=3pA~3j2x000
1n3\`c`pF=3(3p3,3b3n3\`y`p9pCpF=3(3p3,3b3n3\`z`p9pCpF}}{COM_R 26 
0{TEXT 1 123 "The model is completed by assuming that the two pha
ses leaving (i.e. the V and L phases) are in equilibrium with eac
h other"}}{COM_R 27 0{TEXT 1 0 ""}}{INP_R 28 0 "> "{TEXT 0 31 "EQ
M[i]:=y[i]=K[i]*x[i]: EQM[i];"}}{OUT_R 29 0 28{DAG =3b3n3\`y`,2n3
\`i`*5b3n3\`K`p4j2x0001b3n3\`x`p4pC}}{COM_R 30 0{TEXT 1 9 "where 
the"}}{COM_R 31 0{TEXT 1 0 ""}}{INP_R 32 0 "> "{TEXT 0 7 "'K[i]';
"}}{OUT_R 33 0 32{DAG b3n3\`K`,2n3\`i`}}{COM_R 34 0{TEXT 1 0 ""}}
{COM_R 35 0{TEXT 1 39 "are the K-values or equilibrium ratios."}}
{COM_R 36 0{TEXT 1 0 ""}}{COM_R 37 0{TEXT 1 51 "There are 3c+5 va
riables in this set of equations: "}}{COM_R 38 0{TEXT 1 63 "   Th
e flow rates of the three streams (feed, vapor and liquid)"}}
{COM_R 39 0{TEXT 1 34 "   c mole fractions in each stream"}}
{COM_R 40 0{TEXT 1 25 "   The system temperature"}}{COM_R 41 0
{TEXT 1 22 "   The system pressure"}}{COM_R 42 0{TEXT 1 0 ""}}
{COM_R 43 0{TEXT 1 51 "There are only 2c+3 independent equations,
 however:"}}{COM_R 44 0{TEXT 1 22 "   c material balances"}}
{COM_R 45 0{TEXT 1 26 "   c equilibrium equations"}}{COM_R 46 0
{TEXT 1 38 "   3 mole fraction summation equations"}}{COM_R 47 0
{TEXT 1 0 ""}}{COM_R 48 0{TEXT 1 405 "This means that c+2 variabl
es must be specified before we can carry out any calculations.  A
 possible (and common) specification includes the feed flow and c
-1 mole fractions in the feed (the last one is calculated from th
e mole fraction summation equation for the feed), the temperature
 and pressure.  The calculated quantities include the flow rates,
 and the mole fractions of the two product streams.  "}}{COM_R 49
 0{TEXT 1 0 ""}}{COM_R 50 0{TEXT 1 28 "The Rachford - Rice Equati
on"}}{COM_R 51 0{TEXT 1 0 ""}}{COM_R 52 0{TEXT 1 290 "Our concern
 here is with the development of a method that permits us to solv
e simple flash problems. The classical approach is to combine the
 equations in such a way that flash problems can be solved by a r
oot finding method such as Newton's method. We define the vapor f
raction as follows:"}}{COM_R 53 0{TEXT 1 0 ""}}{INP_R 54 0 "> "
{TEXT 0 37 "t0:=V=alpha*F: alpha=solve(t0,alpha);"}}{OUT_R 55 0 
54{DAG =3n4\`alpha`*5n3\`V`j2x0001n3\`F`i2x0001}}{COM_R 56 0{TEXT
 1 75 "which allows us to solve the total material balance for th
e liquid fraction"}}{COM_R 57 0{TEXT 1 0 ""}}{INP_R 58 0 "> "
{TEXT 0 61 "t1:=collect(TMB/F,L): t1:=L=solve(t1,L): t1:=subs(t0,
t1): t1;"}}{OUT_R 59 0 58{DAG =3n3\`L`*5+5j2x0001p5n4\`alpha`i2x0
001p5n3\`F`p5}}{COM_R 60 0{TEXT 1 516 "When the vapor fraction is
 zero the system is a saturated liquid at its boiling point. When
 the vapor fraction is one the system is a vapor at its dew point
.  When the vapor fraction is between zero and one we have a two-
phase or partially vaporized system.  As we shall see below, it i
s possible for us to compute vapor fractions that are less than z
ero or greater than one.  The former (usually) corresponds to a s
ubcooled liquid, the latter to a superheated vapor (there are exc
eptions, however, as we shall see)."}}{COM_R 61 0{TEXT 1 0 ""}}
{COM_R 62 0{TEXT 1 91 "The component material balances can be exp
ressed in terms of the vapor fraction as follows:"}}{COM_R 63 0
{TEXT 1 0 ""}}{INP_R 64 0 "> "{TEXT 0 49 "e1:=collect(subs(\{t1,t
0\},CMB[i]/F),\{F,x[i]\}): e1;"}}{OUT_R 65 0 64{DAG =3b3n3\`z`,2n
3\`i`+5*5n4\`alpha`j2x0001b3n3\`y`p4pCpC*5+5pCpCp9i2x0001pCb3n3\`
x`p4pCpC}}{COM_R 66 0{TEXT 1 149 "The vapor phase mole fractions 
can be eliminated using the equilibrium equations and the result 
rearranged to give the liquid phase mole fractions as"}}{COM_R 67
 0{TEXT 1 0 ""}}{INP_R 68 0 "> "{TEXT 0 65 "e2:=subs(EQM[i],e1): 
e3:=solve(e2,x[i]): e4:=x[i]=normal(e3): e4;"}}{OUT_R 69 0 68{DAG
 =3b3n3\`x`,2n3\`i`*5b3n3\`z`p4j2x0001+7*5n4\`alpha`pCb3n3\`K`p4p
CpCpCpCp10i2x0001p1D}}{COM_R 70 0{TEXT 1 115 "The vapor phase mol
e fractions may now be obtained by substituting the above result 
into the equilibrium equations."}}{COM_R 71 0{TEXT 1 0 ""}}{INP_R
 72 0 "> "{TEXT 0 24 "e5:=subs(e4,EQM[i]): e5;"}}{OUT_R 73 0 72
{DAG =3b3n3\`y`,2n3\`i`*7b3n3\`K`p4j2x0001b3n3\`z`p4pC+7*5n4\`alp
ha`pCp8pCpCpCpCp15i2x0001p1F}}{COM_R 74 0{TEXT 1 101 "The only eq
uations not used so far are the mole fraction summation equations
 which we combine to give"}}{COM_R 75 0{TEXT 1 0 ""}}{INP_R 76 0 
"> "{TEXT 0 28 "c:='c': RR1:=Sumy-Sumx: RR1;"}}{OUT_R 77 0 76{DAG
 =3+5(3n3\`sum`,3b3n3\`y`,2n3\`i`=3pA~3j2x0001n3\`c`pF(3p3,3b3n3\
`x`p9pCi2x0001j2x0000}}{COM_R 78 0{TEXT 1 0 ""}}{COM_R 79 0{TEXT 
1 64 "This expression may be written in the following alternative
 form"}}{COM_R 80 0{TEXT 1 0 ""}}{INP_R 81 0 "> "{TEXT 0 23 "RR1:
=combine(RR1): RR1;"}}{OUT_R 82 0 81{DAG =3(3n3\`sum`,3+5b3n3\`y`
,2n3\`i`j2x0001b3n3\`x`p9i2x0001=3pA~3pCn3\`c`j2x0000}}{COM_R 83 
0{TEXT 1 96 "We now eliminate the vapor and liquid phase mole fra
ctions to give the Rachford - Rice equation."}}{COM_R 84 0{TEXT 1
 0 ""}}{INP_R 85 0 "> "{TEXT 0 43 "RReqn:= simplify(subs(\{e4,e5\
},RR1)): RReqn;"}}{OUT_R 86 0 85{DAG =3(3n3\`sum`,3*7b3n3\`z`,2n3
\`i`j2x0001+5b3n3\`K`p9pCi2x0001pCpC+7*5n4\`alpha`pCpFpCpCpCpCp1A
p14p14=3pA~3pCn3\`c`j2x0000}}{COM_R 87 0{TEXT 1 325 "There are se
veral features of this equation that are worth noting here.  Firs
t, the function applies to mixtures with any number of components
.  Second, all of the equations modeling the flash have been comb
ined into a single equation.  This equation may be solved for the
 vapor fraction as shown in the examples that follow."}}{COM_R 88
 0{TEXT 1 0 ""}}{COM_R 89 0{TEXT 1 9 "Example 1"}}{COM_R 90 0
{TEXT 1 0 ""}}{COM_R 91 0{TEXT 1 292 "Let us illustrate the form 
of the Rachford - Rice equation with an example from the book by 
P.C. Wankat (1988).  On page 56 of this book we find an example i
nvolving a mixture of  propane(1), n-butane(2), n-pentane(3), and
 n-hexane(4).  The composition of the mixture is specified as fol
lows:"}}{COM_R 92 0{TEXT 1 0 ""}}{INP_R 93 0 "> "{TEXT 0 53 "c:=4
: z:=linalg[vector](c): z:=([0.3,0.1,0.15,0.45]);"}}{OUT_R 94 0 
93{DAG :3n3\`z`[2,5e3j2x0003i2x0001e3j2x0001p8e3j2x0015i2x0002e3j
2x0045p11}}{COM_R 95 0{TEXT 1 0 ""}}{COM_R 96 0{TEXT 1 123 "The K
-values at the specified temperature and pressure of  323.15 K an
d 200 kPa (obtained from a graphical correlation) are"}}{COM_R 97
 0{TEXT 1 0 ""}}{INP_R 98 0 "> "{TEXT 0 45 "K:=linalg[vector](c):
 K:=([7.0,2.4,0.8,0.3]);"}}{OUT_R 99 0 98{DAG :3n3\`K`[2,5e3j2x00
70i2x0001e3j2x0024p8e3j2x0008p8e3j2x0003p8}}{COM_R 100 0{TEXT 1 0
 ""}}{COM_R 101 0{TEXT 1 59 "For this system the Rachford - Rice 
equation is as follows:"}}{INP_R 102 0 "> "{TEXT 0 6 "RReqn;"}}
{OUT_R 103 0 102{DAG =3+9*3+5n4\`alpha`e3j2x0060i2x0001j2x0001pCp
Ae3j2x0180i2x0002*3+5p4e3j2x0014pApCpCpAe3p19p13*3+5p4e3p13pApCpC
pAe3i2x0030i2x0003*3+5p4e3i2x0007pApCpCpAe3i2x0315p2Ej2x0000}}
{COM_R 104 0{TEXT 1 0 ""}}{COM_R 105 0{TEXT 1 37 "We make a funct
ion of this expression"}}{COM_R 106 0{TEXT 1 0 ""}}{INP_R 107 0 "
> "{TEXT 0 33 "fRR := unapply(lhs(RReqn),alpha);"}}{OUT_R 108 0 
107{DAG :3n3\`fRR`@7,2n4\`alpha`,1,3n5\`operator`n4\`arrow`p8+9*3
+5a2x0001e3j2x0060i2x0001j2x0001p1Cp1Ae3j2x0180i2x0002*3+5p15e3j2
x0014p1Ap1Cp1Cp1Ae3p29p23*3+5p15e3p23p1Ap1Cp1Cp1Ae3i2x0030i2x0003
*3+5p15e3i2x0007p1Ap1Cp1Cp1Ae3i2x0315p3Ep8}}{COM_R 109 0{TEXT 1 0
 ""}}{COM_R 110 0{TEXT 1 105 "First we plot the function to see i
f there is a solution in the range of vapor fraction from zero to
 one."}}{COM_R 111 0{TEXT 1 0 ""}}{INP_R 112 0 "> "{TEXT 0 16 "pl
ot (fRR,0..1);"}}{OUT_R 113 0 112{TEXT 2 1 "\012"}}{COM_R 114 0
{TEXT 1 0 ""}}{COM_R 115 0{TEXT 1 99 "We see from this graph that
 there is a solution near 0.5.  We can ask Maple to compute the s
olution"}}{COM_R 116 0{TEXT 1 0 ""}}{INP_R 117 0 "> "{TEXT 0 20 "
fsolve(RReqn,alpha);"}}{OUT_R 118 0 117{DAG e3i4x006067125721i2x0
010}}{COM_R 119 0{TEXT 1 0 ""}}{COM_R 120 0{TEXT 1 172 "But this 
is not the solution we see in the figure above.  Is there more th
an one solution?  Let us plot the function over an expanded range
 of values of the vapor fraction."}}{INP_R 121 0 "> "{TEXT 0 23 "
plot(fRR, -3..7,-1..1);"}}{OUT_R 122 0 121{TEXT 2 1 "\012"}}
{COM_R 123 0{TEXT 1 0 ""}}{COM_R 124 0{TEXT 1 0 ""}}{COM_R 125 0
{TEXT 1 640 "Now we can see at least three places where the funct
ion crosses the horizontal axis (one at about -0.5, another at ar
ound 0.5 and a third at about 4.5).  In addition, there are no le
ss than four singular points (where the function goes to plus or 
minus infinity).  We note that Maple's fsolve command found the n
egative root.  Is that the root we want?  If not, how can we ensu
re that we find the root we want?  And how do we know which root 
we want?  Are there any other solutions that are not shown in the
 above figure?  Does the location of the singular points have any
thing to do with all of this?  We deal with the last question fir
st."}}{COM_R 126 0{TEXT 1 0 ""}}{COM_R 127 0{TEXT 1 18 "Some More
 Analysis"}}{COM_R 128 0{TEXT 1 0 ""}}{COM_R 129 0{TEXT 1 71 "We 
begin by recalling the general form of the Rachford - Rice equati
on."}}{COM_R 130 0{TEXT 1 0 ""}}{INP_R 131 0 "> "{TEXT 0 22 "c:='
c': i:='i': RReqn;"}}{OUT_R 132 0 131{DAG =3(3n3\`sum`,3*7b3n3\`z
`,2n3\`i`j2x0001+5b3n3\`K`p9pCi2x0001pCpC+7*5n4\`alpha`pCpFpCpCpC
pCp1Ap14p14=3pA~3pCn3\`c`j2x0000}}{COM_R 133 0{TEXT 1 0 ""}}
{COM_R 134 0{TEXT 1 79 "Now, a singular point occurs whenever the
 denominator of this equation is zero."}}{COM_R 135 0{TEXT 1 0 ""
}}{INP_R 136 0 "> "{TEXT 0 34 "t2:=denom(op(1,lhs(RReqn)))=0: t2;
"}}{OUT_R 137 0 136{DAG =3+7*5n4\`alpha`j2x0001b3n3\`K`,2n3\`i`p6
p6p6p6p3i2x0001j2x0000}}{COM_R 138 0{TEXT 1 54 "which can be solv
ed to give the i-th singular point at"}}{COM_R 139 0{TEXT 1 0 ""}
}{INP_R 140 0 "> "{TEXT 0 35 "t3:=S[i]=sort(solve(t2,alpha)): t3;
"}}{OUT_R 141 0 140{DAG =3b3n3\`S`,2n3\`i`+3*3+5b3n3\`K`p4j2x0001
i2x0001pEp10p10}}{COM_R 142 0{TEXT 1 210 "Thus, the number of sin
gular points is equal to the number of components and solutions c
an be found between the singular points defined by the above resu
lt.  We make a function of this expression for later use:"}}
{COM_R 143 0{TEXT 1 0 ""}}{INP_R 144 0 "> "{TEXT 0 30 "RRsing:=un
apply(rhs(t3),K[i]);"}}{OUT_R 145 0 144{DAG :3n4\`RRsing`@7,2n3\`
y1`,1,3n5\`operator`n4\`arrow`p8+3*3+5a2x0001j2x0001i2x0001p17p19
p19p8}}{COM_R 146 0{TEXT 1 116 "We can obtain an alternative form
 of the Rachford - Rice equation by using this expression to elim
inate the K-values"}}{COM_R 147 0{TEXT 1 0 ""}}{INP_R 148 0 "> "
{TEXT 0 58 "RRS:=sort(simplify(subs(K[i]=solve(t3,K[i]),RReqn))):
 RRS;"}}{OUT_R 149 0 148{DAG =3(3n3\`sum`,3+3*5+5b3n3\`S`,2n3\`i`
j2x0001n4\`alpha`i2x0001p13b3n3\`z`pBpEp13=3pC~3pEn3\`c`j2x0000}}
{COM_R 150 0{TEXT 1 0 ""}}{COM_R 151 0{TEXT 1 15 "Example 1 Again
"}}{COM_R 152 0{TEXT 1 0 ""}}{COM_R 153 0{TEXT 1 247 "We first co
nsider the question of the number of solutions.  We express the R
achford - Rice equation as a polynomial in vapor fraction (there 
are several ways to do this with Maple, one that works well here 
is to take the numerator of the function)"}}{COM_R 154 0{TEXT 1 0
 ""}}{INP_R 155 0 "> "{TEXT 0 24 "c:=4: numer(fRR(alpha));"}}
{OUT_R 156 0 155{DAG +9*3n4\`alpha`j2x0003e3j3x01176000i2x0006*3p
2j2x0002e3i3x00502880i2x0005p2e3i2x8550i2x0004e3j2x1595i2x0003j2x
0001}}{COM_R 157 0{TEXT 1 0 ""}}{COM_R 158 0{TEXT 1 287 "which is
 a polynomial of degree 3.  We know, therefore, that there are th
ree solutions, all of which were shown in the illustration above.
  In fact, it is possible to show that the Rachford - Rice equati
on  can be written as a polynomial of degree one less than the nu
mber of components."}}{COM_R 159 0{TEXT 1 0 ""}}{COM_R 160 0{TEXT
 1 188 "Now we try to compute all of the solutions.  We can see f
rom the figure that the solutions can be found between the singul
ar points.  It might, therefore, be helpful to compute them first
."}}{COM_R 161 0{TEXT 1 0 ""}}{INP_R 162 0 "> "{TEXT 0 50 "c:=4: 
for i from 1 to c do S[i]:=RRsing(K[i]); od;"}}{OUT_R 163 0 162
{DAG :3b3n3\`S`,2j2x0001e3i4x001666666667i2x0010}}{OUT_R 164 0 
162{DAG :3b3n3\`S`,2j2x0002e3i4x007142857143i2x0010}}{OUT_R 165 0
 162{DAG :3b3n3\`S`,2j2x0003e3j4x005000000000i2x0009}}{OUT_R 166 
0 162{DAG :3b3n3\`S`,2j2x0004e3j4x001428571429i2x0009}}{COM_R 167
 0{TEXT 1 67 "We order this set of points to make it easier to fi
nd the solutions"}}{INP_R 168 0 "> "{TEXT 0 49 "c:=4: i:='i': pts
:=sort([seq(S[i],i=1..c)]): pts;"}}{OUT_R 169 0 168{DAG [2,5e3i4x
007142857143i2x0010e3i4x001666666667p7e3j4x001428571429i2x0009e3j
4x005000000000p14}}{COM_R 170 0{TEXT 1 65 "and solve the flash fu
nction between each pair of singular points"}}{COM_R 171 0{TEXT 1
 0 ""}}{INP_R 172 0 "> "{TEXT 0 71 "i:= 'i': for k from 1 to c-1 
do fsolve(RRS,alpha,pts[k]..pts[k+1]); od;"}}{OUT_R 173 0 172{DAG
 e3i4x006067125722i2x0010}}{OUT_R 174 0 172{DAG e3j4x005113718126
i2x0010}}{OUT_R 175 0 172{DAG e3j4x004371531237i2x0009}}{COM_R 
176 0{TEXT 1 370 "Now, we have all the values of the vapor fracti
on that satisfy the Rachford - Rice equation but how do we know w
hich is the \"correct\" solution?  It turns out that the correct 
solution lies between the singular points defined by the largest 
and smallest K-values.  This is the only solution  that gives mol
e fractions that are non-negative for all species in both phases.
"}}{COM_R 177 0{TEXT 1 0 ""}}{COM_R 178 0{TEXT 1 51 "The largest 
and smallest K-values are easily found "}}{COM_R 179 0{TEXT 1 0 "
"}}{INP_R 180 0 "> "{TEXT 0 57 "Kmax:=max(seq(K[i],i=1..c)); Kmin
:=min(seq(K[i],i=1..c));"}}{OUT_R 181 0 180{DAG :3n4\`Kmax`e3j2x0
070i2x0001}}{OUT_R 182 0 180{DAG :3n4\`Kmin`e3j2x0003i2x0001}}
{COM_R 183 0{TEXT 1 41 "and the corresponding singular points are
"}}{INP_R 184 0 "> "{TEXT 0 39 "Smin:=RRsing(Kmax); Smax:=RRsing(
Kmin);"}}{OUT_R 185 0 184{DAG :3n4\`Smin`e3i4x001666666667i2x0010
}}{OUT_R 186 0 184{DAG :3n4\`Smax`e3j4x001428571429i2x0009}}
{COM_R 187 0{TEXT 1 111 "and we can find the correct solution by 
solving the Rachford - Rice equation for the root between these p
oints."}}{COM_R 188 0{TEXT 1 0 ""}}{INP_R 189 0 "> "{TEXT 0 37 "i
:='i': fsolve(RRS,alpha,Smin..Smax);"}}{OUT_R 190 0 189{DAG e3j4x
005113718126i2x0010}}{COM_R 191 0{TEXT 1 0 ""}}{COM_R 192 0{TEXT 
1 36 "Solving the Rachford - Rice Equation"}}{COM_R 193 0{TEXT 1 
0 ""}}{COM_R 194 0{TEXT 1 465 "Maple's fsolve function has hidden
 all of the details regarding how the solution is obtained.  Perh
aps that is as it should be but we believe that it is instructive
 to show in more detail how the Rachford - Rice equation can be s
olved using an iterative method.  Several numerical methods may b
e used for this task; here we use Newton's method.  Starting from
 an initial estimate of the vapor fraction, Newton's method suppl
ies subsequent estimates from the formula"}}{COM_R 195 0{TEXT 1 0
 ""}}{INP_R 196 0 "> "{TEXT 0 27 "x[new]=x-f(x)/Diff(f(x),x);"}}
{OUT_R 197 0 196{DAG =3b3n3\`x`,2n3\`new`+5p2j2x0001*5(3n3\`f`,2p
2p9(3n4\`Diff`,3pCp2i2x0001p19}}{COM_R 198 0{TEXT 1 0 ""}}{COM_R 
199 0{TEXT 1 94 "In our case the unknown variable is the vapor fr
action and the function and its derivative are"}}{INP_R 200 0 "> 
"{TEXT 0 82 "c:='c':   fRR:=unapply(lhs(RRS),alpha); dfRR:=unappl
y(diff(lhs(RRS),alpha),alpha);"}}{OUT_R 201 0 200{DAG :3n3\`fRR`@
7,2n4\`alpha`,1,3n5\`operator`n4\`arrow`p8(3n3\`sum`,3+3*5+5b3n3\
`S`,2n3\`i`j2x0001a2x0001i2x0001p23b3n3\`z`p1Cp1Fp23=3p1D~3p1Fn3\
`c`p8}}{OUT_R 202 0 200{DAG :3n4\`dfRR`@7,2n4\`alpha`,1,3n5\`oper
ator`n4\`arrow`p9(3n3\`sum`,3+3*5+5b3n3\`S`,2n3\`i`j2x0001a2x0001
i2x0001i2x0002b3n3\`z`p1Dp20p24=3p1E~3p20n3\`c`p9}}{COM_R 203 0
{TEXT 1 0 ""}}{COM_R 204 0{TEXT 1 155 "Note that the derivative i
s always negative.  As a result, the Rachford - Rice equation mus
t decrease monotonically (at least between the singular points)."
}}{COM_R 205 0{TEXT 1 0 ""}}{COM_R 206 0{TEXT 1 25 "Example 1 (on
e more time)"}}{COM_R 207 0{TEXT 1 0 ""}}{COM_R 208 0{TEXT 1 94 "
Let us illustrate the use of Newton's method with the help of  th
e above example.  The initial"}}{COM_R 209 0{TEXT 1 49 "value of 
the vapor fraction is chosen to be unity"}}{COM_R 210 0{TEXT 1 0 
""}}{INP_R 211 0 "> "{TEXT 0 15 "c:=4: alpha:=1;"}}{OUT_R 212 0 
211{DAG :3n4\`alpha`j2x0001}}{COM_R 213 0{TEXT 1 30 "and the Newt
on iterates follow"}}{COM_R 214 0{TEXT 1 0 ""}}{INP_R 215 0 "> "
{TEXT 0 78 "while abs(fRR(alpha)) > 1E-8 do alpha := alpha - fRR(
alpha) / dfRR(alpha); od;"}}{COM_R 216 0{TEXT 1 0 ""}}{OUT_R 217 
0 215{DAG :3n4\`alpha`e3j4x007155204151i2x0010}}{OUT_R 218 0 215
{DAG :3n4\`alpha`e3j4x005226210274i2x0010}}{OUT_R 219 0 215{DAG :
3n4\`alpha`e3j4x005113329026i2x0010}}{OUT_R 220 0 215{DAG :3n4\`a
lpha`e3j4x005113718121i2x0010}}{COM_R 221 0{TEXT 1 9 "Exercises"}
}{COM_R 222 0{TEXT 1 0 ""}}{COM_R 223 0{TEXT 1 111 "1. Count how 
many iterations it takes to compute this root from different init
ial values of the vapor fraction."}}{COM_R 224 0{TEXT 1 130 "2. T
ry to find the other roots using Newton's method (all you need to
 do is use appropriate initial values of the vapor fraction)."}}
{COM_R 225 0{TEXT 1 141 "3. Convince yourself that only one of th
e roots is valid by computing the mole fractions of both phases f
or each value of the vapor fraction."}}{COM_R 226 0{TEXT 1 173 "4
. Devise a method of  using the mole fractions and singular point
s in order to generate an initial estimate of vapor fraction that
 converges to the \"correct\" root directly."}}{COM_R 227 0{TEXT 
1 0 ""}}{COM_R 228 0{TEXT 1 36 "Flash Calculations for Ideal Syst
ems"}}{COM_R 229 0{TEXT 1 0 ""}}{COM_R 230 0{TEXT 1 282 "We conti
nue our investigations into the solution of the flash function wi
th some numerical examples involving flash calculations of  ideal
 systems.  An ideal system may be considered to be one where the 
K-values are functions only of temperature and pressure and not o
f composition:"}}{OUT_R 231 0 0{TEXT 2 1 "\012"}}{INP_R 232 0 "> 
"{TEXT 0 17 "'K[i]=K[i](T,P)';"}}{OUT_R 233 0 232{DAG =3b3n3\`K`,
2n3\`i`(3p1,3n3\`T`n3\`P`}}{COM_R 234 0{TEXT 1 0 ""}}{COM_R 235 0
{TEXT 1 413 "This simplification, while it limits the variety of 
flash problems to which we may apply the flash function definitel
y makes life a great deal easier.  For an ideal system the K-valu
es are known once the the temperature and pressure have been spec
ified and the flash function is easily solved for the vapor fract
ion by any of the popular root-finding schemes such as Newton's m
ethod as we shall demonstrate below."}}{COM_R 236 0{TEXT 1 0 ""}}
{COM_R 237 0{TEXT 1 9 "Example 2"}}{COM_R 238 0{TEXT 1 0 ""}}
{COM_R 239 0{TEXT 1 100 "Compute the vapor fraction of a mixture 
of benzene(1) and toluene(2) under the following conditions:"}}
{COM_R 240 0{TEXT 1 0 ""}}{INP_R 241 0 "> "{TEXT 0 33 "c := 2: T 
:= 378.2;  P := 101325;"}}{OUT_R 242 0 241{DAG :3n3\`T`e3j2x3782i
2x0001}}{OUT_R 243 0 241{DAG :3n3\`P`j3x00101325}}{COM_R 244 0
{TEXT 1 74 "where the temperature and pressure are in kelvin and 
pascals respectively."}}{COM_R 245 0{TEXT 1 0 ""}}{COM_R 246 0
{TEXT 1 45 "The mixture contains 20 mole percent benzene."}}
{COM_R 247 0{TEXT 1 0 ""}}{INP_R 248 0 "> "{TEXT 0 49 "z:= linalg
[vector](c): z[1] := 0.2; z[2]:=1-z[1];"}}{OUT_R 249 0 248{DAG :3
b3n3\`z`,2j2x0001e3j2x0002i2x0001}}{OUT_R 250 0 248{DAG :3b3n3\`z
`,2j2x0002e3j2x0008i2x0001}}{COM_R 251 0{TEXT 1 110 "The K-values
 are to be computed using Raoult's law with the vapor pressures c
omputed from the Antoine equation"}}{COM_R 252 0{TEXT 1 0 ""}}
{INP_R 253 0 "> "{TEXT 0 49 "Antoine := (T, A, B, C) ->  exp(A - 
B / (T + C));"}}{OUT_R 254 0 253{DAG :3n4\`Antoine`@7,5n3\`T`n3\`
A`n3\`B`n3\`C`,1,3n5\`operator`n4\`arrow`pE(3n3\`exp`,2+5a2x0002j
2x0001*5a2x0003p1F+5a2x0001p1Fa2x0004p1Fi2x0001p2CpE}}{COM_R 255 
0{TEXT 1 0 ""}}{COM_R 256 0{TEXT 1 52 "The Antoine coefficients f
or benzene and toluene are"}}{COM_R 257 0{TEXT 1 0 ""}}{INP_R 258
 0 "> "{TEXT 0 54 "AntA[1]:=21.06807; AntB[1]:=2948.78; AntC[1]:=
-44.563;"}}{OUT_R 259 0 258{DAG :3b3n4\`AntA`,2j2x0001e3j3x021068
07i2x0005}}{OUT_R 260 0 258{DAG :3b3n4\`AntB`,2j2x0001e3j3x002948
78i2x0002}}{OUT_R 261 0 258{DAG :3b3n4\`AntC`,2j2x0001e3i3x000445
63i2x0003}}{INP_R 262 0 "> "{TEXT 0 54 "AntA[2]:=21.15917; AntB[2
]:=3242.38; AntC[2]:=-47.181;"}}{OUT_R 263 0 262{DAG :3b3n4\`AntA
`,2j2x0002e3j3x02115917i2x0005}}{OUT_R 264 0 262{DAG :3b3n4\`AntB
`,2j2x0002e3j3x00324238i2x0002}}{OUT_R 265 0 262{DAG :3b3n4\`AntC
`,2j2x0002e3i3x00047181i2x0003}}{COM_R 266 0{TEXT 1 0 ""}}{COM_R 
267 0{TEXT 1 74 "which give the vapor pressures in pascals if the
 temperature is in kelvin."}}{COM_R 268 0{TEXT 1 0 ""}}{COM_R 269
 0{TEXT 1 43 "We may now compute the K-values as follows:"}}
{COM_R 270 0{TEXT 1 0 ""}}{INP_R 271 0 "> "{TEXT 0 95 "K:=linalg[
vector](c):  for i from 1 to c do K[i] := Antoine(T,AntA[i],AntB[
i],AntC[i]) / P; od;"}}{COM_R 272 0{TEXT 1 0 ""}}{OUT_R 273 0 271
{DAG :3b3n3\`K`,2j2x0001e3j4x002021203707i2x0009}}{OUT_R 274 0 
271{DAG :3b3n3\`K`,2j2x0002e3j4x008503849399i2x0010}}{COM_R 275 0
{TEXT 1 33 "and the singular points follow as"}}{COM_R 276 0{TEXT
 1 0 ""}}{INP_R 277 0 "> "{TEXT 0 46 "for i from 1 to c do S[i] :
= RRsing(K[i]); od;"}}{OUT_R 278 0 277{DAG :3b3n3\`S`,2j2x0001e3i
4x009792365550i2x0010}}{OUT_R 279 0 277{DAG :3b3n3\`S`,2j2x0002e3
j4x006683819124i2x0009}}{COM_R 280 0{TEXT 1 71 "The Rachford - Ri
ce function for this system under these conditions is "}}{COM_R 
281 0{TEXT 1 0 ""}}{INP_R 282 0 "> "{TEXT 0 37 "i:='i': alpha := 
'alpha': fRR(alpha);"}}{OUT_R 283 0 282{DAG +5*3+5e3i4x0097923655
50i2x0010j2x0001n4\`alpha`i2x0001pFe3i2x0002pF*3+5e3j4x0066838191
24i2x0009pApCpFpFe3i2x0008pF}}{COM_R 284 0{TEXT 1 0 ""}}{COM_R 
285 0{TEXT 1 74 "Let us evaluate the function at a vapor fraction
 of zero and one of unity:"}}{COM_R 286 0{TEXT 1 0 ""}}{INP_R 287
 0 "> "{TEXT 0 15 "fRR(0); fRR(1);"}}{OUT_R 288 0 287{DAG e3j4x00
0845486933i2x0010}}{OUT_R 289 0 287{DAG e3i4x000397013692i2x0010}
}{COM_R 290 0{TEXT 1 154 "The fact that the function changes sign
 shows that there is a value of the vapor fraction in the range f
rom zero to one that satisfies the flash function."}}{COM_R 291 0
{TEXT 1 0 ""}}{COM_R 292 0{TEXT 1 76 "We now plot the function ov
er this range (vapor fractions from zero to one):"}}{COM_R 293 0
{TEXT 1 0 ""}}{INP_R 294 0 "> "{TEXT 0 15 "plot(fRR,0..1);"}}
{OUT_R 295 0 294{TEXT 2 1 "\012"}}{COM_R 296 0{TEXT 1 0 ""}}
{COM_R 297 0{TEXT 1 0 ""}}{COM_R 298 0{TEXT 1 143 "We see from th
e graph that the function cuts the axis between 0.5 and 0.6.  Map
le's solve function computes a more precise result quite easily."
}}{COM_R 299 0{TEXT 1 0 ""}}{INP_R 300 0 "> "{TEXT 0 36 "alpha=fs
olve(fRR(alpha),alpha,0..1);"}}{OUT_R 301 0 300{DAG =3n4\`alpha`e
3j4x005533745810i2x0010}}{COM_R 302 0{TEXT 1 0 ""}}{COM_R 303 0
{TEXT 1 230 "and, since this example involves a binary system, th
is is the only solution.  So, for this particular mixture of benz
ene and toluene at the specified temperature and pressure, the mi
xture is approximately 55% vapor and 45% liquid."}}{COM_R 304 0
{TEXT 1 0 ""}}{COM_R 305 0{TEXT 1 0 ""}}{COM_R 306 0{TEXT 1 9 "Ex
ample 3"}}{COM_R 307 0{TEXT 1 0 ""}}{COM_R 308 0{TEXT 1 70 "Repea
t the above exercise at temperatures of 368.2, 382.2 and 388.2 K.
"}}{COM_R 309 0{TEXT 1 0 ""}}{COM_R 310 0{TEXT 1 70 "We first rec
ompute the K-values at the lower of the three temperatures"}}
{COM_R 311 0{TEXT 1 0 ""}}{INP_R 312 0 "> "{TEXT 0 33 "c := 2: T 
:= 368.2;  P := 101325;"}}{OUT_R 313 0 312{DAG :3n3\`T`e3j2x3682i
2x0001}}{OUT_R 314 0 312{DAG :3n3\`P`j3x00101325}}{COM_R 315 0
{TEXT 1 0 ""}}{INP_R 316 0 "> "{TEXT 0 72 "for i from 1 to c do K
[i] := Antoine(T,AntA[i],AntB[i],AntC[i]) / P; od;"}}{OUT_R 317 0
 316{DAG :3b3n3\`K`,2j2x0001e3j4x001538181060i2x0009}}{OUT_R 318 
0 316{DAG :3b3n3\`K`,2j2x0002e3j4x006267591822i2x0010}}{INP_R 319
 0 "> "{TEXT 0 45 "for i from 1 to c do S[i]:= RRsing(K[i]); od;"
}}{OUT_R 320 0 319{DAG :3b3n3\`S`,2j2x0001e3i4x001858110726i2x000
9}}{OUT_R 321 0 319{DAG :3b3n3\`S`,2j2x0002e3j4x002679235368i2x00
09}}{COM_R 322 0{TEXT 1 0 ""}}{COM_R 323 0{TEXT 1 54 "The Rachfor
d - Rice flash function now takes the form:"}}{COM_R 324 0{TEXT 1
 0 ""}}{INP_R 325 0 "> "{TEXT 0 36 "alpha:='alpha': i:='i': fRR(a
lpha); "}}{OUT_R 326 0 325{DAG +5*3+5e3i4x001858110726i2x0009j2x0
001n4\`alpha`i2x0001pFe3i2x0002pF*3+5e3j4x002679235368p8pApCpFpFe
3i2x0008pF}}{COM_R 327 0{TEXT 1 0 ""}}{COM_R 328 0{TEXT 1 0 ""}}
{COM_R 329 0{TEXT 1 96 "We make a function of this expression and
 solve it for the root between the two singular points."}}{COM_R 
330 0{TEXT 1 0 ""}}{INP_R 331 0 "> "{TEXT 0 45 "alpha := fsolve(f
RR(alpha),alpha,S[1]..S[2]);"}}{OUT_R 332 0 331{DAG :3n4\`alpha`e
3i4x009506415074i2x0010}}{COM_R 333 0{TEXT 1 0 ""}}{COM_R 334 0
{TEXT 1 301 "The negative value of the vapor fraction means that 
at a temperature of 368.2 K the specified mixture cannot exist as
 a vapor.  (Be careful, however; it is not always safe to draw su
ch conclusions from the same calculation - as we shall see quite 
soon).  In this case the system is a subcooled liquid."}}{COM_R 
335 0{TEXT 1 0 ""}}{COM_R 336 0{TEXT 1 35 "At a temperature of 38
2.2 K we have"}}{COM_R 337 0{TEXT 1 0 ""}}{INP_R 338 0 "> "{TEXT 
0 33 "c := 2: T := 382.2;  P := 101325;"}}{OUT_R 339 0 338{DAG :3
n3\`T`e3j2x3822i2x0001}}{OUT_R 340 0 338{DAG :3n3\`P`j3x00101325}
}{COM_R 341 0{TEXT 1 0 ""}}{INP_R 342 0 "> "{TEXT 0 72 "for i fro
m 1 to c do K[i] := Antoine(T,AntA[i],AntB[i],AntC[i]) / P; od;"}
}{OUT_R 343 0 342{DAG :3b3n3\`K`,2j2x0001e3j4x002244316025i2x0009
}}{OUT_R 344 0 342{DAG :3b3n3\`K`,2j2x0002e3j4x009558867727i2x001
0}}{OUT_R 345 0 0{TEXT 2 1 "\012"}}{COM_R 346 0{TEXT 1 100 "The s
ingular points are evaluated next to limit the range in which we 
can expect to find a solution."}}{COM_R 347 0{TEXT 1 0 ""}}{INP_R
 348 0 "> "{TEXT 0 46 "for i from 1 to c do S[i] := RRsing(K[i]);
 od;"}}{OUT_R 349 0 348{DAG :3b3n3\`S`,2j2x0001e3i4x008036543610i
2x0010}}{OUT_R 350 0 348{DAG :3b3n3\`S`,2j2x0002e3j4x002266893767
i2x0008}}{COM_R 351 0{TEXT 1 0 ""}}{COM_R 352 0{TEXT 1 51 "and th
e solution of the Rachford - Rice equation is"}}{COM_R 353 0{TEXT
 1 0 ""}}{INP_R 354 0 "> "{TEXT 0 68 "i:='i':  alpha:='alpha': al
pha=fsolve(fRR(alpha),alpha,S[1]..S[2]); "}}{OUT_R 355 0 354{DAG 
=3n4\`alpha`e3j4x003890864045i2x0009}}{COM_R 356 0{TEXT 1 0 ""}}
{COM_R 357 0{TEXT 1 191 "This time the computed value of the vapo
r fraction is greater than unity and we conclude that the system 
cannot exist as a liquid at this temperature.  The system must be
 a superheated vapor."}}{COM_R 358 0{TEXT 1 0 ""}}{COM_R 359 0
{TEXT 1 76 "We repeat the calculations at the higher of the three
 temperatures (388.2 K)"}}{COM_R 360 0{TEXT 1 0 ""}}{INP_R 361 0 
"> "{TEXT 0 33 "c := 2: T := 388.2;  P := 101325;"}}{OUT_R 362 0 
361{DAG :3n3\`T`e3j2x3882i2x0001}}{OUT_R 363 0 361{DAG :3n3\`P`j3
x00101325}}{COM_R 364 0{TEXT 1 0 ""}}{INP_R 365 0 "> "{TEXT 0 72 
"for i from 1 to c do K[i] := Antoine(T,AntA[i],AntB[i],AntC[i]) 
/ P; od;"}}{OUT_R 366 0 365{DAG :3b3n3\`K`,2j2x0001e3j4x002614026
148i2x0009}}{OUT_R 367 0 365{DAG :3b3n3\`K`,2j2x0002e3j4x00113333
6082i2x0009}}{OUT_R 368 0 0{TEXT 2 1 "\012"}}{INP_R 369 0 "> "
{TEXT 0 46 "for i from 1 to c do S[i] := RRsing(K[i]); od;"}}
{OUT_R 370 0 369{DAG :3b3n3\`S`,2j2x0001e3i4x006195686490i2x0010}
}{OUT_R 371 0 369{DAG :3b3n3\`S`,2j2x0002e3i4x007499845391i2x0009
}}{INP_R 372 0 "> "{TEXT 0 68 "i:='i': alpha:='alpha':  alpha=fso
lve(fRR(alpha),alpha,S[2]..S[1]); "}}{OUT_R 373 0 372{DAG =3n4\`a
lpha`e3i4x001995623997i2x0009}}{COM_R 374 0{TEXT 1 0 ""}}{COM_R 
375 0{TEXT 1 288 "which is negative suggesting that the system ca
nnot exist as a vapor at this temperature.  However, the temperat
ure of this calculation is higher than the preceeding case and on
e would expect that increasing the temperature still further woul
d serve only to further superheat the vapor.  "}}{COM_R 376 0
{TEXT 1 0 ""}}{COM_R 377 0{TEXT 1 212 "In this case we need look 
no further than the K-values.  Both K-values are greater than 1 s
o neither component can exist as a liquid and the system must, in
 fact, be a superheated vapor as we had surmised before."}}{COM_R
 378 0{TEXT 1 0 ""}}{COM_R 379 0{TEXT 1 421 "We conclude from the
se calculations that the vapor fraction computed from the Rachfor
d-Rice equation can be used to diagnose the phase state of a mixt
ure only if the K-values lie either side of unity (and the singul
ar points lie either side of 0).  If all the K-values are greater
 than one, the system must be a superheated vapor.  Conversely, i
f all the K-values are less than one, the system must be a subcoo
led liquid."}}{COM_R 380 0{TEXT 1 0 ""}}{COM_R 381 0{TEXT 1 752 "
Exercise:  Clearly, we cannot rely on value of the vapor fraction
 computed from the Rachford-Rice equation in order to determine t
he phase (vapor or liquid) of the system in question.  In Example
 2 we used the values of the Rachford-Rice function when the vapo
r fraction was zero and one to show that the system was in the tw
o phase region (the function values had different signs showing t
hat there was a value of the vapor fraction betwen zero and one t
hat satisfied the Rachford-Rice equation.  Evaluate  the Rachford
-Rice function when the vapor fraction is set to zero or one for 
the conditions in Example 3.  Use this information to devise crit
eria to determine if the system is in the two phase region, a sup
erheated vapor or a subcooled liquid."}}{COM_R 382 0{TEXT 1 0 ""}
}{COM_R 383 0{TEXT 1 47 "Polynomial Form of the Rachford - Rice E
quation"}}{COM_R 384 0{TEXT 1 0 ""}}{COM_R 385 0{TEXT 1 360 "It i
s worth pointing out (if only as a warning) that the Rachford - R
ice equation can be written as a polynomial in the vapor fraction
 of degree one less than the number of components.  Some authors 
have advocated solving the polynomial form instead of solving the
 Rachford - Rice form.  There are several reasons why we do not c
onsider this to be a good idea."}}{COM_R 386 0{TEXT 1 0 ""}}
{COM_R 387 0{TEXT 1 248 "1. The numerical evaluation of the coeff
icients of the polynomial and the solution of the polynomial is l
ikely to be significantly more time consuming than is solving the
 Rachford - Rice equation using a root finding method such as New
ton's method."}}{COM_R 388 0{TEXT 1 0 ""}}{COM_R 389 0{TEXT 1 75 
"2. The polynomial form is not monotonic as is the Rachford - Ric
e equation."}}{COM_R 390 0{TEXT 1 0 ""}}{COM_R 391 0{TEXT 1 264 "
3. It may be necessary to find all solutions to the polynomial an
d some of them may be complex.  Selection of the desired root is 
not always straightforward.  In addition, the roots of a polynomi
al can be very sensitive to the numerical values of the coefficie
nts."}}{COM_R 392 0{TEXT 1 0 ""}}{COM_R 393 0{TEXT 1 250 "Only in
 one case can we advocate solving the polynomial form - binary sy
stems for which we may solve the Rachford - Rice equation explici
tly for the vapor fraction.  We begin by writing out the Rachford
 - Rice equation for a binary system as follows:"}}{COM_R 394 0
{TEXT 1 0 ""}}{INP_R 395 0 "> "{TEXT 0 74 "c:=2: z:=linalg[vector
](c): S:=linalg[vector](c):  RR2:=fRR(alpha)=0: RR2;"}}{INP_R 396
 0 "> "{TEXT 0 49 "e6:=numer(lhs(RR2))=0: t1:=alpha=solve(e6,alph
a):"}}{OUT_R 397 0 396{DAG =3+5*5+5b3n3\`S`,2j2x0001p8n4\`alpha`i
2x0001pEb3n3\`z`p7p8pE*5+5b3p5,2j2x0002p8pBpEpEb3p12p1Bp8pEj2x000
0}}{INP_R 398 0 "> "{TEXT 0 40 "t2:=subs(Sumz,t1): sort(t2,[z[1],
z[2]]);"}}{COM_R 399 0{TEXT 1 0 ""}}{OUT_R 400 0 398{DAG =3n4\`al
pha`+5*5b3n3\`S`,2j2x0002j2x0001b3n3\`z`,2pCpCpC*5b3p7p11pCb3pFp9
pCpC}}{COM_R 401 0{TEXT 1 94 "Thus, knowing the K-values and feed
 mole fractions we can compute the vapor fraction directly."}}
{COM_R 402 0{TEXT 1 0 ""}}{COM_R 403 0{TEXT 1 91 "Exercise: Use t
he explicit result obtained above and check the results of Exampl
es 2 and 3."}}{COM_R 404 0{TEXT 1 0 ""}}{COM_R 405 0{TEXT 1 31 "A
dditional Exercises and Topics"}}{COM_R 406 0{TEXT 1 0 ""}}{COM_R
 407 0{TEXT 1 699 "Exercise 1 below asks you to consider alternat
ive methods of formulating an objective function.  Exercises 2 an
d 3 ask you to consider alternative numerical methods.  Iterative
 methods are not the main topic of this worksheet; we recommend t
he book by Press et al. (1993) for those wishing to learn more ab
out numerical methods for solving nonlinear equations.  Exercises
 4 and 5 ask you to formulate the flash problem in terms of varia
bles other than the vapor fraction.  Exercises 6 and 7 look at ot
her kinds of flash calculation and questions 8 and 9 ask you to d
emonstrate the relationship of the flash equations to those used 
to solve bubble and dew point problems in episode II of this seri
es."}}{COM_R 408 0{TEXT 1 0 ""}}{COM_R 409 0{TEXT 1 61 "1. The Ra
chford-Rice flash function is based on the equation "}}{INP_R 410
 0 "> "{TEXT 0 18 "c:='c': Sumy-Sumx;"}}{OUT_R 411 0 410{DAG =3+5
(3n3\`sum`,3b3n3\`y`,2n3\`i`=3pA~3j2x0001n3\`c`pF(3p3,3b3n3\`x`p9
pCi2x0001j2x0000}}{COM_R 412 0{TEXT 1 87 " Devise alternative fun
ctions that could be used for solving flash problems based on   "
}}{INP_R 413 0 "> "{TEXT 0 22 "lhs(Sumx)-rhs(Sumx)=0;"}}{OUT_R 
414 0 413{DAG =3+5(3n3\`sum`,3b3n3\`x`,2n3\`i`=3pA~3j2x0001n3\`c`
pFi2x0001pFj2x0000}}{INP_R 415 0 "> "{TEXT 0 22 "lhs(Sumy)-rhs(Su
my)=0;"}}{OUT_R 416 0 415{DAG =3+5(3n3\`sum`,3b3n3\`y`,2n3\`i`=3p
A~3j2x0001n3\`c`pFi2x0001pFj2x0000}}{INP_R 417 0 "> "{TEXT 0 16 "
ln(lhs(Sumx))=0;"}}{OUT_R 418 0 417{DAG =3(3n3\`ln`,2(3n3\`sum`,3
b3n3\`x`,2n3\`i`=3pD~3j2x0001n3\`c`j2x0000}}{INP_R 419 0 "> "
{TEXT 0 30 "ln(lhs(Sumy))-ln(lhs(Sumx))=0;"}}{OUT_R 420 0 419{DAG
 =3+5(3n3\`ln`,2(3n3\`sum`,3b3n3\`y`,2n3\`i`=3pE~3j2x0001n3\`c`p1
3(3p3,2(3p7,3b3n3\`x`pDp10i2x0001j2x0000}}{COM_R 421 0{TEXT 1 196
 "Without solving a numerical example can you say which of these 
equations has the best convergence properties?  Solve the TP flas
h problem of Example 1 using the functions derived in this exerci
se."}}{COM_R 422 0{TEXT 1 0 ""}}{COM_R 423 0{TEXT 1 128 "2. The R
achford-Rice equation can be solved using methods other than that
 credited to Newton.  Solve the example problems using:"}}{COM_R 
424 0{TEXT 1 26 "     (a) The secant method"}}{COM_R 425 0{TEXT 1
 32 "     (b) The method of bisection"}}{COM_R 426 0{TEXT 1 52 " 
    (c) The method of false position (regula falsi)"}}{COM_R 427 
0{TEXT 1 88 "     (d) A higher order Newton-method that uses seco
nd derivatives as well as the first."}}{COM_R 428 0{TEXT 1 60 "Co
mment on the convergence characteristics of these methods."}}
{COM_R 429 0{TEXT 1 0 ""}}{COM_R 430 0{TEXT 1 145 "3. Derive dire
ct iteration formulae for computing the vapor fraction starting w
ith each of the following equations (or combinations of equations
)"}}{COM_R 431 0{TEXT 1 0 ""}}{INP_R 432 0 "> "{TEXT 0 5 "Sumx;"}
}{OUT_R 433 0 432{DAG =3(3n3\`sum`,3b3n3\`x`,2n3\`i`=3p9~3j2x0001
n3\`c`pE}}{COM_R 434 0{TEXT 1 0 ""}}{INP_R 435 0 "> "{TEXT 0 5 "S
umy;"}}{OUT_R 436 0 435{DAG =3(3n3\`sum`,3b3n3\`y`,2n3\`i`=3p9~3j
2x0001n3\`c`pE}}{COM_R 437 0{TEXT 1 0 ""}}{INP_R 438 0 "> "{TEXT 
0 11 "Sumx, Sumy;"}}{OUT_R 439 0 438{DAG ,3=3(3n3\`sum`,3b3n3\`x`
,2n3\`i`=3pA~3j2x0001n3\`c`pF=3(3p3,3b3n3\`y`p9pCpF}}{COM_R 440 0
{TEXT 1 190 "Without solving a numerical example can you say whic
h of these methods has the best convergence properties?  Solve th
e flash problem of Example 1 using the functions derived in thise
xercise."}}{COM_R 441 0{TEXT 1 0 ""}}{COM_R 442 0{TEXT 1 160 "4. 
Devise methods for solving the TP flash in terms of the liquid fr
action (L/F) rather than the vapor fraction.  Is there any advant
age to using these methods?"}}{COM_R 443 0{TEXT 1 0 ""}}{COM_R 
444 0{TEXT 1 197 "5. Devise methods for solving the TP flash in t
erms of the ratio of vapor to liquid flows (V/L) rather than the 
vapor fraction.  What, if any, are the advantages and disadvantag
es of this approach?"}}{COM_R 445 0{TEXT 1 0 ""}}{COM_R 446 0
{TEXT 1 427 "The Rachford-Rice equation (or any of the alternativ
es that follow from the exercises above) can be solved for variab
les other than the vapor (or liquid) fraction.  If the vapor frac
tion and pressure are specified it is possible to solve the Rachf
ord-Rice equation for temperature (a PV flash).  If the vapor fra
ction and temperature are specified it is possible to solve the R
achford-Rice equation for pressure (a TV flash).  "}}{COM_R 447 0
{TEXT 1 0 ""}}{COM_R 448 0{TEXT 1 217 "6. Devise methods for solv
ing PV flash problems where the temperature is the unknown variab
le.  Test your methods on the benzene - toluene system of Example
 2.  Remember that the K-values are functions of temperature."}}
{COM_R 449 0{TEXT 1 0 ""}}{COM_R 450 0{TEXT 1 211 "7. Devise meth
ods for solving TV flash problems where the pressure is the unkno
wn variable.  Test your methods on the benzene - toluene system o
f Example 2.  Remember that the K-values are functions of pressur
e."}}{COM_R 451 0{TEXT 1 0 ""}}{COM_R 452 0{TEXT 1 459 "Simple (o
r not so simple) phase equilibrium calculations such as the deter
mination of bubble and dew points of mixtures (as discussed in ep
isode II of this series) are related to flash calculations.  The 
boiling point of a mixture can be determined by solving the Rachf
ord - Rice equation for temperature or pressure with the vapor fr
action set to zero. The dew-point is determined by solving the Ra
chford - Rice equation with the vapor fraction set to unity:"}}
{COM_R 453 0{TEXT 1 0 ""}}{COM_R 454 0{TEXT 1 166 "8. Show that w
hen the vapor fraction is zero the Rachford-Rice equation simplif
ies to give the equation that we solved for the bubble-point temp
erature in episode II."}}{COM_R 455 0{TEXT 1 0 ""}}{COM_R 456 0
{TEXT 1 176 "9. Show that when the vapor fraction is one the Rach
ford-Rice equation simplifies to give the equation that we solved
 for the dew-point temperature (or pressure) in episode II."}}
{COM_R 457 0{TEXT 1 0 ""}}{COM_R 458 0{TEXT 1 13 "Final Remarks"}
}{COM_R 459 0{TEXT 1 0 ""}}{COM_R 460 0{TEXT 1 404 "In this works
heet we have discussed methods for solving equilibrium flash calc
ulations for ideal systems where the K-values are functions only 
of temperature and pressure.  The methods described in this works
heet must be adapted (or completely revised) to handle systems wh
ere the K-values depend on the mole fractions of one or both phas
es.  We will take up this topic for discussion in a later episode
."}}{COM_R 461 0{TEXT 1 0 ""}}{COM_R 462 0{TEXT 1 30 "References 
and Further Reading"}}{COM_R 463 0{TEXT 1 0 ""}}{COM_R 464 0{TEXT
 1 120 "Henley, E.J., and J.D. Seader, Equilibrium Staged Separat
ion Operations in Chemical Engineering, Wiley, New York (1981)."}
}{COM_R 465 0{TEXT 1 0 ""}}{COM_R 466 0{TEXT 1 196 "Press, W. H.,
 Teukolsky, S. A., Vetterling, W. T., and Flannery, B. P.,Numeric
al Recipes in Fortran: The Art of Scientific Computing, 2nd ed.,C
ambridge University Press, Cambridge, England (1992)."}}{COM_R 
467 0{TEXT 1 0 ""}}{COM_R 468 0{TEXT 1 62 "Wankat, P.C., Equilibr
ium Staged Separations, Elsevier (1988)."}}}{END}
