{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--*-180-*-
*-*-*-*-*" "new century schoolbook" "Times-Bold" 8 18 64 "Times-B
old" 18}{FONT 4 "-adobe-new century schoolbook-bold-r-normal--*-1
80-*-*-*-*-*-*" "new century schoolbook" "Times-Bold" 8 18 64 "Ti
mes-Bold" 18}{FONT 5 "-adobe-new century schoolbook-bold-r-normal
--*-180-*-*-*-*-*-*" "new century schoolbook" "Times-Bold" 8 18 
64 "Times-Bold" 18}{SCP_R 1 0 50{COM_R 2 0{TEXT 5 33 "Multiple Qu
antum Filtered Spectra"}}{COM_R 3 0{TEXT 1 60 "\015Copyright (199
4) Rene P.F. Kanters\012KANTERS@urvax.urich.edu\012"}}{INP_R 4 0 
"> "{TEXT 0 53 "with(share): readshare(pof, science); # read `pof
.m`;"}}{OUT_R 5 0 4{TEXT 2 71 "See ?share and ?share,contents for
 information about the share library\012"}}{OUT_R 6 0 4{DAG n3\`p
of`}}{COM_R 7 0{TEXT 1 1107 "\015We are going to look at a few mu
ltiple-quantum filtered spectra.\012\012The nQF-COSY sequence is:
\012       (Pi/2) - t1 - (Pi/2) - tau - (Pi/2) - observe\012\012T
he angles for the direction of the pulses are not included since \+
these are cycled through sequences in order to get a specific qua
ntum filtering. The constant time tau is present to allow build-u
p of multiple quantum coherences.\012\012In this implementation o
f the Product-Operator formalism we can achieve the same results \+
as this pulse sequence by doing:\012       (Pi/2)x - t1 - (Pi/2)x
 - QF(n) - (Pi/2)x - observe\012\012where we selected only 1 step
 in the phase cycle and obtained the quantum filtering by using t
he QF procedure after the second pulse generated the multiple qua
ntum coherences.\012\012Since we are going to perform several nQF
 pulse experiments, we will define the procedure nQF(order,nucleu
s,system,dom1,dom2) where order is the quantum filter order, nucl
eus is a set containing the nuclei that receive the pulses, the s
ystem is the spinsystem list, and dom1 and dom2 are the spins who
se chemical shifts evolve during time domains t1 and t2, respecti
vely."}}{INP_R 8 0 "> "{TEXT 0 207 "nQF:=proc(order,nucleus,syste
m,dom1,dom2)\012  spinsystem(system):\012  xpulse(\",nucleus,Pi/2
):\012   evolve(\",dom1,t1):\012  xpulse(\",nucleus,Pi/2):\012  Q
F(\",order):\012  xpulse(\",nucleus,Pi/2):\012  observe(\",dom2,t
2,0):\012end:"}}{COM_R 9 0{TEXT 1 157 "\015Since we will also nee
d to obtain real parts of the specta we will define the function \+
real(s), that will evaluate to only the real part of its argument
, s."}}{INP_R 10 0 "> "{TEXT 0 26 "real:=(s) -> evalc(Re(s)):"}}
{COM_R 11 0{TEXT 1 251 "\015We will start with a simple 2 spin sy
tem, AM, and perform a Double QF-COSY (DQF-COSY) in which we will
 only focus on the cross peak.\012\012First we look at the real p
art in order to figure out what phase correction we need to obtai
n pure absorption peaks."}}{INP_R 12 0 "> "{TEXT 0 41 "AM:=nQF(2,
\{A,M\},[A,M],\{A\},\{M\}): real(\");\012"}}{OUT_R 13 0 12{DAG +3
*9(3n3\`Cos`,2+3*7n3\`Pi`j2x0001b3n3\`W`,2n3\`A`pAn3\`t1`pAj2x000
2pA(3n3\`Sin`,2*7p8pAb3n3\`J`,3p10n3\`M`pAp13pApA(3p1A,2+3*7p8pAb
3pD,2p25pAn3\`t2`pAp16pA(3p1A,2*7p8pAp20pAp37pApA/3pAj2x0004}}
{COM_R 14 0{TEXT 1 861 "\015In order to determine the effect of F
ourier transformation on the shape of peaks we will obtain, we ne
ed to look at the resulting kind of modulation when we combine bo
th the shift and coupling modulation for each time domain: (produ
cts of trigonometric functions: product of sin * cos -> sum of si
nes, sin * sin -> cosines, cos * cos -> cosines).\012\012Complex \+
Fourier transform of a Cos will give real Ab peaks, and imaginary
 Di peaks, while that of a Sin wil give real Di and imaginary Ab \+
peaks. Cosine transforms will yield only the real parts of the sa
me results. So we really want to obtain cosine modulations in bot
h time domains to get pure absorption peaks after Fourier transfo
rmation.\012\012We see that for t1 we have Cos * Sin -> Sin : nee
d a Pi/2 phase shift to turn that into Cos\012For t2 : Sin * Sin \+
-> Cos : no phase shift needed.\012\012Let's see what this does."
}}{INP_R 15 0 "> "{TEXT 0 39 "CosFT(real(FT(AM,0,t2,v2)),Pi/2,t1,
v1);"}}{OUT_R 16 0 15{DAG +9*5(3n3\`Ab`,3+5b3n3\`W`,2n3\`M`j2x000
1b3n3\`J`,3n3\`A`pB/3pDj2x0002n3\`v2`pD(3p3,3+5b3p8,2p13pDpFp16n3
\`v1`pD/3i2x0001j2x0032*5p2pD(3p3,3+5p21pDpF/3p2Cp18p28pD/3pDp2E*
5(3p3,3+5p7pDpFp3Ap1ApDp1DpDp3F*5p43pDp33pDp2B}}{COM_R 17 0{TEXT 
1 370 "\015We do indeed end up with pure absorption peaks, but we
 notice that the signs are such that on the line parallel to the \+
diagonal (both arguments + J/2 or -J/2) the peaks have negative i
ntensities, so we will use a phase correction of -Pi/2 for the t1
 domain instead.\012\012We will include this in a new function nQ
FFT(FID) that will perform the Fourier transformation of FID."}}
{INP_R 18 0 "> "{TEXT 0 55 "nQFFT := (s) -> CosFT(real(FT(s,0,t2,
v2)),-Pi/2,t1,v1):"}}{COM_R 19 0{TEXT 1 205 "\015Now we will perf
orm the DQF-COSY on AM to obtain the whole spectrum.\012\012We wi
ll look at the modulation present in the real part of the FID to \+
determine the requirements for the presence of particular terms:"
}}{INP_R 20 0 "> "{TEXT 0 39 "AM:=nQF(2,\{A,M\},[A,M],\{\},\{\}):
 real(AM);"}}{OUT_R 21 0 20{DAG +9*9(3n3\`Cos`,2+3*7n3\`Pi`j2x000
1b3n3\`W`,2n3\`A`pAn3\`t1`pAj2x0002pA(3n3\`Sin`,2*7p8pAb3n3\`J`,3
p10n3\`M`pAp13pApA(3p1A,2+3*7p8pApCpAn3\`t2`pAp16pA(3p1A,2*7p8pAp
20pAp34pApA/3pAj2x0004*9p2pAp19pA(3p1A,2+3*7p8pAb3pD,2p25pAp34pAp
16pAp39pAp44*9(3p3,2+3*7p8pAp54pAp13pAp16pAp19pAp2BpAp39pAp44*9p6
1pAp19pAp4DpAp39pAp44}}{COM_R 22 0{TEXT 1 921 "\015We know that t
he absolute value of the chemical shift can not be zero, otherwis
e the nucleus wouldn't be NMR active, so the only way for certain
 terms to become zero is if the term has a sine modulation depend
ing on a coupling.\012\012We notice that all terms present have s
ine modulation of Pi J[A,M] in both t1 and t2, so if J[A,M] is ze
ro every term evaluates to ... * Sin(0) = 0: in that case nothing
 will be observed.\012\012The coupling J[A,M] for the crosspeak b
etween A and M is called the active coupling since in a COSY sequ
ence it will give rise to sine modulation for the crosspeak, and \+
as a result of that needs to be present for the crosspeak to exis
t.\012\012The fact that the presence of crosspeaks and diagonal p
eaks in this spectrum depends on the size of the coupling between
 the two spins can easily be checked by doing the substitution. N
ote that we use nmrsubs because AM is an FID expression with Sin \+
and Cos terms."}}{INP_R 23 0 "> "{TEXT 0 21 "nmrsubs(J[A,M]=0,AM)
;"}}{OUT_R 24 0 23{DAG j2x0000}}{COM_R 25 0{TEXT 1 181 "In order \+
to be able to plot the spectrum we will define the numerical valu
es required. We will also define couplings with, a not yet presen
t, spin X since we will need that shortly."}}{INP_R 26 0 "> "
{TEXT 0 93 "T2:=table([A=1,M=1]):Wv:=table([A=0,M=50]): Jv:=table
(symmetric,[(A,M)=2,(A,X)=10,(M,X)=20]):"}}{COM_R 27 0{TEXT 1 60 
"\015Let's perform the Fourier transforms for both time domains:"
}}{INP_R 28 0 "> "{TEXT 0 16 "spec:=nQFFT(AM);"}}{OUT_R 29 0 28
{DAG :3n4\`spec`+21*5(3n3\`Ab`,3+5b3n3\`W`,2n3\`M`j2x0001b3n3\`J`
,3n3\`A`pF/3p11j2x0002n3\`v2`p11(3p7,3+5b3pC,2p17p11p13p1An3\`v1`
p11/3p11j2x0032*5p6p11(3p7,3+5p25p11p13/3i2x0001p1Cp2Cp11/3p3Ep31
*5(3p7,3+5pBp11p13p3Dp1Ep11(3p7,3pAp2Cp11p43*5p47p11(3p7,3p4Ap2Cp
11p2F*5(3p7,3p24p1Ep11p21p11p2F*5p63p11p36p11p43*5p47p11p21p11p43
*5p47p11p36p11p2F*5p6p11p51p11p2F*5p6p11p5Bp11p43*5(3p7,3p39p1Ep1
1p21p11p43*5p8Bp11p36p11p2F*5p8Bp11p51p11p43*5p8Bp11p5Bp11p2F*5p6
3p11p51p11p2F*5p63p11p5Bp11p43}}{COM_R 30 0{TEXT 1 72 "We can use
 super2d to plot this (there are no dispersion peaks present):"}}
{INP_R 31 0 "> "{TEXT 0 87 "super2d(spec,v2,v1,numpoints=6*6,axes
=FRAME,orientation=[120,60], title=`AM DQF-COSY`);"}}{COM_R 32 0
{TEXT 1 0 ""}}{COM_R 33 0{TEXT 1 158 "\015Now we will look at the
 DQF-COSY crosspeaks between A and M in the spectrum of a homonuc
lear AMX spinsystem.\012\012First we will look at the real part o
f the FID:"}}{INP_R 34 0 "> "{TEXT 0 44 "AMX:=nQF(2,\{A,M,X\},[A,
M,X],\{A\},\{M\}):real(\");"}}{OUT_R 35 0 34{DAG +3*D(3n3\`Cos`,2
+3*7n3\`Pi`j2x0001b3n3\`W`,2n3\`A`pAn3\`t1`pAj2x0002pA(3n3\`Sin`,
2*7p8pAb3n3\`J`,3p10n3\`M`pAp13pApA(3p3,2*7p8pAb3p21,3p10n3\`X`pA
p13pApA(3p1A,2+3*7p8pAb3pD,2p25pAn3\`t2`pAp16pA(3p1A,2*7p8pAp20pA
p47pApA(3p3,2*7p8pAb3p21,3p25p35pAp47pApA/3pAj2x0004}}{COM_R 36 0
{TEXT 1 599 "\015We also see that the terms Cos(Pi J[A,X] t1) and
 Cos(Pi J[M,X] t2) are present. This means that there will be an \+
in-phase splitting of size J[A,X] in v1 and one of size J[M,X] in
 t2 present. Since these splittings are in-phase the peaks will s
till be present when those couplings are 0 (Cos(0)=1).\012\012The
 couplings of spin A with X and M with X are called passive coupl
ings for the crosspeak between A and M since they give rise to co
sine modulation for and need not be present for the crosspeak to \+
be present.\012\012Let's look at the crosspeak (the active coupli
ng J[A,M] is 2Hz, J[A,X]=10 and J[M,X]=20."}}{INP_R 37 0 "> "
{TEXT 0 107 "super2d(nQFFT(AMX),v2,v1,numpoints=6*6,axes=FRAME,or
ientation=[120,60], title=`AMX DQF-COSY AM crosspeak`);"}}{COM_R 
38 0{TEXT 1 0 ""}}{COM_R 39 0{TEXT 1 182 "\015Finally we will loo
k at the crosspeak of a heteronuclear AMX DQF-COSY spectrum where
 X is the heteronucleus.\012\012This is achieved by having \{A,M\
} as the nucleus set in the call to nQF:"}}{INP_R 40 0 "> "{TEXT 
0 43 "AMX:=nQF(2,\{A,M\},[A,M,X],\{A\},\{M\}): real(\");"}}{OUT_R
 41 0 40{DAG +5*D(3n3\`Cos`,2+3*7n3\`Pi`j2x0001b3n3\`W`,2n3\`A`pA
n3\`t1`pAj2x0002pA(3n3\`Sin`,2*7p8pAb3n3\`J`,3p10n3\`M`pAp13pApA(
3p3,2*7p8pAb3p21,3p10n3\`X`pAp13pApA(3p1A,2+3*7p8pAb3pD,2p25pAn3\
`t2`pAp16pA(3p1A,2*7p8pAp20pAp47pApA(3p3,2*7p8pAb3p21,3p25p35pAp4
7pApA/3pAj2x0004*D(3p1Ap5pAp19pA(3p1Ap2DpA(3p3p3DpAp4CpA(3p1Ap59p
A/3i2x0001p68}}{COM_R 42 0{TEXT 1 243 "\012We see that we have th
e same modulation in the FID but subtracted from that a new term.
\012The result of that is that two of the 4 anti-phase patters wi
ll cancel out, depending on the relative \012\015Let's look at th
e crosspeak that would be obtained"}}{INP_R 43 0 "> "{TEXT 0 17 "
spec:=nQFFT(AMX):"}}{INP_R 44 0 "> "{TEXT 0 116 "super2d(spec,v2,
v1,numpoints=6*6,axes=FRAME,orientation=[120,60], title=`AMX DQF-
COSY, hetero X, equal signs of J`);"}}{COM_R 45 0{TEXT 1 0 ""}}
{COM_R 46 0{TEXT 1 76 "\015Now with the two couplings to the hete
ronuecleus of opposite signs, we get:"}}{INP_R 47 0 "> "{TEXT 0 
18 "Jv[M,X]:=-Jv[M,X]:"}}{INP_R 48 0 "> "{TEXT 0 119 "super2d(spe
c,v2,v1,numpoints=6*6,axes=FRAME,orientation=[120,60], title=`AMX
 DQF-COSY, hetero X, opposite signs of J`);"}}{COM_R 49 0{TEXT 1 
0 ""}}{COM_R 50 0{TEXT 1 50 "We see that the other anti-phase pat
terns appear.\012"}}{INP_R 51 0 "> "{TEXT 0 0 ""}}}{END}
