{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "Courier New"
 "Courier New" "Courier" 4 12 192 "Courier" 10}{FONT 3 "-adobe-ne
w century schoolbook-bold-r-normal--17-*" "new century schoolbook
" "Times-Bold" 8 17 64 "Times-Bold" 17}{SCP_R 1 0 70{COM_R 2 0
{TEXT 3 55 "DAMPED SIMPLE HARMONIC MOTION ... A PENDULUM IN TREAC
LE"}}{COM_R 3 0{TEXT 1 12 "David Harper"}}{COM_R 4 0{TEXT 1 0 ""}
}{COM_R 5 0{TEXT 1 436 "The diagram below shows a pendulum consis
ting of a small spherical mass suspended from a pivot. The whole 
pendulum is immersed in a liquid which resists the motion of the 
pendulum bob. The green arrow shows the velocity v of the bob, an
d the red arrows show the forces acting on it. There is a downwar
ds force g due to gravity and also r a resistive force due to the
 fluid, acting in a direction OPPOSITE to the pendulum bob's velo
city."}}{COM_R 6 0{TEXT 1 0 ""}}{INP_R 7 0 "> "{TEXT 0 85 "circle
 := proc(n) local i; [seq([ cos(2*Pi*i/n)/2, sin(2*Pi*i/n)/2 ], i
 = 1..n)] end:"}}{INP_R 8 0 "> "{TEXT 0 64 "ball := POLYGONS( eva
lf( circle(16) ) ), CURVES([[-2,8],[0,0]]):"}}{INP_R 9 0 "> "
{TEXT 0 52 "lines := CURVES( [[-6,8],[2,8]], [[-2,8],[-2,-2]] ):"
}}{INP_R 10 0 "> "{TEXT 0 53 "red := COLOUR(RGB,1,0,0): green := 
COLOUR(RGB,0,1,0):"}}{INP_R 11 0 "> "{TEXT 0 92 "resistance := CU
RVES( [[0,0],[2,0.5]], [[1.8,0.7],[2,0.5],[1.8,0.2]],red), TEXT( 
[1,0], r ):"}}{INP_R 12 0 "> "{TEXT 0 96 "gravity := CURVES( [[0,
0],[0,-2]], [[-0.2,-1.8],[0,-2],[0.2,-1.8]], red), TEXT( [0.2,-1.
0], g ):"}}{INP_R 13 0 "> "{TEXT 0 103 "velocity := CURVES( [[0,0
],[-2,-0.5]], [[-1.8,-0.2],[-2,-0.5],[-1.8,-0.7]], green), TEXT( 
[-1.5,0], v):"}}{INP_R 14 0 "> "{TEXT 0 149 "diagram := PLOT( bal
l, lines, resistance, gravity, velocity, \012                    
SCALING(CONSTRAINED), AXESSTYLE(NONE), TITLE(`Pendulum Diagram`) 
):"}}{INP_R 15 0 "> "{TEXT 0 8 "diagram;"}}{COM_R 16 0{TEXT 1 0 "
"}}{COM_R 17 0{TEXT 1 139 "We can write an equation which describ
es the motion of the pendulum, in terms of the angle theta betwee
n the pendulum bob and the vertical."}}{INP_R 18 0 "> "{TEXT 0 52
 "diff(theta(t),t,t) = -k*diff(theta(t),t) - theta(t);"}}{OUT_R 
19 0 18{DAG =3(3n4\`diff`,3(3p2,3(3n4\`theta`,2n3\`t`pEpE+5*5n3\`
k`j2x0001p6p16i2x0001p9p1A}}{COM_R 20 0{TEXT 1 0 ""}}{COM_R 21 0
{TEXT 1 164 "This is called a DIFFERENTIAL equation because it in
volves the derivatives of theta. The constant k is a measure of h
ow much resistance the fluid exerts on the bob."}}{COM_R 22 0
{TEXT 1 0 ""}}{COM_R 23 0{TEXT 1 80 "If k = 0 then the fluid exer
ts NO resistance. The equation then looks like this:"}}{INP_R 24 
0 "> "{TEXT 0 34 "pendulum := \": subs(k=0,pendulum);"}}{OUT_R 25
 0 24{DAG =3(3n4\`diff`,3(3p2,3(3n4\`theta`,2n3\`t`pEpE+3p9i2x000
1}}{COM_R 26 0{TEXT 1 0 ""}}{COM_R 27 0{TEXT 1 230 "We can use Ma
ple's \"dsolve\" function to solve the differential equation. We 
must specify the initial conditions i.e. the values of theta and 
d(theta)/dt at t = 0. We will suppose that the pendulum starts at
 rest from an angle phi."}}{INP_R 28 0 "> "{TEXT 0 48 "dsolve(\{\
",theta(0)=phi,D(theta)(0)=0\},theta(t));"}}{OUT_R 29 0 28{DAG =3
(3n4\`theta`,2n3\`t`*5n3\`phi`j2x0001(3n3\`cos`p5pB}}{COM_R 30 0
{TEXT 1 0 ""}}{COM_R 31 0{TEXT 1 194 "As you can see, the solutio
n is just a cosine curve. This means that the pendulum will oscil
late for ever. We can plot a graph of theta against time for a pa
rticular starting angle phi, say 0.1:"}}{INP_R 32 0 "> "{TEXT 0 
16 "subs(phi=0.1,\");"}}{OUT_R 33 0 32{DAG =3(3n4\`theta`,2n3\`t`
+3(3n3\`cos`p5e3j2x0001i2x0001}}{COM_R 34 0{TEXT 1 0 ""}}{COM_R 
35 0{TEXT 1 101 "The next command selects the RIGHT-HAND side of 
the equation, which is what we actually want to plot."}}{INP_R 36
 0 "> "{TEXT 0 7 "rhs(\");"}}{OUT_R 37 0 36{DAG +3(3n3\`cos`,2n3\
`t`e3j2x0001i2x0001}}{COM_R 38 0{TEXT 1 0 ""}}{COM_R 39 0{TEXT 1 
53 "And then we can plot it using Maple's \"plot\" command:"}}
{INP_R 40 0 "> "{TEXT 0 16 "plot(\",t=0..10);"}}{COM_R 41 0{TEXT 
1 0 ""}}{COM_R 42 0{TEXT 1 154 "Now let's experiment to see what 
happens if we set k to a small number, corresponding to a fluid w
hich exerts a small resisting force on the pendulum bob."}}{INP_R
 43 0 "> "{TEXT 0 22 "subs(k=1/10,pendulum);"}}{OUT_R 44 0 43{DAG
 =3(3n4\`diff`,3(3p2,3(3n4\`theta`,2n3\`t`pEpE+5p6/3i2x0001j2x001
0p9p15}}{INP_R 45 0 "> "{TEXT 0 56 "soln := dsolve(\{\",theta(0)=
phi,D(theta)(0)=0\},theta(t));"}}{OUT_R 46 0 45{DAG :3n4\`soln`=3
(3n4\`theta`,2n3\`t`+5*Dj2x0003/3j2x0001j2x0002j2x0007p10j2x0019p
10n3\`phi`p11(3n3\`exp`,2+3pA/3i2x0001j2x0020p11(3n3\`sin`,2+3*9p
Ep10p15p10p18p10pAp11/3p11p27p11/3p11j2x0399*7p1Bp11p1Ep11(3n3\`c
os`p2Dp11p11}}{COM_R 47 0{TEXT 1 0 ""}}{COM_R 48 0{TEXT 1 198 "Th
is solution looks more complicated than the k = 0 solution. You c
an see exponential functions in this solution. To see what this s
olution actually means, let's plot it for a specific value of phi
."}}{INP_R 49 0 "> "{TEXT 0 19 "subs(phi=0.1,soln);"}}{OUT_R 50 0
 49{DAG =3(3n4\`theta`,2n3\`t`+5*Bj2x0003/3j2x0001j2x0002j2x0007p
Cj2x0019pC(3n3\`exp`,2+3p6/3i2x0001j2x0020pD(3n3\`sin`,2+3*9pApCp
11pCp14pCp6pD/3pDp20pDe3j4x002506265664i2x0013*5p17pD(3n3\`cos`p2
6pDe3pDp1E}}{COM_R 51 0{TEXT 1 0 ""}}{COM_R 52 0{TEXT 1 75 "We ne
ed to select the right-hand-side of this equation in order to plo
t it."}}{INP_R 53 0 "> "{TEXT 0 7 "rhs(\");"}}{OUT_R 54 0 53{DAG 
+5*Bj2x0003/3j2x0001j2x0002j2x0007p4j2x0019p4(3n3\`exp`,2+3n3\`t`
/3i2x0001j2x0020p5(3n3\`sin`,2+3*9p2p4p9p4pCp4p14p5/3p5p19p5e3j4x
002506265664i2x0013*5pFp5(3n3\`cos`p1Fp5e3p5p17}}{COM_R 55 0{TEXT
 1 0 ""}}{COM_R 56 0{TEXT 1 29 "Now we give the plot command."}}
{INP_R 57 0 "> "{TEXT 0 17 "plot(\",t=0..100);"}}{COM_R 58 0{TEXT
 1 0 ""}}{COM_R 59 0{TEXT 1 294 "As you can see, the oscillations
 of the pendulum gradually decrease in amplitude. This is because
 of the resisting force of the fluid, which is literally draining
 away the energy from the pendulum. Eventually, the oscillations 
will become so small that the pendulum will effectively be at res
t."}}{COM_R 60 0{TEXT 1 0 ""}}{COM_R 61 0{TEXT 1 91 "Now you try 
substituting a value of k into the equation, then solve it and pl
ot the result."}}{COM_R 62 0{TEXT 1 0 ""}}{INP_R 63 0 "> "{TEXT 0
 64 "pendulum := diff(theta(t),t,t) = -k*diff(theta(t),t) - theta
(t);"}}{OUT_R 64 0 63{DAG :3n5\`pendulum`=3(3n4\`diff`,3(3p7,3(3n
4\`theta`,2n3\`t`p13p13+5*5n3\`k`j2x0001pBp1Bi2x0001pEp1F}}{COM_R
 65 0{TEXT 1 0 ""}}{COM_R 66 0{TEXT 1 174 "Change 1/10 to a diffe
rent value in the command below. Try values such as 1/2, 1, 2, 3 
and 4. Do you notice anything different about the solution for th
e largest values of k?"}}{INP_R 67 0 "> "{TEXT 0 22 "subs(k=1/10,
pendulum);"}}{INP_R 68 0 "> "{TEXT 0 56 "soln := dsolve(\{\",thet
a(0)=phi,D(theta)(0)=0\},theta(t));"}}{INP_R 69 0 "> "{TEXT 0 19 
"subs(phi=0.1,soln);"}}{INP_R 70 0 "> "{TEXT 0 7 "rhs(\");"}}
{INP_R 71 0 "> "{TEXT 0 17 "plot(\",t=0..100);"}}}{END}
