{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "" "" "Courie
r" 4 1 192 "Courier" 10}{SCP_R 1 0 272{COM_R 2 0{TEXT 1 33 "Phase
 Equilibria in Ideal Systems"}}{COM_R 3 0{TEXT 1 0 ""}}{COM_R 4 0
{TEXT 1 11 "Ross Taylor"}}{COM_R 5 0{TEXT 1 85 "Department of Che
mical Engineering, Clarkson University, Potsdam, New York 13699-5
705"}}{COM_R 6 0{TEXT 1 0 ""}}{COM_R 7 0{TEXT 1 12 "Introduction"
}}{COM_R 8 0{TEXT 1 0 ""}}{COM_R 9 0{TEXT 1 209 "Vapor - liquid e
quilibrium data for two component or binary systems has been comp
iled by Gmehling and Onken (1977ff).  One of the data sets for be
nzene - toluene at a pressure of 101325 Pa is summarized below:"}
}{COM_R 10 0{TEXT 1 0 ""}}{INP_R 11 0 "> "{TEXT 0 68 "btdata:=arr
ay([[0,0,383.75],[0.1,0.2080,379.35],[0.2,0.3720,375.35],"}}
{INP_R 12 0 "> "{TEXT 0 84 "                        [0.3,0.5070,3
71.75],[0.4,0.6190,368.45],[0.5,0.7130,365.45],"}}{INP_R 13 0 "> 
"{TEXT 0 84 "                        [0.6,0.7910,362.55],[0.7,0.8
570,359.95],[0.8,0.9120,357.35],"}}{INP_R 14 0 "> "{TEXT 0 63 "  
                      [0.9,0.9590,355.35],[1.0,1.0,353.25]]):"}}
{INP_R 15 0 "> "{TEXT 0 15 "print (btdata);"}}{OUT_R 16 0 15{DAG 
(3n4\`MATRIX`,2[2,C[2,4j2x0000p9e3j3x00038375i2x0002[2,4e3j2x0001
i2x0001e3j2x2080i2x0004e3j3x00037935p10[2,4e3j2x0002p17e3j2x3720p
1Ce3j3x00037535p10[2,4e3j2x0003p17e3j2x5070p1Ce3j3x00037175p10[2,
4e3j2x0004p17e3j2x6190p1Ce3j3x00036845p10[2,4e3j2x0005p17e3j2x713
0p1Ce3j3x00036545p10[2,4e3j2x0006p17e3j2x7910p1Ce3j3x00036255p10[
2,4e3j2x0007p17e3j2x8570p1Ce3j3x00035995p10[2,4e3j2x0008p17e3j2x9
120p1Ce3j3x00035735p10[2,4e3j2x0009p17e3j2x9590p1Ce3j3x00035535p1
0[2,4e3j2x0010p17p9De3j3x00035325p10}}{COM_R 17 0{TEXT 1 356 "whe
re column 1 of the above matrix is the mole fraction of benzene i
n the liquid, column 2 is the (measured) mole fraction of benzene
 in the vapor that is in equilibrium with the liquid and column 3
 is the measured temperature in kelvin.  Note that the mole fract
ion of benzene in the vapor is always higher than the mole fracti
on of benzene in the liquid."}}{COM_R 18 0{TEXT 1 0 ""}}{COM_R 19
 0{TEXT 1 303 "The prediction of equilibrium between two phases i
s an important application of thermodynamics.  This article shows
 how Maple can be used to perform some simple phase equilibrium c
alculations. In addition, we demonstrate how Maple can be used to
 create phase diagrams and interpret the data given above."}}
{COM_R 20 0{TEXT 1 0 ""}}{COM_R 21 0{TEXT 1 22 "Theoretical Backg
round"}}{COM_R 22 0{TEXT 1 0 ""}}{COM_R 23 0{TEXT 1 136 "The mole
 fractions of the i-th component in two different phases in equil
ibrium with each other are related by the following expression:"}
}{COM_R 24 0{TEXT 1 0 ""}}{INP_R 25 0 "> "{TEXT 0 31 "EQM[i]:=y[i
]=K[i]*x[i]: EQM[i];"}}{OUT_R 26 0 25{DAG =3b3n3\`y`,2n3\`i`*5b3n
3\`K`p4j2x0001b3n3\`x`p4pC}}{COM_R 27 0{TEXT 1 315 "where the K[i
] are the K-values or equilibrium ratios.  They are also referred
 to sometimes as K-constants although they are probably the least
 constant property in all of  science and engineering. In fact, K
-values are, in general, complicated functions of temperature, pr
essure and the composition of both phases."}}{COM_R 28 0{TEXT 1 0
 ""}}{COM_R 29 0{TEXT 1 313 "It is beyond the scope of this docum
ent to discuss in detail the wide variety of models used by therm
odynamicists for calculating K-values.  We shall reserve such a d
iscussion for a later article.  We shall use some specific models
 for the K-values later when the time comes to carry out some act
ual calculations."}}{COM_R 30 0{TEXT 1 0 ""}}{COM_R 31 0{TEXT 1 
80 "In view of the way they are defined, the mole fractions of bo
th phases sum to 1."}}{COM_R 32 0{TEXT 1 0 ""}}{INP_R 33 0 "> "
{TEXT 0 63 "Sumx:=sum(x[i],i=1..c)=1:  Sumy:=sum(y[i],i=1..c)=1: 
Sumx,Sumy;"}}{OUT_R 34 0 33{DAG ,3=3(3n3\`sum`,3b3n3\`x`,2n3\`i`=
3pA~3j2x0001n3\`c`pF=3(3p3,3b3n3\`y`p9pCpF}}{COM_R 35 0{TEXT 1 51
 "where c is the number of components in the mixture."}}{COM_R 36
 0{TEXT 1 0 ""}}{COM_R 37 0{TEXT 1 51 "There are 2c+2 variables i
n this set of equations: "}}{COM_R 38 0{TEXT 1 34 "   c mole frac
tions in the x-phase"}}{COM_R 39 0{TEXT 1 34 "   c mole fractions
 in the y-phase"}}{COM_R 40 0{TEXT 1 25 "   The system temperatur
e"}}{COM_R 41 0{TEXT 1 22 "   The system pressure"}}{COM_R 42 0
{TEXT 1 0 ""}}{COM_R 43 0{TEXT 1 38 "There are only c+2 equations
, however:"}}{COM_R 44 0{TEXT 1 26 "   c equilibrium equations"}}
{COM_R 45 0{TEXT 1 38 "   2 mole fraction summation equations"}}
{COM_R 46 0{TEXT 1 0 ""}}{COM_R 47 0{TEXT 1 135 "The number of va
riables that must be specified before we can carry out any calcul
ations is the difference between these two numbers, c."}}{COM_R 
48 0{TEXT 1 0 ""}}{COM_R 49 0{TEXT 1 155 "Simple phase equilibriu
m calculations are based on finding the roots of an objective fun
ction derived by subtracting the mole fraction summation equation
s."}}{COM_R 50 0{TEXT 1 0 ""}}{INP_R 51 0 "> "{TEXT 0 20 "Eqn:=Su
my-Sumx: Eqn;"}}{OUT_R 52 0 51{DAG =3+5(3n3\`sum`,3b3n3\`y`,2n3\`
i`=3pA~3j2x0001n3\`c`pF(3p3,3b3n3\`x`p9pCi2x0001j2x0000}}{COM_R 
53 0{TEXT 1 87 "In what follows we will assume that the x-phase i
s a liquid and the y-phase is a vapor."}}{COM_R 54 0{TEXT 1 0 ""}
}{COM_R 55 0{TEXT 1 25 "Bubble Point Calculations"}}{COM_R 56 0
{TEXT 1 0 ""}}{COM_R 57 0{TEXT 1 627 "The bubble point temperatur
e is the temperature at which the first bubble of vapor forms in 
a liquid as it is heated.  To determine the bubble point of a liq
uid mixture we specify c-1 mole fractions of the x-phase and the 
pressure (or temperature).  The mole fraction of  component numbe
r c may be calculated from the summation equation for the x-phase
.  The remaining equations may then be solved for the mole fracti
ons of the y-phase and for the system temperature (or pressure). 
 We eliminate the vapor phase mole fractions from the objective f
unction above, noting that the mole fractions of the x-phase sum 
to 1, to obtain"}}{INP_R 58 0 "> "{TEXT 0 38 "BPeqn:=subs(\{EQM[i
],Sumx\},Eqn): BPeqn;"}}{OUT_R 59 0 58{DAG =3+5(3n3\`sum`,3*5b3n3
\`K`,2n3\`i`j2x0001b3n3\`x`pApD=3pB~3pDn3\`c`pDi2x0001pDj2x0000}}
{COM_R 60 0{TEXT 1 61 "We will now make a function of this expres
sion for later use."}}{COM_R 61 0{TEXT 1 0 ""}}{INP_R 62 0 "> "
{TEXT 0 28 "fBP := proc(K,x,components) "}}{INP_R 63 0 "> "{TEXT 
0 8 "local i;"}}{INP_R 64 0 "> "{TEXT 0 29 "if type(components,`.
.`) then"}}{INP_R 65 0 "> "{TEXT 0 33 "  sum(K[i]*x[i],i=componen
ts) -1;"}}{INP_R 66 0 "> "{TEXT 0 4 "else"}}{INP_R 67 0 "> "{TEXT
 0 51 "  convert([seq(K[i]*x[i],i=components)],`+`)-1; fi;"}}
{INP_R 68 0 "> "{TEXT 0 4 "end:"}}{OUT_R 69 0 68{TEXT 2 1 "\012"}
}{COM_R 70 0{TEXT 1 0 ""}}{COM_R 71 0{TEXT 1 43 "Example 1 - Bubb
le Point of an Ideal System"}}{COM_R 72 0{TEXT 1 0 ""}}{COM_R 73 
0{TEXT 1 263 "Estimate the bubble point of a mixture containing 2
0 mole percent benzene and 80 mole percent toluene.  Assume that 
the benzene - toluene system may be considered to behave as an id
eal system; one where the K-values are functions only of temperat
ure and pressure:"}}{COM_R 74 0{TEXT 1 0 ""}}{COM_R 75 0{TEXT 1 
153 "The K-values of benzene and toluene will be calculated using
 Raoult's law with the vapor pressures computed from the Antoine 
equation (Reid et al.,1987)."}}{COM_R 76 0{TEXT 1 0 ""}}{INP_R 77
 0 "> "{TEXT 0 49 "Antoine := (T, A, B, C) ->  exp(A - B / (T + C
));"}}{OUT_R 78 0 77{DAG :3n4\`Antoine`@7,5n3\`T`n3\`A`n3\`B`n3\`
C`,1,3n5\`operator`n4\`arrow`pE(3n3\`exp`,2+5a2x0002j2x0001*5a2x0
003p1F+5a2x0001p1Fa2x0004p1Fi2x0001p2CpE}}{COM_R 79 0{TEXT 1 97 "
The Antoine coefficients for benzene and toluene are (recalculate
d from Gmehling and Onken, 1977)"}}{INP_R 80 0 "> "{TEXT 0 72 "An
tA[benzene]:=21.06807; AntB[benzene]:=2948.78; AntC[benzene]:=-44
.563;"}}{OUT_R 81 0 80{DAG :3b3n4\`AntA`,2n4\`benzene`e3j3x021068
07i2x0005}}{OUT_R 82 0 80{DAG :3b3n4\`AntB`,2n4\`benzene`e3j3x002
94878i2x0002}}{OUT_R 83 0 80{DAG :3b3n4\`AntC`,2n4\`benzene`e3i3x
00044563i2x0003}}{INP_R 84 0 "> "{TEXT 0 72 "AntA[toluene]:=21.15
917; AntB[toluene]:=3242.38; AntC[toluene]:=-47.181;"}}{OUT_R 85 
0 84{DAG :3b3n4\`AntA`,2n4\`toluene`e3j3x02115917i2x0005}}{OUT_R 
86 0 84{DAG :3b3n4\`AntB`,2n4\`toluene`e3j3x00324238i2x0002}}
{OUT_R 87 0 84{DAG :3b3n4\`AntC`,2n4\`toluene`e3i3x00047181i2x000
3}}{COM_R 88 0{TEXT 1 74 "which give the vapor pressures in pasca
ls if the temperature is in kelvin."}}{COM_R 89 0{TEXT 1 0 ""}}
{COM_R 90 0{TEXT 1 40 "The K-values may be expessed as follows:"}
}{INP_R 91 0 "> "{TEXT 0 29 "component:=[benzene,toluene]:"}}
{OUT_R 92 0 91{TEXT 2 1 "\012"}}{INP_R 93 0 "> "{TEXT 0 73 "for i
 in component do K[i] := Antoine(T,AntA[i],AntB[i],AntC[i]) / P: 
od;"}}{OUT_R 94 0 93{DAG :3b3n3\`K`,2n4\`benzene`*5(3n3\`exp`,2+5
e3j3x02106807i2x0005j2x0001*3+5n3\`T`p14e3i3x00044563i2x0003p14i2
x0001e3i3x00294878i2x0002p14n3\`P`p22}}{OUT_R 95 0 93{DAG :3b3n3\
`K`,2n4\`toluene`*5(3n3\`exp`,2+5e3j3x02115917i2x0005j2x0001*3+5n
3\`T`p14e3i3x00047181i2x0003p14i2x0001e3i3x00324238i2x0002p14n3\`
P`p22}}{COM_R 96 0{TEXT 1 70 "We make functions of these expressi
ons for help in later calculations."}}{INP_R 97 0 "> "{TEXT 0 55 
"for i in component do Kvalue[i]:=unapply(K[i],T,P); od:"}}{OUT_R
 98 0 97{TEXT 2 1 "\012"}}{COM_R 99 0{TEXT 1 118 "We continue by 
making a function from the bubble-point equation, incorporating t
he above expressions for the K-values:"}}{INP_R 100 0 "> "{TEXT 0
 47 "x:='x': BP2:=unapply(fBP(K,x,component),T,P,x);"}}{OUT_R 101
 0 100{DAG :3n3\`BP2`@7,4n3\`T`n3\`P`n3\`x`,1,3n5\`operator`n4\`a
rrow`pB+7*7(3n3\`exp`,2+5e3j3x02106807i2x0005j2x0001*3+5a2x0001p2
2e3i3x00044563i2x0003p22i2x0001e3i3x00294878i2x0002p22a2x0002p30b
3a2x0003,2n4\`benzene`p22p22*7(3p18,2+5e3j3x02115917p20p22*3+5p26
p22e3i3x00047181p2Dp22p30e3i3x00324238p36p22p39p30b3p3D,2n4\`tolu
ene`p22p22p30p22pB}}{COM_R 102 0{TEXT 1 378 "where the arguments 
to the Maple function are temperature (in kelvin), pressure (in p
ascals), and the mole fractions of both components.  Note that we
 have retained the dependance on the mole fractions and pressure 
as well as temperature so that we can use the same function to fi
nd the bubble point temperature under other conditions.  We will 
need to this in the next example."}}{COM_R 103 0{TEXT 1 0 ""}}
{COM_R 104 0{TEXT 1 155 "Maple's fsolve command is unable to find
 a zero to this function unless we tell it roughly where to look.
  To help us locate the zero we plot the function "}}{COM_R 105 0
{TEXT 1 0 ""}}{INP_R 106 0 "> "{TEXT 0 58 "x[component[1]]:=0.2: 
x[component[2]]:=1-x[component[1]]: "}}{INP_R 107 0 "> "{TEXT 0 
33 "plot(BP2(T,101325,x),T=300..400);"}}{COM_R 108 0{TEXT 1 0 ""}
}{COM_R 109 0{TEXT 1 167 "from which we see that there is a zero 
somewhere between 370 and 400 K.  Now we can invoke the fsolve co
mmand and specify the range in which we know a solution exists."}
}{OUT_R 110 0 107{TEXT 2 1 "\012"}}{INP_R 111 0 "> "{TEXT 0 55 "T
BP:=fsolve(BP2(T,101325,x),T,350..400): T[bubble]=TBP;"}}{OUT_R 
112 0 111{DAG =3b3n3\`T`,2n4\`bubble`e3j4x003753696892i2x0007}}
{COM_R 113 0{TEXT 1 0 ""}}{COM_R 114 0{TEXT 1 269 "Thus, the esti
mated bubble point of this mixture is 375.37 K.  This result comp
ares quite favorably with the measured value of 375.35 K reported
 in the table.  The mole fractions of benzene and toluene in the 
vapor in equilibrium with the liquid at this temperature are"}}
{COM_R 115 0{TEXT 1 0 ""}}{INP_R 116 0 "> "{TEXT 0 66 "y:='y': fo
r i in component do y[i]=Kvalue[i](TBP,101325)*x[i]; od;"}}{OUT_R
 117 0 116{DAG =3b3n3\`y`,2n4\`benzene`e3j4x003747998330i2x0010}}
{OUT_R 118 0 116{DAG =3b3n3\`y`,2n4\`toluene`e3j4x006252001673i2x
0010}}{COM_R 119 0{TEXT 1 95 "The experimental value for the mole
 fraction of benzene from the table of data above is 0.3720."}}
{COM_R 120 0{TEXT 1 0 ""}}{COM_R 121 0{TEXT 1 155 "Exercise: Comp
ute the bubble point temperature and vapor phase mole fractions f
or some of the other data points from the table of data in the in
troduction."}}{COM_R 122 0{TEXT 1 0 ""}}{COM_R 123 0{TEXT 1 22 "D
ew Point Calculations"}}{COM_R 124 0{TEXT 1 0 ""}}{COM_R 125 0
{TEXT 1 252 "The dew point of a vapor mixture is the point at whi
ch the first drop of liquid forms as it is cooled. The calculatio
n of the dew point requires the specification of  the mole fracti
ons of the vapor (y) phase and the system pressure (or temperatur
e).  "}}{COM_R 126 0{TEXT 1 0 ""}}{INP_R 127 0 "> "{TEXT 0 63 "i:
='i': DPeqn:=subs(\{x[i]=solve(EQM[i],x[i]),Sumy\},Eqn): DPeqn;"}
}{OUT_R 128 0 127{DAG =3+5j2x0001p2(3n3\`sum`,3*5b3n3\`y`,2n3\`i`
p2b3n3\`K`pDi2x0001=3pE~3p2n3\`c`p15j2x0000}}{COM_R 129 0{TEXT 1 
0 ""}}{COM_R 130 0{TEXT 1 62 "We will now make a procedure of thi
s expression for later use."}}{INP_R 131 0 "> "{TEXT 0 28 "fDP :=
 proc(K,y,components) "}}{INP_R 132 0 "> "{TEXT 0 8 "local i;"}}
{INP_R 133 0 "> "{TEXT 0 29 "if type(components,`..`) then"}}
{INP_R 134 0 "> "{TEXT 0 33 "  1- sum(y[i]/K[i],i=components);"}}
{INP_R 135 0 "> "{TEXT 0 4 "else"}}{INP_R 136 0 "> "{TEXT 0 51 " 
 1-convert([seq(y[i]/K[i],i=components)],`+`); fi;"}}{INP_R 137 0
 "> "{TEXT 0 4 "end:"}}{OUT_R 138 0 137{TEXT 2 1 "\012"}}{OUT_R 
139 0 0{TEXT 2 1 "\012"}}{COM_R 140 0{TEXT 1 64 "Example 2 - Dew 
Point Temperature of a Benzene - Toluene Mixture"}}{COM_R 141 0
{TEXT 1 0 ""}}{COM_R 142 0{TEXT 1 138 "Estimate the dew point tem
perature of a mixture of benzene (61.9 mole percent) and toluene 
(38.1 mole percent) at a pressure of 101325 Pa."}}{COM_R 143 0
{TEXT 1 0 ""}}{COM_R 144 0{TEXT 1 112 "We first make a function o
f the dew point equation using the Raoult's law K-values we used 
in the prior example."}}{COM_R 145 0{TEXT 1 0 ""}}{INP_R 146 0 ">
 "{TEXT 0 39 "DP2:=unapply(fDP(K,y,component),T,P,y);"}}{OUT_R 
147 0 146{DAG :3n3\`DP2`@7,4n3\`T`n3\`P`n3\`y`,1,3n5\`operator`n4
\`arrow`pB+7j2x0001p16*7b3a2x0003,2n4\`benzene`p16(3n3\`exp`,2+5e
3j3x02106807i2x0005p16*3+5a2x0001p16e3i3x00044563i2x0003p16i2x000
1e3i3x00294878i2x0002p3Aa2x0002p16p3A*7b3p1B,2n4\`toluene`p16(3p2
3,2+5e3j3x02115917p2Bp16*3+5p30p16e3i3x00047181p37p16p3Ae3i3x0032
4238p40p3Ap43p16p3ApB}}{COM_R 148 0{TEXT 1 107 "As before, we plo
t this function over a range of temperatures to see approximately
 where the solution lies."}}{COM_R 149 0{TEXT 1 0 ""}}{INP_R 150 
0 "> "{TEXT 0 60 "y[component[1]]:=0.619: y[component[2]]:=1-y[co
mponent[1]]: "}}{INP_R 151 0 "> "{TEXT 0 33 "plot(DP2(T,101325,y)
,T=350..450);"}}{COM_R 152 0{TEXT 1 0 ""}}{COM_R 153 0{TEXT 1 100
 "Now we can ask Maple to compute a more precise numerical approx
imation to the dew point temperature."}}{OUT_R 154 0 151{TEXT 2 1
 "\012"}}{INP_R 155 0 "> "{TEXT 0 52 "TDP:=fsolve(DP2(T,101325,y)
,T,350..450): T[dew]=TDP;"}}{OUT_R 156 0 155{DAG =3b3n3\`T`,2n3\`
dew`e3j4x003685407080i2x0007}}{COM_R 157 0{TEXT 1 226 "The comput
ed estimate of 368.54 K compares well with the measured value of 
 368.45 K as reported in the table of data in the Introduction.  
The mole fractions in the liquid in equilibrium with the vapor at
 this temperature are"}}{INP_R 158 0 "> "{TEXT 0 66 "x:='x': for 
i in component do x[i]=y[i]/Kvalue[i](TDP,101325); od;"}}{OUT_R 
159 0 158{DAG =3b3n3\`x`,2n4\`benzene`e3j4x003985858047i2x0010}}
{OUT_R 160 0 158{DAG =3b3n3\`x`,2n4\`toluene`e3j4x006014141969i2x
0010}}{COM_R 161 0{TEXT 1 84 "The experimental value of the mole 
fraction of benzene from the table above is  0.4."}}{COM_R 162 0
{TEXT 1 0 ""}}{COM_R 163 0{TEXT 1 30 "Example 3 - Dew Point Press
ure"}}{COM_R 164 0{TEXT 1 0 ""}}{COM_R 165 0{TEXT 1 203 "The bubb
le and dew point equations can also be solved for pressure if the
 temperature is specified. In this example we determine the press
ure at which a mixture starts to condense at a fixed temperature.
"}}{COM_R 166 0{TEXT 1 0 ""}}{INP_R 167 0 "> "{TEXT 0 29 "y:='y':
 fDP(K,y,component)=0;"}}{OUT_R 168 0 167{DAG =3+7j2x0001p2*7b3n3
\`y`,2n4\`benzene`p2(3n3\`exp`,2+5e3j3x02106807i2x0005p2*3+5n3\`T
`p2e3i3x00044563i2x0003p2i2x0001e3i3x00294878i2x0002p26n3\`P`p2p2
6*7b3p7,2n4\`toluene`p2(3pF,2+5e3j3x02115917p17p2*3+5p1Cp2e3i3x00
047181p23p2p26e3i3x00324238p2Cp26p2Fp2p26j2x0000}}{COM_R 169 0
{TEXT 1 54 "This expression can be solved explicitly for pressure
 "}}{INP_R 170 0 "> "{TEXT 0 26 "Peqn:=P=solve(-\",P): Peqn;"}}
{OUT_R 171 0 170{DAG =3n3\`P`*3+5*5b3n3\`y`,2n4\`benzene`j2x0001(
3n3\`exp`,2+5e3j4x002106807000i2x0008pD*3+5n3\`T`pDe3i4x004456300
000p19pDi2x0001e3i4x002948780000i2x0006p28pD*5b3p7,2n4\`toluene`p
D(3p10,2+5e3j4x002115917000p19pD*3+5p1EpDe3i4x004718100000p19pDp2
8e3i4x003242380000p2Fp28pDp28}}{COM_R 172 0{TEXT 1 33 "We make a 
function of this result"}}{INP_R 173 0 "> "{TEXT 0 27 "fP:=unappl
y(rhs(Peqn),T,y):"}}{COM_R 174 0{TEXT 1 0 ""}}{OUT_R 175 0 173
{TEXT 2 1 "\012"}}{COM_R 176 0{TEXT 1 100 "and evaluate the funct
ion at a temperature of 375 K for an equimolar mixture of benzene
 and toluene."}}{OUT_R 177 0 0{TEXT 2 1 "\012"}}{INP_R 178 0 "> "
{TEXT 0 76 "y[component[1]]:=0.5: y[component[2]]:=1-y[component[
1]]:  P[dew]=fP(375,y);"}}{OUT_R 179 0 178{DAG =3b3n3\`P`,2n3\`de
w`e3j4x001105629261i2x0004}}{COM_R 180 0{TEXT 1 119 "Thus, an equ
imolar mixture of these two components at 375 K will start to con
dense when the pressure reaches 110563 Pa."}}{COM_R 181 0{TEXT 1 
0 ""}}{COM_R 182 0{TEXT 1 14 "Phase Diagrams"}}{COM_R 183 0{TEXT 
1 0 ""}}{COM_R 184 0{TEXT 1 196 "Phase diagrams are a useful meth
od of displaying vapor liquid equilibrium data graphically.  We s
hall compute the VLE curves for the benzene-toluene system that w
e have used in the above examples."}}{COM_R 185 0{TEXT 1 0 ""}}
{COM_R 186 0{TEXT 1 560 "Computing the vapor - liquid equilibrium
 curves involves carrying out a series of bubble point or dew poi
nt calculations for mole fractions of one component from 0 to 1 (
making sure that the mole fractions of both components sum to 1).
  We have chosen to use bubble-point calculations in the followin
g examples.  They are easier to perform than are dew point calcul
ations (although there is no essential difference in the degree o
f difficulty when Raoult's law is used to calculate the K-values)
.  These calculations are carried out in the following examples. 
"}}{COM_R 187 0{TEXT 1 0 ""}}{COM_R 188 0{TEXT 1 48 "Example 4 - 
Phase Diagrams for Benzene - Toluene"}}{COM_R 189 0{TEXT 1 0 ""}}
{COM_R 190 0{TEXT 1 333 "In the following sequence of Maple comma
nds we carry out a series of bubble point calculations covering t
he range of liquid mole fractions of benzene from 0 to 1.  The bu
bble point temperature is computed first and the vapor compositio
n follows from the equilibrium equation.  The results are stored 
in an array for later processing."}}{INP_R 191 0 "> "{TEXT 0 39 "
numpts:=31: pts:=array(1..numpts,1..3):"}}{OUT_R 192 0 191{TEXT 2
 1 "\012"}}{INP_R 193 0 "> "{TEXT 0 25 "for k from 1 to numpts do
"}}{INP_R 194 0 "> "{TEXT 0 81 "   x[component[1]]:= evalf((k-1)/
(numpts-1)): x[component[2]]:=1-x[component[1]]:"}}{INP_R 195 0 "
> "{TEXT 0 44 "   TBP:=fsolve(BP2(T,101325,x),T,300..410): "}}
{INP_R 196 0 "> "{TEXT 0 70 "   y[component[1]]:= Kvalue[componen
t[1]](TBP,101325)*x[component[1]]:"}}{INP_R 197 0 "> "{TEXT 0 75 
"   pts[k,1]:=x[component[1]]: pts[k,2]:=y[component[1]]: pts[k,3
]:=TBP: od:"}}{OUT_R 198 0 197{TEXT 2 1 "\012"}}{COM_R 199 0{TEXT
 1 271 "In order to display the measured and calculated equilibri
um data we have created the procedure Txyplot.  This procedure ma
kes use of  the function makepoints which takes as input an array
 (or matrix) and returns a set of points that can be displayed wi
th the plot comand."}}{INP_R 200 0 "> "{TEXT 0 36 "makepoints := 
proc(A,j1,j2,i1,nrows)"}}{INP_R 201 0 "> "{TEXT 0 0 ""}}{INP_R 
202 0 "> "{TEXT 0 59 "#  Procedure to make a list of points for p
lotting purposes"}}{INP_R 203 0 "> "{TEXT 0 36 "#  A       = matr
ix or array of data"}}{INP_R 204 0 "> "{TEXT 0 67 "#  j1, j2  = C
olumn indeces of 1st and 2nd columns extracted from A"}}{INP_R 
205 0 "> "{TEXT 0 59 "#            to make the x and y coordinate
s of the points."}}{INP_R 206 0 "> "{TEXT 0 65 "#            (opt
ional, but j1 must be specified if j2 is given)."}}{INP_R 207 0 "
> "{TEXT 0 64 "#  i1      = Index of first row of A for points ex
tracted from A"}}{INP_R 208 0 "> "{TEXT 0 58 "#            (optio
nal but j1 and j2 must be given first)."}}{INP_R 209 0 "> "{TEXT 
0 55 "#  nrows   = Number of rows of matrix A to be extracted"}}
{INP_R 210 0 "> "{TEXT 0 69 "#            (optional, and can only
 be given as the fifth argument)."}}{INP_R 211 0 "> "{TEXT 0 0 ""
}}{INP_R 212 0 "> "{TEXT 0 61 "   local col1, col2, row1, nrowsA,
 i, lastrow, lrow, Indices;"}}{INP_R 213 0 "> "{TEXT 0 64 "    co
l1 := 1; col2 := 2; row1 := 1; lastrow:=linalg[rowdim](A);"}}
{INP_R 214 0 "> "{TEXT 0 33 "    if nargs > 1 then col1 := j1;"}}
{INP_R 215 0 "> "{TEXT 0 35 "      if nargs > 2 then col2 := j2;"
}}{INP_R 216 0 "> "{TEXT 0 38 "         if nargs > 3 then row1 :=
 i1;"}}{INP_R 217 0 "> "{TEXT 0 55 "            if nargs > 4 then
 lrow := row1 + nrows - 1;"}}{INP_R 218 0 "> "{TEXT 0 77 "       
        if lrow > lastrow then lrow := lastrow; else lastrow := l
row; "}}{INP_R 219 0 "> "{TEXT 0 23 "    fi; fi; fi; fi; fi;"}}
{INP_R 220 0 "> "{TEXT 0 52 "    [seq([A[i,col1],A[i,col2]], i = 
row1..lastrow)];"}}{INP_R 221 0 "> "{TEXT 0 4 "end:"}}{OUT_R 222 
0 221{TEXT 2 1 "\012"}}{COM_R 223 0{TEXT 1 320 "The procedure Txy
plot is designed to take binary VLE data (both computed and exper
imental) that is stored in a Maple array (or matrix) with three c
olumns: liquid mole fraction of component 1, vapor mole fraction 
of component 1 and temperature. This procedure is easily modified
 for systems with more than two components."}}{INP_R 224 0 "> "
{TEXT 0 35 "Txyplot := proc (calcdata, expdata)"}}{INP_R 225 0 ">
 "{TEXT 0 61 "local bubline, dewline, bubdata, dewdata, Txyplot1,
 Txyplot2;"}}{INP_R 226 0 "> "{TEXT 0 79 "    bubline  := makepoi
nts(calcdata,1,3): dewline  := makepoints(calcdata,2,3):"}}{INP_R
 227 0 "> "{TEXT 0 76 "    Txyplot1 := plot(\{bubline,dewline\},0
..1,axes=boxed,labels=[`x, y`,`T`]):"}}{INP_R 228 0 "> "{TEXT 0 
21 "    if nargs > 1 then"}}{INP_R 229 0 "> "{TEXT 0 80 "       b
ubdata  := makepoints(expdata,1,3): dewdata  := makepoints(expdat
a,2,3):"}}{INP_R 230 0 "> "{TEXT 0 60 "       Txyplot2 := plot(\{
bubdata,dewdata\},0..1,style=point):"}}{INP_R 231 0 "> "{TEXT 0 7
 "    fi;"}}{INP_R 232 0 "> "{TEXT 0 77 "    if nargs = 1 then Tx
yplot1; else plots[display](\{Txyplot1,Txyplot2\}); fi;"}}{INP_R 
233 0 "> "{TEXT 0 4 "end;"}}{COM_R 234 0{TEXT 1 0 ""}}{INP_R 235 
0 "> "{TEXT 0 20 "Txyplot(pts,btdata);"}}{OUT_R 236 0 235{TEXT 2 
1 "\012"}}{COM_R 237 0{TEXT 1 0 ""}}{COM_R 238 0{TEXT 1 304 "This
 figure shows the calculated bubble-point line (the lower curve) 
and the calculated dew-point line (upper curve) as a function of 
the mole fraction of benzene (x-axis).  The experimental data are
 shown as isolated points.  You can see that the data are in good
 agreement with the calculated curves.  "}}{COM_R 239 0{TEXT 1 0 
""}}{COM_R 240 0{TEXT 1 166 "It is also useful to plot the vapor 
composition against the liquid composition on an x-y diagram.  Th
is is done with the procedure yxplot which is similar to Txyplot.
"}}{INP_R 241 0 "> "{TEXT 0 34 "yxplot := proc (calcdata, expdata
)"}}{INP_R 242 0 "> "{TEXT 0 49 "local yxline, diagline, yxdata, 
xyplot1, xyplot2;"}}{INP_R 243 0 "> "{TEXT 0 79 "   yxline   := m
akepoints(calcdata,1,2):  diagline := makepoints(calcdata,1,1):"}
}{INP_R 244 0 "> "{TEXT 0 77 "   xyplot1  := plot(\{yxline,diagli
ne\},0..1,0..1,labels=[`x`,`y`],axes=boxed):"}}{INP_R 245 0 "> "
{TEXT 0 21 "   if nargs > 1 then "}}{INP_R 246 0 "> "{TEXT 0 41 "
      yxdata   :=makepoints(expdata,1,2):"}}{INP_R 247 0 "> "
{TEXT 0 52 "      xyplot2  :=plot(yxdata,0..1,0..1,style=point):"
}}{INP_R 248 0 "> "{TEXT 0 6 "   fi;"}}{INP_R 249 0 "> "{TEXT 0 
73 "   if nargs = 1 then xyplot1; else plots[display](\{xyplot1,x
yplot2\}); fi;"}}{INP_R 250 0 "> "{TEXT 0 4 "end:"}}{OUT_R 251 0 
250{TEXT 2 1 "\012"}}{INP_R 252 0 "> "{TEXT 0 15 "yxplot(btdata);
"}}{OUT_R 253 0 252{TEXT 2 1 "\012"}}{COM_R 254 0{TEXT 1 0 ""}}
{COM_R 255 0{TEXT 1 327 "Note that the measured data points lie a
lmost exactly on top of the predicted equilibrium line.  The clos
e agreement between the measured data and the calculated curves i
s an indication that the benzene - toluene system is indeed nearl
y ideal and that Raoult's law may be used to estimate the equilib
rium ratios of this system."}}{COM_R 256 0{TEXT 1 0 ""}}{COM_R 
257 0{TEXT 1 226 "Raoult's law only works for a few simple system
s such as the benzene-toluene mixture used in the preceding examp
les.  For non-ideal systems the K-values depend on composition an
d we must use different methods to evaluate them."}}{COM_R 258 0
{TEXT 1 0 ""}}{COM_R 259 0{TEXT 1 9 "Exercises"}}{COM_R 260 0
{TEXT 1 0 ""}}{COM_R 261 0{TEXT 1 374 "A great many other exercis
es can be based on the material presented above.  There are sever
al other activity coefficient models that can be used as alternat
ives to the Van Laar model.  In addition, there are hundreds of o
ther binary mixtures for which data have been published. The data
 and the necessary model parameters have been collected by Gmehli
ng and Onken (1977ff). "}}{COM_R 262 0{TEXT 1 0 ""}}{COM_R 263 0
{TEXT 1 103 "For further reading (as well as a source of many oth
er problems) we recommend the book by Walas (1985)."}}{COM_R 264 
0{TEXT 1 0 ""}}{COM_R 265 0{TEXT 1 10 "References"}}{COM_R 266 0
{TEXT 1 0 ""}}{COM_R 267 0{TEXT 1 117 "Gmehling, J. and Onken, U.
 Vapor-Liquid Equilibrium Data Collection, DECHEMA Chemistry Data
 Series, DECHEMA (1977ff)."}}{COM_R 268 0{TEXT 1 0 ""}}{COM_R 269
 0{TEXT 1 115 "Reid, R.C., Prausnitz, J.M., and Poling, B. Proper
ties of Gases and Liquids, 4th Ed., McGraw-Hill, New York (1987).
"}}{COM_R 270 0{TEXT 1 0 ""}}{COM_R 271 0{TEXT 1 73 "Walas, S.M. 
Phase Equilibria in Chemical Engineering, Butterworth (1985)."}}
{COM_R 272 0{TEXT 1 0 ""}}{INP_R 273 0 "> "{TEXT 0 0 ""}}}{END}
