{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-*-Helvetica
-bold-r-normal--*-100-*-*-p-*-*-*" "Helvetica" "Times-Bold" 8 10 
64 "Helvetica-Bold" 10}{FONT 1 "-*-Times-medium-r-normal--*-120-*
-*-p-*-*-*" "Times" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 
2 "-*-Courier-medium-r-normal--*-100-*-*-m-*-*-*" "Courier" "Cour
ier" 4 10 192 "Courier" 10}{SCP_R 1 0 170{COM_R 2 0{TEXT 1 43 "Ph
ase Equilibria in Nonideal Binary Systems"}}{COM_R 3 0{TEXT 1 0 "
"}}{COM_R 4 0{TEXT 1 11 "Ross Taylor"}}{COM_R 5 0{TEXT 1 85 "Depa
rtment of Chemical Engineering, Clarkson University, Potsdam, New
 York 13699-5705"}}{COM_R 6 0{TEXT 1 0 ""}}{COM_R 7 0{TEXT 1 12 "
Introduction"}}{COM_R 8 0{TEXT 1 0 ""}}{COM_R 9 0{TEXT 1 110 "Exp
erimental data for a different system, 2-propanol-water, are give
n below (from Gmehling and Onken, 1977ff)."}}{INP_R 10 0 "> "
{TEXT 0 8 "restart;"}}{INP_R 11 0 "> "{TEXT 0 31 "unprotect(gamma
); # ignore this"}}{INP_R 12 0 "> "{TEXT 0 11 "TK:=273.15:"}}
{INP_R 13 0 "> "{TEXT 0 74 "prohdata:=array([[0,0,100+TK],[0.1,0.
4952,83.23+TK],[0.2,0.5247,82.14+TK],"}}{INP_R 14 0 "> "{TEXT 0 
83 "                 [0.3,0.5460,81.53+TK],[0.4,0.5705,81.02+TK],
[0.5,0.6000,80.62+TK],"}}{INP_R 15 0 "> "{TEXT 0 83 "            \+
     [0.6,0.6409,80.33+TK],[0.7,0.6989,80.25+TK],[0.8,0.7670,80.4
5+TK],"}}{INP_R 16 0 "> "{TEXT 0 60 "                 [0.9,0.8642
,81.07+TK],[1.0,1.0,82.24+TK]]):"}}{INP_R 17 0 "> "{TEXT 0 16 "pr
int(prohdata);"}}{OUT_R 18 0 17{DAG (3n4\`MATRIX`,2[2,C[2,4j2x000
0p9e3j3x00037315i2x0002[2,4e3j2x0001i2x0001e3j2x4952i2x0004e3j3x0
0035638p10[2,4e3j2x0002p17e3j2x5247p1Ce3j3x00035529p10[2,4e3j2x00
03p17e3j2x5460p1Ce3j3x00035468p10[2,4e3j2x0004p17e3j2x5705p1Ce3j3
x00035417p10[2,4e3j2x0005p17e3j2x6000p1Ce3j3x00035377p10[2,4e3j2x
0006p17e3j2x6409p1Ce3j3x00035348p10[2,4e3j2x0007p17e3j2x6989p1Ce3
j3x00035340p10[2,4e3j2x0008p17e3j2x7670p1Ce3j3x00035360p10[2,4e3j
2x0009p17e3j2x8642p1Ce3j3x00035422p10[2,4e3j2x0010p17p9De3j3x0003
5539p10}}{COM_R 19 0{TEXT 1 574 "Here we see that the mole fracti
on of 2-propanol in the vapor (column 2) is higher than the mole \+
fraction of 2-propanol in the liquid (column 1) up to a liquid ph
ase mole fraction of just under 0.7.  After this point the vapor \+
has a higher concentration of water than does the liquid.  The po
int where the composition of the liquid is the same as the compos
ition of the vapor is an azeotrope.  Azeotropes occur quite frequ
ently in nonideal binary mixtures.  This article shows how Maple \+
can be used to perform some simple phase equilibrium calculations
 for nonideal systems."}}{COM_R 20 0{TEXT 1 0 ""}}{COM_R 21 0
{TEXT 1 154 "The background to phase equilibrium calculations is \+
given in the worksheet phase.ms.  We recall some procedures devel
oped there for use in this worksheet."}}{COM_R 22 0{TEXT 1 0 ""}}
{COM_R 23 0{TEXT 1 69 "The function that can be used to compute t
he bubble point is given by"}}{INP_R 24 0 "> "{TEXT 0 28 "fBP := \+
proc(K,x,components) "}}{INP_R 25 0 "> "{TEXT 0 8 "local i;"}}
{INP_R 26 0 "> "{TEXT 0 29 "if type(components,`..`) then"}}
{INP_R 27 0 "> "{TEXT 0 33 "  sum(K[i]*x[i],i=components) -1;"}}
{INP_R 28 0 "> "{TEXT 0 4 "else"}}{INP_R 29 0 "> "{TEXT 0 51 "  c
onvert([seq(K[i]*x[i],i=components)],`+`)-1; fi;"}}{INP_R 30 0 ">
 "{TEXT 0 4 "end:"}}{COM_R 31 0{TEXT 1 0 ""}}{COM_R 32 0{TEXT 1 
47 "Bubble Point Calculations for Nonideal Mixtures"}}{COM_R 33 0
{TEXT 1 0 ""}}{COM_R 34 0{TEXT 1 203 "For non-ideal systems like \+
the 2-propanol -water system  the K-values depend on composition.
 The model used by Gmehling and Onken (1977ff) to fit the equilib
rium data compiled in the DECHEMA handbooks is"}}{COM_R 35 0{TEXT
 1 0 ""}}{INP_R 36 0 "> "{TEXT 0 28 "'K[i]=gamma[i]*P[sat][i]/P';
"}}{OUT_R 37 0 36{DAG =3b3n3\`K`,2n3\`i`*7b3n4\`gamma`p4j2x0001b3
b3n3\`P`,2n3\`sat`p4pDp11i2x0001}}{COM_R 38 0{TEXT 1 7 "where  "}
}{INP_R 39 0 "> "{TEXT 0 21 "'gamma[i],P[sat][i]';"}}{OUT_R 40 0 
39{DAG ,3b3n4\`gamma`,2n3\`i`b3b3n3\`P`,2n3\`sat`p5}}{COM_R 41 0
{TEXT 1 203 "are the activity coefficient and vapor pressure resp
ectively.  Models for calculating activity coefficients are the s
ubject of another worksheet and many books and papers (see, for e
xample, Walas, 1985)."}}{COM_R 42 0{TEXT 1 0 ""}}{COM_R 43 0{TEXT
 1 36 "Example 1 - VLE of a Nonideal System"}}{COM_R 44 0{TEXT 1 
0 ""}}{COM_R 45 0{TEXT 1 163 "Compute the bubble point of a mixtu
re containing 70 mole percent 2-propanol and 30 mole percent wate
r.  We shall use the following names to identify the components"}
}{INP_R 46 0 "> "{TEXT 0 23 "component:=[iPrOH,H2O];"}}{OUT_R 47 
0 46{DAG :3n5\`component`[2,3n4\`iPrOH`n3\`H2O`}}{COM_R 48 0{TEXT
 1 69 "iPrOH is short for iso-propanol which is another name for \+
2-propanol."}}{COM_R 49 0{TEXT 1 0 ""}}{COM_R 50 0{TEXT 1 172 "In
 this example we will use the Van Laar model to calculate the act
ivity coefficients for the liquid phase (see, for example, Gmehli
ng and Onken (1977ff) or Walas, 1985).  "}}{INP_R 51 0 "> "{TEXT 
0 201 "gamma[component[1]]:=exp((A[component[1],component[2]]*A[c
omponent[2],component[1]]^2*x[component[2]]^2)/(A[component[1],co
mponent[2]]*x[component[1]]+A[component[2],component[1]]*x[compon
ent[2]])^2); "}}{OUT_R 52 0 51{DAG :3b3n4\`gamma`,2n4\`iPrOH`(3n3
\`exp`,2*9b3n3\`A`,3p6n3\`H2O`j2x0001b3pF,3p13p6j2x0002b3n3\`x`,2
p13p1C+5*5pEp15b3p1Fp5p15p15*5p17p15p1Ep15p15i2x0002}}{INP_R 53 0
 "> "{TEXT 0 200 "gamma[component[2]]:=exp((A[component[2],compon
ent[1]]*A[component[1],component[2]]^2*x[component[1]]^2)/(A[comp
onent[2],component[1]]*x[component[2]]+A[component[1],component[2
]]*x[component[1]])^2);"}}{OUT_R 54 0 53{DAG :3b3n4\`gamma`,2n3\`
H2O`(3n3\`exp`,2*9b3n3\`A`,3p6n4\`iPrOH`j2x0001b3pE,3p12p6j2x0002
b3n3\`x`,2p12p1C+5*5p17p15p1Ep15p15*5pDp15b3p1Fp5p15p15i2x0002}}
{COM_R 55 0{TEXT 1 50 "The parameters for the 2-propanol-water sy
stem are"}}{INP_R 56 0 "> "{TEXT 0 43 "A[iPrOH,H2O]:=2.4807; A[H2
O,iPrOH]:=1.0937;"}}{OUT_R 57 0 56{DAG :3b3n3\`A`,3n4\`iPrOH`n3\`
H2O`e3j3x00024807i2x0004}}{OUT_R 58 0 56{DAG :3b3n3\`A`,3n3\`H2O`
n4\`iPrOH`e3j3x00010937i2x0004}}{COM_R 59 0{TEXT 1 82 "The Antoin
e equation with the following parameters is used for the vapor pr
essures"}}{INP_R 60 0 "> "{TEXT 0 49 "Antoine := (T, A, B, C) -> \+
 exp(A - B / (T + C));"}}{OUT_R 61 0 60{DAG :3n4\`Antoine`@8,5n3\
`T`n3\`A`n3\`B`n3\`C`,1,3n5\`operator`n4\`arrow`pE(3n3\`exp`,2+5a
2x0002j2x0001*5a2x0003p1F+5a2x0001p1Fa2x0004p1Fi2x0001p2CpEpE}}
{INP_R 62 0 "> "{TEXT 0 66 "AntA[iPrOH]:=22.55687; AntB[iPrOH]:=3
109.34; AntC[iPrOH]:=-73.546;"}}{OUT_R 63 0 62{DAG :3b3n4\`AntA`,
2n4\`iPrOH`e3j3x02255687i2x0005}}{OUT_R 64 0 62{DAG :3b3n4\`AntB`
,2n4\`iPrOH`e3j3x00310934i2x0002}}{OUT_R 65 0 62{DAG :3b3n4\`AntC
`,2n4\`iPrOH`e3i3x00073546i2x0003}}{INP_R 66 0 "> "{TEXT 0 59 "An
tA[H2O]:=23.19637; AntB[H2O]:=3816.44; AntC[H2O]:=-46.13;"}}
{OUT_R 67 0 66{DAG :3b3n4\`AntA`,2n3\`H2O`e3j3x02319637i2x0005}}
{OUT_R 68 0 66{DAG :3b3n4\`AntB`,2n3\`H2O`e3j3x00381644i2x0002}}
{OUT_R 69 0 66{DAG :3b3n4\`AntC`,2n3\`H2O`e3i2x4613i2x0002}}
{INP_R 70 0 "> "{TEXT 0 81 "for i in component do K[i] :=gamma[i]
*Antoine(T,AntA[i],AntB[i],AntC[i]) / P; od;"}}{OUT_R 71 0 70{DAG
 :3b3n3\`K`,2n4\`iPrOH`*7(3n3\`exp`,2+3*5b3n3\`x`,2n3\`H2O`j2x000
2+5b3p10p4e3j3x00024807i2x0004pFe3j3x00010937p1Fi2x0002e3j4x00296
7362957i2x0009j2x0001(3pA,2+5e3j3x02255687i2x0005p30*3+5n3\`T`p30
e3i3x00073546i2x0003p30i2x0001e3i3x00310934p27p30n3\`P`p49}}
{OUT_R 72 0 70{DAG :3b3n3\`K`,2n3\`H2O`*7(3n3\`exp`,2+3*5b3n3\`x`
,2n4\`iPrOH`j2x0002+5pEe3j3x00024807i2x0004b3pFp4e3j3x00010937p1D
i2x0002e3j4x006730490342i2x0009j2x0001(3p9,2+5e3j3x02319637i2x000
5p30*3+5n3\`T`p30e3i2x4613p27p30i2x0001e3i3x00381644p27p30n3\`P`p
47}}{COM_R 73 0{TEXT 1 91 "We now make functions of the K-values \+
and define the bubble-point function for this system."}}{INP_R 74
 0 "> "{TEXT 0 73 "x:='x': i:='i': for i in component do Kvalue[i
]:=unapply(K[i],T,P,x); od:"}}{INP_R 75 0 "> "{TEXT 0 47 "i:='i':
 BP2:=unapply(fBP(K,x,component),T,P,x);"}}{OUT_R 76 0 75{DAG :3n
3\`BP2`@8,4n3\`T`n3\`P`n3\`x`,1,3n5\`operator`n4\`arrow`pB+7*9(3n
3\`exp`,2+3*5b3a2x0003,2n3\`H2O`j2x0002+5b3p1E,2n4\`iPrOH`e3j3x00
024807i2x0004p1De3j3x00010937p30i2x0002e3j4x002967362957i2x0009j2
x0001(3p18,2+5e3j3x02255687i2x0005p41*3+5a2x0001p41e3i3x00073546i
2x0003p41i2x0001e3i3x00310934p38p41a2x0002p5Ap26p41p41*9(3p18,2+3
*5p26p23p25p38e3j4x006730490342p3Fp41(3p18,2+5e3j3x02319637p4Bp41
*3+5p50p41e3i2x4613p38p41p5Ae3i3x00381644p38p41p62p5Ap1Dp41p41p5A
p41pBpB}}{COM_R 77 0{TEXT 1 137 "We now compute the bubble point \+
temperature and composition of a mixture containing 70 mole perce
nt 2-propanol and 30 mole percent water."}}{INP_R 78 0 "> "{TEXT 
0 57 "x[component[1]]:=0.7: x[component[2]]:=1-x[component[1]]:"}
}{INP_R 79 0 "> "{TEXT 0 55 "TBP:=fsolve(BP2(T,101325,x),T,300..4
50): T[bubble]=TBP;"}}{OUT_R 80 0 79{DAG =3b3n3\`T`,2n4\`bubble`e
3j4x003535196873i2x0007}}{INP_R 81 0 "> "{TEXT 0 68 "y:='y': for \+
i in component do y[i]=Kvalue[i](TBP,101325,x)*x[i]; od;"}}{OUT_R
 82 0 81{DAG =3b3n3\`y`,2n4\`iPrOH`e3j4x006913771213i2x0010}}
{OUT_R 83 0 81{DAG =3b3n3\`y`,2n3\`H2O`e3j4x003086228805i2x0010}}
{COM_R 84 0{TEXT 1 141 "which are close to the experimentally det
ermined values of 353.4 and 0.6989 respectively (as shown in the \+
table of data in the introduction)."}}{COM_R 85 0{TEXT 1 0 ""}}
{COM_R 86 0{TEXT 1 14 "Phase Diagrams"}}{COM_R 87 0{TEXT 1 0 ""}}
{COM_R 88 0{TEXT 1 60 "Phase diagrams can be created with the fol
lowing procedures."}}{INP_R 89 0 "> "{TEXT 0 36 "makepoints := pr
oc(A,j1,j2,i1,nrows)"}}{INP_R 90 0 "> "{TEXT 0 0 ""}}{INP_R 91 0 
"> "{TEXT 0 59 "#  Procedure to make a list of points for plottin
g purposes"}}{INP_R 92 0 "> "{TEXT 0 36 "#  A       = matrix or a
rray of data"}}{INP_R 93 0 "> "{TEXT 0 67 "#  j1, j2  = Column in
deces of 1st and 2nd columns extracted from A"}}{INP_R 94 0 "> "
{TEXT 0 59 "#            to make the x and y coordinates of the p
oints."}}{INP_R 95 0 "> "{TEXT 0 65 "#            (optional, but \+
j1 must be specified if j2 is given)."}}{INP_R 96 0 "> "{TEXT 0 
64 "#  i1      = Index of first row of A for points extracted fro
m A"}}{INP_R 97 0 "> "{TEXT 0 58 "#            (optional but j1 a
nd j2 must be given first)."}}{INP_R 98 0 "> "{TEXT 0 55 "#  nrow
s   = Number of rows of matrix A to be extracted"}}{INP_R 99 0 ">
 "{TEXT 0 69 "#            (optional, and can only be given as th
e fifth argument)."}}{INP_R 100 0 "> "{TEXT 0 0 ""}}{INP_R 101 0 
"> "{TEXT 0 61 "   local col1, col2, row1, nrowsA, i, lastrow, lr
ow, Indices;"}}{INP_R 102 0 "> "{TEXT 0 64 "    col1 := 1; col2 :
= 2; row1 := 1; lastrow:=linalg[rowdim](A);"}}{INP_R 103 0 "> "
{TEXT 0 33 "    if nargs > 1 then col1 := j1;"}}{INP_R 104 0 "> "
{TEXT 0 35 "      if nargs > 2 then col2 := j2;"}}{INP_R 105 0 ">
 "{TEXT 0 38 "         if nargs > 3 then row1 := i1;"}}{INP_R 106
 0 "> "{TEXT 0 55 "            if nargs > 4 then lrow := row1 + n
rows - 1;"}}{INP_R 107 0 "> "{TEXT 0 77 "               if lrow >
 lastrow then lrow := lastrow; else lastrow := lrow; "}}{INP_R 
108 0 "> "{TEXT 0 23 "    fi; fi; fi; fi; fi;"}}{INP_R 109 0 "> "
{TEXT 0 52 "    [seq([A[i,col1],A[i,col2]], i = row1..lastrow)];"
}}{INP_R 110 0 "> "{TEXT 0 4 "end:"}}{INP_R 111 0 "> "{TEXT 0 35 
"Txyplot := proc (calcdata, expdata)"}}{INP_R 112 0 "> "{TEXT 0 
61 "local bubline, dewline, bubdata, dewdata, Txyplot1, Txyplot2;
"}}{INP_R 113 0 "> "{TEXT 0 79 "    bubline  := makepoints(calcda
ta,1,3): dewline  := makepoints(calcdata,2,3):"}}{INP_R 114 0 "> \+
"{TEXT 0 76 "    Txyplot1 := plot(\{bubline,dewline\},0..1,axes=b
oxed,labels=[`x, y`,`T`]):"}}{INP_R 115 0 "> "{TEXT 0 21 "    if \+
nargs > 1 then"}}{INP_R 116 0 "> "{TEXT 0 80 "       bubdata  := \+
makepoints(expdata,1,3): dewdata  := makepoints(expdata,2,3):"}}
{INP_R 117 0 "> "{TEXT 0 60 "       Txyplot2 := plot(\{bubdata,de
wdata\},0..1,style=point):"}}{INP_R 118 0 "> "{TEXT 0 7 "    fi;"
}}{INP_R 119 0 "> "{TEXT 0 77 "    if nargs = 1 then Txyplot1; el
se plots[display](\{Txyplot1,Txyplot2\}); fi;"}}{INP_R 120 0 "> "
{TEXT 0 4 "end;"}}{OUT_R 121 0 120{DAG :3n4\`Txyplot`@8,3n5\`calc
data`n4\`expdata`,7n4\`bubline`n4\`dewline`n4\`bubdata`n4\`dewdat
a`n5\`Txyplot1`n5\`Txyplot2`,1p22;6:3l2x0001(3n5\`makepoints`,4a2
x0001j2x0001j2x0003:3l2x0002(3p29,4p2Ej2x0002p32:3l2x0005(3n4\`pl
ot`,5%2,3p26p35~3j2x0000p30=3n4\`axes`n4\`boxed`=3n4\`labels`[2,3
n4\`x,~`y`n3\`T`?3<3p30a2x0000;4:3l2x0003(3p29,4a2x0002p30p32:3l2
x0004(3p29,4p6Cp3Bp32:3l2x0006(3p42,4%2,3p67p71p4A=3n4\`style`n4\
`point`?4=3p63p30p3F(3b3n4\`plots`,2n4\`display`,2%2,3p7Ap3Fp22p2
2}{TEXT 2 527 "\012Txyplot :=\012\012proc(calcdata,expdata)\012lo
cal bubline,dewline,bubdata,dewdata,Txyplot1,Txyplot2;\012    bub
line := makepoints(calcdata,1,3);\012    dewline := makepoints(ca
lcdata,2,3);\012    Txyplot1 := plot(\{bubline,dewline\},0 .. 1,a
xes = boxed,labels = [`x, y`,T])\012        ;\012    if 1 < nargs
 then\012        bubdata := makepoints(expdata,1,3);\012        d
ewdata := makepoints(expdata,2,3);\012        Txyplot2 := plot(\{
bubdata,dewdata\},0 .. 1,style = point)\012    fi;\012    if narg
s = 1 then Txyplot1 else plots[display](\{Txyplot2,Txyplot1\}) fi
\012end\012"}}{INP_R 122 0 "> "{TEXT 0 34 "yxplot := proc (calcda
ta, expdata)"}}{INP_R 123 0 "> "{TEXT 0 49 "local yxline, diaglin
e, yxdata, xyplot1, xyplot2;"}}{INP_R 124 0 "> "{TEXT 0 79 "   yx
line   := makepoints(calcdata,1,2):  diagline := makepoints(calcd
ata,1,1):"}}{INP_R 125 0 "> "{TEXT 0 77 "   xyplot1  := plot(\{yx
line,diagline\},0..1,0..1,labels=[`x`,`y`],axes=boxed):"}}{INP_R 
126 0 "> "{TEXT 0 21 "   if nargs > 1 then "}}{INP_R 127 0 "> "
{TEXT 0 41 "      yxdata   :=makepoints(expdata,1,2):"}}{INP_R 
128 0 "> "{TEXT 0 52 "      xyplot2  :=plot(yxdata,0..1,0..1,styl
e=point):"}}{INP_R 129 0 "> "{TEXT 0 6 "   fi;"}}{INP_R 130 0 "> \+
"{TEXT 0 73 "   if nargs = 1 then xyplot1; else plots[display](\{
xyplot1,xyplot2\}); fi;"}}{INP_R 131 0 "> "{TEXT 0 4 "end:"}}
{COM_R 132 0{TEXT 1 49 "Example 6 - Phase Diagrams for a  Nonidea
l System"}}{COM_R 133 0{TEXT 1 0 ""}}{COM_R 134 0{TEXT 1 348 "To \+
compute the vapor-liquid equilibrium curves for the 2-propanol-wa
ter system we follow a series of commands similar to those used i
n phase.ms when we computed the VLE data for the benzene-toluene \+
system; the differences are that we use a greater number of point
s here and use the new K-value functions in the calculation of th
e vapor composition."}}{COM_R 135 0{TEXT 1 0 ""}}{INP_R 136 0 "> \+
"{TEXT 0 39 "numpts:=51: pts:=array(1..numpts,1..3):"}}{INP_R 137
 0 "> "{TEXT 0 25 "for k from 1 to numpts do"}}{INP_R 138 0 "> "
{TEXT 0 81 "   x[component[1]]:= evalf((k-1)/(numpts-1)): x[compo
nent[2]]:=1-x[component[1]]:"}}{INP_R 139 0 "> "{TEXT 0 44 "   TB
P:=fsolve(BP2(T,101325,x),T,300..410): "}}{INP_R 140 0 "> "{TEXT 
0 72 "   y[component[1]]:= Kvalue[component[1]](TBP,101325,x)*x[c
omponent[1]]:"}}{INP_R 141 0 "> "{TEXT 0 75 "   pts[k,1]:=x[compo
nent[1]]: pts[k,2]:=y[component[1]]: pts[k,3]:=TBP: od:"}}{COM_R 
142 0{TEXT 1 105 "The calculated VLE is compared to the experimen
tal data by displaying the phase diagrams for this system."}}
{COM_R 143 0{TEXT 1 0 ""}}{INP_R 144 0 "> "{TEXT 0 22 "Txyplot(pt
s,prohdata);"}}{COM_R 145 0{TEXT 1 0 ""}}{INP_R 146 0 "> "{TEXT 0
 21 "yxplot(pts,prohdata);"}}{COM_R 147 0{TEXT 1 0 ""}}{COM_R 148
 0{TEXT 1 386 "Note the minimum in the T-x-y diagram where the bu
bble and dew point curves come together.  On the y-x diagram the \+
same point is located where the equilibrium line crosses the diag
onal.  This is a minimum boiling azeotrope where the composition \+
of the vapor is the same as the composition of the liquid.  The K
-value of both components is precisely equal to 1 at the azeotrop
ic point.  "}}{COM_R 149 0{TEXT 1 0 ""}}{COM_R 150 0{TEXT 1 9 "Ex
ercises"}}{COM_R 151 0{TEXT 1 0 ""}}{COM_R 152 0{TEXT 1 221 "1. T
o show the importance of the activity coefficient is in the model
ing of the VLE of a nonideal system repeat the above calculations
 for the 2-propanol - water system with the activity coefficients
 set equal to unity.  "}}{COM_R 153 0{TEXT 1 0 ""}}{COM_R 154 0
{TEXT 1 98 "2. Determine the composition and temeperature of the \+
azeotrope in the 2-propanol - water system.  "}}{COM_R 155 0{TEXT
 1 0 ""}}{COM_R 156 0{TEXT 1 343 "3. Devise an algorithm for comp
uting dew points for nonideal systems such as 2-propanol - water.
  This is more difficult than the bubble point calculation becaus
e the K-values are functions of the liquid composition (but not o
f the vapor composition) and the liquid composition is not known \+
in advance when carrying out dew point calculations."}}{COM_R 157
 0{TEXT 1 0 ""}}{COM_R 158 0{TEXT 1 374 "A great many other exerc
ises can be based on the material presented above.  There are sev
eral other activity coefficient models that can be used as altern
atives to the Van Laar model.  In addition, there are hundreds of
 other binary mixtures for which data have been published. The da
ta and the necessary model parameters have been collected by Gmeh
ling and Onken (1977ff). "}}{COM_R 159 0{TEXT 1 0 ""}}{COM_R 160 
0{TEXT 1 103 "For further reading (as well as a source of many ot
her problems) we recommend the book by Walas (1985)."}}{COM_R 161
 0{TEXT 1 0 ""}}{COM_R 162 0{TEXT 1 0 ""}}{COM_R 163 0{TEXT 1 10 
"References"}}{COM_R 164 0{TEXT 1 0 ""}}{COM_R 165 0{TEXT 1 117 "
Gmehling, J. and Onken, U. Vapor-Liquid Equilibrium Data Collecti
on, DECHEMA Chemistry Data Series, DECHEMA (1977ff)."}}{COM_R 166
 0{TEXT 1 0 ""}}{COM_R 167 0{TEXT 1 115 "Reid, R.C., Prausnitz, J
.M., and Poling, B. Properties of Gases and Liquids, 4th Ed., McG
raw-Hill, New York (1987)."}}{COM_R 168 0{TEXT 1 0 ""}}{COM_R 169
 0{TEXT 1 73 "Walas, S.M. Phase Equilibria in Chemical Engineerin
g, Butterworth (1985)."}}{COM_R 170 0{TEXT 1 0 ""}}{INP_R 171 0 "
> "{TEXT 0 0 ""}}}{END}
