{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 17 64 "Times-Bold" 17}
{SCP_R 1 0 29{COM_R 2 0{TEXT 3 73 "The trajectory of a ball throw
n or bullet shot straight up into the air.\015"}}{COM_R 3 0{TEXT 
1 16 "Michael Monagan\015"}}{COM_R 4 0{TEXT 1 257 "This worksheet
 considers the problem of a ball or bullet thrown (shot) straight
 up into the air.  We describe the trajectory of the ball / bulle
t as an ODE, plot the motion of the ball / bullet and solve for w
hen the ball lands on the ground.  In the model\015"}}{COM_R 5 0
{TEXT 1 296 "m is the mass of the ball in kg.\015b is the air fri
ction constant 0.2 used here\015g is the gravitational constant 9
.8 meters per second\015y(t) is the height of the ball at time t.
\015\015The trajectory is governed by this 2nd order differential
 equation.  The main thing here is to model the air resistance.\0
15"}}{INP_R 6 0 "> "{TEXT 0 48 "ode := m*diff(y(t),t$2) + b*diff(
y(t),t) = -m*g;"}}{OUT_R 7 0 6{DAG :3n3\`ode`=3+5*5n3\`m`j2x0001(
3n4\`diff`,3(3pB,3(3n3\`y`,2n3\`t`p16p16p8p8*5n3\`b`p8pFp8p8+3*5p
6p8n3\`g`p8i2x0001}}{COM_R 8 0{TEXT 1 50 "\015We obtain a general
 symbolic solution of this ODE"}}{INP_R 9 0 "> "{TEXT 0 28 "gsol 
:= dsolve( ode, y(t) );"}}{OUT_R 10 0 9{DAG :3n4\`gsol`=3(3n3\`y`
,2n3\`t`*5+9*9n3\`m`j2x0001n3\`g`p10p9p10n3\`b`p10i2x0001*5pEj2x0
002p12p10p10*5n3\`_C1`p10p17p1Ep10*7n3\`_C2`p10(3n3\`exp`,2+3*7pE
p1Ap17p10p9p10p1Ap10p17p1Ep10p10p17i2x0002}}{COM_R 11 0{TEXT 1 
467 "The variables _C1 and _C2 are constants which are determined
 by appropriate initial conditions.  Here we assume that the init
ial height of the ball (bullet)  is 0, i.e. y(0) = 0, and the ini
tial velocity of the ball (bullet) is v0, i.e. y'(0)=0 which in M
aple is specified as D(y)(0)=v0.  This is the velocity of the bal
l after the ball leaves the persons hand (after the bullet leaves
 the barrel of the gun).  Solving the ODE with these intial condi
tions we obtain \015"}}{INP_R 12 0 "> "{TEXT 0 48 "psol := dsolve
( \{ode,y(0)=0,D(y)(0)=v0\}, y(t) );"}}{OUT_R 13 0 12{DAG :3n4\`p
sol`=3(3n3\`y`,2n3\`t`+9*9n3\`m`j2x0001n3\`b`i2x0001n3\`g`pFp9pFp
13*7pDj2x0002p11i2x0002p15pFpF*7p11p13pDpFn3\`v0`pFpF*9pDpF+5*5pD
pFp15pFpF*5p2ApFp11pFpFpFp11p20(3n3\`exp`,2+3*7pDp13p11pFp9pFp13p
Fp13}}{COM_R 14 0{TEXT 1 182 "\015Now consider two particular exa
mples.  A ball of mass 0.5kg with initial velocity v0 = 20  meter
s per second.  This is approximately the situation of a man throw
ing a cricket ball.\015"}}{INP_R 15 0 "> "{TEXT 0 41 "ball := [g 
= 9.8, b=0.2, m=0.5, v0=20.0]:"}}{INP_R 16 0 "> "{TEXT 0 31 "sol 
:= subs( ball, rhs(psol) );"}}{OUT_R 17 0 16{DAG :3n3\`sol`+7n3\`
t`e3i4x002450000000i2x0008e3j4x001112500000i2x0007j2x0001(3n3\`ex
p`,2+3p4e3i4x004000000000i2x0010e3i4x001112500000p12}}{INP_R 18 0
 "> "{TEXT 0 40 "plot( sol, t=0..10, labels=[t,height] );"}}
{COM_R 19 0{TEXT 1 101 "\015From the plot we see that the ball co
mes back to the ground in about 3.5 seconds, or more precisely\01
5"}}{INP_R 20 0 "> "{TEXT 0 24 "fsolve( sol, t, 1..10 );"}}{OUT_R
 21 0 20{DAG e3j4x003353474604i2x0009}}{COM_R 22 0{TEXT 1 127 "\0
15Consider the case of a gun.  The bullet has mass of approximate
ly 0.05 kg, and the initial velocity of 300 meters per second.\01
5"}}{INP_R 23 0 "> "{TEXT 0 49 "bullet := [g = 9.8, b = 0.2, m = 
0.05, v0 = 300]:"}}{INP_R 24 0 "> "{TEXT 0 33 "sol := subs( bulle
t, rhs(psol) );"}}{OUT_R 25 0 24{DAG :3n3\`sol`+7n3\`t`e3i4x00245
0000000i2x0009e3j4x007561250000i2x0008j2x0001(3n3\`exp`,2+3p4e3i4
x004000000000pBe3i4x007561250000p12}}{INP_R 26 0 "> "{TEXT 0 42 "
plot( sol, t=0..100, labels=[t, height] );"}}{COM_R 27 0{TEXT 1 
56 "The bullet returns to the ground after about 30 seconds\015"}
}{INP_R 28 0 "> "{TEXT 0 25 "fsolve( sol, t, 20..40 );"}}{OUT_R 
29 0 28{DAG e3j4x003086224490i2x0008}}{INP_R 30 0 "> "{TEXT 0 0 "
"}}}{END}
