{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-*-Courier-m
edium-r-normal--*-120-*-*-m-*-*-*" "Courier" "Courier" 4 12 192 "
Courier" 10}{FONT 3 "-adobe-courier-medium-r-normal--14-*" "couri
er" "Courier" 4 12 192 "Courier" 14}{FONT 4 "-adobe-new century s
choolbook-bold-i-normal--25-*" "new century schoolbook" "Times-Bo
ldItalic" 8 12 96 "Times-BoldItalic" 25}{FONT 5 "-adobe-times-med
ium-r-normal--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 
20}{SCP_R 1 0 115{COM_R 2 0{TEXT 1 62 "File : marks.ms, Author : \+
Jero\377me M. Lang, Date : 15 May 1993."}}{COM_R 3 0{TEXT 1 42 "C
opyright 1993 by Waterloo Maple Software."}}{INP_R 4 0 "> "{TEXT 
0 12 "with(stats);"}}{COM_R 5 0{TEXT 1 176 "The data is in a tabl
e with 16 columns, in the file `mark.dat` in the stats directory \+
in the share library.  Hopefully the following two commands will \+
find the `mark.dat` file."}}{INP_R 6 0 "> "{TEXT 0 12 "with(share
):"}}{INP_R 7 0 "> "{TEXT 0 52 "Data:=importdata(``.sharename.`/s
tats/mark.dat`,16);"}}{INP_R 8 0 "> "{TEXT 0 34 "# Data:=importda
ta(`mark.dat`,16):"}}{COM_R 9 0{TEXT 1 37 "Extract the appropriat
e data columns."}}{INP_R 10 0 "> "{TEXT 0 83 "assignments:=[Data[
3],Data[4],Data[6],Data[7],Data[9],Data[10],Data[12], Data[13]]:"
}}{INP_R 11 0 "> "{TEXT 0 28 "quizzes:=[Data[5],Data[11]]:"}}
{INP_R 12 0 "> "{TEXT 0 17 "midterm:=Data[8]:"}}{INP_R 13 0 "> "
{TEXT 0 21 "final_exam:=Data[14]:"}}{INP_R 14 0 "> "{TEXT 0 28 "a
ctual_term_marks:=Data[15]:"}}{INP_R 15 0 "> "{TEXT 0 20 "student
_id:=Data[1]:"}}{COM_R 16 0{TEXT 1 87 "Summarize the results of e
ach of the various evaluations. The required functions are in"}}
{COM_R 17 0{TEXT 1 81 "the `describe` subpackage. For convenience
, they are grouped together in the list"}}{COM_R 18 0{TEXT 1 13 "
`statistics`."}}{INP_R 19 0 "> "{TEXT 0 15 "with(describe);"}}
{INP_R 20 0 "> "{TEXT 0 56 "statistics:=[mean,count,countmissing,
standarddeviation]:"}}{COM_R 21 0{TEXT 1 64 "This functions gives
 a tidy display of various calculated marks."}}{INP_R 22 0 "> "
{TEXT 0 131 "show:=proc( t:list)  local t2;\012    if type(t, lis
tlist) then t2:=t else t2:=[t] fi;\012    convert( t2, matrix );\
012    evalf(\",3);\012end:"}}{COM_R 23 0{TEXT 1 90 "First, we lo
ok at how the assignments went. The first four assignments are ou
t of 10, the "}}{COM_R 24 0{TEXT 1 24 "next four are out of 20."}
}{INP_R 25 0 "> "{TEXT 0 58 "results_assignments:=map(statistics,
assignments): show(\");"}}{COM_R 26 0{TEXT 1 29 "Then, we look at
 the quizzes,"}}{INP_R 27 0 "> "{TEXT 0 49 "results_quizzes:=map(
statistics,quizzes):show(\");"}}{COM_R 28 0{TEXT 1 30 "followed b
y  the midterm mark "}}{INP_R 29 0 "> "{TEXT 0 45 "results_midter
m:=statistics(midterm):show(\");"}}{COM_R 30 0{TEXT 1 23 "and the
 final exam mark"}}{INP_R 31 0 "> "{TEXT 0 51 "results_final_exam
:=statistics(final_exam):show(\");"}}{COM_R 32 0{TEXT 1 154 "We n
ow compute the performance of each students. Missing assignments \+
are assigned a value of zero.The required functions are in the tr
ansform subpackage. "}}{INP_R 33 0 "> "{TEXT 0 16 "with(transform
);"}}{COM_R 34 0{TEXT 1 212 "The mark, at the mid term point, for
 each student is computed out of 35 by the following procedure.  \+
The midterm is worth 25 out of those 35 marks. The quizzes are wo
rth 4.\015The assignments are worth a total of 6."}}{INP_R 35 0 "
> "{TEXT 0 175 "compute_term_mark:=\012    proc(a1,a2,a3,a4,a5,a6
,a7,a8,q1,q2,mt)\012        ((a1+a2+a3+a4+a5+a6+a7+a8)/120)*6 + (
(q1+q2)/20)*4 + (mt/50)*25;\012        subs(missing = 0, \");\012
     end:"}}{COM_R 36 0{TEXT 1 117 "The procedure just defined co
mputes the marks for one students. Using it, the marks for all st
udents are computed by:"}}{INP_R 37 0 "> "{TEXT 0 113 "term_marks
:=multiapply[ compute_term_mark ](\012     [seq(assignments[i],i=
1..8), seq(quizzes[i],i=1..2) ,midterm]):"}}{COM_R 38 0{TEXT 1 42
 "Let us show the term mark for each student"}}{INP_R 39 0 "> "
{TEXT 0 79 "map(round, term_marks):\012zip((x,y)-> [x,y], student
_id,  \" ):\012convert(\",matrix);"}}{COM_R 40 0{TEXT 1 90 "Suppo
se that the formula for computing the marks was lost. Let us try \+
to find what it was:"}}{INP_R 41 0 "> "{TEXT 0 293 "regressed:=fi
t[\012  leastsquare[ [a1,a2,a3,a4,a5,a6,a7,a8,q1,q2,mt,term],\012
  term=b1*a1+b2*a2+b3*a3+b4*a4+b5*a5+b6*a6+b7*a7+b8*a8+b9*q1+b10*
q2+b11*mt]\012  ](   subs(missing=0, \012       [ seq(assignments
[i],i=1..8), seq(quizzes[i],i=1..2), midterm, actual_term_marks ]
\012    )            ):\012evalf(\",3);"}}{COM_R 42 0{TEXT 1 693 
"Since the midterm was marked out of 50, the mark needs to be div
ided by two to get the midterm \012contribution to the term mark.
 The quizzes were marked out of  10. The contribution is therefor
e\012one fifth of the sum of their marks, for a maximum of  4. Th
e term mark is out of 35, that leaves 6 marks\012for the assignme
nts. One possibility is to add the assignment marks together and \+
divide by 20. \012We can use the results above to infer  more pre
cise weights for the assignments.\012\012No on to the final mark.
 If the student did not write the final exam, a special mark of D
NW (did not write) is assigned. The final exam contributes 65% of
 the final mark, the other 35% is obtained via the term marks."}}
{INP_R 43 0 "> "{TEXT 0 196 "compute_final_mark:=proc(term_mark, \+
final_exam)  \012    if final_exam=missing then \012       DNW \0
12    else\012       term_mark + final_exam*65/100;\012       sub
s(missing=0,\");\012       round(\");\012    fi\012 end:"}}{COM_R
 44 0{TEXT 1 67 "This computes the marks for one student. Use thi
s for all students."}}{INP_R 45 0 "> "{TEXT 0 66 "marks:=multiapp
ly[compute_final_mark]( [term_marks, final_exam] ):"}}{INP_R 46 0
 "> "{TEXT 0 54 "convert(zip((x,y)-> [x,y], student_id, marks),ma
trix);"}}{COM_R 47 0{TEXT 1 177 "Compute the correlation between \+
the various types of evaluations and the final mark.\015First a p
rocedure that adds up its arguments, giving a value of zero to th
e keyword missing."}}{INP_R 48 0 "> "{TEXT 0 60 "Add:=proc()\012 \+
 convert([args],`+`);\012  subs(missing=0,\");\012end:"}}{COM_R 
49 0{TEXT 1 29 "Then compute partial results:"}}{INP_R 50 0 "> "
{TEXT 0 92 "sum_assignments:=multiapply[ Add ] (assignments):\012
sum_quizzes:=multiapply[ Add ] (quizzes ):"}}{COM_R 51 0{TEXT 1 
50 "Compute the correlation between two sets of marks."}}{INP_R 
52 0 "> "{TEXT 0 195 "one_correlation:=proc(x,y)\012   subs(missi
ng=0, DNW=0, [x,y]); # missing assignments and exams are worth ze
ro\012   op(\"); # get back the two lists\012   linearcorrelation
(\"); # do the computation  \012end:"}}{COM_R 53 0{TEXT 1 53 "Com
pute the actual correlations, and show the results"}}{INP_R 54 0 
"> "{TEXT 0 106 "map(one_correlation,\012    [sum_assignments, su
m_quizzes, midterm, term_marks, final_exam], marks):\012show(\");
"}}{COM_R 55 0{TEXT 1 111 "Try to predict final mark based on ass
ignments  giving  a Weight of 0 to students who did not write fin
al exam."}}{INP_R 56 0 "> "{TEXT 0 100 "  apply[proc(x) \012     \+
   if x=DNW  then Weight(0,0)\012        else x \012        fi\01
2     end] ( marks ): "}}{INP_R 57 0 "> "{TEXT 0 210 "fit[\012  l
eastsquare[ \012            [a1,a2,a3,a4,a5,a6,a7,a8, m],\012    \+
        m=b1*a1+b2*a2+b3*a3+b4*a4+b5*a5+b6*a6+b7*a7+b8*a8+c\012  \+
 ]                  ](  \012       [     op(subs(missing=0,assign
ments)),  \"    ] );"}}{COM_R 58 0{TEXT 1 47 "Display some plots \+
based on the preceding data."}}{INP_R 59 0 "> "{TEXT 0 16 "with(s
tatplots);"}}{COM_R 60 0{TEXT 1 60 "For convenience, a function i
s defined to change the colour."}}{INP_R 61 0 "> "{TEXT 0 73 "cha
ngecolour:=proc()\012    plots[display](args, colour=op(1,procnam
e))\012end:"}}{COM_R 62 0{TEXT 1 214 "Display a summary of assign
ments, quizzes, midterm final exam and final mark.Scale so that a
ll of them are from 0 to 10. Note that the first index to notched
box controls the horizontal position of each notched box."}}
{INP_R 63 0 "> "{TEXT 0 874 "P1:= map( k-> notchedbox[k, 0.4]( as
signments[k] ) , \{$1..4\} ):\012                 # first four as
signments (out of 10)\012P2:= map( k-> notchedbox[k, 0.4]( apply[
x->x/2](assignments[k]) ) , \{$5..8\}):\012                  # la
st four assignments (out of 20, so need to divide by 2)\012P3:= m
ap( k-> changecolour[green](  notchedbox[k+8, 0.4]( quizzes[k] ))
, \{$1..2\}):\012                 # quizzes\012P4:=changecolour[r
ed]( notchedbox[11,0.4]( apply[x->x/5](midterm) ) ): \012        \+
        # midterm (out of 50 so need to divide by 5)\012P5:=chang
ecolour[cyan]( notchedbox[12,0.4]( apply[x->x/10](final_exam))): \+
\012                # final exam (out of 100 so need to divide by
 10)\012P6:= changecolour[yellow]( notchedbox[13,0.4]( \012      \+
         apply[x->x/10](subs(DNW=missing,marks) )\012            \+
                                   )                             \+
    ): #  final mark (divide by 10)"}}{INP_R 64 0 "> "{TEXT 0 59 
"plots[display] ( P1 union P2 union P3 union \{P4, P5, P6\} );"}}
{COM_R 65 0{TEXT 1 48 "Show assignments and midterm versus final \+
exams."}}{INP_R 66 0 "> "{TEXT 0 38 "scatter2d(sum_assignments,fi
nal_exam);"}}{INP_R 67 0 "> "{TEXT 0 31 "scatter2d(midterm, final
_exam);"}}{COM_R 68 0{TEXT 1 320 "In the margins of the plot of t
he final mark versus the final exam, we put box plots indicating \+
the distribution of each of those sets of marks. As can be seen, \+
one of the low marks is an outlier for the final mark. Note that \+
the marks  of the students who did not write the final exam are o
mitted from the scatter plot."}}{INP_R 69 0 "> "{TEXT 0 275 "P1:=
plots[display](\{  \012    scatter2d(final_exam,subs(DNW=missing,
marks)),\012    changecolour[blue](boxplot[110,10](subs(DNW=missi
ng,marks))),\012    changecolour[blue](xyexchange(boxplot[110,10]
(final_exam)))\012                                 \},view=[0..12
0, 0..120], axes=box):\012\";"}}{COM_R 70 0{TEXT 1 314 "The linea
r correlation between the final exam and the final mark was fairl
y high. This makes sense since the final exam has high weight in \+
the calculation of the final mark. The previous plot is fairly li
near, so we compute the regression line.We give a weight of zero \+
to students who did not write the final exam."}}{INP_R 71 0 "> "
{TEXT 0 247 "Rline:=fit[ leastsquare[ [exam,final] ] ](\012      \+
            [ subs(missing=0,final_exam),\012                    \+
map(proc(x) \012                         if x=DNW  then Weight(0,
0)  else Weight(x,1) fi\012                         end,         \+
   marks)]);"}}{COM_R 72 0{TEXT 1 31 "Where are the bulk of the m
arks"}}{INP_R 73 0 "> "{TEXT 0 31 "range(subs(DNW=missing,marks))
;"}}{INP_R 74 0 "> "{TEXT 0 83 "quartiles:=[ describe[quartile[1]
], describe[quartile[2]],  describe[quartile[3]]]:"}}{INP_R 75 0 
"> "{TEXT 0 38 "Q:=quartiles(subs(DNW=missing,marks));"}}{COM_R 
76 0{TEXT 1 165 "We look at the regression line putting a higher \+
weight on the data between the first and third quartile. First a \+
procedure to give the appropriate weight to a datum."}}{INP_R 77 
0 "> "{TEXT 0 143 "give_weight:= proc(x,q1,q3) \012  if x=DNW or \+
x=missing then Weight(0,0)\012  elif x<q1 or x>q3 then Weight(x,0
.30) \012  else Weight(x,1)\012   fi\012  end: "}}{COM_R 78 0
{TEXT 1 13 "Fit the line."}}{INP_R 79 0 "> "{TEXT 0 196 "R2line:=
fit[\012                leastsquare[ [exam,final] ]\012          \+
        ] ( [subs(missing=0,final_exam),  \012                   \+
     map( give_weight ,  marks,Q[1],Q[3])\012                    \+
 ] );"}}{COM_R 80 0{TEXT 1 177 "We plot the final marks versus th
e final exams showing the two regression lines. The regression li
ne with the data in the interquartile range with a higher weight \+
is in magenta."}}{INP_R 81 0 "> "{TEXT 0 153 "plots[display](\{ \
012   P1,   \012   plot( rhs(Rline),exam=0..100,colour=red),\012 \+
  plot( rhs(R2line),exam=0..100,colour=magenta)\012              \+
             \}); "}}{COM_R 82 0{TEXT 1 228 "We now look more clo
sely at the marks of the final exam. The last range is enlarged a
 little bit since the upper bounds of each subrange is exclusive.
 Then we scale the weight so that the total weight of non missing
 mark is one."}}{INP_R 83 0 "> "{TEXT 0 190 "exam_distr:=tallyint
o(final_exam,\012                 [0..10,10..20,20..30,30..40,40.
.50,  50..60,60..70,70..80,80..90,90..100.001]):\012exam_distr_1:
=scaleweight[1/count(exam_distr)](exam_distr);"}}{COM_R 84 0{TEXT
 1 100 "Let us compute the mean and standard deviation of the fin
al exam based on the previous grouped data."}}{INP_R 85 0 "> "
{TEXT 0 32 "mean_exam_1:=mean(exam_distr_1);"}}{INP_R 86 0 "> "
{TEXT 0 53 "standarddeviation(exam_distr_1): sd_exam_1:=evalf(\")
;"}}{COM_R 87 0{TEXT 1 74 "These values are fairly close to the o
nes computed from the original data."}}{INP_R 88 0 "> "{TEXT 0 75
 "stat_exam:=[mean,standarddeviation,skewness,kurtosis](final_exa
m): show(\");"}}{COM_R 89 0{TEXT 1 177 "Then, we plot the histogr
am of the marks distribution together with a 1 dimensional scatte
r plot and a plot of the normal distribution with the same mean a
nd standard deviation."}}{INP_R 90 0 "> "{TEXT 0 470 "P1:= histog
ram(exam_distr_1): \012    # histogram of the data\012P2:= plot(s
tatevalf[pdf,normald[stat_exam[1],stat_exam[2]]],0..100): \012   \+
 # superimpose a normal distribution\012P3:= xyexchange(xshift[0.
04](xscale[0.0005](xyexchange(  \012                             \+
scatter1d[jittered](final_exam)\012                              \+
)                   )                        )                   \+
 ): \012    # and 1d scatter plot along the top\012plots[display]
(\{P1, P2, P3 \}, style=line);"}}{COM_R 91 0{TEXT 1 105 "Let us c
hange the classes slightly, and compute the mean and standard dev
iation based on the new classes."}}{INP_R 92 0 "> "{TEXT 0 192 "c
lasses:=[5..15,15..25,25..35,35..45,45..55,  55..65,65..75,75..85
,85..95,95..105]:\012exam_distr_2:=tallyinto(final_exam,classes):
\012exam_distr_3:=scaleweight[1/count(exam_distr_2)](exam_distr_2
);"}}{INP_R 93 0 "> "{TEXT 0 32 "mean_exam_2:=mean(exam_distr_2);
"}}{INP_R 94 0 "> "{TEXT 0 53 "standarddeviation(exam_distr_2): s
d_exam_2:=evalf(\");"}}{COM_R 95 0{TEXT 1 76 "And now display the
 new histogram with a slightly different 1d scatter plot."}}
{INP_R 96 0 "> "{TEXT 0 343 "P1:=histogram(exam_distr_3):\012P2:=
plot(statevalf[pdf,normald[stat_exam[1],stat_exam[2]]],0..100):\0
12P3:=xyexchange(xshift[0.035](xscale[0.0005](xyexchange(\012    \+
        scatter1d[stacked](final_exam)\012                       \+
      )                     )                        )           \+
          ):\012plots[display](\{ P1, P2, P3 \},    style=line);"
}}{COM_R 97 0{TEXT 1 208 "The last two plots show a limitation of
 histograms since the appearance varies quite dramatically depend
ing on the position of the classes. \012\012Let us find the expec
ted frequencies for the classes we just used."}}{INP_R 98 0 "> "
{TEXT 0 284 "expected:=map(proc(x, mu, sigma, N) \012       N*(\0
12               statevalf[ cdf, normald[mu,sigma] ](op(2,x) ) # \+
top of class\012             - statevalf[ cdf,normald[mu,sigma] ]
(op(1,x)) ) # bottom of class\012       end,               classe
s,   mean_exam_2, sd_exam_2,count(exam_distr_2));"}}{COM_R 99 0
{TEXT 1 84 "We must have the classes in the same order for the ob
served and missing frequencies."}}{INP_R 100 0 "> "{TEXT 0 49 "st
atvalue(statsort(deletemissing(exam_distr_2)));"}}{INP_R 101 0 ">
 "{TEXT 0 17 "evalb(\"=classes);"}}{COM_R 102 0{TEXT 1 254 "In or
der to evaluate whether the exam results do indeed follow the nor
mal distribution with the parameters we just determined, we need \+
to apply the chi-square test. (The last statement is just for dis
play purposes: we want a nice presentation for chi^2.)"}}{INP_R 
103 0 "> "{TEXT 0 38 "statsort(deletemissing(exam_distr_2));"}}
{INP_R 104 0 "> "{TEXT 0 24 "observed:= frequency(\");"}}{INP_R 
105 0 "> "{TEXT 0 56 "zip(proc(ob,ex) ob^2/ex     end,    observe
d, expected);"}}{INP_R 106 0 "> "{TEXT 0 58 "ch2:=convert(\",`+`)
 - convert( observed, `+` ): chi^2=ch2;"}}{COM_R 107 0{TEXT 1 136
 "The degree of freedom is the number of classes minus one minus \+
the number of parameters that were estimated using the sample sta
tistics."}}{INP_R 108 0 "> "{TEXT 0 22 "nu:=nops(classes)-1-2;"}}
{COM_R 109 0{TEXT 1 79 "The 95th percentile of the chi square dis
tribution with 7 degrees of freedom is"}}{INP_R 110 0 "> "{TEXT 0
 36 "statevalf[icdf,chisquare[nu]](0.95);"}}{INP_R 111 0 "> "
{TEXT 0 14 " evalb(ch2<\");"}}{COM_R 112 0{TEXT 1 219 "Since the \+
computed value of chi square is less than this last value, then w
e conclude that the exam results, at the 0.05 significance level,
 do indeed obey a normal distribution with mean and standard devi
ation equal to"}}{INP_R 113 0 "> "{TEXT 0 47 "mean=mean_exam_2; s
tandard_deviation=sd_exam_2;"}}{COM_R 114 0{TEXT 1 265 "In order \+
to check that the agreement is not suspiciously too good, the com
puted value for the chi square statistic must not be too close to
 zero. We therefore perform the following calculation in order to
 check that the fit is believable; we find that indeed it is."}}
{INP_R 115 0 "> "{TEXT 0 50 "statevalf[icdf,chisquare[nu]](0.05);
 evalb(ch2>\");"}}{INP_R 116 0 "> "{TEXT 0 0 ""}}}{END}
