#!/usr/bin/perl


##first pass of this for 6.4 will simply return the 
##string to put into the license file.  No checks will be 
##performed when $debug is set to 1.

my $debug=0;

if ($debug) {
  my @servers = @ARGV;
  my $serverString;
  my $server;
  my $numServers = scalar(@servers);
  
  if ($numServers != 1 and $numServers != 3 ) {
    print STDOUT "***ERROR: Exactly one or three servers is required." ;
    exit 1;
  }
  else {
    foreach $server ( @servers ) {
      #clean off any white space
      $server =~ s/\s//g;
      chomp $server;
      $server = '@'."$server" if ( $server !~ /@/ );
      $serverString = "$serverString" . "$server:" ; 
    }
    $serverString =~ s/:$//g;
    print STDOUT "$serverString";
    exit 0;
  }
}else {
  
  select STDERR; $| = 1;
  select STDOUT; $| = 1;

  my $serverString;
  my $backdoor = 'abaqusfea';
  my $academic = '';
  my $vendor_daemon = 'ABAQUSLM';
  my $nti = 0;
  my $exe = '';
  my $abaquslm_license_file = '';
  my $err_msg = '***ERROR: ';
  my @err_stat;
  #my @servers;
  #my $lmpath;
  #my $lmdiag;
  my @diagtest = ('standard','explicit');
  my $dirsep = '/';
  my $server_arg;
  my @server_arg_list;
  my @abaquslm;
  my @licensed_prods;
  my @licensed_for;
  my $failed = 0;
  #version 6.4
  my $thisver = "6.4";
  my $thisver_maj = "6";
  my $thisver_min = "4";

  # Error status variables
  my $down = 1;
  my $no_lic_current = 2;
  my $no_abaquslm = 3;
  my $no_licproducts = 4;
  my $flex_error = 5;
  my $error = 1;

  @products = ('standard',
               'foundation',
               'explicit',
               'aqua',
               'design', 
               'viewer', 
               'cae',
               'adams', 
               'cmold', 
               'cat', 
               'safe', 
               'moldflow'
              );
  
  &ParseCmdLine();
  
  # Check for lmstat and lmdiag executable 
  if ($^O  =~ m/MSWin32/) {
    $nti = 1;
    $exe = '.exe';
    $dirsep = '\\\\';
  }
  $lmstatExe = "lmstat" . "$exe";
#  $lmdiagExe = "lmdiag" . "$exe";
  if ($lmpath =~ /$lmstatExe^/) {
    $lmpath =~ s/$lmstatExe^//;
  } elsif ($lmpath ne '' && $lmpath !~ /$dirsep^/) {
    $lmpath .= $dirsep;
  } 
  $lmstatExe = $lmpath . $lmstatExe;
  if (! -e $lmstatExe ) {
    $err_msg .= "$lmpath$lmstatExe executable not found.\n";
    print STDOUT "$err_msg";
    exit 1;
  }
#  $lmdiagExe = $lmpath . $lmdiagExe;
#  if (! -e $lmdiagExe ) {
#    $err_msg .= "$lmpath$lmdiagExe executable not found.\n";
#    print STDOUT "$err_msg";
#    exit 1;
#  }
  
  # Test servers
  
  # Confirm all hostnames are valid
  $num_servers = scalar(@servers);
  
  # Check for valid response and valid hostname
  for ($x = 0 ; $x < $num_servers ; $x++ ) {
    my $server = $servers[$x];
    $err_stat[$x] = 0;
    $abaquslm[$x] = 0;
    # Exit if server name equals Back door name
    if ($server =~ /$backdoor/) {
      print STDOUT "\@$backdoor";
      exit 0;
    }
    if ( not $server ) {
      $err_msg .=  "You have entered an invalid hostname.\n" .
	"Hostnames cannot begin with a colon\n";
      print STDOUT $err_msg;
      exit 1;
    } else {
      $serv_chop = $server;
      $letter = chop($serv_chop);
      do {
	if ( $letter !~ /\w|\d|\.|\@|\-/ ) {
	  $failed = 1;
	  $err_msg .= "$server is an invalid hostname.\n";
	  print STDOUT "$err_msg";
	  exit 1;
	} else {
	  $letter = chop($serv_chop);         
	}
      }  while $letter and ! $failed ;	    
    }

    # Build argument list for the Flex utilities
    if ( $server =~ /\@/ ) {
      $lmstat_args = "-c "."$server -a -i "; 
    } else {
      $lmstat_args="-c @"."$server -a -i ";
    }

    
    # Get lmstat output
    $command = "$lmstatExe $lmstat_args";
    open(LMSTAT,"$command | " );
    @lmstatout = <LMSTAT> ;
    close(LMSTAT);

    
    foreach $line (@lmstatout) {
      $abaquslm[$x] = 1 if $line =~ /$vendor_daemon/ ; 
      if ($line =~ /$vendor_daemon/ && $line =~ /down/) {
	$err_stat[$x] = $down;
	$err_msg .= "The ABAQUSLM vendor daemon on $server is down\n";
      }
      $academic = "TEACHING" if $line =~ /_teaching/ ;
      if ($line =~ /Error/) {
        #weed out the non-abaqus errors
        next if ($line =~ /Users/ && $line !~ /abaqus/ );
	$err_stat[$x] = $flex_error;
        $err_msg .= "The following error was encountered connecting to $server:\n";
        $err_msg .= "           $line\n";

	if ( $line =~ /\-15/ ) {
	  $err_msg .= "It appears that there is no FLEXlm license server running on $server.\n\n";
	}
	elsif ( $line =~ /\-14/ ) {
	  $err_msg .= "Please ensure that you have entered the license server " ;
          $err_msg .= "information correctly and that this computer and the " ;
          $err_msg .= "license server both have an entry for each other in their ";
          $err_msg .= "respective hosts files.\n\n";
	}
        last;

      }
    }

    if ($abaquslm[$x] == 1 && $err_stat[$x] ne $down) {
      foreach $line (@lmstatout) {
	foreach $product ( @products ) {
	  $licensed_prods[$x] = 1 if $line =~ /\s${product}/ ;                   
        }
      }
      #print "@licensed_prods\n";

      if ( ! $licensed_prods[$x] ) {
	$err_stat[$x] = $no_licproducts;
	$err_msg .=  "Couldn't find licensed products on $server\n";
	$err_msg .= "The license server host is not running a \n" .
	  "license server for ABAQUS products.\n\n" ;

      } elsif ( $err_stat[$x] == 0  ) {
	# Test for current version of license.
	# Future test for license expired.
        my $ver_maj = '0';
        my $ver_min = '0';
        
        
        
        while ( $_ = pop(@lmstatout)) {
          next if ( $_ !~ /ABAQUSLM\s*$/ );
          my @words = split;
          if ( $words[1] =~ /(\d+)\.(\d+)/ ) {
            my $ver_maj_tmp = $1;
            my $ver_min_tmp = $2;
            if ( ( $ver_maj_tmp > $ver_maj) or 
                 ( $ver_maj_tmp == $ver_maj and $ver_min_tmp > $ver_min ) ) {
              $ver_maj = $ver_maj_tmp;
              $ver_min = $ver_min_tmp;
            }
          }
        }

        if ( ( $ver_maj > $thisver_maj ) or 
             ( $ver_maj == $thisver_maj and $ver_min >= $thisver_min ) ) {
          #we're all set
        }
        else {
          $err_stat[$x] = $no_lic_current;
          $err_msg .= "The license file on $server is not current. \n" .
            "It currently authorizes version $ver_maj\.$ver_min and must \n".
            "be upgraded to version $thisver to install and execute \n".
            "ABAQUS Version $thisver products. \n\n";
        }                
    }
  }  
    elsif ($abaquslm[$x] == 0 && $err_stat[$x] == 0 ) {
      $err_stat[$x] = $no_abaquslm;
      $err_msg .=  "Couldn't find ABAQUSLM running on $server\n";
      $err_msg .=  "The ABAQUSLM vendor daemon is down or the \n" .
	"FLEXlm license server host is not running a\n" .
	  "license server for ABAQUS products.\n" ;
    }
    $error = 0 if ($err_stat[$x] eq 0);
    # Add server name to license file variable
    if ( $server !~ /\@/ ) {
      $server = '@'. "$server" ;
    }
    if ($abaquslm_license_file eq "") {
      $abaquslm_license_file = $server;
    } else {
      $abaquslm_license_file = $abaquslm_license_file . ':'. "$server" ;
    }
  } 

  if ($error) {
    print STDOUT "$err_msg"; 
  } else {
    chomp $abaquslm_license_file;
    print STDOUT "$abaquslm_license_file";
    print STDERR "TEACHING" if $academic =~ /TEACHING/;
  }

  # Future capability
  #print STDOUT "licensed products :::";
  #foreach $prod(  @licensed_for ) {
  #  print STDOUT "$prod,";
  #}
  #print STDOUT "\n";
  #$serverString .= "abaquslm_license_file:::$abaquslm_license_file\n"; 
  #$serverString .= "academic:::$academic\n";
  #$serverString .= "version_current:::$vercurrent\n";
  #$serverString .= "Error_Msg:::$err_msg";
  #$serverString .= "Status:::0\n";
  #print STDOUT "$serverString";
  exit 0;
}

##  
##  Parse the command line and validate the options
##  
sub ParseCmdLine() {  
  
  my $arg;
  my $subarg;
  my @arg;
  my $servlist = 0;
  my $lmarg = 0;
  my $servnum = 0;
  
  foreach $arg (@ARGV) {
    if ($arg =~ /^-ser/ ) {
      if (($servlist && $servnum)  || ($lmarg && $lmpath eq "")) {
        usage();
      } else {
        $servlist = 1;
        $lmarg = 0;
      }
    } elsif ($arg =~ /^-lm/ ) {
      if ($lmarg && $lmpath ne "") {
        usage();
      } else {
        $lmarg = 1;
        $servlist = 0;
      }
    } else {
      if ($servlist) {
        chomp($arg);
        @serv_arg = (split ' ',$arg);
        foreach $sarg (@serv_arg) {
          @sub_serv_arg = (split ':', $sarg);
          foreach $server (@sub_serv_arg) {
	    push @servers, $server;
	  }
        }
      } elsif ($lmarg) {
        $lmpath = $arg;
      } else {
        usage();
      }
    }
  }
  if (scalar(@servers) !=1 and scalar(@servers) != 3) {
    print STDOUT "***ERROR: Please enter exactly one or three license servers.\n" ;
    exit(1);
  }
  if ($lmarg && $lmpath eq "") {
    usage();
  }
}

#
# Get servers from command arguments
# 





sub usage{

  print STDOUT "***ERROR:  Unknown error querying servers\n";
  exit(1);
}

#
# Displays Usage when parameters are incorrect
#
sub USAGE {   
  my $prog = 'QueryServer';
  print STDOUT qq%  
  
    ***USAGE ERROR***

    SUMMARY: $prog executes the ABAQUS installation verification 
             procedure for one or more desired products. 
  
      USAGE: perl QueryServer.pl -server s1 [s2 s3] [-lmpath <path to flex utils>]
  
    OPTIONS: 
             -server      Required. Atleast one server hostname must follow.
	     
             -lmpath      Opt. parameter supplies the path to the lmstat executable.
		          The default is the current working directory.
  
  
      NOTES: All output is displayed to STDOUT
  
    EXAMPLE: perl QueryServer.pl -server volcano tank firefly -lmpath /usr/local/flexlm/lmstat
  
   %; 
   
   exit(1);  
}  



#
# Sets the directory delimiter depending on OS type.
#
sub pString($) {  
    my $path = shift;  
    if ($nti == 1) {  
        $path =~ s(/)(\\)g;  
    }  
    return $path;  
}  

#
# Determines the basename 
#
sub basename($$) {  
  my $pathstring = shift;  
  my @array = "";  
  my $basename = "";  
  
  if ($nti == 1) {  
    @array = split( /\\/,$pathstring);  
  }    
  else {  
    @array = split( /\//, $pathstring);  
  }  
  pop @array;  
  if ($nti == 1 ) {  
    $basename = join "\\", @array;  
  }  
  else {  
    $basename = join "\/",@array;  
  }  
  return $basename;  
}  




