#!/usr/bin/perl -w
BEGIN{ @INC = (); } 

select STDOUT; $| = 1;
select STDERR; $| = 1;

####
#### ReadLicenseKey.pl
####
####  function : certify license file and return lmhostid that file
####             was intended for.
####
####             If certification fails and ERROR message is returned. 
####             (Must contain the string ERROR, as the installer keys on this.
####
####             If certification passes but license file is for redundant 
####             servers then REDUNDANT is returned.
####
####  input    :  full path to license file
####
####  output   :  <lmhostid>, REDUNDANT, or ERROR message.
####              (All to STDOUT)
####

sub usage();
sub validateLicFile($);
sub validateVersion($);
sub getHostID($);
sub myChomp($);

my $version = 0;
my $license_file;

##
## Warning/Error message strings 
##
my $err = "***ERROR: ";
my $wrn = "***WARNING: ";

##
## Get command line args...
##

if ( scalar(@ARGV)!= 1 ) {
  usage();
}
else {
  $license_file = shift(@ARGV);
}

##
## slurp in the license file...
##

if ( $license_file =~ / / ) {
  print STDOUT "$err"."Invalid path.  Please move the file to a directory that does not contain spaces and reselect.\n";
  exit(1);
}
  
$license_file =~ s/\"//g; 

if ( ! -f $license_file ) {
  print STDOUT "$err"."Cannot find $license_file.\n";
  exit(1);
}
elsif ( ! -r $license_file ) {
  print STDOUT "$err"."Cannot read $license_file.\n";
  exit(1);
}



open(LIC_FILE, "<$license_file") || die "$err Can\'t open \'$license_file\'.\n";
                                   
my @licfile = <LIC_FILE>;
close(LIC_FILE);




#getHostID must be called last.
validateLicFile(\@licfile);
validateVersion(\@licfile);
my $hostID = getHostID(\@licfile);


chomp $hostID;
print STDOUT "$hostID";





########################################
##
## Subroutines
##
########################################

sub usage() {
    my $prog = $0;

    $prog =~ s/.*[\/\\](\w*(\.pl)?)/$1/;

    print STDOUT qq%
  
     ***ERROR:
        Usage: $prog <license file>

      Example: $prog /a/tmp/63licenseFile.txt
	%;
	die "\n";
}


sub getHostID($) {
  my $ra_keyfile = shift;
  my $i;
  foreach my $line (@$ra_keyfile) { 
    if ($line =~ /^SERVER/) {
      my @words = split /\s/,$line;
      chomp $words[2];
      if ( $words[2] =~ /\w|\d/ ) {
          my $id = $words[2];
          #The following case mods are implemented to 
          #guarantee that the output of this script
          #matches in case from what is reported from
          #lmstat.
          $id =~ tr/A-Z/a-z/;
          $id =~ s/id_string/ID_STRING/;
          return $id;
      }
    }
  }
  return "unknown"; 
}


sub validateVersion($) {
  my $ra_keyfile = shift;
  my $version;
  my $err_version = 1;

  ##
  ## parse license_file for info needed to install key files...
  ##
  
  foreach my $line ( @$ra_keyfile ) {   
    if ($line =~ /FEATURE\s*\w*\s*ABAQUSLM\s*(\d.\d+)/ ) {
      $version = myChomp($1);
      my @version = split /\D/, $version;
      if ($version[0] > 6 || $version[0] == 6 && 
          $version[1] >= 4) {
          $err_version = 0; # key version is gte 6.4
          last;
      }
    }
  }
  if ( $err_version ) {
    print STDOUT "$err"."This license file does not license version 6.4 or higher.\n" ;
    exit(1);
  }
}


sub validateLicFile($) {
  my $ra_keyfile = shift;
  #my $vendor = grep /^VENDOR.*ABAQUSLM/, @$ra_keyfile;
  my $feature = grep /^FEATURE\s\w+\sABAQUSLM/,@$ra_keyfile  ;
  my $numServers = grep /^SERVER/ , @$ra_keyfile;
  #print STDOUT "numServers: $numServers\n";

  if ($numServers == 0 ) {
        print STDOUT "$err"."This does not appear to be a valid FLEXlm license file.\n";
	exit (1);
  }
  elsif ($numServers != 1 and $numServers != 3 ) {
        print STDOUT "$err"."$numServers is an invalid number of license servers.  ".
                     "Valid ABAQUS license files are made for one or three servers.\n";
        exit (1);
  }
  
  elsif ($numServers == 3) {
    #The message is in the IA project
    print STDOUT "REDUNDANT";
    exit(0);
  }

  #if ( $vendor == 0 ) {
  #  print STDOUT "$err"."Vendor daemon not found in this license file.  ".
  #               "This does not appear to be an ABAQUS license file.\n";
  #  exit (1);
  #}
  if ( $feature == 0 ) {
    print STDOUT "$err"."No features found in this license file.\n";
    exit (1);
  }  
}


sub myChomp($) {
  my $line = shift;
  #
  # I realize this is a global substitution and is not anchored to the 
  # end of the line like chomp, so maybe myChomp isn't the best name,
  # but it's in the spirit of chomp.
  #
  $line =~ s/[\t\n\r\f]//g;
  return $line;
}

