#!/bin/csh -f
###############################################################################
# This file is intended to be used with the standalone sysinfo utility.
# It is not designed to be used inside ABAQUS.
###############################################################################
set uname_ualpha = `uname -a | grep -c OSF`
if( $uname_ualpha > 0 ) then
    echo Checking for Tru64 UNIX C++ Library 6.3-1 \(60300001\) or newer.
    ./checkAlphaCppLib.exe
    if( $status != 0 ) then
        echo Fail - Found an older version of the Tru64 UNIX C++ Library.  To install ABAQUS upgrade your C++ Library to a more recent version.
        exit 1
    else
        echo Pass - Found a compatible version of the C++ Library.
    endif
endif

if(`uname -a | grep -i Linux | grep -cv ia64` == 1) then
   if(`grep flags /proc/cpuinfo | grep -c '\bsse\b'` == 0) then
      echo "***Error Sysinfo and ABAQUS only run on Linux systems which support the SSE instruction set.  Pentium III and later processors support this functionality."
      exit 1
   endif
endif
set path = ( . $path )
if ( $?LD_LIBRARYN32_PATH ) then
    unsetenv LD_LIBRARYN32_PATH
endif
if( $?LD_LIBRARY64_PATH ) then
    unsetenv LD_LIBRARY64_PATH
endif
if ( $?LD_LIBRARY_PATH) then
    setenv LD_LIBRARY_PATH ./plib:${LD_LIBRARY_PATH}
else
    setenv LD_LIBRARY_PATH ./plib
endif
unsetenv ABA_COMMAND
setenv PYTHONPATH ./plib
endif
if ( $?LIBPATH ) then
    setenv LIBPATH ./plib:${LIBPATH}
else 
    setenv LIBPATH ./plib
endif
if ( $?SHLIB_PATH ) then
    setenv SHLIB_PATH ./plib:${SHLIB_PATH}
else 
    setenv SHLIB_PATH ./plib
endif
if( -d ./plib/v9 ) then
    setenv LD_LIBRARY_PATH ./plib/v9:${LD_LIBRARY_PATH}
    setenv SHLIB_PATH ./plib/v9:${SHLIB_PATH}
    setenv LIBPATH    ./plib/v9:${LIBPATH}
endif
./Python ./sysinfo.pyc $argv > sysinfo.log
set syfstatus = $status
cat sysinfo.log
if ( $syfstatus != "0" ) then
   exit $syfstatus
endif
set success = `grep -c "System requirement status is" sysinfo.log`
if ( $success < "1" ) then
   echo "Error:  A serious error was encountered running sysinfo."
   exit 1
endif
exit $syfstatus
