(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7373,        263]
NotebookOptionsPosition[      4882,        190]
NotebookOutlinePosition[      6227,        224]
CellTagsIndexPosition[      6184,        221]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " Data Access and Manipulation"
}], "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " provides functions for working with data stored in tables in SQL \
databases. Operations such as searching, inserting, and deleting are \
supported. They also convert between the different types of data stored in \
the database and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLSelect",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select data from a database"
}], "GuideText",
 CellID->6477],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLInsert",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SQLDelete",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " insert and delete data"
}], "GuideText",
 CellID->1363413265],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLUpdate",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " update existing data"
}], "GuideText",
 CellID->231222784],

Cell["\t", "GuideDelimiter",
 CellID->688063975],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLExecute",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "execute a raw SQL query"
}], "GuideText",
 CellID->27384],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLArgument",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a sequence of arguments to a raw SQL query"
}], "GuideText",
 CellID->1556717216],

Cell["\t", "GuideDelimiter",
 CellID->91788730],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLMemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLMemberQ"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SQLStringMatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLStringMatchQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " test the value of data, in a conditional query"
}], "GuideText",
 CellID->758110693],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLBinary",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLBinary"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SQLDateTime",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SQLExpr",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLExpr"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " data types"
}], "GuideText",
 CellID->2126446181],

Cell["\t", "GuideDelimiter",
 CellID->234230941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["$SQLTimeout",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/$SQLTimeout"], " "}]], 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " how long ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " waits while executing queries"
}], "GuideText",
 CellID->2126949713]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "GuideTutorial",
 CellID->691132687]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "GuideMoreAbout",
 CellID->137578470]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DatabaseLink Data Access and Manipulation - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 16.8283375}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Guide", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "DatabaseLink provides functions for working with data stored in tables \
in SQL databases. Operations such as searching, inserting, and deleting are \
supported. They also convert between the different types of data stored in \
the database and Mathematica expressions.", "synonyms" -> {}, "title" -> 
    "DatabaseLink Data Access and Manipulation", "type" -> "Guide", "uri" -> 
    "DatabaseLink/guide/SQLDataAccessAndManipulation"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 136, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[758, 32, 411, 11, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1172, 45, 261, 8, 70, "GuideText",
 CellID->6477],
Cell[1436, 55, 404, 12, 70, "GuideText",
 CellID->1363413265],
Cell[1843, 69, 259, 8, 70, "GuideText",
 CellID->231222784],
Cell[2105, 79, 48, 1, 70, "GuideDelimiter",
 CellID->688063975],
Cell[2156, 82, 265, 9, 70, "GuideText",
 CellID->27384],
Cell[2424, 93, 286, 8, 70, "GuideText",
 CellID->1556717216],
Cell[2713, 103, 47, 1, 70, "GuideDelimiter",
 CellID->91788730],
Cell[2763, 106, 444, 13, 70, "GuideText",
 CellID->758110693],
Cell[3210, 121, 534, 16, 70, "GuideText",
 CellID->2126446181],
Cell[3747, 139, 48, 1, 70, "GuideDelimiter",
 CellID->234230941],
Cell[3798, 142, 366, 14, 70, "GuideText",
 CellID->2126949713]
}, Open  ]],
Cell[CellGroupData[{
Cell[4201, 161, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4266, 164, 295, 9, 70, "GuideTutorial",
 CellID->691132687]
}, Open  ]],
Cell[CellGroupData[{
Cell[4598, 178, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4663, 181, 177, 4, 70, "GuideMoreAbout",
 CellID->137578470]
}, Open  ]],
Cell[4855, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

