(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9458,        322]
NotebookOptionsPosition[      7005,        241]
NotebookOutlinePosition[      8318,        279]
CellTagsIndexPosition[      8234,        274]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Database Resources in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseResources"], 
          "Named Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#13985"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"Database Resources in DatabaseLink User Guide\"\>", 
       3->"\<\"Named Connections in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DataSources" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/DataSources"], 
          "DatabaseResourcesPath" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/DatabaseResourcesPath"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DataSources\"\>", 
       2->"\<\"DatabaseResourcesPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DataSourceNames", "ObjectName",
 CellID->21724],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DataSourceNames", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of the names of data sources made \
available through ",
     Cell[BoxData[
      ButtonBox["DatabaseResourcesPath",
       BaseStyle->"Link",
       ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13966]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->73393714],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->85229143],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell["Available data sources:", "ExampleText",
 CellID->798781614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataSourceNames", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10383],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"demo\"\>", ",", "\<\"graphs\"\>", ",", "\<\"publisher\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->14945]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3430],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataSources",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/DataSources"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatabaseResourcesPath",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31107]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30191],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Database Resources in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Named Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"]
}], "Tutorials",
 CellID->168046842]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DataSourceNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 21.0939352}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "DataSourceNames[] returns a list of the names of data sources made \
available through DatabaseResourcesPath.", "synonyms" -> {}, "title" -> 
    "DataSourceNames", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/DataSourceNames"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3120, 95, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8100, 267}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1813, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2436, 69, 53, 1, 70, "ObjectName",
 CellID->21724],
Cell[2492, 72, 591, 18, 70, "Usage",
 CellID->13966]
}, Open  ]],
Cell[CellGroupData[{
Cell[3120, 95, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3497, 109, 147, 5, 70, "ExampleSection",
 CellID->73393714],
Cell[3647, 116, 134, 3, 70, "Input",
 CellID->85229143],
Cell[3784, 121, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4185, 133, 66, 1, 70, "ExampleText",
 CellID->798781614],
Cell[CellGroupData[{
Cell[4276, 138, 102, 3, 70, "Input",
 CellID->10383],
Cell[4381, 143, 165, 5, 70, "Output",
 CellID->14945]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4607, 155, 310, 9, 70, "SeeAlsoSection",
 CellID->3430],
Cell[4920, 166, 509, 17, 70, "SeeAlso",
 CellID->31107]
}, Open  ]],
Cell[CellGroupData[{
Cell[5466, 188, 314, 9, 70, "TutorialsSection",
 CellID->30191],
Cell[5783, 199, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[6073, 210, 432, 12, 70, "Tutorials",
 CellID->133710995],
Cell[6508, 224, 455, 12, 70, "Tutorials",
 CellID->168046842]
}, Open  ]],
Cell[6978, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

