(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14079,        450]
NotebookOptionsPosition[     10824,        340]
NotebookOutlinePosition[     12589,        393]
CellTagsIndexPosition[     12478,        387]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Database Resources in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseResources"], 
          "Named Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#13985"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"Database Resources in DatabaseLink User Guide\"\>", 
       3->"\<\"Named Connections in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DataSources" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/DataSources"], 
          "DatabaseResourcesPath" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/DatabaseResourcesPath"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DataSources\"\>", 
       2->"\<\"DatabaseResourcesPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DataSources", "ObjectName",
 CellID->30836],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DataSources", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of information about named data sources \
made available through ",
     Cell[BoxData[
      ButtonBox["DatabaseResourcesPath",
       BaseStyle->"Link",
       ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"]], 
      "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DataSources", "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of information about the data sources \
called ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->628225991],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->842993326],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataSources", "[", "]"}]], "Input",
 CellTags->"b:2.2.2",
 CellLabel->"In[2]:=",
 CellID->4734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLConnection", "[", 
    RowBox[{
     RowBox[{"JDBC", "[", 
      RowBox[{"\<\"hsqldb\"\>", 
       ",", "\<\"/Users/ldegler/Library/Mathematica/DatabaseResources/\
Examples/demo\"\>"}], "]"}], ",", 
     RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"demo\"\>"}], ",", 
     RowBox[{"\<\"Description\"\>", 
      "\[Rule]", "\<\"Connection to hsql db for documention.\"\>"}], ",", 
     RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
     RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
     RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
     RowBox[{"\<\"Location\"\>", 
      "\[Rule]", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/DatabaseLink/DatabaseResources/demo.m\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLConnection", "[", 
    RowBox[{
     RowBox[{"JDBC", "[", 
      RowBox[{"\<\"hsqldb\"\>", 
       ",", "\<\"/Users/ldegler/Library/Mathematica/DatabaseResources/\
Examples/graphs\"\>"}], "]"}], ",", 
     RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"graphs\"\>"}], ",", 
     RowBox[{"\<\"Description\"\>", 
      "\[Rule]", "\<\"Connection to the graph database.\"\>"}], ",", 
     RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
     RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
     RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
     RowBox[{"\<\"Location\"\>", 
      "\[Rule]", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/DatabaseLink/DatabaseResources/graphs.m\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLConnection", "[", 
    RowBox[{
     RowBox[{"JDBC", "[", 
      RowBox[{"\<\"hsqldb\"\>", 
       ",", "\<\"/Users/ldegler/Library/Mathematica/DatabaseResources/\
Examples/publisher\"\>"}], "]"}], ",", 
     RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
     RowBox[{"\<\"Description\"\>", 
      "\[Rule]", "\<\"Connection to hsql db for demos.\"\>"}], ",", 
     RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
     RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
     RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
     RowBox[{"\<\"Location\"\>", 
      "\[Rule]", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/DatabaseLink/DatabaseResources/publisher.m\"\>"}]}\
], "]"}]}], "}"}]], "Output",
 CellTags->"b:2.2.2",
 CellLabel->"Out[2]=",
 CellID->53]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1999],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->223429797],

Cell["Get information about a named data source:", "ExampleText",
 CellID->26418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataSources", "[", "\"\<demo\>\"", "]"}]], "Input",
 CellTags->"b:2.2.2",
 CellLabel->"In[2]:=",
 CellID->27938],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"hsqldb\"\>", 
     ",", "\<\"/Users/ldegler/Library/Mathematica/DatabaseResources/Examples/\
demo\"\>"}], "]"}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"demo\"\>"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to hsql db for documention.\"\>"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/DatabaseLink/DatabaseResources/demo.m\"\>"}]}], 
  "]"}]], "Output",
 CellTags->"b:2.2.2",
 CellLabel->"Out[2]=",
 CellID->6900]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11020],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataSources",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/DataSources"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatabaseResourcesPath",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4596]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24021],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Database Resources in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Named Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"]
}], "Tutorials",
 CellID->168046842]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DataSources - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 21.8751802}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "DataSources[] returns a list of information about named data sources \
made available through DatabaseResourcesPath. DataSources[name] returns a \
list of information about the data sources called name.", "synonyms" -> {}, 
    "title" -> "DataSources", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/DataSources"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3437, 105, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:2.2.2"->{
  Cell[4526, 145, 119, 4, 70, "Input",
   CellTags->"b:2.2.2",
   CellID->4734],
  Cell[4648, 151, 2389, 53, 70, "Output",
   CellTags->"b:2.2.2",
   CellID->53],
  Cell[7419, 222, 136, 4, 70, "Input",
   CellTags->"b:2.2.2",
   CellID->27938],
  Cell[7558, 228, 807, 19, 70, "Output",
   CellTags->"b:2.2.2",
   CellID->6900]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12000, 367},
 {"b:2.2.2", 12126, 371}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1813, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2436, 69, 49, 1, 70, "ObjectName",
 CellID->30836],
Cell[2488, 72, 912, 28, 70, "Usage",
 CellID->9374]
}, Open  ]],
Cell[CellGroupData[{
Cell[3437, 105, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3814, 119, 148, 5, 70, "ExampleSection",
 CellID->628225991],
Cell[3965, 126, 135, 3, 70, "Input",
 CellID->842993326],
Cell[4103, 131, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[CellGroupData[{
Cell[4526, 145, 119, 4, 70, "Input",
 CellTags->"b:2.2.2",
 CellID->4734],
Cell[4648, 151, 2389, 53, 70, "Output",
 CellTags->"b:2.2.2",
 CellID->53]
}, Open  ]],
Cell[7052, 207, 120, 3, 70, "ExampleDelimiter",
 CellID->1999],
Cell[7175, 212, 135, 3, 70, "Input",
 CellID->223429797],
Cell[7313, 217, 81, 1, 70, "ExampleText",
 CellID->26418],
Cell[CellGroupData[{
Cell[7419, 222, 136, 4, 70, "Input",
 CellTags->"b:2.2.2",
 CellID->27938],
Cell[7558, 228, 807, 19, 70, "Output",
 CellTags->"b:2.2.2",
 CellID->6900]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8426, 254, 311, 9, 70, "SeeAlsoSection",
 CellID->11020],
Cell[8740, 265, 508, 17, 70, "SeeAlso",
 CellID->4596]
}, Open  ]],
Cell[CellGroupData[{
Cell[9285, 287, 314, 9, 70, "TutorialsSection",
 CellID->24021],
Cell[9602, 298, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[9892, 309, 432, 12, 70, "Tutorials",
 CellID->133710995],
Cell[10327, 323, 455, 12, 70, "Tutorials",
 CellID->168046842]
}, Open  ]],
Cell[10797, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

