(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11164,        375]
NotebookOptionsPosition[      8455,        283]
NotebookOutlinePosition[      9922,        328]
CellTagsIndexPosition[      9813,        322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "JDBC Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#27756"], 
          "JDBC Configuration in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"JDBC Connections in DatabaseLink User Guide\"\>", 
       3->"\<\"JDBC Configuration in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "JDBCDriver" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDriver"], 
          "JDBCDrivers" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDrivers"], 
          "JDBCDriverNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/JDBCDriverNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 2->"\<\"JDBCDriver\"\>", 
       3->"\<\"JDBCDrivers\"\>", 
       4->"\<\"JDBCDriverNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JDBC", "ObjectName",
 CellID->29264],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JDBC", "[", 
       RowBox[{
        StyleBox["arg", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that holds parameters for making a JDBC \
connection to a database."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->289391776],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->230556355],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell["Make a JDBC connection:", "ExampleText",
 CellID->11197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", "  ", 
   RowBox[{
    RowBox[{"JDBC", "[", 
     RowBox[{"\"\<hsqldb\>\"", ",", 
      RowBox[{"ToFileName", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "$UserBaseDirectory", ",", "\"\<DatabaseResources\>\"", ",", 
          "\"\<Examples\>\""}], "}"}], ",", "\"\<demo\>\""}], "]"}]}], " ", 
     "]"}], ",", " ", "\[IndentingNewLine]", "\t", 
    RowBox[{"\"\<Name\>\"", "->", "\"\<manualA\>\""}], ",", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}]}], "]"}]}]], "Input",
 CellTags->"b:2.2.1",
 CellLabel->"In[2]:=",
 CellID->23692],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"manualA\"\>", ",", "1", ",", "\<\"Open\"\>", 
   ",", "\<\"<>\"\>"}], "]"}]], "Output",
 CellTags->"b:2.2.1",
 CellLabel->"Out[2]=",
 CellID->19771]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[3]:=",
 CellID->20363]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDriver",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDriver"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDrivers",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDriverNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDriverNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4596]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14723],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["JDBC Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["JDBC Configuration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]
}], "Tutorials",
 CellID->18109296]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JDBC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 25.7032807}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "JDBC[arg, ...] is an object that holds parameters for making a JDBC \
connection to a database.", "synonyms" -> {}, "title" -> "JDBC", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/JDBC"}, "SearchTextTranslated" -> "",
   "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3285, 97, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:2.2.1"->{
  Cell[4439, 140, 641, 17, 70, "Input",
   CellTags->"b:2.2.1",
   CellID->23692],
  Cell[5083, 159, 209, 6, 70, "Output",
   CellTags->"b:2.2.1",
   CellID->19771]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9498, 308},
 {"b:2.2.1", 9623, 312}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2085, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2708, 74, 42, 1, 70, "ObjectName",
 CellID->29264],
Cell[2753, 77, 495, 15, 70, "Usage",
 CellID->28801]
}, Open  ]],
Cell[CellGroupData[{
Cell[3285, 97, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3662, 111, 148, 5, 70, "ExampleSection",
 CellID->289391776],
Cell[3813, 118, 135, 3, 70, "Input",
 CellID->230556355],
Cell[3951, 123, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4352, 135, 62, 1, 70, "ExampleText",
 CellID->11197],
Cell[CellGroupData[{
Cell[4439, 140, 641, 17, 70, "Input",
 CellTags->"b:2.2.1",
 CellID->23692],
Cell[5083, 159, 209, 6, 70, "Output",
 CellTags->"b:2.2.1",
 CellID->19771]
}, Open  ]],
Cell[5307, 168, 148, 5, 70, "Input",
 CellID->20363]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5504, 179, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5823, 190, 1034, 35, 70, "SeeAlso",
 CellID->4596]
}, Open  ]],
Cell[CellGroupData[{
Cell[6894, 230, 314, 9, 70, "TutorialsSection",
 CellID->14723],
Cell[7211, 241, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[7501, 252, 454, 12, 70, "Tutorials",
 CellID->133710995],
Cell[7958, 266, 455, 12, 70, "Tutorials",
 CellID->18109296]
}, Open  ]],
Cell[8428, 281, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

