(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14092,        466]
NotebookOptionsPosition[     11083,        365]
NotebookOutlinePosition[     12383,        402]
CellTagsIndexPosition[     12298,        397]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "JDBC Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#27756"], 
          "JDBC Configuration in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"JDBC Connections in DatabaseLink User Guide\"\>", 
       3->"\<\"JDBC Configuration in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "JDBC" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBC"], 
          "JDBCDrivers" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDrivers"], 
          "JDBCDriverNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/JDBCDriverNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 2->"\<\"JDBC\"\>", 
       3->"\<\"JDBCDrivers\"\>", 
       4->"\<\"JDBCDriverNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JDBCDriver", "ObjectName",
 CellID->9248],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JDBCDriver", "[", 
       StyleBox["args", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies the configuration for connecting to a \
database produced by a specific vendor."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26018]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Used only in JDBC configuration files on ",
 Cell[BoxData[
  ButtonBox["DatabaseResourcesPath",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->27368],

Cell["The following options can be given: ", "Notes",
 CellID->23717],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", "\"\<\>\"", Cell[
    "description of the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Driver\>\"", "\"\<\>\"", Cell[
    "class file of the JDBC driver", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Location\>\"", "\"\<\>\"", Cell[
    "location of the file that defines the driver", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", "\"\<\>\"", Cell[
    "name of the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Protocol\>\"", "\"\<\>\"", Cell[
    "JDBC protocol", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->9714]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->185296034],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->279771428],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->152315298],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell["A JDBC configuration file:", "ExampleText",
 CellID->21979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "$DatabaseLinkDirectory", ",", " ", "\"\<DatabaseResources\>\""}], "}"}],
     ",", " ", "\"\<hsqldb.m\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24199],

Cell[BoxData[
 RowBox[{"JDBCDriver", "[", 
  RowBox[{
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"hsqldb\"\>"}], ",", 
   RowBox[{"\<\"Driver\"\>", "\[Rule]", "\<\"org.hsqldb.jdbcDriver\"\>"}], 
   ",", 
   RowBox[{"\<\"Protocol\"\>", "\[Rule]", "\<\"jdbc:hsqldb:file:\"\>"}], ",", 
   
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"HSQL Database Engine - Version 1.8.0.0 - This JDBCDriver \
has been deprecated.  Please use HSQL(Standalone).\"\>"}]}], "]"}]], "Output",\

 CellLabel->"Out[2]=",
 CellID->29105]
}, Open  ]],

Cell["A connection that uses this configuration:", "ExampleText",
 CellID->24791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", 
   RowBox[{
    RowBox[{"JDBC", "[", 
     RowBox[{"\"\<hsqldb\>\"", ",", " ", 
      RowBox[{"ToFileName", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "$UserBaseDirectory", ",", " ", "\"\<DatabaseResources\>\"", ",", 
          " ", "\"\<Examples\>\""}], "}"}], ",", " ", "\"\<demo\>\""}], 
       "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", "\t", 
    RowBox[{"Name", "->", "\"\<manualA\>\""}], ",", 
    RowBox[{"Username", "->", "\"\<sa\>\""}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18661],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"manualA\"\>", ",", "13", ",", "\<\"Open\"\>", 
   ",", "\<\"<>\"\>"}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->8681]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->3652]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17650],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBC",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDrivers",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDriverNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDriverNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4596]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3335],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["JDBC Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["JDBC Configuration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]
}], "Tutorials",
 CellID->18109296]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JDBCDriver - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 23.7345433}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "JDBCDriver[args] specifies the configuration for connecting to a \
database produced by a specific vendor.", "synonyms" -> {}, "title" -> 
    "JDBCDriver", "type" -> "Symbol", "uri" -> "DatabaseLink/ref/JDBCDriver"},
   "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4982, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->185296034]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12155, 390}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2067, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2690, 74, 47, 1, 70, "ObjectName",
 CellID->9248],
Cell[2740, 77, 447, 13, 70, "Usage",
 CellID->26018]
}, Open  ]],
Cell[CellGroupData[{
Cell[3224, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3702, 112, 256, 9, 70, "Notes",
 CellID->27368],
Cell[3961, 123, 69, 1, 70, "Notes",
 CellID->23717],
Cell[4033, 126, 912, 17, 70, "3ColumnTableMod",
 CellID->9714]
}, Closed]],
Cell[CellGroupData[{
Cell[4982, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->185296034],
Cell[CellGroupData[{
Cell[5367, 162, 148, 5, 70, "ExampleSection",
 CellID->279771428],
Cell[5518, 169, 135, 3, 70, "Input",
 CellID->152315298],
Cell[5656, 174, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6057, 186, 65, 1, 70, "ExampleText",
 CellID->21979],
Cell[CellGroupData[{
Cell[6147, 191, 288, 9, 70, "Input",
 CellID->24199],
Cell[6438, 202, 576, 14, 70, "Output",
 CellID->29105]
}, Open  ]],
Cell[7029, 219, 81, 1, 70, "ExampleText",
 CellID->24791],
Cell[CellGroupData[{
Cell[7135, 224, 614, 16, 70, "Input",
 CellID->18661],
Cell[7752, 242, 187, 5, 70, "Output",
 CellID->8681]
}, Open  ]],
Cell[7954, 250, 147, 5, 70, "Input",
 CellID->3652]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8150, 261, 311, 9, 70, "SeeAlsoSection",
 CellID->17650],
Cell[8464, 272, 1022, 35, 70, "SeeAlso",
 CellID->4596]
}, Open  ]],
Cell[CellGroupData[{
Cell[9523, 312, 313, 9, 70, "TutorialsSection",
 CellID->3335],
Cell[9839, 323, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10129, 334, 454, 12, 70, "Tutorials",
 CellID->133710995],
Cell[10586, 348, 455, 12, 70, "Tutorials",
 CellID->18109296]
}, Open  ]],
Cell[11056, 363, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

