(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12137,        397]
NotebookOptionsPosition[      9310,        302]
NotebookOutlinePosition[     10850,        348]
CellTagsIndexPosition[     10739,        342]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "JDBC Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#27756"], 
          "JDBC Configuration in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"JDBC Connections in DatabaseLink User Guide\"\>", 
       3->"\<\"JDBC Configuration in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "JDBC" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBC"], 
          "JDBCDriver" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDriver"], 
          "JDBCDrivers" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDrivers"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"OpenSQLConnection\"\>", 
       2->"\<\"JDBC\"\>", 3->"\<\"JDBCDriver\"\>", 
       4->"\<\"JDBCDrivers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections and Resources" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Database Connections and Resources\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JDBCDriverNames", "ObjectName",
 CellID->1836],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JDBCDriverNames", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of the names of databases for which JDBC \
drivers are available through ",
     Cell[BoxData["DatabaseResourcesPath"], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10797]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->773565094],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->852920915],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JDBCDriverNames", "[", "]"}]], "Input",
 CellTags->"b:2.2.1",
 CellLabel->"In[2]:=",
 CellID->8546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Microsoft Access(ODBC)\"\>", ",", "\<\"hsqldb\"\>", 
   ",", "\<\"HSQL(Memory)\"\>", ",", "\<\"HSQL(Server)\"\>", 
   ",", "\<\"HSQL(Server+TLS)\"\>", ",", "\<\"HSQL(Standalone)\"\>", 
   ",", "\<\"HSQL(Webserver)\"\>", ",", "\<\"HSQL(Webserver+TLS)\"\>", 
   ",", "\<\"jtds_sqlserver\"\>", ",", "\<\"jtds_sybase\"\>", 
   ",", "\<\"mysql\"\>", ",", "\<\"MySQL(Connector/J)\"\>", 
   ",", "\<\"ODBC(DSN)\"\>", ",", "\<\"odbc\"\>", ",", "\<\"Oracle(thin)\"\>",
    ",", "\<\"Microsoft SQL Server(jTDS)\"\>", ",", "\<\"Sybase(jTDS)\"\>"}], 
  "}"}]], "Output",
 CellTags->"b:2.2.1",
 CellLabel->"Out[2]=",
 CellID->20474]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31202],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBC",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDriver",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDriver"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDrivers",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4596]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10080],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["JDBC Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["JDBC Configuration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]
}], "Tutorials",
 CellID->18109296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->438008365],

Cell[TextData[ButtonBox["Database Connections and Resources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->522335738]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JDBCDriverNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 22.8595489}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "JDBCDriverNames[] returns a list of the names of databases for which \
JDBC drivers are available through DatabaseResourcesPath.", "synonyms" -> {}, 
    "title" -> "JDBCDriverNames", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/JDBCDriverNames"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3895, 112, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:2.2.1"->{
  Cell[4984, 152, 123, 4, 70, "Input",
   CellTags->"b:2.2.1",
   CellID->8546],
  Cell[5110, 158, 663, 13, 70, "Output",
   CellTags->"b:2.2.1",
   CellID->20474]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10424, 328},
 {"b:2.2.1", 10550, 332}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2689, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3312, 90, 52, 1, 70, "ObjectName",
 CellID->1836],
Cell[3367, 93, 491, 14, 70, "Usage",
 CellID->10797]
}, Open  ]],
Cell[CellGroupData[{
Cell[3895, 112, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4272, 126, 148, 5, 70, "ExampleSection",
 CellID->773565094],
Cell[4423, 133, 135, 3, 70, "Input",
 CellID->852920915],
Cell[4561, 138, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[CellGroupData[{
Cell[4984, 152, 123, 4, 70, "Input",
 CellTags->"b:2.2.1",
 CellID->8546],
Cell[5110, 158, 663, 13, 70, "Output",
 CellTags->"b:2.2.1",
 CellID->20474]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5834, 178, 311, 9, 70, "SeeAlsoSection",
 CellID->31202],
Cell[6148, 189, 1012, 35, 70, "SeeAlso",
 CellID->4596]
}, Open  ]],
Cell[CellGroupData[{
Cell[7197, 229, 314, 9, 70, "TutorialsSection",
 CellID->10080],
Cell[7514, 240, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[7804, 251, 454, 12, 70, "Tutorials",
 CellID->133710995],
Cell[8261, 265, 455, 12, 70, "Tutorials",
 CellID->18109296]
}, Open  ]],
Cell[CellGroupData[{
Cell[8753, 282, 319, 9, 70, "MoreAboutSection",
 CellID->438008365],
Cell[9075, 293, 193, 4, 70, "MoreAbout",
 CellID->522335738]
}, Open  ]],
Cell[9283, 300, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

