(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16244,        524]
NotebookOptionsPosition[     12653,        402]
NotebookOutlinePosition[     14497,        458]
CellTagsIndexPosition[     14386,        452]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "JDBC Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#27756"], 
          "JDBC Configuration in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"JDBC Connections in DatabaseLink User Guide\"\>", 
       3->"\<\"JDBC Configuration in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "JDBC" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBC"], 
          "JDBCDriver" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDriver"], 
          "JDBCDriverNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/JDBCDriverNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 2->"\<\"JDBC\"\>", 
       3->"\<\"JDBCDriver\"\>", 
       4->"\<\"JDBCDriverNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections and Resources" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Database Connections and Resources\"\>", 
       2->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JDBCDrivers", "ObjectName",
 CellID->23990],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JDBCDrivers", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of information about JDBC drivers \
available through ",
     Cell[BoxData[
      ButtonBox["DatabaseResourcesPath",
       BaseStyle->"Link",
       ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"]], 
      "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JDBCDrivers", "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of information about the JDBC driver \
called ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->310389663],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->589462135],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBCDrivers", "[", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", " ", "15"}], "]"}], " ", "&"}]}]], "Input",
 CellTags->"b:2.2.1",
 CellLabel->"In[2]:=",
 CellID->4978],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"JDBCDriver", "[", 
     RowBox[{
      RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"Microsoft Access(ODBC)\"\>"}], 
      ",", 
      RowBox[{"\<\"Driver\"\>", 
       "\[Rule]", "\<\"sun.jdbc.odbc.JdbcOdbcDriver\"\>"}], ",", 
      RowBox[{"\<\"Protocol\"\>", 
       "\[Rule]", "\<\"jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)}; \
Dbq=\"\>"}], ",", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
      RowBox[{"\<\"Description\"\>", 
       "\[Rule]", "\<\"Microsoft Access file using JDBC-ODBC Bridge \
distributed with the Sun JVM.  This driver only works on Windows.\"\>"}], ",",
       
      RowBox[{"\<\"Location\"\>", 
       "\[Rule]", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/DatabaseLink/DatabaseResources/accessodbc.m\"\>"}]\
}], "]"}], ",", 
    RowBox[{"\[LeftSkeleton]", "16", "\[RightSkeleton]"}], ",", 
    RowBox[{"JDBCDriver", "[", 
     RowBox[{
      RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"Sybase(jTDS)\"\>"}], ",", 
      RowBox[{"\<\"Driver\"\>", 
       "\[Rule]", "\<\"net.sourceforge.jtds.jdbc.Driver\"\>"}], ",", 
      RowBox[{"\<\"Protocol\"\>", "\[Rule]", "\<\"jdbc:jtds:sybase://\"\>"}], 
      ",", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
      RowBox[{"\<\"Description\"\>", 
       "\[Rule]", "\<\"Sybase Adaptive Server Enterprise using jTDS - Version \
1.1 - This supports Sybase Adaptive Server Enterprise 10, 11, 12.\"\>"}], ",",
       
      RowBox[{"\<\"Location\"\>", 
       "\[Rule]", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/DatabaseLink/DatabaseResources/sybasejtds.m\"\>"}]\
}], "]"}]}], "}"}],
  Short[#, 15]& ]], "Output",
 CellTags->"b:2.2.1",
 CellLabel->"Out[2]//Short=",
 CellID->24779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5006],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->91498608],

Cell["Get information for a specific driver:", "ExampleText",
 CellTags->"b:2.2.1",
 CellID->13262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JDBCDrivers", "[", "\"\<odbc\>\"", "]"}]], "Input",
 CellTags->"b:2.2.1",
 CellLabel->"In[2]:=",
 CellID->20135],

Cell[BoxData[
 RowBox[{"JDBCDriver", "[", 
  RowBox[{
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"odbc\"\>"}], ",", 
   RowBox[{"\<\"Driver\"\>", 
    "\[Rule]", "\<\"sun.jdbc.odbc.JdbcOdbcDriver\"\>"}], ",", 
   RowBox[{"\<\"Protocol\"\>", "\[Rule]", "\<\"jdbc:odbc:\"\>"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"JDBC-ODBC Bridge distributed with the Sun JVM - This \
JDBCDriver has been deprecated.  Please use ODBC(DSN).  This driver only \
works on Windows.\"\>"}], ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"/Applications/Mathematica \
6.0.app/AddOns/Applications/DatabaseLink/DatabaseResources/odbc.m\"\>"}]}], 
  "]"}]], "Output",
 CellTags->"b:2.2.1",
 CellLabel->"Out[2]=",
 CellID->23487]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24710],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBC",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDriver",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDriver"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JDBCDriverNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/JDBCDriverNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4596]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17945],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["JDBC Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["JDBC Configuration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#15185"]
}], "Tutorials",
 CellID->18109296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->239104002],

Cell[TextData[ButtonBox["Database Connections and Resources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->106299966],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->72778190]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JDBCDrivers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 24.7189120}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "JDBCDrivers[] returns a list of information about JDBC drivers available \
through DatabaseResourcesPath. JDBCDrivers[name] returns a list of \
information about the JDBC driver called name.", "synonyms" -> {}, "title" -> 
    "JDBCDrivers", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/JDBCDrivers"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4502, 130, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:2.2.1"->{
  Cell[5591, 170, 230, 8, 70, "Input",
   CellTags->"b:2.2.1",
   CellID->4978],
  Cell[5824, 180, 1781, 42, 70, "Output",
   CellTags->"b:2.2.1",
   CellID->24779],
  Cell[7880, 235, 99, 2, 70, "ExampleText",
   CellTags->"b:2.2.1",
   CellID->13262],
  Cell[8004, 241, 136, 4, 70, "Input",
   CellTags->"b:2.2.1",
   CellID->20135],
  Cell[8143, 247, 792, 18, 70, "Output",
   CellTags->"b:2.2.1",
   CellID->23487]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13817, 429},
 {"b:2.2.1", 13943, 433}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2889, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3512, 94, 49, 1, 70, "ObjectName",
 CellID->23990],
Cell[3564, 97, 901, 28, 70, "Usage",
 CellID->32588]
}, Open  ]],
Cell[CellGroupData[{
Cell[4502, 130, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4879, 144, 148, 5, 70, "ExampleSection",
 CellID->310389663],
Cell[5030, 151, 135, 3, 70, "Input",
 CellID->589462135],
Cell[5168, 156, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[CellGroupData[{
Cell[5591, 170, 230, 8, 70, "Input",
 CellTags->"b:2.2.1",
 CellID->4978],
Cell[5824, 180, 1781, 42, 70, "Output",
 CellTags->"b:2.2.1",
 CellID->24779]
}, Open  ]],
Cell[7620, 225, 120, 3, 70, "ExampleDelimiter",
 CellID->5006],
Cell[7743, 230, 134, 3, 70, "Input",
 CellID->91498608],
Cell[7880, 235, 99, 2, 70, "ExampleText",
 CellTags->"b:2.2.1",
 CellID->13262],
Cell[CellGroupData[{
Cell[8004, 241, 136, 4, 70, "Input",
 CellTags->"b:2.2.1",
 CellID->20135],
Cell[8143, 247, 792, 18, 70, "Output",
 CellTags->"b:2.2.1",
 CellID->23487]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8996, 272, 311, 9, 70, "SeeAlsoSection",
 CellID->24710],
Cell[9310, 283, 1020, 35, 70, "SeeAlso",
 CellID->4596]
}, Open  ]],
Cell[CellGroupData[{
Cell[10367, 323, 314, 9, 70, "TutorialsSection",
 CellID->17945],
Cell[10684, 334, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10974, 345, 454, 12, 70, "Tutorials",
 CellID->133710995],
Cell[11431, 359, 455, 12, 70, "Tutorials",
 CellID->18109296]
}, Open  ]],
Cell[CellGroupData[{
Cell[11923, 376, 319, 9, 70, "MoreAboutSection",
 CellID->239104002],
Cell[12245, 387, 193, 4, 70, "MoreAbout",
 CellID->106299966],
Cell[12441, 393, 170, 4, 70, "MoreAbout",
 CellID->72778190]
}, Open  ]],
Cell[12626, 400, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

