(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17857,        603]
NotebookOptionsPosition[     12169,        424]
NotebookOutlinePosition[     15214,        510]
CellTagsIndexPosition[     14762,        497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Argument Sequences in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLExecute#16828"], 
          "Batch Operations in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/Performance#17968"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Argument Sequences in DatabaseLink User Guide\"\>", 
       3->"\<\"Batch Operations in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQLExecute\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLArgument", "ObjectName",
 CellID->14875],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLArgument", "[", 
       RowBox[{
        StyleBox["arg1", "TI"], ",", " ", 
        StyleBox["arg2", "TI"], ",", " ", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox["holds a sequence of arguments to an SQL query.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SQLArgument"], "InlineFormula"],
 " is always used as an argument to ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21184]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->966877756],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->493475347],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->354339489],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,25",
 CellLabel->"In[2]:=",
 CellID->3351],

Cell["Select multiple columns:", "ExampleText",
 CellID->8329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT NAME, VALUE FROM SAMPLETABLE1\>\""}], 
  "]"}]], "Input",
 CellTags->"Ex--21943492438155078303,26",
 CellLabel->"In[3]:=",
 CellID->16290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Day1\"\>", ",", "5.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day2\"\>", ",", "5.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day3\"\>", ",", "7.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day4\"\>", ",", "6.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day5\"\>", ",", "6.`"}], "}"}]}], "}"}]], "Output",
 CellTags->"Ex--21943492438155078303,26",
 CellLabel->"Out[3]=",
 CellID->22974]
}, Open  ]],

Cell["Use a prepared statement to execute the same query:", "ExampleText",
 CellID->23072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT `1` FROM `2`\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLArgument", "[", 
      RowBox[{
       RowBox[{"SQLColumn", "[", "\"\<NAME\>\"", "]"}], ",", " ", 
       RowBox[{"SQLColumn", "[", "\"\<VALUE\>\"", "]"}]}], "]"}], ",", " ", 
     RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"Ex--21943492438155078303,27",
 CellLabel->"In[4]:=",
 CellID->3591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Day1\"\>", ",", "5.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day2\"\>", ",", "5.9`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day3\"\>", ",", "7.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day4\"\>", ",", "6.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Day5\"\>", ",", "6.`"}], "}"}]}], "}"}]], "Output",
 CellTags->"Ex--21943492438155078303,27",
 CellLabel->"Out[4]=",
 CellID->12189]
}, Open  ]],

Cell["Use a prepared statement to insert data:", "ExampleText",
 CellID->15787],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<A\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<Integer\>\""}]}], 
       "]"}], ",", " ", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<B\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<Integer\>\""}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21950856252955103714,2",
 CellLabel->"In[5]:=",
 CellID->31490],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", "\"\<INSERT INTO TEST (A, B) VALUES (`1`)\>\"", ",", " ",
     
    RowBox[{"{", 
     RowBox[{"SQLArgument", "[", 
      RowBox[{"3", ",", "7"}], "]"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21943492438155078303,29",
 CellLabel->"In[6]:=",
 CellID->3239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"Ex--21943492438155078303,30",
 CellLabel->"In[7]:=",
 CellID->14893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"3", ",", "7"}], "}"}], "}"}]], "Output",
 CellTags->"Ex--21943492438155078303,30",
 CellLabel->"Out[7]=",
 CellID->3053]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,31",
 CellLabel->"In[8]:=",
 CellID->17063],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,32",
 CellLabel->"In[9]:=",
 CellID->10681]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28074],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Argument Sequences in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute#16828"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute#16828"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute#16828"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Batch Operations in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Performance#17968"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Performance#17968"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Performance#17968"]
}], "Tutorials",
 CellID->133138080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->44849869],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->10552229]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLArgument - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 27.8126422}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLArgument[arg1, arg2, ...] holds a sequence of arguments to an SQL \
query.", "synonyms" -> {}, "title" -> "SQLArgument", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLArgument"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4302, 137, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->966877756]},
 "Ex--21943492438155078303,25"->{
  Cell[5377, 175, 243, 8, 70, "Input",
   CellTags->"Ex--21943492438155078303,25",
   CellID->3351]},
 "Ex--21943492438155078303,26"->{
  Cell[5710, 190, 221, 6, 70, "Input",
   CellTags->"Ex--21943492438155078303,26",
   CellID->16290],
  Cell[5934, 198, 498, 15, 70, "Output",
   CellTags->"Ex--21943492438155078303,26",
   CellID->22974]},
 "Ex--21943492438155078303,27"->{
  Cell[6562, 221, 507, 13, 70, "Input",
   CellTags->"Ex--21943492438155078303,27",
   CellID->3591],
  Cell[7072, 236, 498, 15, 70, "Output",
   CellTags->"Ex--21943492438155078303,27",
   CellID->12189]},
 "Ex--21950856252955103714,2"->{
  Cell[7667, 257, 630, 17, 70, "Input",
   CellTags->"Ex--21950856252955103714,2",
   CellID->31490]},
 "Ex--21943492438155078303,29"->{
  Cell[8300, 276, 353, 11, 70, "Input",
   CellTags->"Ex--21943492438155078303,29",
   CellID->3239]},
 "Ex--21943492438155078303,30"->{
  Cell[8678, 291, 185, 5, 70, "Input",
   CellTags->"Ex--21943492438155078303,30",
   CellID->14893],
  Cell[8866, 298, 177, 6, 70, "Output",
   CellTags->"Ex--21943492438155078303,30",
   CellID->3053]},
 "Ex--21943492438155078303,31"->{
  Cell[9058, 307, 244, 8, 70, "Input",
   CellTags->"Ex--21943492438155078303,31",
   CellID->17063]},
 "Ex--21943492438155078303,32"->{
  Cell[9305, 317, 190, 6, 70, "Input",
   CellTags->"Ex--21943492438155078303,32",
   CellID->10681]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13215, 449},
 {"Ex--21943492438155078303,25", 13369, 453},
 {"Ex--21943492438155078303,26", 13505, 457},
 {"Ex--21943492438155078303,27", 13746, 464},
 {"Ex--21950856252955103714,2", 13986, 471},
 {"Ex--21943492438155078303,29", 14123, 475},
 {"Ex--21943492438155078303,30", 14260, 479},
 {"Ex--21943492438155078303,31", 14499, 486},
 {"Ex--21943492438155078303,32", 14636, 490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2260, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2883, 82, 49, 1, 70, "ObjectName",
 CellID->14875],
Cell[2935, 85, 543, 16, 70, "Usage",
 CellID->5907]
}, Open  ]],
Cell[CellGroupData[{
Cell[3515, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3993, 123, 272, 9, 70, "Notes",
 CellID->21184]
}, Closed]],
Cell[CellGroupData[{
Cell[4302, 137, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->966877756],
Cell[CellGroupData[{
Cell[4687, 151, 148, 5, 70, "ExampleSection",
 CellID->493475347],
Cell[4838, 158, 135, 3, 70, "Input",
 CellID->354339489],
Cell[4976, 163, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5377, 175, 243, 8, 70, "Input",
 CellTags->"Ex--21943492438155078303,25",
 CellID->3351],
Cell[5623, 185, 62, 1, 70, "ExampleText",
 CellID->8329],
Cell[CellGroupData[{
Cell[5710, 190, 221, 6, 70, "Input",
 CellTags->"Ex--21943492438155078303,26",
 CellID->16290],
Cell[5934, 198, 498, 15, 70, "Output",
 CellTags->"Ex--21943492438155078303,26",
 CellID->22974]
}, Open  ]],
Cell[6447, 216, 90, 1, 70, "ExampleText",
 CellID->23072],
Cell[CellGroupData[{
Cell[6562, 221, 507, 13, 70, "Input",
 CellTags->"Ex--21943492438155078303,27",
 CellID->3591],
Cell[7072, 236, 498, 15, 70, "Output",
 CellTags->"Ex--21943492438155078303,27",
 CellID->12189]
}, Open  ]],
Cell[7585, 254, 79, 1, 70, "ExampleText",
 CellID->15787],
Cell[7667, 257, 630, 17, 70, "Input",
 CellTags->"Ex--21950856252955103714,2",
 CellID->31490],
Cell[8300, 276, 353, 11, 70, "Input",
 CellTags->"Ex--21943492438155078303,29",
 CellID->3239],
Cell[CellGroupData[{
Cell[8678, 291, 185, 5, 70, "Input",
 CellTags->"Ex--21943492438155078303,30",
 CellID->14893],
Cell[8866, 298, 177, 6, 70, "Output",
 CellTags->"Ex--21943492438155078303,30",
 CellID->3053]
}, Open  ]],
Cell[9058, 307, 244, 8, 70, "Input",
 CellTags->"Ex--21943492438155078303,31",
 CellID->17063],
Cell[9305, 317, 190, 6, 70, "Input",
 CellTags->"Ex--21943492438155078303,32",
 CellID->10681]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9544, 329, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9863, 340, 213, 6, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[10113, 351, 314, 9, 70, "TutorialsSection",
 CellID->28074],
Cell[10430, 362, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10720, 373, 429, 12, 70, "Tutorials",
 CellID->133710995],
Cell[11152, 387, 430, 12, 70, "Tutorials",
 CellID->133138080]
}, Open  ]],
Cell[CellGroupData[{
Cell[11619, 404, 318, 9, 70, "MoreAboutSection",
 CellID->44849869],
Cell[11940, 415, 187, 4, 70, "MoreAbout",
 CellID->10552229]
}, Open  ]],
Cell[12142, 422, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

