(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26799,        881]
NotebookOptionsPosition[     21889,        706]
NotebookOutlinePosition[     23459,        756]
CellTagsIndexPosition[     23324,        749]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Creating Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/CreatingTables"], 
          "Column Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure"], 
          "Column Representation in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure#2154"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Creating Tables in DatabaseLink User Guide\"\>", 
       3->"\<\"Column Structure in DatabaseLink User Guide\"\>", 
       4->"\<\"Column Representation in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLCreateTable" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLCreateTable"], 
          "SQLColumns" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumns"], 
          "SQLColumnNames" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumnNames"], 
          "SQLColumnInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLColumnInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SQLCreateTable\"\>", 
       2->"\<\"SQLColumns\"\>", 3->"\<\"SQLColumnNames\"\>", 
       4->"\<\"SQLColumnInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLColumn", "ObjectName",
 CellID->7540],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLColumn", "[", 
       StyleBox["\[Ellipsis]", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a column in an SQL table."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->24459],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DataLength\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "maximum length for variable length data", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DataTypeName\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["type of the entry", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nullable\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "whether the entry can be null", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->11622]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11885055],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->311703460],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->67001662],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->18493],

Cell["List the columns in a table:", "ExampleText",
 CellID->28596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", " ", "\"\<SAMPLETABLE1\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->7746]
}, Open  ]],

Cell["Select data matching a condition:", "ExampleText",
 CellID->10538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<SAMPLETABLE1\>\"", ",", " ", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<VALUE\>\"", "]"}], ">", "6"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "7.2`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6.2`", ",", "\<\"Day4\"\>"}], "}"}]}], "}"}]], "Output",\

 CellLabel->"Out[4]=",
 CellID->20538]
}, Open  ]],

Cell["Use a prepared statement:", "ExampleText",
 CellID->21476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT `1` FROM `2`\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLArgument", "[", 
      RowBox[{
       RowBox[{"SQLColumn", "[", "\"\<VALUE\>\"", "]"}], ",", 
       RowBox[{"SQLColumn", "[", "\"\<NAME\>\"", "]"}]}], "]"}], ",", " ", 
     RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.9`", ",", "\<\"Day2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.2`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.2`", ",", "\<\"Day4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.`", ",", "\<\"Day5\"\>"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->24917]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[6]:=",
 CellID->16371],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->183796411]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13758],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"DataTypeName\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15433],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->924363763],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->29065],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<TINYINTCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TINYINT\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<SMALLINTCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<SMALLINT\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<INTEGERCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<BIGINTCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BIGINT\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<NUMERICCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<NUMERIC\>\""}]}], "]"}], 
      ",", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<DECIMALCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DECIMAL\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<FLOATCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<FLOAT\>\""}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<REALCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<REAL\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<DOUBLECOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}], 
      ",", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<BITCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BIT\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<LONGVARBINARYCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<LONGVARBINARY\>\""}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<VARBINARYCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARBINARY\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<BINARYCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BINARY\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<LONGVARCHARCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<LONGVARCHAR\>\""}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<VARCHARCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARCHAR\>\""}], ",", "  ", 
        
        RowBox[{"\"\<DataLength\>\"", "\[Rule]", "5"}]}], "]"}], ",", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<CHARCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<CHAR\>\""}], ",", "  ", 
        RowBox[{"\"\<DataLength\>\"", "\[Rule]", "3"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<DATECOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DATE\>\""}]}], "]"}], ",", 
      
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<TIMECOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TIME\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<TIMESTAMPCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TIMESTAMP\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<OBJECTCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<OBJECT\>\""}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[3]:=",
 CellID->726],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->2401],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->3034]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"Nullable\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12759],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->386546273],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->30548],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<A\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}], ",", " ", 
        RowBox[{"\"\<Nullable\>\"", "->", "True"}]}], "]"}], ",", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<B\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}], ",", " ", 
        RowBox[{"\"\<Nullable\>\"", "->", "False"}]}], "]"}]}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[3]:=",
 CellID->27273],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->18792],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->16193]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"DataLength\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12933],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->115120593],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->17103],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<X\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARCHAR\>\""}], ",", " ", 
        RowBox[{"\"\<DataLength\>\"", "->", "5"}]}], "]"}], ",", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<Y\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<CHAR\>\""}], ",", " ", 
        RowBox[{"\"\<DataLength\>\"", "->", "3"}]}], "]"}]}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[3]:=",
 CellID->3690],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->28211],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->13694]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14398],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCreateTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumns",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumns"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumnNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumnInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27098],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Creating Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Column Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"]
}], "Tutorials",
 CellID->294321021],

Cell[TextData[{
 ButtonBox["Column Representation in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"]
}], "Tutorials",
 CellID->510020099]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLColumn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 34.7500978}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLColumn[...] represents a column in an SQL table.", "synonyms" -> {}, 
    "title" -> "SQLColumn", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLColumn"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4868, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->11885055]},
 "b:4.1.2"->{
  Cell[10579, 349, 4214, 92, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->726]},
 "b:6.4"->{
  Cell[15759, 485, 709, 18, 70, "Input",
   CellTags->"b:6.4",
   CellID->27273],
  Cell[17438, 547, 696, 18, 70, "Input",
   CellTags->"b:6.4",
   CellID->3690]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22908, 731},
 {"b:4.1.2", 23041, 735},
 {"b:6.4", 23137, 739}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2309, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2932, 78, 46, 1, 70, "ObjectName",
 CellID->7540],
Cell[2981, 81, 400, 12, 70, "Usage",
 CellID->18828]
}, Open  ]],
Cell[CellGroupData[{
Cell[3418, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3896, 115, 69, 1, 70, "Notes",
 CellID->24459],
Cell[3968, 118, 863, 21, 70, "3ColumnTableMod",
 CellID->11622]
}, Closed]],
Cell[CellGroupData[{
Cell[4868, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11885055],
Cell[CellGroupData[{
Cell[5252, 158, 148, 5, 70, "ExampleSection",
 CellID->311703460],
Cell[5403, 165, 134, 3, 70, "Input",
 CellID->67001662],
Cell[5540, 170, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5941, 182, 202, 7, 70, "Input",
 CellID->18493],
Cell[6146, 191, 67, 1, 70, "ExampleText",
 CellID->28596],
Cell[CellGroupData[{
Cell[6238, 196, 152, 4, 70, "Input",
 CellID->19161],
Cell[6393, 202, 1118, 26, 70, "Output",
 CellID->7746]
}, Open  ]],
Cell[7526, 231, 72, 1, 70, "ExampleText",
 CellID->10538],
Cell[CellGroupData[{
Cell[7623, 236, 242, 7, 70, "Input",
 CellID->7670],
Cell[7868, 245, 260, 9, 70, "Output",
 CellID->20538]
}, Open  ]],
Cell[8143, 257, 64, 1, 70, "ExampleText",
 CellID->21476],
Cell[CellGroupData[{
Cell[8232, 262, 461, 12, 70, "Input",
 CellID->21555],
Cell[8696, 276, 456, 14, 70, "Output",
 CellID->24917]
}, Open  ]],
Cell[9167, 293, 148, 5, 70, "Input",
 CellID->16371],
Cell[9318, 300, 402, 10, 70, "ExampleText",
 CellID->183796411]
}, Open  ]],
Cell[CellGroupData[{
Cell[9757, 315, 218, 7, 70, "ExampleSection",
 CellID->13758],
Cell[CellGroupData[{
Cell[10000, 326, 233, 7, 70, "ExampleSubsection",
 CellID->15433],
Cell[10236, 335, 135, 3, 70, "Input",
 CellID->924363763],
Cell[10374, 340, 202, 7, 70, "Input",
 CellID->29065],
Cell[10579, 349, 4214, 92, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->726],
Cell[14796, 443, 201, 7, 70, "Input",
 CellID->2401],
Cell[15000, 452, 147, 5, 70, "Input",
 CellID->3034]
}, Closed]],
Cell[CellGroupData[{
Cell[15184, 462, 229, 7, 70, "ExampleSubsection",
 CellID->12759],
Cell[15416, 471, 135, 3, 70, "Input",
 CellID->386546273],
Cell[15554, 476, 202, 7, 70, "Input",
 CellID->30548],
Cell[15759, 485, 709, 18, 70, "Input",
 CellTags->"b:6.4",
 CellID->27273],
Cell[16471, 505, 202, 7, 70, "Input",
 CellID->18792],
Cell[16676, 514, 148, 5, 70, "Input",
 CellID->16193]
}, Closed]],
Cell[CellGroupData[{
Cell[16861, 524, 231, 7, 70, "ExampleSubsection",
 CellID->12933],
Cell[17095, 533, 135, 3, 70, "Input",
 CellID->115120593],
Cell[17233, 538, 202, 7, 70, "Input",
 CellID->17103],
Cell[17438, 547, 696, 18, 70, "Input",
 CellTags->"b:6.4",
 CellID->3690],
Cell[18137, 567, 202, 7, 70, "Input",
 CellID->28211],
Cell[18342, 576, 148, 5, 70, "Input",
 CellID->13694]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18551, 588, 311, 9, 70, "SeeAlsoSection",
 CellID->14398],
Cell[18865, 599, 1044, 35, 70, "SeeAlso",
 CellID->3760]
}, Open  ]],
Cell[CellGroupData[{
Cell[19946, 639, 314, 9, 70, "TutorialsSection",
 CellID->27098],
Cell[20263, 650, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[20553, 661, 420, 12, 70, "Tutorials",
 CellID->133710995],
Cell[20976, 675, 424, 12, 70, "Tutorials",
 CellID->294321021],
Cell[21403, 689, 444, 12, 70, "Tutorials",
 CellID->510020099]
}, Open  ]],
Cell[21862, 704, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

