(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36121,       1062]
NotebookOptionsPosition[     29983,        840]
NotebookOutlinePosition[     32495,        922]
CellTagsIndexPosition[     32386,        916]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Creating Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/CreatingTables"], 
          "Column Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure"], 
          "Column Representation in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure#2154"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Creating Tables in DatabaseLink User Guide\"\>", 
       3->"\<\"Column Structure in DatabaseLink User Guide\"\>", 
       4->"\<\"Column Representation in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLCreateTable" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLCreateTable"], 
          "SQLColumn" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumn"], 
          "SQLColumns" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumns"], 
          "SQLColumnNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLColumnNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLCreateTable\"\>", 2->"\<\"SQLColumn\"\>", 
       3->"\<\"SQLColumns\"\>", 
       4->"\<\"SQLColumnNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Information\"\>", 
       2->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLColumnInformation", "ObjectName",
 CellID->29731],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLColumnInformation", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of information about the columns in an \
SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6747]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->7511],

Cell[BoxData[GridBox[{
   {"\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {"\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]},
   {"\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTable",
 CellID->5869]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184367257],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->615073529],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->33130138],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->14522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", "conn", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "10"}], "]"}], "&"}]}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[3]:=",
 CellID->31088],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "Null", ",", "\<\"INFORMATION_SCHEMA\"\>", ",", "\<\"SYSTEM_ALIASES\"\>",
       ",", "\<\"OBJECT_TYPE\"\>", ",", "12", ",", "\<\"VARCHAR\"\>", ",", 
      "32", ",", "64", ",", "Null", ",", "Null", ",", "0", 
      ",", "\<\"type of the aliased object: \\\"DOMAIN\\\" for data type \
aliases and \\\"ROUTINE\\\" for routine call aliases\"\>", ",", "Null", ",", 
      "12", ",", "Null", ",", "64", ",", "1", ",", "\<\"NO\"\>", ",", "Null", 
      ",", "Null", ",", "Null", ",", "Null", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "Null", ",", "\<\"INFORMATION_SCHEMA\"\>", ",", "\<\"SYSTEM_ALIASES\"\>",
       ",", "\<\"OBJECT_CAT\"\>", ",", "12", ",", "\<\"VARCHAR\"\>", ",", 
      "2147483647", ",", "Null", ",", "Null", ",", "Null", ",", "1", 
      ",", "\<\"catalog in which the aliased object is defined\"\>", ",", 
      "Null", ",", "12", ",", "Null", ",", "Null", ",", "2", 
      ",", "\<\"YES\"\>", ",", "Null", ",", "Null", ",", "Null", ",", "Null", 
      ",", "1"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "403", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "Null", ",", "\<\"PUBLIC\"\>", ",", "\<\"SAMPLETABLE1\"\>", 
      ",", "\<\"NAME\"\>", ",", "12", ",", "\<\"VARCHAR\"\>", ",", 
      "2147483647", ",", "Null", ",", "Null", ",", "Null", ",", "1", ",", 
      "Null", ",", "Null", ",", "12", ",", "Null", ",", "Null", ",", "3", 
      ",", "\<\"YES\"\>", ",", "Null", ",", "Null", ",", "Null", ",", "Null", 
      ",", "1"}], "}"}]}], "}"}],
  Short[#, 10]& ]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[3]//Short=",
 CellID->1563]
}, Open  ]],

Cell["\<\
Get information for all columns from tables whose names start with \"SA\":\
\>", "ExampleText",
 CellID->25834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", "\"\<SA%\>\""}], "]"}], " ", "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[4]:=",
 CellID->9850],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
     "4", "\<\"INTEGER\"\>", "Null", "4", "Null", "10", "1", "Null", "Null", 
     "4", "Null", "Null", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", "1", 
     "Null", "Null", "12", "Null", "Null", "3", "\<\"YES\"\>", "Null", "Null",
      "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[4]//TableForm=",
 CellID->17022]
}, Open  ]],

Cell["Get information for all columns from a particular table:", "ExampleText",
 CellID->7240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[5]:=",
 CellID->21911],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
     "4", "\<\"INTEGER\"\>", "Null", "4", "Null", "10", "1", "Null", "Null", 
     "4", "Null", "Null", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", "1", 
     "Null", "Null", "12", "Null", "Null", "3", "\<\"YES\"\>", "Null", "Null",
      "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[5]//TableForm=",
 CellID->9492]
}, Open  ]],

Cell["Here is another way:", "ExampleText",
 CellID->5651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<SAMPLETABLE1\>\"", ",", "\"\<%\>\""}], "}"}]}], "]"}], "//",
   "TableForm"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[6]:=",
 CellID->28580],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
     "4", "\<\"INTEGER\"\>", "Null", "4", "Null", "10", "1", "Null", "Null", 
     "4", "Null", "Null", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", "1", 
     "Null", "Null", "12", "Null", "Null", "3", "\<\"YES\"\>", "Null", "Null",
      "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[6]//TableForm=",
 CellID->15477]
}, Open  ]],

Cell["\<\
Get information for columns whose names begin with \"V\" from all tables:\
\>", "ExampleText",
 CellID->27616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<%\>\"", ",", "\"\<V%\>\""}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[7]:=",
 CellID->29876],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEWS\"\>", "\<\"VALID\
\"\>", "16", "\<\"BOOLEAN\"\>", "Null", "1", "Null", "Null", 
     "1", "\<\"{TRUE | FALSE}\"\>", "Null", "16", "Null", "Null", 
     "7", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SESSIONINFO\"\>", \
"\<\"VALUE\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", 
     "Null", "0", "\<\"VALUE: the value corresponding to the indicated key \
(see JavaDocs)\"\>", "Null", "12", "Null", "Null", "2", "\<\"NO\"\>", "Null", 
     "Null", "Null", "Null", "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TEXTTABLES\"\>", \
"\<\"VARCHAR_SEPARATOR\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", 
     "Null", "Null", "1", "\<\"varchar field separator\"\>", "Null", "12", 
     "Null", "Null", "8", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", "\<\"VIEW_CATALOG\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", 
     "1", "\<\"view catalog name\"\>", "Null", "12", "Null", "Null", 
     "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", \
"\<\"VIEW_CATALOG\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null",
      "Null", "1", "\<\"view catalog name\"\>", "Null", "12", "Null", "Null", 
     "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEWS\"\>", \
"\<\"VIEW_DEFINITION\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", 
     "Null", "Null", 
     "1", "\<\"the character representation of the query expression contained \
in the corresponding view descriptor.\"\>", "Null", "12", "Null", "Null", 
     "4", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", "\<\"VIEW_NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", 
     "1", "\<\"view identifier\"\>", "Null", "12", "Null", "Null", 
     "3", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", \
"\<\"VIEW_NAME\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", 
     "Null", "1", "\<\"view identifier\"\>", "Null", "12", "Null", "Null", 
     "3", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", "\<\"VIEW_SCHEMA\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", 
     "1", "\<\"view schema name\"\>", "Null", "12", "Null", "Null", 
     "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", \
"\<\"VIEW_SCHEMA\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", 
     "Null", "1", "\<\"view schema name\"\>", "Null", "12", "Null", "Null", 
     "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[7]//TableForm=",
 CellID->19178]
}, Open  ]],

Cell["Here is another way:", "ExampleText",
 CellID->5220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"SQLColumn", "[", "\"\<V%\>\"", "]"}]}], "]"}], " ", "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[8]:=",
 CellID->14615],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEWS\"\>", "\<\"VALID\
\"\>", "16", "\<\"BOOLEAN\"\>", "Null", "1", "Null", "Null", 
     "1", "\<\"{TRUE | FALSE}\"\>", "Null", "16", "Null", "Null", 
     "7", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SESSIONINFO\"\>", \
"\<\"VALUE\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", 
     "Null", "0", "\<\"VALUE: the value corresponding to the indicated key \
(see JavaDocs)\"\>", "Null", "12", "Null", "Null", "2", "\<\"NO\"\>", "Null", 
     "Null", "Null", "Null", "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TEXTTABLES\"\>", \
"\<\"VARCHAR_SEPARATOR\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", 
     "Null", "Null", "1", "\<\"varchar field separator\"\>", "Null", "12", 
     "Null", "Null", "8", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", "\<\"VIEW_CATALOG\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", 
     "1", "\<\"view catalog name\"\>", "Null", "12", "Null", "Null", 
     "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", \
"\<\"VIEW_CATALOG\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null",
      "Null", "1", "\<\"view catalog name\"\>", "Null", "12", "Null", "Null", 
     "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEWS\"\>", \
"\<\"VIEW_DEFINITION\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", 
     "Null", "Null", 
     "1", "\<\"the character representation of the query expression contained \
in the corresponding view descriptor.\"\>", "Null", "12", "Null", "Null", 
     "4", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", "\<\"VIEW_NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", 
     "1", "\<\"view identifier\"\>", "Null", "12", "Null", "Null", 
     "3", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", \
"\<\"VIEW_NAME\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", 
     "Null", "1", "\<\"view identifier\"\>", "Null", "12", "Null", "Null", 
     "3", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", "\<\"VIEW_SCHEMA\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", 
     "1", "\<\"view schema name\"\>", "Null", "12", "Null", "Null", 
     "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", \
"\<\"VIEW_SCHEMA\"\>", "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", 
     "Null", "1", "\<\"view schema name\"\>", "Null", "12", "Null", "Null", 
     "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[8]//TableForm=",
 CellID->22348]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[9]:=",
 CellID->26798],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->229073473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16857],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"ShowColumnHeadings\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2883],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->109935438],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->18902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", " ", "\"\<SA%\>\"", ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[3]:=",
 CellID->28262],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TABLE_CAT\"\>", "\<\"TABLE_SCHEM\"\>", "\<\"TABLE_NAME\"\>", \
"\<\"COLUMN_NAME\"\>", "\<\"DATA_TYPE\"\>", "\<\"TYPE_NAME\"\>", \
"\<\"COLUMN_SIZE\"\>", "\<\"BUFFER_LENGTH\"\>", "\<\"DECIMAL_DIGITS\"\>", "\<\
\"NUM_PREC_RADIX\"\>", "\<\"NULLABLE\"\>", "\<\"REMARKS\"\>", "\<\"COLUMN_DEF\
\"\>", "\<\"SQL_DATA_TYPE\"\>", "\<\"SQL_DATETIME_SUB\"\>", \
"\<\"CHAR_OCTET_LENGTH\"\>", "\<\"ORDINAL_POSITION\"\>", \
"\<\"IS_NULLABLE\"\>", "\<\"SCOPE_CATLOG\"\>", "\<\"SCOPE_SCHEMA\"\>", \
"\<\"SCOPE_TABLE\"\>", "\<\"SOURCE_DATA_TYPE\"\>", "\<\"TYPE_SUB\"\>"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
     "4", "\<\"INTEGER\"\>", "Null", "4", "Null", "10", "1", "Null", "Null", 
     "4", "Null", "Null", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", "1", 
     "Null", "Null", "12", "Null", "Null", "3", "\<\"YES\"\>", "Null", "Null",
      "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[3]//TableForm=",
 CellID->19420]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->19770]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14398],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCreateTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumns",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumns"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumnNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7103],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Creating Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Column Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"]
}], "Tutorials",
 CellID->294321021],

Cell[TextData[{
 ButtonBox["Column Representation in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"]
}], "Tutorials",
 CellID->510020099]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->202534658],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->61749819],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->276419829]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLColumnInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 32.4532375}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLColumnInformation[conn] returns a list of information about the \
columns in an SQL connection.", "synonyms" -> {}, "title" -> 
    "SQLColumnInformation", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLColumnInformation"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5500, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->184367257]},
 "b:3.3"->{
  Cell[6801, 212, 236, 8, 70, "Input",
   CellTags->"b:3.3",
   CellID->31088],
  Cell[7040, 222, 1692, 34, 70, "Output",
   CellTags->"b:3.3",
   CellID->1563],
  Cell[8893, 266, 208, 7, 70, "Input",
   CellTags->"b:3.3",
   CellID->9850],
  Cell[9104, 275, 1259, 29, 70, "Output",
   CellTags->"b:3.3",
   CellID->17022],
  Cell[10497, 312, 250, 8, 70, "Input",
   CellTags->"b:3.3",
   CellID->21911],
  Cell[10750, 322, 1258, 29, 70, "Output",
   CellTags->"b:3.3",
   CellID->9492],
  Cell[12106, 359, 277, 9, 70, "Input",
   CellTags->"b:3.3",
   CellID->28580],
  Cell[12386, 370, 1259, 29, 70, "Output",
   CellTags->"b:3.3",
   CellID->15477],
  Cell[13805, 409, 267, 9, 70, "Input",
   CellTags->"b:3.3",
   CellID->29876],
  Cell[14075, 420, 3884, 68, 70, "Output",
   CellTags->"b:3.3",
   CellID->19178],
  Cell[18057, 496, 246, 8, 70, "Input",
   CellTags->"b:3.3",
   CellID->14615],
  Cell[18306, 506, 3884, 68, 70, "Output",
   CellTags->"b:3.3",
   CellID->22348],
  Cell[23644, 635, 278, 8, 70, "Input",
   CellTags->"b:3.3",
   CellID->28262],
  Cell[23925, 645, 1823, 37, 70, "Output",
   CellTags->"b:3.3",
   CellID->19420]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31082, 866},
 {"b:3.3", 31214, 870}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3053, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3676, 97, 58, 1, 70, "ObjectName",
 CellID->29731],
Cell[3737, 100, 438, 13, 70, "Usage",
 CellID->6747]
}, Open  ]],
Cell[CellGroupData[{
Cell[4212, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4690, 135, 68, 1, 70, "Notes",
 CellID->7511],
Cell[4761, 138, 702, 20, 70, "3ColumnTable",
 CellID->5869]
}, Closed]],
Cell[CellGroupData[{
Cell[5500, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184367257],
Cell[CellGroupData[{
Cell[5885, 177, 148, 5, 70, "ExampleSection",
 CellID->615073529],
Cell[6036, 184, 134, 3, 70, "Input",
 CellID->33130138],
Cell[6173, 189, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6574, 201, 202, 7, 70, "Input",
 CellID->14522],
Cell[CellGroupData[{
Cell[6801, 212, 236, 8, 70, "Input",
 CellTags->"b:3.3",
 CellID->31088],
Cell[7040, 222, 1692, 34, 70, "Output",
 CellTags->"b:3.3",
 CellID->1563]
}, Open  ]],
Cell[8747, 259, 121, 3, 70, "ExampleText",
 CellID->25834],
Cell[CellGroupData[{
Cell[8893, 266, 208, 7, 70, "Input",
 CellTags->"b:3.3",
 CellID->9850],
Cell[9104, 275, 1259, 29, 70, "Output",
 CellTags->"b:3.3",
 CellID->17022]
}, Open  ]],
Cell[10378, 307, 94, 1, 70, "ExampleText",
 CellID->7240],
Cell[CellGroupData[{
Cell[10497, 312, 250, 8, 70, "Input",
 CellTags->"b:3.3",
 CellID->21911],
Cell[10750, 322, 1258, 29, 70, "Output",
 CellTags->"b:3.3",
 CellID->9492]
}, Open  ]],
Cell[12023, 354, 58, 1, 70, "ExampleText",
 CellID->5651],
Cell[CellGroupData[{
Cell[12106, 359, 277, 9, 70, "Input",
 CellTags->"b:3.3",
 CellID->28580],
Cell[12386, 370, 1259, 29, 70, "Output",
 CellTags->"b:3.3",
 CellID->15477]
}, Open  ]],
Cell[13660, 402, 120, 3, 70, "ExampleText",
 CellID->27616],
Cell[CellGroupData[{
Cell[13805, 409, 267, 9, 70, "Input",
 CellTags->"b:3.3",
 CellID->29876],
Cell[14075, 420, 3884, 68, 70, "Output",
 CellTags->"b:3.3",
 CellID->19178]
}, Open  ]],
Cell[17974, 491, 58, 1, 70, "ExampleText",
 CellID->5220],
Cell[CellGroupData[{
Cell[18057, 496, 246, 8, 70, "Input",
 CellTags->"b:3.3",
 CellID->14615],
Cell[18306, 506, 3884, 68, 70, "Output",
 CellTags->"b:3.3",
 CellID->22348]
}, Open  ]],
Cell[22205, 577, 148, 5, 70, "Input",
 CellID->26798],
Cell[22356, 584, 402, 10, 70, "ExampleText",
 CellID->229073473]
}, Open  ]],
Cell[CellGroupData[{
Cell[22795, 599, 218, 7, 70, "ExampleSection",
 CellID->16857],
Cell[CellGroupData[{
Cell[23038, 610, 238, 7, 70, "ExampleSubsection",
 CellID->2883],
Cell[23279, 619, 135, 3, 70, "Input",
 CellID->109935438],
Cell[23417, 624, 202, 7, 70, "Input",
 CellID->18902],
Cell[CellGroupData[{
Cell[23644, 635, 278, 8, 70, "Input",
 CellTags->"b:3.3",
 CellID->28262],
Cell[23925, 645, 1823, 37, 70, "Output",
 CellTags->"b:3.3",
 CellID->19420]
}, Open  ]],
Cell[25763, 685, 148, 5, 70, "Input",
 CellID->19770]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25972, 697, 311, 9, 70, "SeeAlsoSection",
 CellID->14398],
Cell[26286, 708, 1022, 35, 70, "SeeAlso",
 CellID->3760]
}, Open  ]],
Cell[CellGroupData[{
Cell[27345, 748, 313, 9, 70, "TutorialsSection",
 CellID->7103],
Cell[27661, 759, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[27951, 770, 420, 12, 70, "Tutorials",
 CellID->133710995],
Cell[28374, 784, 424, 12, 70, "Tutorials",
 CellID->294321021],
Cell[28801, 798, 444, 12, 70, "Tutorials",
 CellID->510020099]
}, Open  ]],
Cell[CellGroupData[{
Cell[29282, 815, 319, 9, 70, "MoreAboutSection",
 CellID->202534658],
Cell[29604, 826, 163, 3, 70, "MoreAbout",
 CellID->61749819],
Cell[29770, 831, 171, 4, 70, "MoreAbout",
 CellID->276419829]
}, Open  ]],
Cell[29956, 838, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

