(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15361,        539]
NotebookOptionsPosition[     11246,        394]
NotebookOutlinePosition[     13208,        457]
CellTagsIndexPosition[     13099,        451]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Transactions in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/Transactions#31020"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Transactions in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLBeginTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLBeginTransaction"], 
          "SQLRollbackTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLRollbackTransaction"], 
          "SQLSetSavepoint" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSetSavepoint"],
           "SQLSavepoint" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLSavepoint"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLBeginTransaction\"\>", 
       2->"\<\"SQLRollbackTransaction\"\>", 3->"\<\"SQLSetSavepoint\"\>", 
       4->"\<\"SQLSavepoint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLCommitTransaction", "ObjectName",
 CellID->3565],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLCommitTransaction", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox["commits an SQL transaction. ", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3872]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[StyleBox["A group of SQL commands grouped into a transaction \
will only take effect permanently when the transaction is committed. The \
transaction can be canceled or returned to a savepoint.", "Text"]], "Notes",
 CellID->832]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->309661719],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->388269350],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->23532320],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 RowBox[{
  RowBox[{"conn", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}]], "Input",\

 CellTags->"b:6.4",
 CellLabel->"In[2]:=",
 CellID->10883],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<X\>\"", ",", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<Integer\>\""}]}], 
       "]"}], ",", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<Y\>\"", ",", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<Integer\>\""}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[3]:=",
 CellID->24925],

Cell["Begin a transaction:", "ExampleText",
 CellID->21265],

Cell[BoxData[
 RowBox[{"SQLBeginTransaction", "[", "conn", "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[4]:=",
 CellID->31260],

Cell["Insert data:", "ExampleText",
 CellID->5045],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"61", ",", "80"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[5]:=",
 CellID->20778],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"72", ",", "5"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[6]:=",
 CellID->5821],

Cell["Commit the transaction:", "ExampleText",
 CellID->13855],

Cell[BoxData[
 RowBox[{"SQLCommitTransaction", "[", "conn", "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[7]:=",
 CellID->2520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", "\"\<TEST\>\""}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->12927],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"61", ",", "80"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->24773]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", "\"\<TEST\>\""}], "]"}], ";"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[9]:=",
 CellID->25134],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[10]:=",
 CellID->27251]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLBeginTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLBeginTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLRollbackTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLRollbackTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSetSavepoint",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSetSavepoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSavepoint",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSavepoint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30885],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Transactions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->655538936],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->28982989]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLCommitTransaction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 37.6719541}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLCommitTransaction[conn] commits an SQL transaction. ", 
    "synonyms" -> {}, "title" -> "SQLCommitTransaction", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLCommitTransaction"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4449, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->309661719]},
 "b:6.4"->{
  Cell[5523, 173, 187, 7, 70, "Input",
   CellTags->"b:6.4",
   CellID->10883],
  Cell[5713, 182, 584, 17, 70, "Input",
   CellTags->"b:6.4",
   CellID->24925],
  Cell[6362, 204, 134, 4, 70, "Input",
   CellTags->"b:6.4",
   CellID->31260],
  Cell[6552, 213, 337, 10, 70, "Input",
   CellTags->"b:6.4",
   CellID->20778],
  Cell[6892, 225, 335, 10, 70, "Input",
   CellTags->"b:6.4",
   CellID->5821],
  Cell[7295, 240, 134, 4, 70, "Input",
   CellTags->"b:6.4",
   CellID->2520],
  Cell[7823, 265, 180, 6, 70, "Input",
   CellTags->"b:6.4",
   CellID->25134],
  Cell[8006, 273, 134, 4, 70, "Input",
   CellTags->"b:6.4",
   CellID->27251]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12302, 419},
 {"b:6.4", 12434, 423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2550, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3173, 89, 57, 1, 70, "ObjectName",
 CellID->3565],
Cell[3233, 92, 422, 13, 70, "Usage",
 CellID->3872]
}, Open  ]],
Cell[CellGroupData[{
Cell[3692, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4170, 127, 242, 3, 70, "Notes",
 CellID->832]
}, Closed]],
Cell[CellGroupData[{
Cell[4449, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->309661719],
Cell[CellGroupData[{
Cell[4834, 149, 148, 5, 70, "ExampleSection",
 CellID->388269350],
Cell[4985, 156, 134, 3, 70, "Input",
 CellID->23532320],
Cell[5122, 161, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5523, 173, 187, 7, 70, "Input",
 CellTags->"b:6.4",
 CellID->10883],
Cell[5713, 182, 584, 17, 70, "Input",
 CellTags->"b:6.4",
 CellID->24925],
Cell[6300, 201, 59, 1, 70, "ExampleText",
 CellID->21265],
Cell[6362, 204, 134, 4, 70, "Input",
 CellTags->"b:6.4",
 CellID->31260],
Cell[6499, 210, 50, 1, 70, "ExampleText",
 CellID->5045],
Cell[6552, 213, 337, 10, 70, "Input",
 CellTags->"b:6.4",
 CellID->20778],
Cell[6892, 225, 335, 10, 70, "Input",
 CellTags->"b:6.4",
 CellID->5821],
Cell[7230, 237, 62, 1, 70, "ExampleText",
 CellID->13855],
Cell[7295, 240, 134, 4, 70, "Input",
 CellTags->"b:6.4",
 CellID->2520],
Cell[CellGroupData[{
Cell[7454, 248, 138, 4, 70, "Input",
 CellID->12927],
Cell[7595, 254, 213, 8, 70, "Output",
 CellID->24773]
}, Open  ]],
Cell[7823, 265, 180, 6, 70, "Input",
 CellTags->"b:6.4",
 CellID->25134],
Cell[8006, 273, 134, 4, 70, "Input",
 CellTags->"b:6.4",
 CellID->27251]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8189, 283, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8508, 294, 1065, 35, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[9610, 334, 314, 9, 70, "TutorialsSection",
 CellID->30885],
Cell[9927, 345, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10217, 356, 429, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[10683, 373, 319, 9, 70, "MoreAboutSection",
 CellID->655538936],
Cell[11005, 384, 199, 5, 70, "MoreAbout",
 CellID->28982989]
}, Open  ]],
Cell[11219, 392, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

