(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9322,        307]
NotebookOptionsPosition[      6830,        227]
NotebookOutlinePosition[      8186,        265]
CellTagsIndexPosition[      8102,        260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
    
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DatabaseLink User Guide" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
         "Connection Pools in DatabaseLink User Guide" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/tutorial/ConnectionPools"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
      2->"\<\"Connection Pools in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLConnectionPools", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLConnectionPools", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of the open connection pools."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLConnectionPools", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the connection pool used for a connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23154]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->823948203],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->101526907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", " ", "=", " ", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<publisher\>\"", ",", " ", 
    RowBox[{"UseConnectionPool", " ", "\[Rule]", " ", "True"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->410259035],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"publisher\"\>", ",", "6", ",", "\<\"Open\"\>"}], 
  "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->280075249]
}, Open  ]],

Cell["The connection pool used to connect to the database:", "ExampleText",
 CellID->489043954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pool", "=", 
  RowBox[{"SQLConnectionPools", "[", "conn", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482739374],

Cell[BoxData[
 RowBox[{"SQLConnectionPool", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{
      "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
       "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject299909580324865], ",", 
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", 
     ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
    "]"}], ",", "1", ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
   ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0_Thin\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\
\\DatabaseResources\\\\publisher.m\"\>"}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->927407452]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Connection Pools in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[Cell[BoxData[
 ButtonBox["OpenSQLConnection",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/OpenSQLConnection"]], "InlineFormula"]], \
"RelatedLinks",
 CellID->19895]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLConnectionPools - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 42.4687984}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLConnectionPools[] returns a list of the open connection pools. \
SQLConnectionPools[conn] returns the connection pool used for a connection.", 
    "synonyms" -> {}, "title" -> "SQLConnectionPools", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLConnectionPools"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2134, 70, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7968, 253}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 821, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1444, 46, 40, 0, 70, "ObjectName"],
Cell[1487, 48, 610, 17, 70, "Usage",
 CellID->23154]
}, Open  ]],
Cell[CellGroupData[{
Cell[2134, 70, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2511, 84, 148, 5, 70, "ExampleSection",
 CellID->823948203],
Cell[2662, 91, 135, 3, 70, "Input",
 CellID->101526907],
Cell[CellGroupData[{
Cell[2822, 98, 263, 7, 70, "Input",
 CellID->410259035],
Cell[3088, 107, 173, 5, 70, "Output",
 CellID->280075249]
}, Open  ]],
Cell[3276, 115, 95, 1, 70, "ExampleText",
 CellID->489043954],
Cell[CellGroupData[{
Cell[3396, 120, 143, 4, 70, "Input",
 CellID->482739374],
Cell[3542, 126, 1627, 35, 70, "Output",
 CellID->927407452]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5230, 168, 298, 8, 70, "TutorialsSection"],
Cell[5531, 178, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[5821, 189, 424, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[6282, 206, 305, 8, 70, "RelatedLinksSection"],
Cell[6590, 216, 198, 6, 70, "RelatedLinks",
 CellID->19895]
}, Open  ]],
Cell[6803, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

