(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12126,        419]
NotebookOptionsPosition[      9035,        313]
NotebookOutlinePosition[     10510,        358]
CellTagsIndexPosition[     10399,        352]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Database Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections"], 
          "Establishing a Connection in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#16139"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"Database Connections in DatabaseLink User Guide\"\>", 
       3->"\<\"Establishing a Connection in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "CloseSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/CloseSQLConnection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 
       2->"\<\"CloseSQLConnection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections and Resources" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Database Connections and Resources\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLConnections", "ObjectName",
 CellID->9507],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLConnections", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of the open ",
     Cell[BoxData["SQLConnection"], "InlineFormula"],
     " objects."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13993]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->117397623],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->79516607],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell["Create connections:", "ExampleText",
 CellID->10677],

Cell[BoxData[
 RowBox[{
  RowBox[{"conn1", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->119],

Cell[BoxData[
 RowBox[{
  RowBox[{"conn2", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29857],

Cell["List connections:", "ExampleText",
 CellID->23041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLConnections", "[", "]"}]], "Input",
 CellTags->"b:2.2.0",
 CellLabel->"In[4]:=",
 CellID->8891],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLConnection", "[", 
    RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>", 
     ",", "\<\"<>\"\>"}], "]"}], ",", 
   RowBox[{"SQLConnection", "[", 
    RowBox[{"\<\"publisher\"\>", ",", "2", ",", "\<\"Open\"\>", 
     ",", "\<\"<>\"\>"}], "]"}]}], "}"}]], "Output",
 CellTags->"b:2.2.0",
 CellLabel->"Out[4]=",
 CellID->25264]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn1", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->1623],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn2", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[6]:=",
 CellID->6915]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21284],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/CloseSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2944]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30259],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Database Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Establishing a Connection in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"]
}], "Tutorials",
 CellID->341678367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->178537980],

Cell[TextData[ButtonBox["Database Connections and Resources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->546486180]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLConnections - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 43.3594177}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLConnections[] returns a list of the open SQLConnection objects.", 
    "synonyms" -> {}, "title" -> "SQLConnections", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLConnections"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3636, 107, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:2.2.0"->{
  Cell[5190, 169, 122, 4, 70, "Input",
   CellTags->"b:2.2.0",
   CellID->8891],
  Cell[5315, 175, 385, 11, 70, "Output",
   CellTags->"b:2.2.0",
   CellID->25264]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10084, 338},
 {"b:2.2.0", 10210, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2493, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3116, 86, 51, 1, 70, "ObjectName",
 CellID->9507],
Cell[3170, 89, 429, 13, 70, "Usage",
 CellID->13993]
}, Open  ]],
Cell[CellGroupData[{
Cell[3636, 107, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4013, 121, 148, 5, 70, "ExampleSection",
 CellID->117397623],
Cell[4164, 128, 134, 3, 70, "Input",
 CellID->79516607],
Cell[4301, 133, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4702, 145, 58, 1, 70, "ExampleText",
 CellID->10677],
Cell[4763, 148, 166, 6, 70, "Input",
 CellID->119],
Cell[4932, 156, 174, 6, 70, "Input",
 CellID->29857],
Cell[5109, 164, 56, 1, 70, "ExampleText",
 CellID->23041],
Cell[CellGroupData[{
Cell[5190, 169, 122, 4, 70, "Input",
 CellTags->"b:2.2.0",
 CellID->8891],
Cell[5315, 175, 385, 11, 70, "Output",
 CellTags->"b:2.2.0",
 CellID->25264]
}, Open  ]],
Cell[5715, 189, 148, 5, 70, "Input",
 CellID->1623],
Cell[5866, 196, 148, 5, 70, "Input",
 CellID->6915]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6063, 207, 311, 9, 70, "SeeAlsoSection",
 CellID->21284],
Cell[6377, 218, 514, 17, 70, "SeeAlso",
 CellID->2944]
}, Open  ]],
Cell[CellGroupData[{
Cell[6928, 240, 314, 9, 70, "TutorialsSection",
 CellID->30259],
Cell[7245, 251, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[7535, 262, 440, 12, 70, "Tutorials",
 CellID->133710995],
Cell[7978, 276, 463, 12, 70, "Tutorials",
 CellID->341678367]
}, Open  ]],
Cell[CellGroupData[{
Cell[8478, 293, 319, 9, 70, "MoreAboutSection",
 CellID->178537980],
Cell[8800, 304, 193, 4, 70, "MoreAbout",
 CellID->546486180]
}, Open  ]],
Cell[9008, 311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

