(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24102,        692]
NotebookOptionsPosition[     20316,        562]
NotebookOutlinePosition[     21863,        608]
CellTagsIndexPosition[     21754,        602]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Data Type Mapping in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DataTypeMapping"], 
          "Supported Data Types in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SupportedDataTypes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Data Type Mapping in DatabaseLink User Guide\"\>", 
       3->"\<\"Supported Data Types in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLDataTypeNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLDataTypeNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLDataTypeNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Database Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLDataTypeInformation", "ObjectName",
 CellID->25020],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLDataTypeInformation", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox[
     "returns information about the data types that can be stored in an SQL \
connection.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10827]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->2554],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1988]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153267019],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11468607],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->173167158],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->7056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLDataTypeInformation", "[", "conn", "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.5",
 CellLabel->"In[3]:=",
 CellID->18509],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TINYINT\"\>", 
     RowBox[{"-", "6"}], "3", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"TINYINT\"\>", "0", "0", 
     RowBox[{"-", "6"}], "Null", "10", "1"},
    {"\<\"BIGINT\"\>", 
     RowBox[{"-", "5"}], "19", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "True", "\<\"BIGINT\"\>", "0", "0", "25", "Null", "10",
      "1"},
    {"\<\"LONGVARBINARY\"\>", 
     RowBox[{"-", "4"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"LONGVARBINARY\"\>", "Null", 
     "Null", "30", "Null", "Null", "1"},
    {"\<\"VARBINARY\"\>", 
     RowBox[{"-", "3"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"VARBINARY\"\>", "Null", 
     "Null", "30", "Null", "Null", "1"},
    {"\<\"BINARY\"\>", 
     RowBox[{"-", "2"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"BINARY\"\>", "Null", "Null", 
     "30", "Null", "Null", "1"},
    {"\<\"LONGVARCHAR\"\>", 
     RowBox[{"-", "1"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "True", "3", "Null", "Null", "Null", "\<\"LONGVARCHAR\"\>", "Null", 
     "Null", "40", "Null", "Null", "1"},
    {"\<\"CHAR\"\>", "1", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "Null", "Null", "Null", "\<\"CHAR\"\>", "Null", "Null", "1", "Null",
      "Null", "1"},
    {"\<\"NUMERIC\"\>", "2", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"NUMERIC\"\>", "0", "32767", "2", "Null", "10", "1"},
    {"\<\"DECIMAL\"\>", "3", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"DECIMAL\"\>", "0", "32767", "3", "Null", "10", "1"},
    {"\<\"INTEGER\"\>", "4", "10", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "True", "\<\"INTEGER\"\>", "0", "0", "4", "Null", "10",
      "1"},
    {"\<\"SMALLINT\"\>", "5", "5", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"SMALLINT\"\>", "0", "0", "5", "Null", 
     "10", "1"},
    {"\<\"FLOAT\"\>", "6", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"FLOAT\"\>", 
     RowBox[{"-", "324"}], "306", "6", "Null", "10", "1"},
    {"\<\"REAL\"\>", "7", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"REAL\"\>", 
     RowBox[{"-", "324"}], "306", "7", "Null", "10", "1"},
    {"\<\"DOUBLE\"\>", "8", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"DOUBLE\"\>", 
     RowBox[{"-", "324"}], "306", "8", "Null", "10", "1"},
    {"\<\"VARCHAR\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "False", 
     "3", "Null", "Null", "Null", "\<\"VARCHAR\"\>", "Null", "Null", "12", 
     "Null", "Null", "1"},
    {"\<\"VARCHAR_IGNORECASE\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "Null", "Null", "Null", "\<\"VARCHAR_IGNORECASE\"\>", "Null", 
     "Null", "12", "Null", "Null", "4"},
    {"\<\"BOOLEAN\"\>", "16", "1", "Null", "Null", "Null", "1", "False", "3", 
     "Null", "Null", "Null", "\<\"BOOLEAN\"\>", "Null", "Null", "16", "Null", 
     "Null", "1"},
    {"\<\"DATE\"\>", "91", "10", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"DATE\"\>", "0", "0", "9", "1",
      "Null", "1"},
    {"\<\"TIME\"\>", "92", "8", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"TIME\"\>", "Null", "Null", 
     "9", "2", "Null", "1"},
    {"\<\"TIMESTAMP\"\>", "93", "29", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"TIMESTAMP\"\>", "Null", 
     "Null", "9", "3", "Null", "1"},
    {"\<\"OTHER\"\>", "1111", "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", 
     "1", "True", "0", "Null", "Null", "Null", "\<\"OTHER\"\>", "Null", 
     "Null", "1111", "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.5",
 CellLabel->"Out[3]//TableForm=",
 CellID->29833]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->17708],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->403688063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20686],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"ShowColumnHeadings\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14804],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->887992895],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->10142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLDataTypeInformation", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "->", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18842],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TYPE_NAME\"\>", "\<\"DATA_TYPE\"\>", "\<\"PRECISION\"\>", \
"\<\"LITERAL_PREFIX\"\>", "\<\"LITERAL_SUFFIX\"\>", "\<\"CREATE_PARAMS\"\>", \
"\<\"NULLABLE\"\>", "\<\"CASE_SENSITIVE\"\>", "\<\"SEARCHABLE\"\>", \
"\<\"UNSIGNED_ATTRIBUTE\"\>", "\<\"FIXED_PREC_SCALE\"\>", "\<\"AUTO_INCREMENT\
\"\>", "\<\"LOCAL_TYPE_NAME\"\>", "\<\"MINIMUM_SCALE\"\>", "\<\"MAXIMUM_SCALE\
\"\>", "\<\"SQL_DATA_TYPE\"\>", "\<\"SQL_DATETIME_SUB\"\>", \
"\<\"NUM_PREC_RADIX\"\>", "\<\"TYPE_SUB\"\>"},
    {"\<\"TINYINT\"\>", 
     RowBox[{"-", "6"}], "3", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"TINYINT\"\>", "0", "0", 
     RowBox[{"-", "6"}], "Null", "10", "1"},
    {"\<\"BIGINT\"\>", 
     RowBox[{"-", "5"}], "19", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "True", "\<\"BIGINT\"\>", "0", "0", "25", "Null", "10",
      "1"},
    {"\<\"LONGVARBINARY\"\>", 
     RowBox[{"-", "4"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"LONGVARBINARY\"\>", "Null", 
     "Null", "30", "Null", "Null", "1"},
    {"\<\"VARBINARY\"\>", 
     RowBox[{"-", "3"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"VARBINARY\"\>", "Null", 
     "Null", "30", "Null", "Null", "1"},
    {"\<\"BINARY\"\>", 
     RowBox[{"-", "2"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"BINARY\"\>", "Null", "Null", 
     "30", "Null", "Null", "1"},
    {"\<\"LONGVARCHAR\"\>", 
     RowBox[{"-", "1"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "True", "3", "Null", "Null", "Null", "\<\"LONGVARCHAR\"\>", "Null", 
     "Null", "40", "Null", "Null", "1"},
    {"\<\"CHAR\"\>", "1", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "Null", "Null", "Null", "\<\"CHAR\"\>", "Null", "Null", "1", "Null",
      "Null", "1"},
    {"\<\"NUMERIC\"\>", "2", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"NUMERIC\"\>", "0", "32767", "2", "Null", "10", "1"},
    {"\<\"DECIMAL\"\>", "3", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"DECIMAL\"\>", "0", "32767", "3", "Null", "10", "1"},
    {"\<\"INTEGER\"\>", "4", "10", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "True", "\<\"INTEGER\"\>", "0", "0", "4", "Null", "10",
      "1"},
    {"\<\"SMALLINT\"\>", "5", "5", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"SMALLINT\"\>", "0", "0", "5", "Null", 
     "10", "1"},
    {"\<\"FLOAT\"\>", "6", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"FLOAT\"\>", 
     RowBox[{"-", "324"}], "306", "6", "Null", "10", "1"},
    {"\<\"REAL\"\>", "7", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"REAL\"\>", 
     RowBox[{"-", "324"}], "306", "7", "Null", "10", "1"},
    {"\<\"DOUBLE\"\>", "8", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"DOUBLE\"\>", 
     RowBox[{"-", "324"}], "306", "8", "Null", "10", "1"},
    {"\<\"VARCHAR\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "False", 
     "3", "Null", "Null", "Null", "\<\"VARCHAR\"\>", "Null", "Null", "12", 
     "Null", "Null", "1"},
    {"\<\"VARCHAR_IGNORECASE\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "Null", "Null", "Null", "\<\"VARCHAR_IGNORECASE\"\>", "Null", 
     "Null", "12", "Null", "Null", "4"},
    {"\<\"BOOLEAN\"\>", "16", "1", "Null", "Null", "Null", "1", "False", "3", 
     "Null", "Null", "Null", "\<\"BOOLEAN\"\>", "Null", "Null", "16", "Null", 
     "Null", "1"},
    {"\<\"DATE\"\>", "91", "10", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"DATE\"\>", "0", "0", "9", "1",
      "Null", "1"},
    {"\<\"TIME\"\>", "92", "8", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"TIME\"\>", "Null", "Null", 
     "9", "2", "Null", "1"},
    {"\<\"TIMESTAMP\"\>", "93", "29", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "Null", "Null", "Null", "\<\"TIMESTAMP\"\>", "Null", 
     "Null", "9", "3", "Null", "1"},
    {"\<\"OTHER\"\>", "1111", "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", 
     "1", "True", "0", "Null", "Null", "Null", "\<\"OTHER\"\>", "Null", 
     "Null", "1111", "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//TableForm=",
 CellID->17260]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->22161]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SQLDataTypeNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeNames"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13642],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Data Type Mapping in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Supported Data Types in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SupportedDataTypes"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SupportedDataTypes"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SupportedDataTypes"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->481432278],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->776460314]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLDataTypeInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 45.2344057}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLDataTypeInformation[conn] returns information about the data types \
that can be stored in an SQL connection.", "synonyms" -> {}, "title" -> 
    "SQLDataTypeInformation", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLDataTypeInformation"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4516, 142, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->153267019]},
 "b:3.5"->{
  Cell[5816, 191, 172, 6, 70, "Input",
   CellTags->"b:3.5",
   CellID->18509],
  Cell[5991, 199, 4665, 89, 70, "Output",
   CellTags->"b:3.5",
   CellID->29833]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21435, 588},
 {"b:3.5", 21567, 592}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2253, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2876, 82, 60, 1, 70, "ObjectName",
 CellID->25020],
Cell[2939, 85, 486, 15, 70, "Usage",
 CellID->10827]
}, Open  ]],
Cell[CellGroupData[{
Cell[3462, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3940, 122, 67, 1, 70, "Notes",
 CellID->2554],
Cell[4010, 125, 469, 12, 70, "3ColumnTableMod",
 CellID->1988]
}, Closed]],
Cell[CellGroupData[{
Cell[4516, 142, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153267019],
Cell[CellGroupData[{
Cell[4901, 156, 147, 5, 70, "ExampleSection",
 CellID->11468607],
Cell[5051, 163, 135, 3, 70, "Input",
 CellID->173167158],
Cell[5189, 168, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5590, 180, 201, 7, 70, "Input",
 CellID->7056],
Cell[CellGroupData[{
Cell[5816, 191, 172, 6, 70, "Input",
 CellTags->"b:3.5",
 CellID->18509],
Cell[5991, 199, 4665, 89, 70, "Output",
 CellTags->"b:3.5",
 CellID->29833]
}, Open  ]],
Cell[10671, 291, 148, 5, 70, "Input",
 CellID->17708],
Cell[10822, 298, 402, 10, 70, "ExampleText",
 CellID->403688063]
}, Open  ]],
Cell[CellGroupData[{
Cell[11261, 313, 218, 7, 70, "ExampleSection",
 CellID->20686],
Cell[CellGroupData[{
Cell[11504, 324, 239, 7, 70, "ExampleSubsection",
 CellID->14804],
Cell[11746, 333, 135, 3, 70, "Input",
 CellID->887992895],
Cell[11884, 338, 202, 7, 70, "Input",
 CellID->10142],
Cell[CellGroupData[{
Cell[12111, 349, 235, 7, 70, "Input",
 CellID->18842],
Cell[12349, 358, 5131, 95, 70, "Output",
 CellID->17260]
}, Open  ]],
Cell[17495, 456, 148, 5, 70, "Input",
 CellID->22161]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17704, 468, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18023, 479, 224, 6, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[18284, 490, 314, 9, 70, "TutorialsSection",
 CellID->13642],
Cell[18601, 501, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[18891, 512, 421, 12, 70, "Tutorials",
 CellID->14193],
Cell[19315, 526, 436, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[19788, 543, 319, 9, 70, "MoreAboutSection",
 CellID->481432278],
Cell[20110, 554, 164, 3, 70, "MoreAbout",
 CellID->776460314]
}, Open  ]],
Cell[20289, 560, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

