(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14896,        551]
NotebookOptionsPosition[     10530,        396]
NotebookOutlinePosition[     12431,        456]
CellTagsIndexPosition[     12320,        450]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSetClose\"\>", 
       3->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetGoto", "ObjectName",
 CellID->7104],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetGoto", "[", 
       RowBox[{
        StyleBox["rs", "TI"], ",", 
        StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current position of a result set to ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1768]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["SQLResultSetGoto", "MR"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if there is data at ",
 StyleBox["pos", "TI"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if there is no data."
}], "Notes",
 CellID->29768]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37709701],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->157737540],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->511932705],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->27918],

Cell["Open a result set:", "ExampleText",
 CellID->9625],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[3]:=",
 CellID->21219],

Cell["Go to the eighth row:", "ExampleText",
 CellID->17584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetGoto", "[", 
  RowBox[{"rs", ",", " ", "8"}], "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[4]:=",
 CellID->18174],

Cell[BoxData["True"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[4]=",
 CellID->10984]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[5]:=",
 CellID->10459],

Cell[BoxData["8"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[5]=",
 CellID->13149]
}, Open  ]],

Cell["Go to the beginning:", "ExampleText",
 CellID->17014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetGoto", "[", 
  RowBox[{"rs", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5695],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[6]=",
 CellID->12503]
}, Open  ]],

Cell["Go to the end:", "ExampleText",
 CellID->5032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetGoto", "[", 
  RowBox[{"rs", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->13851],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[7]=",
 CellID->1537]
}, Open  ]],

Cell["Close the result set:", "ExampleText",
 CellID->26814],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[8]:=",
 CellID->8363],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[9]:=",
 CellID->4651]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26641],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->218179006],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->884959419]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetGoto - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 57.1405795}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetGoto[rs, pos] sets the current position of a result set to \
pos.", "synonyms" -> {}, "title" -> "SQLResultSetGoto", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLResultSetGoto"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4529, 148, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37709701]},
 "b:6.2.3"->{
  Cell[5872, 198, 263, 9, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->21219],
  Cell[6223, 214, 159, 5, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->18174],
  Cell[6385, 221, 92, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->10984],
  Cell[6514, 229, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->10459],
  Cell[6652, 235, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->13149],
  Cell[7427, 276, 131, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->8363],
  Cell[7561, 282, 174, 6, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->4651]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11591, 421},
 {"b:6.2.3", 11724, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2355, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2978, 85, 53, 1, 70, "ObjectName",
 CellID->7104],
Cell[3034, 88, 539, 17, 70, "Usage",
 CellID->1768]
}, Open  ]],
Cell[CellGroupData[{
Cell[3610, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4088, 127, 404, 16, 70, "Notes",
 CellID->29768]
}, Closed]],
Cell[CellGroupData[{
Cell[4529, 148, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37709701],
Cell[CellGroupData[{
Cell[4913, 162, 148, 5, 70, "ExampleSection",
 CellID->157737540],
Cell[5064, 169, 135, 3, 70, "Input",
 CellID->511932705],
Cell[5202, 174, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5603, 186, 207, 7, 70, "Input",
 CellID->27918],
Cell[5813, 195, 56, 1, 70, "ExampleText",
 CellID->9625],
Cell[5872, 198, 263, 9, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->21219],
Cell[6138, 209, 60, 1, 70, "ExampleText",
 CellID->17584],
Cell[CellGroupData[{
Cell[6223, 214, 159, 5, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->18174],
Cell[6385, 221, 92, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->10984]
}, Open  ]],
Cell[CellGroupData[{
Cell[6514, 229, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->10459],
Cell[6652, 235, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->13149]
}, Open  ]],
Cell[6756, 241, 59, 1, 70, "ExampleText",
 CellID->17014],
Cell[CellGroupData[{
Cell[6840, 246, 131, 4, 70, "Input",
 CellID->5695],
Cell[6974, 252, 71, 2, 70, "Output",
 CellID->12503]
}, Open  ]],
Cell[7060, 257, 52, 1, 70, "ExampleText",
 CellID->5032],
Cell[CellGroupData[{
Cell[7137, 262, 139, 4, 70, "Input",
 CellID->13851],
Cell[7279, 268, 70, 2, 70, "Output",
 CellID->1537]
}, Open  ]],
Cell[7364, 273, 60, 1, 70, "ExampleText",
 CellID->26814],
Cell[7427, 276, 131, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->8363],
Cell[7561, 282, 174, 6, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->4651]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7784, 294, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8103, 305, 778, 26, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[8918, 336, 314, 9, 70, "TutorialsSection",
 CellID->26641],
Cell[9235, 347, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[9525, 358, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[9966, 375, 319, 9, 70, "MoreAboutSection",
 CellID->218179006],
Cell[10288, 386, 200, 5, 70, "MoreAbout",
 CellID->884959419]
}, Open  ]],
Cell[10503, 394, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

