(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17920,        685]
NotebookOptionsPosition[     12253,        478]
NotebookOutlinePosition[     14430,        548]
CellTagsIndexPosition[     14319,        542]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSetClose\"\>", 
       3->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetPosition", "ObjectName",
 CellID->18277],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetPosition", "[", 
       StyleBox["rs", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns an integer that specifies the current position \
in a result set."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5553]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->104837410],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->563679896],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->30397],

Cell["Open a result set:", "ExampleText",
 CellID->19751],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[3]:=",
 CellID->29001],

Cell["The initial position is always 0:", "ExampleText",
 CellID->435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[4]:=",
 CellID->16693],

Cell[BoxData["0"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[4]=",
 CellID->15072]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetGoto", "[", 
   RowBox[{"rs", ",", " ", "3"}], "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->17916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[6]:=",
 CellID->6716],

Cell[BoxData["3"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[6]=",
 CellID->25328]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetShift", "[", 
   RowBox[{"rs", ",", "2"}], "]"}], ";"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[7]:=",
 CellID->1511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[8]:=",
 CellID->32125],

Cell[BoxData["5"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[8]=",
 CellID->11838]
}, Open  ]],

Cell["Close the connection:", "ExampleText",
 CellID->18939],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[9]:=",
 CellID->11544],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[10]:=",
 CellID->1056]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->65218090],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->24588],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12021],

Cell["There is no data at position 0:", "ExampleText",
 CellID->22586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14108],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[4]=",
 CellID->29777]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->12628],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"No data is available\\\"\\)\"\>"}]], "Message", "MSG",
 CellID->21979],

Cell[BoxData["$Failed"], "Output",
 CellLabel->"Out[5]=",
 CellID->26947]
}, Open  ]],

Cell["There is no data at the end of the result set:", "ExampleText",
 CellID->12549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetGoto", "[", 
  RowBox[{"rs", ",", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1280],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[6]=",
 CellID->13245]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->25128],

Cell[BoxData["52"], "Output",
 CellLabel->"Out[7]=",
 CellID->14062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->10426],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"No data is available\\\"\\)\"\>"}]], "Message", "MSG",
 CellID->4719],

Cell[BoxData["$Failed"], "Output",
 CellLabel->"Out[8]=",
 CellID->10677]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->29091],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[10]:=",
 CellID->4047]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13976],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->164261],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->53117858]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetPosition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 59.1249418}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetPosition[rs] returns an integer that specifies the current \
position in a result set.", "synonyms" -> {}, "title" -> 
    "SQLResultSetPosition", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLResultSetPosition"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3514, 106, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:6.2.3"->{
  Cell[4851, 156, 263, 9, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->29001],
  Cell[5212, 172, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->16693],
  Cell[5350, 178, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->15072],
  Cell[5635, 193, 134, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->6716],
  Cell[5772, 199, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->25328],
  Cell[5876, 205, 173, 6, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->1511],
  Cell[6074, 215, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->32125],
  Cell[6212, 221, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->11838],
  Cell[6379, 230, 132, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->11544],
  Cell[6514, 236, 189, 7, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->1056]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13352, 504},
 {"b:6.2.3", 13478, 508}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2355, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2978, 85, 58, 1, 70, "ObjectName",
 CellID->18277],
Cell[3039, 88, 438, 13, 70, "Usage",
 CellID->5553]
}, Open  ]],
Cell[CellGroupData[{
Cell[3514, 106, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3891, 120, 148, 5, 70, "ExampleSection",
 CellID->104837410],
Cell[4042, 127, 135, 3, 70, "Input",
 CellID->563679896],
Cell[4180, 132, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4581, 144, 207, 7, 70, "Input",
 CellID->30397],
Cell[4791, 153, 57, 1, 70, "ExampleText",
 CellID->19751],
Cell[4851, 156, 263, 9, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->29001],
Cell[5117, 167, 70, 1, 70, "ExampleText",
 CellID->435],
Cell[CellGroupData[{
Cell[5212, 172, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->16693],
Cell[5350, 178, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->15072]
}, Open  ]],
Cell[5454, 184, 156, 5, 70, "Input",
 CellID->17916],
Cell[CellGroupData[{
Cell[5635, 193, 134, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->6716],
Cell[5772, 199, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->25328]
}, Open  ]],
Cell[5876, 205, 173, 6, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->1511],
Cell[CellGroupData[{
Cell[6074, 215, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->32125],
Cell[6212, 221, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->11838]
}, Open  ]],
Cell[6316, 227, 60, 1, 70, "ExampleText",
 CellID->18939],
Cell[6379, 230, 132, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->11544],
Cell[6514, 236, 189, 7, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->1056]
}, Open  ]],
Cell[CellGroupData[{
Cell[6740, 248, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[6974, 257, 134, 3, 70, "Input",
 CellID->65218090],
Cell[7111, 262, 207, 7, 70, "Input",
 CellID->24588],
Cell[7321, 271, 236, 8, 70, "Input",
 CellID->12021],
Cell[7560, 281, 70, 1, 70, "ExampleText",
 CellID->22586],
Cell[CellGroupData[{
Cell[7655, 286, 113, 3, 70, "Input",
 CellID->14108],
Cell[7771, 291, 67, 2, 70, "Output",
 CellID->29777]
}, Open  ]],
Cell[CellGroupData[{
Cell[7875, 298, 112, 3, 70, "Input",
 CellID->12628],
Cell[7990, 303, 165, 4, 70, "Message",
 CellID->21979],
Cell[8158, 309, 73, 2, 70, "Output",
 CellID->26947]
}, Open  ]],
Cell[8246, 314, 85, 1, 70, "ExampleText",
 CellID->12549],
Cell[CellGroupData[{
Cell[8356, 319, 143, 4, 70, "Input",
 CellID->1280],
Cell[8502, 325, 71, 2, 70, "Output",
 CellID->13245]
}, Open  ]],
Cell[CellGroupData[{
Cell[8610, 332, 113, 3, 70, "Input",
 CellID->25128],
Cell[8726, 337, 68, 2, 70, "Output",
 CellID->14062]
}, Open  ]],
Cell[CellGroupData[{
Cell[8831, 344, 112, 3, 70, "Input",
 CellID->10426],
Cell[8946, 349, 164, 4, 70, "Message",
 CellID->4719],
Cell[9113, 355, 73, 2, 70, "Output",
 CellID->10677]
}, Open  ]],
Cell[9201, 360, 110, 3, 70, "Input",
 CellID->29091],
Cell[9314, 365, 148, 5, 70, "Input",
 CellID->4047]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9511, 376, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9830, 387, 778, 26, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[10645, 418, 314, 9, 70, "TutorialsSection",
 CellID->13976],
Cell[10962, 429, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[11252, 440, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[11693, 457, 316, 9, 70, "MoreAboutSection",
 CellID->164261],
Cell[12012, 468, 199, 5, 70, "MoreAbout",
 CellID->53117858]
}, Open  ]],
Cell[12226, 476, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

