(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10235,        369]
NotebookOptionsPosition[      7465,        275]
NotebookOutlinePosition[      8726,        312]
CellTagsIndexPosition[      8642,        307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSetClose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSets", "ObjectName",
 CellID->13647],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     " ",
     Cell[BoxData[
      RowBox[{"SQLResultSets", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of the open ",
     Cell[BoxData["SQLResultSet"], "InlineFormula"],
     " objects."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15618]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->141675788],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->253409729],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->9090],

Cell["Open two result sets:", "ExampleText",
 CellID->9034],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs1", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7915],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs2", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<titleauthors\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6286],

Cell["List the open result sets:", "ExampleText",
 CellID->3523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSets", "[", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLResultSet", "[", 
    RowBox[{"1", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], "]"}], ",", 
   RowBox[{"SQLResultSet", "[", 
    RowBox[{"2", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->1344]
}, Open  ]],

Cell["Close the result sets:", "ExampleText",
 CellID->32736],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs1", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->22037],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs2", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->5416],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[8]:=",
 CellID->5893]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25013],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15712],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 2.1717973}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSets[] returns a list of the open SQLResultSet objects.", 
    "synonyms" -> {}, "title" -> "SQLResultSets", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLResultSets"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2711, 87, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8508, 300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1560, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2183, 65, 51, 1, 70, "ObjectName",
 CellID->13647],
Cell[2237, 68, 437, 14, 70, "Usage",
 CellID->15618]
}, Open  ]],
Cell[CellGroupData[{
Cell[2711, 87, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3088, 101, 148, 5, 70, "ExampleSection",
 CellID->141675788],
Cell[3239, 108, 135, 3, 70, "Input",
 CellID->253409729],
Cell[3377, 113, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[3778, 125, 206, 7, 70, "Input",
 CellID->9090],
Cell[3987, 134, 59, 1, 70, "ExampleText",
 CellID->9034],
Cell[4049, 137, 241, 8, 70, "Input",
 CellID->7915],
Cell[4293, 147, 245, 8, 70, "Input",
 CellID->6286],
Cell[4541, 157, 64, 1, 70, "ExampleText",
 CellID->3523],
Cell[CellGroupData[{
Cell[4630, 162, 100, 3, 70, "Input",
 CellID->20666],
Cell[4733, 167, 316, 9, 70, "Output",
 CellID->1344]
}, Open  ]],
Cell[5064, 179, 61, 1, 70, "ExampleText",
 CellID->32736],
Cell[5128, 182, 111, 3, 70, "Input",
 CellID->22037],
Cell[5242, 187, 110, 3, 70, "Input",
 CellID->5416],
Cell[5355, 192, 147, 5, 70, "Input",
 CellID->5893]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5551, 203, 311, 9, 70, "SeeAlsoSection",
 CellID->25013],
Cell[5865, 214, 510, 17, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[6412, 236, 314, 9, 70, "TutorialsSection",
 CellID->15712],
Cell[6729, 247, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[7019, 258, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[7438, 273, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

