(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9974,        322]
NotebookOptionsPosition[      7934,        258]
NotebookOutlinePosition[      9105,        289]
CellTagsIndexPosition[      9062,        286]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Transactions in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/Transactions#31020"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Transactions in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLBeginTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLBeginTransaction"], 
          "SQLCommitTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCommitTransaction"], "SQLSetSavepoint" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSetSavepoint"],
           "SQLSavepoint" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLSavepoint"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLBeginTransaction\"\>", 
       2->"\<\"SQLCommitTransaction\"\>", 3->"\<\"SQLSetSavepoint\"\>", 
       4->"\<\"SQLSavepoint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLRollbackTransaction", "ObjectName",
 CellID->21856],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLRollbackTransaction", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox["terminates an SQL transaction. \n", "Text"],
     Cell[BoxData[
      RowBox[{"SQLRollbackTransaction", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", " ", 
        StyleBox["savepoint", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox["returns to an ", "Text"],
     Cell[BoxData[
      ButtonBox["SQLSavepoint",
       BaseStyle->"Link",
       ButtonData->"paclet:DatabaseLink/ref/SQLSavepoint"]], "InlineFormula"],
     
     StyleBox[".", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[StyleBox["A group of SQL commands grouped into a transaction \
will only take effect permanently when the transaction is committed. The \
transaction can be canceled or returned to a savepoint.", "Text"]], "Notes",
 CellID->832]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5939],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLBeginTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLBeginTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCommitTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCommitTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSetSavepoint",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSetSavepoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSavepoint",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSavepoint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9290],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Transactions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->95558335],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->129632660]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLRollbackTransaction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 4.0155355}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLRollbackTransaction[conn] terminates an SQL transaction. \
SQLRollbackTransaction[conn, savepoint] returns to an SQLSavepoint.", 
    "synonyms" -> {}, "title" -> "SQLRollbackTransaction", "type" -> "Symbol",
     "uri" -> "DatabaseLink/ref/SQLRollbackTransaction"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2533, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3156, 88, 60, 1, 70, "ObjectName",
 CellID->21856],
Cell[3219, 91, 875, 26, 70, "Usage",
 CellID->18061]
}, Open  ]],
Cell[CellGroupData[{
Cell[4131, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4609, 139, 242, 3, 70, "Notes",
 CellID->832]
}, Closed]],
Cell[CellGroupData[{
Cell[4888, 147, 310, 9, 70, "SeeAlsoSection",
 CellID->5939],
Cell[5201, 158, 1061, 35, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[6299, 198, 313, 9, 70, "TutorialsSection",
 CellID->9290],
Cell[6615, 209, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[6905, 220, 429, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[7371, 237, 318, 9, 70, "MoreAboutSection",
 CellID->95558335],
Cell[7692, 248, 200, 5, 70, "MoreAbout",
 CellID->129632660]
}, Open  ]],
Cell[7907, 256, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

