(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10423,        362]
NotebookOptionsPosition[      7705,        274]
NotebookOutlinePosition[      9034,        312]
CellTagsIndexPosition[      8950,        307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Schema and Catalogs in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SchemaAndCatalogs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Schema and Catalogs in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLSchemaNames" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSchemaNames"], 
          "SQLCatalogNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCatalogNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLSchemaNames\"\>", 
       2->"\<\"SQLCatalogNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLSchemaInformation", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLSchemaInformation", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns information about the schemas available \
through an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->83221961],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->606614420]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25102262],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->63120077],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->166473306],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->13774],

Cell["\<\
This returns the schema details for this database connection.\
\>", "ExampleText",
 CellID->9314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSchemaInformation", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"INFORMATION_SCHEMA\"\>", ",", "Null", ",", "False"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PUBLIC\"\>", ",", "Null", ",", "True"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->6824400]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->19911]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSchemaNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSchemaNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCatalogNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCatalogNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Schema and Catalogs in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SchemaAndCatalogs"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SchemaAndCatalogs"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SchemaAndCatalogs"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLSchemaInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 5.7655243}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLSchemaInformation[conn] returns information about the schemas \
available through an SQL connection.", "synonyms" -> {}, "title" -> 
    "SQLSchemaInformation", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLSchemaInformation"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3767, 121, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25102262]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8808, 300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1570, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2193, 65, 42, 0, 70, "ObjectName"],
Cell[2238, 67, 429, 12, 70, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2704, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3182, 101, 71, 1, 70, "Notes",
 CellID->83221961],
Cell[3256, 104, 474, 12, 70, "3ColumnTableMod",
 CellID->606614420]
}, Closed]],
Cell[CellGroupData[{
Cell[3767, 121, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25102262],
Cell[CellGroupData[{
Cell[4151, 135, 147, 5, 70, "ExampleSection",
 CellID->63120077],
Cell[4301, 142, 135, 3, 70, "Input",
 CellID->166473306],
Cell[4439, 147, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4840, 159, 207, 7, 70, "Input",
 CellID->13774],
Cell[5050, 168, 107, 3, 70, "ExampleText",
 CellID->9314],
Cell[CellGroupData[{
Cell[5182, 175, 115, 3, 70, "Input",
 CellID->20173],
Cell[5300, 180, 290, 10, 70, "Output",
 CellID->6824400]
}, Open  ]],
Cell[5605, 193, 148, 5, 70, "Input",
 CellID->19911]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5802, 204, 295, 8, 70, "SeeAlsoSection"],
Cell[6100, 214, 502, 17, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[6639, 236, 298, 8, 70, "TutorialsSection"],
Cell[6940, 246, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[7230, 257, 433, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[7678, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

