(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83520,       2649]
NotebookOptionsPosition[     71188,       2196]
NotebookOutlinePosition[     76294,       2366]
CellTagsIndexPosition[     76181,       2360]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Selecting Data in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SelectingData"], 
          "Selecting Data with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLSelectingData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Selecting Data in DatabaseLink User Guide\"\>", 
       3->"\<\"Selecting Data with Raw SQL in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"], 
          "SQLDelete" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDelete"], 
          "SQLInsert" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLInsert"], 
          "SQLUpdate" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLUpdate"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLExecute\"\>", 
       2->"\<\"SQLDelete\"\>", 3->"\<\"SQLInsert\"\>", 
       4->"\<\"SQLUpdate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"SQL Data Access and Manipulation\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLSelect", "ObjectName",
 CellID->8144],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLSelect", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]extracts data from a table in an SQL connection. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLSelect", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"], ",", 
        StyleBox["cols", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]extracts data from particular columns."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLSelect", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"], ",", 
        StyleBox["cols", "TI"], ",", 
        StyleBox["cond", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]only extracts data that matches ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->29334],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Distinct\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return only distinct results", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GetAsStrings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return the results as strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaxRows\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of rows to return", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SortingColumns\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to sort the data", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->15296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389810981],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->321297905],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->751520975],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<publisher\>\"", "]"}]}], 
   ";"}], "InputDeemphasis"]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[2]:=",
 CellID->31641],

Cell["Select all data from a table:", "ExampleText",
 CellID->13465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[3]:=",
 CellID->16191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "4001", ",", "50000", ",", "0.16`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "7001", ",", "50000", ",", "0.18`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "5001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "5001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "2001", ",", "6000", ",", "0.14`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "6001", ",", "8000", ",", "0.18`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "8001", ",", "50000", ",", "0.2`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "6000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "6001", ",", "8000", ",", "0.16`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "8001", ",", "50000", ",", "0.16`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "2001", ",", "6000", ",", "0.14`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "6001", ",", "8000", ",", "0.18`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "8001", ",", "50000", ",", "0.2`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0", ",", "4000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "8001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "4001", ",", "8000", ",", "0.14`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "8001", ",", "12000", ",", "0.16`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "15000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "8001", ",", "16000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[3]=",
 CellID->22471]
}, Open  ]],

Cell["Select only certain columns:", "ExampleText",
 CellID->6259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[4]:=",
 CellID->23700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[4]=",
 CellID->20217]
}, Open  ]],

Cell["Join data from multiple tables:", "ExampleText",
 CellID->2016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLES\>\"", ",", "\"\<ROYSCHED\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE\>\""}], "}"}], ",", " ",
       
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"\"\<ROYSCHED\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}]}], 
     "}"}], ",", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], "]"}],
      " ", "==", " ", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<ROYSCHED\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], 
      "]"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", " ", "15"}], "]"}], "&"}]}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[5]:=",
 CellID->1943],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Designer Class Action Suits\"\>", ",", "\<\"BS1001\"\>", 
      ",", "0.1`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Designer Class Action Suits\"\>", ",", "\<\"BS1001\"\>", 
      ",", "0.12`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Designer Class Action Suits\"\>", ",", "\<\"BS1001\"\>", 
      ",", "0.16`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Designer Class Action Suits\"\>", ",", "\<\"BS1001\"\>", 
      ",", "0.18`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Self Hypnosis: A Beginner's Guide\"\>", 
      ",", "\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Self Hypnosis: A Beginner's Guide\"\>", 
      ",", "\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Self Hypnosis: A Beginner's Guide\"\>", 
      ",", "\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Phobic Psychology\"\>", ",", "\<\"PY2003\"\>", ",", 
      "0.1`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Phobic Psychology\"\>", ",", "\<\"PY2003\"\>", ",", 
      "0.12`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Phobic Psychology\"\>", ",", "\<\"PY2003\"\>", ",", 
      "0.14`"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "30", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Treasures of the Sierra Madre\"\>", ",", "\<\"UK3015\"\>", 
      ",", "0.14`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Treasures of the Sierra Madre\"\>", ",", "\<\"UK3015\"\>", 
      ",", "0.16`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Too Many Cooks\"\>", ",", "\<\"CK4016\"\>", ",", "0.1`"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Too Many Cooks\"\>", ",", "\<\"CK4016\"\>", ",", "0.12`"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Let Them Eat Cake!\"\>", ",", "\<\"CK4017\"\>", ",", 
      "0.1`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Let Them Eat Cake!\"\>", ",", "\<\"CK4017\"\>", ",", 
      "0.12`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Let Them Eat Cake!\"\>", ",", "\<\"CK4017\"\>", ",", 
      "0.14`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Sticky Software: UI and GUI\"\>", ",", "\<\"CP5018\"\>", 
      ",", "0.1`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Sticky Software: UI and GUI\"\>", ",", "\<\"CP5018\"\>", 
      ",", "0.12`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Sticky Software: UI and GUI\"\>", ",", "\<\"CP5018\"\>", 
      ",", "0.16`"}], "}"}]}], "}"}],
  Short[#, 15]& ]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[5]//Short=",
 CellID->14624]
}, Open  ]],

Cell["Select data matching a condition:", "ExampleText",
 CellID->17064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   " ", 
   RowBox[{".10", "<", " ", 
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "<", " ", 
    ".15"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[6]:=",
 CellID->31505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[6]=",
 CellID->1157]
}, Open  ]],

Cell["Select data matching a pattern:", "ExampleText",
 CellID->31502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLStringMatchQ", "[", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], ",", " ", 
     "\"\<C%\>\""}], "]"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[7]:=",
 CellID->7666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[7]=",
 CellID->9275]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLStringMatchQ", "[", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], ",", " ", 
     "\"\<_S%\>\""}], "]"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[8]:=",
 CellID->32046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[8]=",
 CellID->17632]
}, Open  ]],

Cell["Select data matching a list:", "ExampleText",
 CellID->29789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLMemberQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".14", ",", " ", ".16"}], "}"}], ",", " ", 
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[9]:=",
 CellID->6046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[9]=",
 CellID->2145]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[10]:=",
 CellID->6003],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->31901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8326],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->231022036],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->21184],

Cell["Select data matching a condition:", "ExampleText",
 CellID->19649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   " ", 
   RowBox[{".13", " ", ">", " ", 
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", ">", " ", 
    ".10"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[3]:=",
 CellID->30350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[3]=",
 CellID->10405]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[4]:=",
 CellID->24346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[4]=",
 CellID->1025]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "!=", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[5]:=",
 CellID->28970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[5]=",
 CellID->14336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", ">", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[6]:=",
 CellID->4795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[6]=",
 CellID->9793]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "<", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[7]:=",
 CellID->11323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[7]=",
 CellID->5532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", ">=", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[8]:=",
 CellID->28856],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[8]=",
 CellID->15896]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "<=", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[9]:=",
 CellID->3210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[9]=",
 CellID->17776]
}, Open  ]],

Cell[TextData[{
 "Combine conditions using ",
 StyleBox["And", "MR"],
 " and ",
 StyleBox["Or", "MR"],
 ":"
}], "ExampleText",
 CellID->5692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<TITLE_ID\>\"", ",", " ", "\"\<LORANGE\>\"", ",", "\"\<ROYALTY\>\""}],
     "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
     ".12"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<LORANGE\>\"", "]"}], " ", ">", " ", 
     "1000"}]}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[10]:=",
 CellID->14550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "0.12`"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[10]=",
 CellID->15290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
     ".12"}], " ", "||", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
     ".14"}]}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[11]:=",
 CellID->13795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[11]=",
 CellID->13852]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[12]:=",
 CellID->17350]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8315],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"ShowColummnHeadings\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10036],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->9546625],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->3760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "->", "True"}]}], "]"}], " ", "//", 
  "TableForm"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[3]:=",
 CellID->9984],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TITLE_ID\"\>", "\<\"ROYALTY\"\>"},
    {"\<\"BS1011\"\>", "0.1`"},
    {"\<\"BS1011\"\>", "0.12`"},
    {"\<\"CP5018\"\>", "0.1`"},
    {"\<\"CP5018\"\>", "0.12`"},
    {"\<\"CP5018\"\>", "0.16`"},
    {"\<\"BS1001\"\>", "0.1`"},
    {"\<\"BS1001\"\>", "0.12`"},
    {"\<\"BS1001\"\>", "0.16`"},
    {"\<\"BS1001\"\>", "0.18`"},
    {"\<\"PS9999\"\>", "0.1`"},
    {"\<\"PY2002\"\>", "0.1`"},
    {"\<\"PY2002\"\>", "0.12`"},
    {"\<\"PY2002\"\>", "0.14`"},
    {"\<\"PY2003\"\>", "0.1`"},
    {"\<\"PY2003\"\>", "0.12`"},
    {"\<\"PY2003\"\>", "0.14`"},
    {"\<\"UK3004\"\>", "0.1`"},
    {"\<\"UK3004\"\>", "0.12`"},
    {"\<\"UK3004\"\>", "0.14`"},
    {"\<\"UK3004\"\>", "0.18`"},
    {"\<\"UK3004\"\>", "0.2`"},
    {"\<\"CK4005\"\>", "0.1`"},
    {"\<\"CK4005\"\>", "0.12`"},
    {"\<\"CK4005\"\>", "0.16`"},
    {"\<\"CK4005\"\>", "0.16`"},
    {"\<\"CP5010\"\>", "0.1`"},
    {"\<\"CP5010\"\>", "0.12`"},
    {"\<\"PY2012\"\>", "0.1`"},
    {"\<\"PY2012\"\>", "0.12`"},
    {"\<\"PY2013\"\>", "0.1`"},
    {"\<\"PY2013\"\>", "0.12`"},
    {"\<\"UK3006\"\>", "0.1`"},
    {"\<\"UK3006\"\>", "0.12`"},
    {"\<\"UK3006\"\>", "0.14`"},
    {"\<\"UK3006\"\>", "0.18`"},
    {"\<\"UK3006\"\>", "0.2`"},
    {"\<\"BS1014\"\>", "0.1`"},
    {"\<\"BS1014\"\>", "0.12`"},
    {"\<\"BS1014\"\>", "0.14`"},
    {"\<\"UK3015\"\>", "0.1`"},
    {"\<\"UK3015\"\>", "0.12`"},
    {"\<\"UK3015\"\>", "0.14`"},
    {"\<\"UK3015\"\>", "0.16`"},
    {"\<\"CK4016\"\>", "0.1`"},
    {"\<\"CK4016\"\>", "0.12`"},
    {"\<\"CK4017\"\>", "0.1`"},
    {"\<\"CK4017\"\>", "0.12`"},
    {"\<\"CK4017\"\>", "0.14`"},
    {"\<\"BS1007\"\>", "0.1`"},
    {"\<\"BS1007\"\>", "0.12`"},
    {"\<\"PY2008\"\>", "0.1`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[3]//TableForm=",
 CellID->8729]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->2534]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"SortingColumns\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6050],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->49185839],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->16806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"\"\<SortingColumns\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], "->", 
       "\"\<Ascending\>\""}], ",", " ", 
      RowBox[{
       RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], "->", 
       "\"\<Ascending\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[3]:=",
 CellID->1936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[3]=",
 CellID->25584]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->10790]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21617],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->187857092],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->19066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", " ", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[3]:=",
 CellID->23116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[3]=",
 CellID->6388]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Last", " ", "/@", " ", "data"}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[4]:=",
 CellID->9425],

Cell[BoxData[
 GraphicsBox[{{}, 
   LineBox[{{1., 0.1}, {2., 0.12}, {3., 0.1}, {4., 0.12}, {5., 0.16}, {6., 
    0.1}, {7., 0.12}, {8., 0.16}, {9., 0.18}, {10., 0.1}, {11., 0.1}, {12., 
    0.12}, {13., 0.14}, {14., 0.1}, {15., 0.12}, {16., 0.14}, {17., 0.1}, {
    18., 0.12}, {19., 0.14}, {20., 0.18}, {21., 0.2}, {22., 0.1}, {23., 
    0.12}, {24., 0.16}, {25., 0.16}, {26., 0.1}, {27., 0.12}, {28., 0.1}, {
    29., 0.12}, {30., 0.1}, {31., 0.12}, {32., 0.1}, {33., 0.12}, {34., 
    0.14}, {35., 0.18}, {36., 0.2}, {37., 0.1}, {38., 0.12}, {39., 0.14}, {
    40., 0.1}, {41., 0.12}, {42., 0.14}, {43., 0.16}, {44., 0.1}, {45., 
    0.12}, {46., 0.1}, {47., 0.12}, {48., 0.14}, {49., 0.1}, {50., 0.12}, {
    51., 0.1}}]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[4]=",
 CellID->13101]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[5]:=",
 CellID->5610]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDelete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLUpdate",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11876],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Selecting Data in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Selecting Data with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->93412643],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->186829075],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->45108491],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->326516757]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLSelect - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 7.7186368}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLSelect[conn, table] extracts data from a table in an SQL connection. \
SQLSelect[conn, table, cols] extracts data from particular columns. \
SQLSelect[conn, table, cols, cond] only extracts data that matches cond.", 
    "synonyms" -> {}, "title" -> "SQLSelect", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLSelect"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7058, 202, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->389810981]},
 "b:4.1.1"->{
  Cell[8133, 240, 245, 8, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->31641],
  Cell[8474, 255, 169, 5, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->16191],
  Cell[8646, 262, 5477, 158, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->22471],
  Cell[14229, 428, 270, 8, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->23700],
  Cell[14502, 438, 3970, 107, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->20217],
  Cell[18581, 553, 1027, 31, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->1943],
  Cell[19611, 586, 2727, 68, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->14624],
  Cell[22450, 662, 396, 11, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->31505],
  Cell[22849, 675, 1861, 51, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->1157],
  Cell[24820, 734, 418, 11, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->7666],
  Cell[25241, 747, 1172, 33, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->9275],
  Cell[26450, 785, 420, 11, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->32046],
  Cell[26873, 798, 1021, 29, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->17632],
  Cell[28001, 835, 462, 13, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->6046],
  Cell[28466, 850, 1025, 29, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->2145],
  Cell[29506, 882, 170, 6, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->6003],
  Cell[30778, 933, 401, 11, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->30350],
  Cell[31182, 946, 1330, 37, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->10405],
  Cell[32549, 988, 371, 10, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->24346],
  Cell[32923, 1000, 1329, 37, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->1025],
  Cell[34289, 1042, 371, 10, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->28970],
  Cell[34663, 1054, 2754, 75, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->14336],
  Cell[37454, 1134, 369, 10, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->4795],
  Cell[37826, 1146, 1403, 39, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->9793],
  Cell[39266, 1190, 370, 10, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->11323],
  Cell[39639, 1202, 1463, 41, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->5532],
  Cell[41139, 1248, 371, 10, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->28856],
  Cell[41513, 1260, 2620, 71, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->15896],
  Cell[44170, 1336, 370, 10, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->3210],
  Cell[44543, 1348, 2680, 73, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->17776],
  Cell[47404, 1435, 541, 16, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->14550],
  Cell[47948, 1453, 1542, 38, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->15290],
  Cell[49527, 1496, 507, 14, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->13795],
  Cell[50037, 1512, 1863, 51, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->13852],
  Cell[52953, 1612, 373, 10, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->9984],
  Cell[53329, 1624, 2234, 69, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->8729],
  Cell[56368, 1731, 598, 16, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->1936],
  Cell[56969, 1749, 3970, 107, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->25584],
  Cell[61747, 1895, 305, 9, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->23116],
  Cell[62055, 1906, 3969, 107, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->6388],
  Cell[66061, 2018, 165, 5, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->9425],
  Cell[66229, 2025, 961, 20, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->13101],
  Cell[67205, 2048, 169, 6, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->5610]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72371, 2223},
 {"b:4.1.1", 72505, 2227}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3017, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3640, 96, 46, 1, 70, "ObjectName",
 CellID->8144],
Cell[3689, 99, 1188, 36, 70, "Usage",
 CellID->32240]
}, Open  ]],
Cell[CellGroupData[{
Cell[4914, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5392, 157, 69, 1, 70, "Notes",
 CellID->29334],
Cell[5464, 160, 1557, 37, 70, "3ColumnTableMod",
 CellID->15296]
}, Closed]],
Cell[CellGroupData[{
Cell[7058, 202, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389810981],
Cell[CellGroupData[{
Cell[7443, 216, 148, 5, 70, "ExampleSection",
 CellID->321297905],
Cell[7594, 223, 135, 3, 70, "Input",
 CellID->751520975],
Cell[7732, 228, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[8133, 240, 245, 8, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->31641],
Cell[8381, 250, 68, 1, 70, "ExampleText",
 CellID->13465],
Cell[CellGroupData[{
Cell[8474, 255, 169, 5, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->16191],
Cell[8646, 262, 5477, 158, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->22471]
}, Open  ]],
Cell[14138, 423, 66, 1, 70, "ExampleText",
 CellID->6259],
Cell[CellGroupData[{
Cell[14229, 428, 270, 8, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->23700],
Cell[14502, 438, 3970, 107, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->20217]
}, Open  ]],
Cell[18487, 548, 69, 1, 70, "ExampleText",
 CellID->2016],
Cell[CellGroupData[{
Cell[18581, 553, 1027, 31, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->1943],
Cell[19611, 586, 2727, 68, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->14624]
}, Open  ]],
Cell[22353, 657, 72, 1, 70, "ExampleText",
 CellID->17064],
Cell[CellGroupData[{
Cell[22450, 662, 396, 11, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->31505],
Cell[22849, 675, 1861, 51, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->1157]
}, Open  ]],
Cell[24725, 729, 70, 1, 70, "ExampleText",
 CellID->31502],
Cell[CellGroupData[{
Cell[24820, 734, 418, 11, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->7666],
Cell[25241, 747, 1172, 33, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->9275]
}, Open  ]],
Cell[CellGroupData[{
Cell[26450, 785, 420, 11, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->32046],
Cell[26873, 798, 1021, 29, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->17632]
}, Open  ]],
Cell[27909, 830, 67, 1, 70, "ExampleText",
 CellID->29789],
Cell[CellGroupData[{
Cell[28001, 835, 462, 13, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->6046],
Cell[28466, 850, 1025, 29, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->2145]
}, Open  ]],
Cell[29506, 882, 170, 6, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->6003],
Cell[29679, 890, 399, 10, 70, "ExampleText",
 CellID->31901]
}, Open  ]],
Cell[CellGroupData[{
Cell[30115, 905, 215, 7, 70, "ExampleSection",
 CellID->8326],
Cell[30333, 914, 135, 3, 70, "Input",
 CellID->231022036],
Cell[30471, 919, 207, 7, 70, "Input",
 CellID->21184],
Cell[30681, 928, 72, 1, 70, "ExampleText",
 CellID->19649],
Cell[CellGroupData[{
Cell[30778, 933, 401, 11, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->30350],
Cell[31182, 946, 1330, 37, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->10405]
}, Open  ]],
Cell[CellGroupData[{
Cell[32549, 988, 371, 10, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->24346],
Cell[32923, 1000, 1329, 37, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->1025]
}, Open  ]],
Cell[CellGroupData[{
Cell[34289, 1042, 371, 10, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->28970],
Cell[34663, 1054, 2754, 75, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->14336]
}, Open  ]],
Cell[CellGroupData[{
Cell[37454, 1134, 369, 10, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->4795],
Cell[37826, 1146, 1403, 39, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->9793]
}, Open  ]],
Cell[CellGroupData[{
Cell[39266, 1190, 370, 10, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->11323],
Cell[39639, 1202, 1463, 41, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->5532]
}, Open  ]],
Cell[CellGroupData[{
Cell[41139, 1248, 371, 10, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->28856],
Cell[41513, 1260, 2620, 71, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->15896]
}, Open  ]],
Cell[CellGroupData[{
Cell[44170, 1336, 370, 10, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->3210],
Cell[44543, 1348, 2680, 73, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->17776]
}, Open  ]],
Cell[47238, 1424, 141, 7, 70, "ExampleText",
 CellID->5692],
Cell[CellGroupData[{
Cell[47404, 1435, 541, 16, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->14550],
Cell[47948, 1453, 1542, 38, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->15290]
}, Open  ]],
Cell[CellGroupData[{
Cell[49527, 1496, 507, 14, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->13795],
Cell[50037, 1512, 1863, 51, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->13852]
}, Open  ]],
Cell[51915, 1566, 149, 5, 70, "Input",
 CellID->17350]
}, Closed]],
Cell[CellGroupData[{
Cell[52101, 1576, 217, 7, 70, "ExampleSection",
 CellID->8315],
Cell[CellGroupData[{
Cell[52343, 1587, 240, 7, 70, "ExampleSubsection",
 CellID->10036],
Cell[52586, 1596, 133, 3, 70, "Input",
 CellID->9546625],
Cell[52722, 1601, 206, 7, 70, "Input",
 CellID->3760],
Cell[CellGroupData[{
Cell[52953, 1612, 373, 10, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->9984],
Cell[53329, 1624, 2234, 69, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->8729]
}, Open  ]],
Cell[55578, 1696, 147, 5, 70, "Input",
 CellID->2534]
}, Closed]],
Cell[CellGroupData[{
Cell[55762, 1706, 234, 7, 70, "ExampleSubsection",
 CellID->6050],
Cell[55999, 1715, 134, 3, 70, "Input",
 CellID->49185839],
Cell[56136, 1720, 207, 7, 70, "Input",
 CellID->16806],
Cell[CellGroupData[{
Cell[56368, 1731, 598, 16, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->1936],
Cell[56969, 1749, 3970, 107, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->25584]
}, Open  ]],
Cell[60954, 1859, 148, 5, 70, "Input",
 CellID->10790]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[61151, 1870, 223, 7, 70, "ExampleSection",
 CellID->21617],
Cell[61377, 1879, 135, 3, 70, "Input",
 CellID->187857092],
Cell[61515, 1884, 207, 7, 70, "Input",
 CellID->19066],
Cell[CellGroupData[{
Cell[61747, 1895, 305, 9, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->23116],
Cell[62055, 1906, 3969, 107, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->6388]
}, Open  ]],
Cell[CellGroupData[{
Cell[66061, 2018, 165, 5, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->9425],
Cell[66229, 2025, 961, 20, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->13101]
}, Open  ]],
Cell[67205, 2048, 169, 6, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->5610]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67423, 2060, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[67742, 2071, 1007, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[68786, 2111, 314, 9, 70, "TutorialsSection",
 CellID->11876],
Cell[69103, 2122, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[69393, 2133, 412, 12, 70, "Tutorials",
 CellID->14193],
Cell[69808, 2147, 437, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[70282, 2164, 318, 9, 70, "MoreAboutSection",
 CellID->93412643],
Cell[70603, 2175, 179, 4, 70, "MoreAbout",
 CellID->186829075],
Cell[70785, 2181, 187, 4, 70, "MoreAbout",
 CellID->45108491],
Cell[70975, 2187, 171, 4, 70, "MoreAbout",
 CellID->326516757]
}, Open  ]],
Cell[71161, 2194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

