(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16246,        535]
NotebookOptionsPosition[     12807,        419]
NotebookOutlinePosition[     14590,        472]
CellTagsIndexPosition[     14479,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Selecting Data in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SelectingData"], 
          "Selecting Data with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLSelectingData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Selecting Data in DatabaseLink User Guide\"\>", 
       3->"\<\"Selecting Data with Raw SQL in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLMemberQ" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLMemberQ"], 
          "SQLSelect" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSelect"], 
          "SQLInsert" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLInsert"], 
          "SQLUpdate" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLUpdate"], 
          "SQLDelete" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDelete"], 
          "SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLMemberQ\"\>", 
       2->"\<\"SQLSelect\"\>", 3->"\<\"SQLInsert\"\>", 4->"\<\"SQLUpdate\"\>",
        5->"\<\"SQLDelete\"\>", 6->"\<\"SQLExecute\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLStringMatchQ", "ObjectName",
 CellID->5946],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLStringMatchQ", "[", 
       RowBox[{
        StyleBox["col", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies a condition in an SQL query used to test \
whether the value of a column matches a pattern. The actual format for the \
pattern varies from one database to another."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->175816874],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->13733840],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->10270],

Cell["Select data matching a pattern:", "ExampleText",
 CellID->32715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLStringMatchQ", "[", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], ",", " ", 
     "\"\<C%\>\""}], "]"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[3]:=",
 CellID->32200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[3]=",
 CellID->1206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLStringMatchQ", "[", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], ",", " ", 
     "\"\<_S%\>\""}], "]"}]}], "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[4]:=",
 CellID->32106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[4]=",
 CellID->31302]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->24696]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLMemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLMemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSelect",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSelect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLUpdate",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDelete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27297],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Selecting Data in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Selecting Data with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->23811225],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->150955237]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLStringMatchQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 14.2029703}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLStringMatchQ[col, patt] specifies a condition in an SQL query used to \
test whether the value of a column matches a pattern. The actual format for \
the pattern varies from one database to another.", "synonyms" -> {}, "title" -> 
    "SQLStringMatchQ", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLStringMatchQ"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4217, 118, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:4.1.1"->{
  Cell[5588, 170, 419, 11, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->32200],
  Cell[6010, 183, 1172, 33, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->1206],
  Cell[7219, 221, 420, 11, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->32106],
  Cell[7642, 234, 1021, 29, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->31302]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13994, 446},
 {"b:4.1.1", 14120, 450}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2909, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3532, 94, 52, 1, 70, "ObjectName",
 CellID->5946],
Cell[3587, 97, 593, 16, 70, "Usage",
 CellID->13540]
}, Open  ]],
Cell[CellGroupData[{
Cell[4217, 118, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4594, 132, 148, 5, 70, "ExampleSection",
 CellID->175816874],
Cell[4745, 139, 134, 3, 70, "Input",
 CellID->13733840],
Cell[4882, 144, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5283, 156, 207, 7, 70, "Input",
 CellID->10270],
Cell[5493, 165, 70, 1, 70, "ExampleText",
 CellID->32715],
Cell[CellGroupData[{
Cell[5588, 170, 419, 11, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->32200],
Cell[6010, 183, 1172, 33, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->1206]
}, Open  ]],
Cell[CellGroupData[{
Cell[7219, 221, 420, 11, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->32106],
Cell[7642, 234, 1021, 29, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->31302]
}, Open  ]],
Cell[8678, 266, 148, 5, 70, "Input",
 CellID->24696]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8875, 277, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9194, 288, 1529, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10760, 346, 314, 9, 70, "TutorialsSection",
 CellID->27297],
Cell[11077, 357, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[11367, 368, 412, 12, 70, "Tutorials",
 CellID->14193],
Cell[11782, 382, 437, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[12256, 399, 318, 9, 70, "MoreAboutSection",
 CellID->23811225],
Cell[12577, 410, 188, 4, 70, "MoreAbout",
 CellID->150955237]
}, Open  ]],
Cell[12780, 417, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

