(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13041,        451]
NotebookOptionsPosition[     10091,        350]
NotebookOutlinePosition[     11338,        387]
CellTagsIndexPosition[     11253,        382]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Table Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/TableStructure"], 
          "Creating Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/CreatingTables"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Table Structure in DatabaseLink User Guide\"\>", 
       3->"\<\"Creating Tables in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLTables" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTables"], 
          "SQLTableNames" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTableNames"], 
          "SQLTableInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableInformation"], 
          "SQLTableTypeNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableTypeNames"], "SQLCreateTable" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCreateTable"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLTables\"\>", 2->"\<\"SQLTableNames\"\>", 
       3->"\<\"SQLTableInformation\"\>", 4->"\<\"SQLTableTypeNames\"\>", 
       5->"\<\"SQLCreateTable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLTable", "ObjectName",
 CellID->15023],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLTable", "[", 
       StyleBox["\[Ellipsis]", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a table in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->26312],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<TableType\>\"", "\"\<TABLE\>\"", 
    Cell["type of table", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->8250]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->149451515],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->759810425],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->9253605],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->20183],

Cell["List the tables in a connection:", "ExampleText",
 CellID->24798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27892],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLTable", "[", 
   RowBox[{"\<\"SAMPLETABLE1\"\>", ",", 
    RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->18848]
}, Open  ]],

Cell["Specify a table in a prepared statement:", "ExampleText",
 CellID->6784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT `1` FROM `2`\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<VALUE\>\"", "]"}], ",", " ", 
     RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5.6`", "}"}], ",", 
   RowBox[{"{", "5.9`", "}"}], ",", 
   RowBox[{"{", "7.2`", "}"}], ",", 
   RowBox[{"{", "6.2`", "}"}], ",", 
   RowBox[{"{", "6.`", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->12187]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->14462]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13475],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTables",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableTypeNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableTypeNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCreateTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26850],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Table Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"]
}], "Tutorials",
 CellID->591254481],

Cell[TextData[{
 ButtonBox["Creating Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"]
}], "Tutorials",
 CellID->14193]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLTable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 19.9998082}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLTable[...] represents a table in an SQL connection.", 
    "synonyms" -> {}, "title" -> "SQLTable", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLTable"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4279, 131, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->149451515]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11110, 375}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2220, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2843, 77, 46, 1, 70, "ObjectName",
 CellID->15023],
Cell[2892, 80, 403, 12, 70, "Usage",
 CellID->30270]
}, Open  ]],
Cell[CellGroupData[{
Cell[3332, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3810, 114, 68, 1, 70, "Notes",
 CellID->26312],
Cell[3881, 117, 361, 9, 70, "3ColumnTableMod",
 CellID->8250]
}, Closed]],
Cell[CellGroupData[{
Cell[4279, 131, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->149451515],
Cell[CellGroupData[{
Cell[4664, 145, 148, 5, 70, "ExampleSection",
 CellID->759810425],
Cell[4815, 152, 133, 3, 70, "Input",
 CellID->9253605],
Cell[4951, 157, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5352, 169, 202, 7, 70, "Input",
 CellID->20183],
Cell[5557, 178, 71, 1, 70, "ExampleText",
 CellID->24798],
Cell[CellGroupData[{
Cell[5653, 183, 104, 3, 70, "Input",
 CellID->27892],
Cell[5760, 188, 229, 7, 70, "Output",
 CellID->18848]
}, Open  ]],
Cell[6004, 198, 78, 1, 70, "ExampleText",
 CellID->6784],
Cell[CellGroupData[{
Cell[6107, 203, 339, 9, 70, "Input",
 CellID->30245],
Cell[6449, 214, 276, 9, 70, "Output",
 CellID->12187]
}, Open  ]],
Cell[6740, 226, 148, 5, 70, "Input",
 CellID->14462]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6937, 237, 311, 9, 70, "SeeAlsoSection",
 CellID->13475],
Cell[7251, 248, 1315, 44, 70, "SeeAlso",
 CellID->20311]
}, Open  ]],
Cell[CellGroupData[{
Cell[8603, 297, 314, 9, 70, "TutorialsSection",
 CellID->26850],
Cell[8920, 308, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[9210, 319, 420, 12, 70, "Tutorials",
 CellID->591254481],
Cell[9633, 333, 416, 12, 70, "Tutorials",
 CellID->14193]
}, Open  ]],
Cell[10064, 348, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

