(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39652,       1051]
NotebookOptionsPosition[     34345,        862]
NotebookOutlinePosition[     36355,        925]
CellTagsIndexPosition[     36246,        919]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Table Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/TableStructure"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Table Structure in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLTable" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTable"], 
          "SQLTables" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTables"], 
          "SQLTableNames" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTableNames"], 
          "SQLTableTypeNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableTypeNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLTable\"\>", 2->"\<\"SQLTables\"\>", 
       3->"\<\"SQLTableNames\"\>", 
       4->"\<\"SQLTableTypeNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"Database Information\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLTableInformation", "ObjectName",
 CellID->32036],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLTableInformation", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of information about the tables in an \
SQL connection. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->4912],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TableType\>\"", "\"\<TABLE\>\"", 
    Cell["type of table to return", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1915]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18038336],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->500082598],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1230639],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->30169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLTableInformation", "[", "conn", "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29681],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"EDITORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"PUBLISHERS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"ROYSCHED\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALESDETAILS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null",
      "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//TableForm=",
 CellID->4879]
}, Open  ]],

Cell["Get information for a specific table:", "ExampleText",
 CellID->21108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLTableInformation", "[", 
   RowBox[{"conn", ",", " ", "\"\<AUTHORS\>\""}], "]"}], " ", "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[4]:=",
 CellID->17207],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[4]//TableForm=",
 CellID->5259]
}, Open  ]],

Cell["Get information for tables that match a pattern:", "ExampleText",
 CellID->25706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLTableInformation", "[", 
   RowBox[{"conn", ",", " ", "\"\<TITLE%\>\""}], "]"}], " ", "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[5]:=",
 CellID->23849],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null",
      "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[5]//TableForm=",
 CellID->24075]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[6]:=",
 CellID->28026],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->273909855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17774],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"ShowColumnHeadings\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2884],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->4400728],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->24546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLTableInformation", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[3]:=",
 CellID->3145],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TABLE_CAT\"\>", "\<\"TABLE_SCHEM\"\>", "\<\"TABLE_NAME\"\>", \
"\<\"TABLE_TYPE\"\>", "\<\"REMARKS\"\>", "\<\"TYPE_CAT\"\>", \
"\<\"TYPE_SCHEM\"\>", "\<\"TYPE_NAME\"\>", \
"\<\"SELF_REFERENCING_COL_NAME\"\>", "\<\"REF_GENERATION\"\>", \
"\<\"HSQLDB_TYPE\"\>", "\<\"READ_ONLY\"\>"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"EDITORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"PUBLISHERS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"ROYSCHED\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALESDETAILS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null",
      "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[3]//TableForm=",
 CellID->20481]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->11714]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"TableType\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20149],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->81433836],

Cell["Get information for all types of tables in a data source: ", \
"ExampleText",
 CellID->24168],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->20307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLTableInformation", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"\"\<TableType\>\"", "\[Rule]", 
     RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[3]:=",
 CellID->26793],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_ALIASES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the aliases defined within this database\"\>", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_ALLTYPEINFO\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"a description of all non user-defined data types \
known to this database and the level of support for them in various \
capacities\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_AUTHORIZATIONS\"\>", "\
\<\"SYSTEM TABLE\"\>", "\<\"one row for each user and one row for each role \
\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"for each \
accessible table defined within this database, the optimal set of visible \
columns that uniquely identifies a row\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_CACHEINFO\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the current state of the system row caching \
mechanism\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_CATALOGS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the accessible catalogs defined within this \
database\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"one row for \
each column identified by a <column reference> contained in the <search \
condition> of a check constraint, domain constraint, or assertion.\"\>", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"one row for \
each domain constraint, table check constraint, and assertion.\"\>", "Null", 
     "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"one row \
for each SQL-invoked routine identified as the subject routine of either a \
<routine invocation>, a <method reference>, a  <method invocation>, or a \
<static method invocation>  contained in an <assertion definition>, a <domain \
constraint>, or a <table constraint definition>.\"\>", "Null", "Null", "Null",
      "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"one row for \
each table identified by a <table name> simply contained in a <table \
reference> contained in the <search condition> of a check constraint, domain \
constraint, or assertion.\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_CLASSPRIVILEGES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the visible user level access permissions for \
each Java class providing implementation for each accessible callable \
procedure, SQL function, trigger body and UDT method defined within this \
database\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_COLLATIONS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"one row for each character collation descriptor.\
\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_COLUMNPRIVILEGES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the visible user level access permissions of \
each visible column of each accessible table defined within this \
database\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_COLUMNS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the visible columns of each accessible table \
defined within this database\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_CROSSREFERENCE\"\>", "\
\<\"SYSTEM TABLE\"\>", "\<\"a description of how the accessible tables \
defined within this database import visible columns to enforce referential \
integrity\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_INDEXINFO\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"information about the indicies of each \
accessible table defined within this database\"\>", "Null", "Null", "Null", 
     "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_PRIMARYKEYS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the visible columns of the primary key of each \
accessible table defined within this database\"\>", "Null", "Null", "Null", 
     "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_PROCEDURECOLUMNS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"a description of the return type, parameters and \
result columns of each accessible callable procedure, SQL function, trigger \
body and UDT method defined within this database\"\>", "Null", "Null", "Null",
      "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_PROCEDURES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the procedures, SQL functions, trigger body \
routines and UDT methods defined within the database\"\>", "Null", "Null", 
     "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_PROPERTIES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the static and dynamic system properties and \
operating parameters of this database\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", "\<\"SYSTEM TABLE\"\>", \
"\<\"one row for each role granted directly to a grantee\"\>", "Null", "Null",
      "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SCHEMAS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the accessible schemas defined within this \
database\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SCHEMATA\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"one row for each schema.\"\>", "Null", "Null", 
     "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SEQUENCES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"one row for each external sequence \
generator\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SESSIONINFO\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"information about the current database session\"\
\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SESSIONS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the visible sessions open in this database\"\>", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SUPERTABLES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the table hierarchies defined in this database. \
Only the immediate super type/sub type relationship is modeled\"\>", "Null", 
     "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_SUPERTYPES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the user-defined type (UDT) hierarchies defined \
in this database. Only the immediate super type/sub type relationship is \
modeled\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TABLEPRIVILEGES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the visible user level access permissions for \
each accessible table defined within this database\"\>", "Null", "Null", 
     "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TABLES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the accessible tables defined within this \
database\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TABLETYPES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the types of tables that can be created/found \
within this database\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"one row for \
each table constraint associated with a table\"\>", "Null", "Null", "Null", 
     "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TEXTTABLES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the data source descriptors of the accessible \
TEXT TABLE objects defined within this database\"\>", "Null", "Null", "Null", 
     "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TRIGGERCOLUMNS\"\>", "\
\<\"SYSTEM TABLE\"\>", "\<\"the column usage of visible triggers defined \
within this database\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TRIGGERS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the visible triggers defined within this \
database\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_TYPEINFO\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"a description of predefined table column data \
types known to this database\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_UDTATTRIBUTES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"a description of the attributes of the \
user-defined types (UDTs) that are available in this database\"\>", "Null", 
     "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_UDTS\"\>", "\<\"SYSTEM \
TABLE\"\>", "\<\"the user-defined types that are available within this \
database\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_USAGE_PRIVILEGES\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"one row for each usage privilege \
descriptor.\"\>", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_USERS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"users defined within this database\"\>", "Null", 
     "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VERSIONCOLUMNS\"\>", "\
\<\"SYSTEM TABLE\"\>", "\<\"the visible columns of the accessible tables that \
are automatically updated when any value in a row is updated\"\>", "Null", 
     "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEWS\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"the view descriptors of the accessible views \
defined within this database\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"one row for \
each column of a table that is explicitly or implicitly referenced in the \
<query expression> of the view being described.\"\>", "Null", "Null", "Null", 
     "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", \
"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", "\<\"SYSTEM TABLE\"\>", "\<\"one row for \
each SQL-invoked routine identified as the subject routine of either a \
<routine invocation>, a <method reference>, a <method invocation>, or a \
<static method invocation> contained in a <view definition>\"\>", "Null", 
     "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"INFORMATION_SCHEMA\"\>", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", \
"\<\"SYSTEM TABLE\"\>", "\<\"one row for each table identified by a <table \
name> simply contained in a <table reference> that is contained in the <query \
expression> of a view\"\>", "Null", "Null", "Null", "Null", 
     "Null", "\<\"MEMORY\"\>", "True"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"EDITORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"PUBLISHERS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"ROYSCHED\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALESDETAILS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null",
      "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[3]//TableForm=",
 CellID->23504]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->1105]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23953],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTables",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableTypeNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableTypeNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20741],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Table Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"]
}], "Tutorials",
 CellID->591254481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->24211375],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->215874729],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->222491983],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->84337071]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLTableInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 17.8435720}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLTableInformation[conn] returns a list of information about the tables \
in an SQL connection. ", "synonyms" -> {}, "title" -> "SQLTableInformation", 
    "type" -> "Symbol", "uri" -> "DatabaseLink/ref/SQLTableInformation"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5537, 163, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18038336]},
 "b:3.1"->{
  Cell[8981, 263, 217, 7, 70, "Input",
   CellTags->"b:3.1",
   CellID->17207],
  Cell[9201, 272, 673, 19, 70, "Output",
   CellTags->"b:3.1",
   CellID->5259],
  Cell[10001, 299, 216, 7, 70, "Input",
   CellTags->"b:3.1",
   CellID->23849],
  Cell[10220, 308, 986, 24, 70, "Output",
   CellTags->"b:3.1",
   CellID->24075],
  Cell[12663, 393, 251, 8, 70, "Input",
   CellTags->"b:3.1",
   CellID->3145],
  Cell[12917, 403, 2184, 42, 70, "Output",
   CellTags->"b:3.1",
   CellID->20481],
  Cell[16005, 487, 290, 9, 70, "Input",
   CellTags->"b:3.1",
   CellID->26793],
  Cell[16298, 498, 14504, 228, 70, "Output",
   CellTags->"b:3.1",
   CellID->23504]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35435, 887},
 {"b:3.1", 35566, 891}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2782, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3405, 93, 57, 1, 70, "ObjectName",
 CellID->32036],
Cell[3465, 96, 438, 13, 70, "Usage",
 CellID->16984]
}, Open  ]],
Cell[CellGroupData[{
Cell[3940, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4418, 131, 68, 1, 70, "Notes",
 CellID->4912],
Cell[4489, 134, 1011, 24, 70, "3ColumnTableMod",
 CellID->1915]
}, Closed]],
Cell[CellGroupData[{
Cell[5537, 163, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18038336],
Cell[CellGroupData[{
Cell[5921, 177, 148, 5, 70, "ExampleSection",
 CellID->500082598],
Cell[6072, 184, 133, 3, 70, "Input",
 CellID->1230639],
Cell[6208, 189, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6609, 201, 207, 7, 70, "Input",
 CellID->30169],
Cell[CellGroupData[{
Cell[6841, 212, 149, 5, 70, "Input",
 CellID->29681],
Cell[6993, 219, 1872, 36, 70, "Output",
 CellID->4879]
}, Open  ]],
Cell[8880, 258, 76, 1, 70, "ExampleText",
 CellID->21108],
Cell[CellGroupData[{
Cell[8981, 263, 217, 7, 70, "Input",
 CellTags->"b:3.1",
 CellID->17207],
Cell[9201, 272, 673, 19, 70, "Output",
 CellTags->"b:3.1",
 CellID->5259]
}, Open  ]],
Cell[9889, 294, 87, 1, 70, "ExampleText",
 CellID->25706],
Cell[CellGroupData[{
Cell[10001, 299, 216, 7, 70, "Input",
 CellTags->"b:3.1",
 CellID->23849],
Cell[10220, 308, 986, 24, 70, "Output",
 CellTags->"b:3.1",
 CellID->24075]
}, Open  ]],
Cell[11221, 335, 148, 5, 70, "Input",
 CellID->28026],
Cell[11372, 342, 402, 10, 70, "ExampleText",
 CellID->273909855]
}, Open  ]],
Cell[CellGroupData[{
Cell[11811, 357, 218, 7, 70, "ExampleSection",
 CellID->17774],
Cell[CellGroupData[{
Cell[12054, 368, 238, 7, 70, "ExampleSubsection",
 CellID->2884],
Cell[12295, 377, 133, 3, 70, "Input",
 CellID->4400728],
Cell[12431, 382, 207, 7, 70, "Input",
 CellID->24546],
Cell[CellGroupData[{
Cell[12663, 393, 251, 8, 70, "Input",
 CellTags->"b:3.1",
 CellID->3145],
Cell[12917, 403, 2184, 42, 70, "Output",
 CellTags->"b:3.1",
 CellID->20481]
}, Open  ]],
Cell[15116, 448, 148, 5, 70, "Input",
 CellID->11714]
}, Closed]],
Cell[CellGroupData[{
Cell[15301, 458, 230, 7, 70, "ExampleSubsection",
 CellID->20149],
Cell[15534, 467, 134, 3, 70, "Input",
 CellID->81433836],
Cell[15671, 472, 99, 2, 70, "ExampleText",
 CellID->24168],
Cell[15773, 476, 207, 7, 70, "Input",
 CellID->20307],
Cell[CellGroupData[{
Cell[16005, 487, 290, 9, 70, "Input",
 CellTags->"b:3.1",
 CellID->26793],
Cell[16298, 498, 14504, 228, 70, "Output",
 CellTags->"b:3.1",
 CellID->23504]
}, Open  ]],
Cell[30817, 729, 147, 5, 70, "Input",
 CellID->1105]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31025, 741, 311, 9, 70, "SeeAlsoSection",
 CellID->23953],
Cell[31339, 752, 1023, 35, 70, "SeeAlso",
 CellID->20311]
}, Open  ]],
Cell[CellGroupData[{
Cell[32399, 792, 314, 9, 70, "TutorialsSection",
 CellID->20741],
Cell[32716, 803, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[33006, 814, 420, 12, 70, "Tutorials",
 CellID->591254481]
}, Open  ]],
Cell[CellGroupData[{
Cell[33463, 831, 318, 9, 70, "MoreAboutSection",
 CellID->24211375],
Cell[33784, 842, 179, 4, 70, "MoreAbout",
 CellID->215874729],
Cell[33966, 848, 164, 3, 70, "MoreAbout",
 CellID->222491983],
Cell[34133, 853, 170, 4, 70, "MoreAbout",
 CellID->84337071]
}, Open  ]],
Cell[34318, 860, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

