(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     90793,       2686]
NotebookOptionsPosition[     73079,       2148]
NotebookOutlinePosition[     84949,       2485]
CellTagsIndexPosition[     84009,       2459]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLColumn" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumn"], 
         "SQLColumnInformation" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLColumnInformation"], "SQLColumnNames" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumnNames"], 
         "SQLColumns" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumns"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"SQLColumn\"\>", 
      2->"\<\"SQLColumnInformation\"\>", 3->"\<\"SQLColumnNames\"\>", 
      4->"\<\"SQLColumns\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Column Structure", "Title",
 CellTags->{"xref:26", "c:37", "b:3.3"},
 CellID->20055],

Cell[CellGroupData[{

Cell["Column Description", "Section",
 CellTags->"c:01",
 CellID->20328],

Cell["\<\
This section discusses commands that get information about database columns. \
\
\>", "Text",
 CellTags->"b:3.3",
 CellID->22646],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->26362],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLColumnNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all column names within a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLColumnNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["name", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "list all column names that match ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " within a data source"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLColumns",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLColumns"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all columns within a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLColumns",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLColumns"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["name", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "list all columns that match ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " within a data source"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLColumnInformation",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all column information for tables within a data source", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLColumnInformation",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["name", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "list all column information for columns that match ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " within a data source"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->4886],

Cell["Functions for retrieving information about columns.", "Caption",
 CellTags->"b:3.3",
 CellID->18875],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:3.3",
 CellID->28433],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,449"},
 CellLabel->"In[5]:=",
 CellID->29869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"]], "InlineFormula"],
 " returns a list of the column names within a database as a list of pairs of \
table and column names. For HSQLDB it returns information from many of the ",
 StyleBox["SYSTEM",
  FontSlant->"Italic"],
 " tables."
}], "Text",
 CellTags->"b:3.3",
 CellID->20142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
 CellLabel->"In[3]:=",
 CellID->23844],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_TYPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_CAT\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"ALIAS_CAT\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"ALIAS_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"ALIAS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"TYPE_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"DATA_TYPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"PRECISION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"LITERAL_PREFIX\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"LITERAL_SUFFIX\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"CREATE_PARAMS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"NULLABLE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"CASE_SENSITIVE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"SEARCHABLE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"UNSIGNED_ATTRIBUTE\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"FIXED_PREC_SCALE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"AUTO_INCREMENT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"LOCAL_TYPE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"MINIMUM_SCALE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"MAXIMUM_SCALE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"SQL_DATA_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"SQL_DATETIME_SUB\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"NUM_PREC_RADIX\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"INTERVAL_PRECISION\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"AS_TAB_COL\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"AS_PROC_COL\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"MAX_PREC_ACT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"MIN_SCALE_ACT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"MAX_SCALE_ACT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"COL_ST_CLS_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"COL_ST_IS_SUP\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"STD_MAP_CLS_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"STD_MAP_IS_SUP\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"CST_MAP_CLS_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"CST_MAP_IS_SUP\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"MCOL_JDBC\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"MCOL_ACT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"DEF_OR_FIXED_SCALE\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"REMARKS\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", "\<\"TYPE_SUB\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_AUTHORIZATIONS\"\>", 
     ",", "\<\"AUTHORIZATION_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_AUTHORIZATIONS\"\>", 
     ",", "\<\"AUTHORIZATION_TYPE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"SCOPE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"COLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"DATA_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"TYPE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"COLUMN_SIZE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", 
     ",", "\<\"BUFFER_LENGTH\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", 
     ",", "\<\"DECIMAL_DIGITS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", 
     ",", "\<\"PSEUDO_COLUMN\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"TABLE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"NULLABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"IN_KEY\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"CACHE_FILE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"MAX_CACHE_COUNT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"MAX_CACHE_BYTES\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"CACHE_SIZE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"CACHE_BYTES\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"FILE_FREE_BYTES\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"FILE_FREE_COUNT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", "\<\"FILE_FREE_POS\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CATALOGS\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", 
     ",", "\<\"TABLE_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", 
     ",", "\<\"TABLE_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", ",", "\<\"COLUMN_NAME\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", 
     ",", "\<\"CONSTRAINT_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", 
     ",", "\<\"CONSTRAINT_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", 
     ",", "\<\"CONSTRAINT_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", ",", "\<\"CHECK_CLAUSE\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
     ",", "\<\"SPECIFIC_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
     ",", "\<\"SPECIFIC_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
     ",", "\<\"SPECIFIC_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", 
     ",", "\<\"CONSTRAINT_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", 
     ",", "\<\"TABLE_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", ",", "\<\"TABLE_SCHEMA\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"CLASS_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"CLASS_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"CLASS_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"GRANTOR\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"GRANTEE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"PRIVILEGE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"IS_GRANTABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", ",", "\<\"COLLATION_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", ",", "\<\"COLLATION_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", ",", "\<\"COLLATION_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", ",", "\<\"PAD_ATTRIBUTE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", ",", "\<\"COLLATION_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", 
     ",", "\<\"COLLATION_DEFINITION\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", 
     ",", "\<\"COLLATION_DICTIONARY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", 
     ",", "\<\"CHARACTER_REPERTOIRE_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"TABLE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"COLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"GRANTOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"GRANTEE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"PRIVILEGE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"IS_GRANTABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"COLUMN_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"DATA_TYPE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"TYPE_NAME\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"COLUMN_SIZE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"BUFFER_LENGTH\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"DECIMAL_DIGITS\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"NUM_PREC_RADIX\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"NULLABLE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"REMARKS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"COLUMN_DEF\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"SQL_DATA_TYPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"SQL_DATETIME_SUB\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"CHAR_OCTET_LENGTH\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"ORDINAL_POSITION\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"IS_NULLABLE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"SCOPE_CATLOG\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"SCOPE_SCHEMA\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"SCOPE_TABLE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"SOURCE_DATA_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", "\<\"TYPE_SUB\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"PKTABLE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"PKTABLE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"PKTABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"PKCOLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"FKTABLE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"FKTABLE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"FKTABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"FKCOLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"KEY_SEQ\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"UPDATE_RULE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"DELETE_RULE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"FK_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"PK_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"DEFERRABILITY\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"NON_UNIQUE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"INDEX_QUALIFIER\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"INDEX_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"TYPE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"ORDINAL_POSITION\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"COLUMN_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"ASC_OR_DESC\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"CARDINALITY\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"PAGES\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", "\<\"FILTER_CONDITION\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"COLUMN_NAME\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"KEY_SEQ\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"PK_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"PROCEDURE_CAT\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", 
     ",", "\<\"PROCEDURE_SCHEM\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", 
     ",", "\<\"PROCEDURE_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"COLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"COLUMN_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"DATA_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"TYPE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"PRECISION\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"LENGTH\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"SCALE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"RADIX\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"NULLABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"REMARKS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"SPECIFIC_NAME\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", "\<\"SEQ\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"PROCEDURE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"PROCEDURE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"PROCEDURE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"NUM_INPUT_PARAMS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"NUM_OUTPUT_PARAMS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"NUM_RESULT_SETS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"REMARKS\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"PROCEDURE_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"ORIGIN\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"SPECIFIC_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROPERTIES\"\>", ",", "\<\"PROPERTY_SCOPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROPERTIES\"\>", ",", "\<\"PROPERTY_NAMESPACE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROPERTIES\"\>", ",", "\<\"PROPERTY_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROPERTIES\"\>", ",", "\<\"PROPERTY_VALUE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_PROPERTIES\"\>", ",", "\<\"PROPERTY_CLASS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", 
     ",", "\<\"ROLE_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", 
     ",", "\<\"GRANTEE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", 
     ",", "\<\"GRANTOR\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", 
     ",", "\<\"IS_GRANTABLE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMAS\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMAS\"\>", ",", "\<\"TABLE_CATALOG\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMAS\"\>", ",", "\<\"IS_DEFAULT\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", ",", "\<\"CATALOG_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", ",", "\<\"SCHEMA_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", ",", "\<\"SCHEMA_OWNER\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", 
     ",", "\<\"DEFAULT_CHARACTER_SET_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", 
     ",", "\<\"DEFAULT_CHARACTER_SET_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", 
     ",", "\<\"DEFAULT_CHARACTER_SET_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", ",", "\<\"SQL_PATH\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"SEQUENCE_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"SEQUENCE_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"SEQUENCE_NAME\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"DTD_IDENTIFIER\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"MAXIMUM_VALUE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"MINIMUM_VALUE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"INCREMENT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"CYCLE_OPTION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"START_WITH\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"KEY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"SESSION_ID\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"CONNECTED\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"USER_NAME\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"IS_ADMIN\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"AUTOCOMMIT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"READONLY\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"MAXROWS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"LAST_IDENTITY\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"TRANSACTION_SIZE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTABLES\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTABLES\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTABLES\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTABLES\"\>", ",", "\<\"SUPERTABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"TYPE_CAT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"TYPE_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"TYPE_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"SUPERTYPE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"SUPERTYPE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"SUPERTYPE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", "\<\"TABLE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", "\<\"GRANTOR\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", "\<\"GRANTEE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", "\<\"PRIVILEGE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", "\<\"IS_GRANTABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"TABLE_TYPE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"REMARKS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"TYPE_CAT\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"TYPE_SCHEM\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"TYPE_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", 
     ",", "\<\"SELF_REFERENCING_COL_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"REF_GENERATION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"HSQLDB_TYPE\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", "\<\"READ_ONLY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLETYPES\"\>", ",", "\<\"TABLE_TYPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", 
     ",", "\<\"CONSTRAINT_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", 
     ",", "\<\"CONSTRAINT_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", 
     ",", "\<\"CONSTRAINT_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", 
     ",", "\<\"CONSTRAINT_TYPE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", 
     ",", "\<\"TABLE_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", ",", "\<\"TABLE_SCHEMA\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", 
     ",", "\<\"IS_DEFERRABLE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", 
     ",", "\<\"INITIALLY_DEFERRED\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", 
     ",", "\<\"DATA_SOURCE_DEFINTION\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"FILE_PATH\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"FILE_ENCODING\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"FIELD_SEPARATOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"VARCHAR_SEPARATOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", 
     ",", "\<\"LONGVARCHAR_SEPARATOR\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"IS_IGNORE_FIRST\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"IS_ALL_QUOTED\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"IS_QUOTED\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"IS_DESC\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"TRIGGER_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"TRIGGER_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"TRIGGER_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"TABLE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"COLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"COLUMN_LIST\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"COLUMN_USAGE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TRIGGER_CAT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TRIGGER_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TRIGGER_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TRIGGER_TYPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TRIGGERING_EVENT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TABLE_CAT\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"BASE_OBJECT_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"COLUMN_NAME\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"REFERENCING_NAMES\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"WHEN_CLAUSE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"STATUS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"DESCRIPTION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"ACTION_TYPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", "\<\"TRIGGER_BODY\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"TYPE_NAME\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"DATA_TYPE\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"PRECISION\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"LITERAL_PREFIX\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"LITERAL_SUFFIX\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"CREATE_PARAMS\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"NULLABLE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"CASE_SENSITIVE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"SEARCHABLE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"UNSIGNED_ATTRIBUTE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"FIXED_PREC_SCALE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"AUTO_INCREMENT\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"LOCAL_TYPE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"MINIMUM_SCALE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"MAXIMUM_SCALE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"SQL_DATA_TYPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"SQL_DATETIME_SUB\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"NUM_PREC_RADIX\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"TYPE_SUB\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"TYPE_CAT\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"TYPE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"TYPE_NAME\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"ATTR_NAME\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"DATA_TYPE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"ATTR_TYPE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"ATTR_SIZE\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"DECIMAL_DIGITS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"NUM_PREC_RADIX\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"NULLABLE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"REMARKS\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"ATTR_DEF\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"SQL_DATA_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"SQL_DATETIME_SUB\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", 
     ",", "\<\"CHAR_OCTET_LENGTH\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"ORDINAL_POSITION\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"IS_NULLABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"SCOPE_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"SCOPE_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"SCOPE_TABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", "\<\"SOURCE_DATA_TYPE\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", "\<\"TYPE_CAT\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", "\<\"TYPE_SCHEM\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", "\<\"TYPE_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", "\<\"CLASS_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", "\<\"DATA_TYPE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", "\<\"REMARKS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", "\<\"BASE_TYPE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", "\<\"GRANTOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", "\<\"GRANTEE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", 
     ",", "\<\"OBJECT_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", "\<\"OBJECT_SCHEMA\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", "\<\"OBJECT_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", "\<\"OBJECT_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", "\<\"IS_GRANTABLE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USERS\"\>", ",", "\<\"USER\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_USERS\"\>", ",", "\<\"ADMIN\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"SCOPE\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"COLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"DATA_TYPE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"TYPE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"COLUMN_SIZE\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"BUFFER_LENGTH\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"DECIMAL_DIGITS\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"PSEUDO_COLUMN\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"TABLE_CAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"TABLE_SCHEM\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"TABLE_CATALOG\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"TABLE_SCHEMA\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"TABLE_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VIEW_DEFINITION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"CHECK_OPTION\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"IS_UPDATABLE\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VALID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", 
     ",", "\<\"TABLE_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"TABLE_SCHEMA\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"COLUMN_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", 
     ",", "\<\"TABLE_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", 
     ",", "\<\"TABLE_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", 
     ",", "\<\"SPECIFIC_CATALOG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", 
     ",", "\<\"SPECIFIC_SCHEMA\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", 
     ",", "\<\"SPECIFIC_NAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"TABLE_CATALOG\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"TABLE_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"TABLE_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
 CellLabel->"Out[3]=",
 CellID->1416]
}, Open  ]],

Cell["\<\
It is possible to use metacharacters that will match names. The \
metacharacters are '%' for zero or more characters and '_' for a single \
character. The following command matches columns in tables that have names \
starting with \"SA\".\
\>", "Text",
 CellTags->"b:3.3",
 CellID->21881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<SA%\>\""}], "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
 CellLabel->"In[4]:=",
 CellID->31998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
 CellLabel->"Out[4]=",
 CellID->10322]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumns",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumns"]], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " expressions. ",
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " expressions are sometimes useful for structural arguments in database \
commands, as described in ",
 ButtonBox["Argument Sequences in SQL-Style Queries",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute#16828"],
 ", because they contain information on the table name, column name, data \
type, whether an entry can be set to ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ", and the data length."
}], "Text",
 CellTags->"b:3.3",
 CellID->18651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", " ", "\"\<SA%\>\""}], "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
 CellLabel->"In[5]:=",
 CellID->10021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
 CellLabel->"Out[5]=",
 CellID->5699]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumnInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"]], 
  "InlineFormula"],
 " returns more information about the columns."
}], "Text",
 CellTags->"b:3.3",
 CellID->3557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", " ", "\"\<SA%\>\""}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
 CellLabel->"In[6]:=",
 CellID->28476],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
     "4", "\<\"INTEGER\"\>", "Null", "4", "Null", "10", "1", "Null", "Null", 
     "4", "Null", "Null", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", "1", 
     "Null", "Null", "12", "Null", "Null", "3", "\<\"YES\"\>", "Null", "Null",
      "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
 CellLabel->"Out[6]//TableForm=",
 CellID->27892]
}, Open  ]],

Cell["\<\
You can filter the names of the columns by providing a list of metacharacters \
to match the table and column names. The following command searches in all \
tables to return all columns that start with V.\
\>", "Text",
 CellTags->"b:3.3",
 CellID->24389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<%\>\"", ",", "\"\<V%\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
 CellLabel->"In[7]:=",
 CellID->5075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VALID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"VARCHAR_SEPARATOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VIEW_DEFINITION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
 CellLabel->"Out[7]=",
 CellID->10712]
}, Open  ]],

Cell["\<\
You can find all the columns in a single table by specifying the table name.\
\>", "Text",
 CellTags->"b:3.3",
 CellID->2600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<SAMPLETABLE1\>\"", ",", "\"\<%\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
 CellLabel->"In[8]:=",
 CellID->2510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
 CellLabel->"Out[8]=",
 CellID->21003]
}, Open  ]],

Cell[TextData[{
 "You can also give a ",
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 " argument."
}], "Text",
 CellTags->"b:3.3",
 CellID->26869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
 CellLabel->"In[9]:=",
 CellID->17861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
 CellLabel->"Out[9]=",
 CellID->14688]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"]], "InlineFormula"],
 " returns a list where each entry is a list of the table name and the column \
names. If you want a list of just the column names, you can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " part notation, entered with ",
 StyleBox["[[All, 2]]", "MR"],
 ", to extract just the second elements."
}], "Text",
 CellTags->"b:3.3",
 CellID->13401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnNames", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
 CellLabel->"In[10]:=",
 CellID->9789],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ENTRY\"\>", ",", "\<\"VALUE\"\>", ",", "\<\"NAME\"\>"}], 
  "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
 CellLabel->"Out[10]=",
 CellID->15255]
}, Open  ]],

Cell[TextData[{
 "In addition, you can give an ",
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " argument."
}], "Text",
 CellTags->"b:3.3",
 CellID->16423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"SQLColumn", "[", "\"\<V%\>\"", "]"}]}], "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
 CellLabel->"In[11]:=",
 CellID->5002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VALID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"VARCHAR_SEPARATOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VIEW_DEFINITION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
 CellLabel->"Out[11]=",
 CellID->10585]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumns",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumns"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["SQLColumnInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"]], 
  "InlineFormula"],
 " take a number of options."
}], "Text",
 CellTags->"b:3.3",
 CellID->24182],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {"\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]},
   {"\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to return headings with the results (",
     Cell[BoxData[
      ButtonBox["SQLColumnInformation",
       BaseStyle->"Link",
       ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"]], 
      "InlineFormula"],
     " option only)"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->10285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumns",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumns"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["SQLColumnInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"]], 
  "InlineFormula"],
 " options."
}], "Caption",
 CellTags->"b:3.3",
 CellID->27088],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<ShowColumnHeadings\>\""], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["SQLColumnInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"]], 
  "InlineFormula"],
 " to return the column headings."
}], "Text",
 CellTags->"b:3.3",
 CellID->31426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnInformation", "[", 
   RowBox[{"conn", ",", " ", "\"\<SA%\>\"", ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
 CellLabel->"In[12]:=",
 CellID->28617],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TABLE_CAT\"\>", "\<\"TABLE_SCHEM\"\>", "\<\"TABLE_NAME\"\>", \
"\<\"COLUMN_NAME\"\>", "\<\"DATA_TYPE\"\>", "\<\"TYPE_NAME\"\>", \
"\<\"COLUMN_SIZE\"\>", "\<\"BUFFER_LENGTH\"\>", "\<\"DECIMAL_DIGITS\"\>", "\<\
\"NUM_PREC_RADIX\"\>", "\<\"NULLABLE\"\>", "\<\"REMARKS\"\>", "\<\"COLUMN_DEF\
\"\>", "\<\"SQL_DATA_TYPE\"\>", "\<\"SQL_DATETIME_SUB\"\>", \
"\<\"CHAR_OCTET_LENGTH\"\>", "\<\"ORDINAL_POSITION\"\>", \
"\<\"IS_NULLABLE\"\>", "\<\"SCOPE_CATLOG\"\>", "\<\"SCOPE_SCHEMA\"\>", \
"\<\"SCOPE_TABLE\"\>", "\<\"SOURCE_DATA_TYPE\"\>", "\<\"TYPE_SUB\"\>"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"ENTRY\"\>", 
     "4", "\<\"INTEGER\"\>", "Null", "4", "Null", "10", "1", "Null", "Null", 
     "4", "Null", "Null", "1", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"VALUE\"\>", 
     "8", "\<\"DOUBLE\"\>", "Null", "8", "Null", "10", "1", "Null", "Null", 
     "8", "Null", "Null", "2", "\<\"YES\"\>", "Null", "Null", "Null", "Null", 
     "1"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SAMPLETABLE1\"\>", "\<\"NAME\"\>", 
     "12", "\<\"VARCHAR\"\>", "2147483647", "Null", "Null", "Null", "1", 
     "Null", "Null", "12", "Null", "Null", "3", "\<\"YES\"\>", "Null", "Null",
      "Null", "Null", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
 CellLabel->"Out[12]//TableForm=",
 CellID->23757]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:3.3",
 CellID->9832],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,460"},
 CellLabel->"In[13]:=",
 CellID->30932],

Cell[TextData[{
 "If the database was designed with particular schema and catalogs, you can \
also select columns by using the ",
 Cell[BoxData["\"\<Catalog\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Schema\>\""], "InlineFormula"],
 " options."
}], "Text",
 CellTags->"b:3.3",
 CellID->4169]
}, Open  ]],

Cell[CellGroupData[{

Cell["Column Representation", "Section",
 CellTags->{"xref:78", "c:38", "b:3.4"},
 CellID->2154],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " expressions hold information about the columns in a database. "
}], "Text",
 CellTags->"b:3.4",
 CellID->25721],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->17189],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLColumn",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLColumn"], "[", "{", 
     StyleBox["table", "TI"], ",", 
     StyleBox["col", "TI"], "}", ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "expression that represents a column in an SQL table", "TableText"]}
  }]], "DefinitionBox",
 CellID->19976],

Cell["Object for representing a column.", "Caption",
 CellTags->"b:3.3",
 CellID->31329],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " accepts a number of options."
}], "Text",
 CellID->2368],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{"option", " ", "name"}], "TableHeader"], 
    StyleBox[
     RowBox[{"default", " ", "value"}], "TableHeader"], " "},
   {"\"\<DataTypeName\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["type of the entry", "TableText"]},
   {"\"\<Nullable\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "whether the entry can be null", "TableText"]},
   {"\"\<DataLength\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "maximum length for variable length data", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->28692],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " options."
}], "Caption",
 CellTags->"b:3.3",
 CellID->21425],

Cell[TextData[{
 "Here is an example demonstrating ",
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " expressions. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:3.4",
 CellID->10555],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:3.4", "Ex--21943418559164291386,461"},
 CellLabel->"In[14]:=",
 CellID->3434],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumns",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumns"]], "InlineFormula"],
 " returns a list of the columns in the database as ",
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " expressions. In this example a pattern is given to pick out just the ",
 StyleBox["SAMPLETABLE1",
  FontSlant->"Italic"],
 " table."
}], "Text",
 CellTags->"b:3.4",
 CellID->16549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\""}], "]"}]], "Input",
 CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
 CellLabel->"In[3]:=",
 CellID->7441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
 CellLabel->"Out[3]=",
 CellID->9512]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:3.4",
 CellID->30145],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.4", "Ex--21943418559164291386,463"},
 CellLabel->"In[4]:=",
 CellID->18060],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " expressions can also be used in commands as discussed in ",
 ButtonBox["Selecting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 " and ",
 ButtonBox["Creating Tables",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 ". ",
 ButtonBox["Creating Tables",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 " discusses one particularly important use."
}], "Text",
 CellTags->"b:3.4",
 CellID->21718]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Column Structure - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 29.5309972}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "This section discusses commands that get information about database \
columns. If you find that the examples in this section do not work as shown, \
you may need to install or restore the example database with the \
DatabaseExamples` package, as described in Using the Example Databases. \
Functions for retrieving information about columns.", "synonyms" -> {}, 
    "title" -> "Column Structure", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/ColumnStructure"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:26"->{
  Cell[1628, 49, 90, 2, 70, "Title",
   CellTags->{"xref:26", "c:37", "b:3.3"},
   CellID->20055]},
 "c:37"->{
  Cell[1628, 49, 90, 2, 70, "Title",
   CellTags->{"xref:26", "c:37", "b:3.3"},
   CellID->20055]},
 "b:3.3"->{
  Cell[1628, 49, 90, 2, 70, "Title",
   CellTags->{"xref:26", "c:37", "b:3.3"},
   CellID->20055],
  Cell[1818, 59, 139, 5, 70, "Text",
   CellTags->"b:3.3",
   CellID->22646],
  Cell[4538, 144, 106, 2, 70, "Caption",
   CellTags->"b:3.3",
   CellID->18875],
  Cell[4647, 148, 229, 10, 70, "Text",
   CellTags->"b:3.3",
   CellID->28433],
  Cell[4879, 160, 319, 9, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,449"},
   CellID->29869],
  Cell[5201, 171, 421, 12, 70, "Text",
   CellTags->"b:3.3",
   CellID->20142],
  Cell[5647, 187, 163, 4, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
   CellID->23844],
  Cell[5813, 193, 43901, 1195, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
   CellID->1416],
  Cell[49729, 1391, 298, 7, 70, "Text",
   CellTags->"b:3.3",
   CellID->21881],
  Cell[50052, 1402, 201, 5, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
   CellID->31998],
  Cell[50256, 1409, 418, 12, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
   CellID->10322],
  Cell[50689, 1424, 1006, 29, 70, "Text",
   CellTags->"b:3.3",
   CellID->18651],
  Cell[51720, 1457, 197, 5, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
   CellID->10021],
  Cell[51920, 1464, 1172, 27, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
   CellID->5699],
  Cell[53107, 1494, 269, 9, 70, "Text",
   CellTags->"b:3.3",
   CellID->3557],
  Cell[53401, 1507, 243, 7, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
   CellID->28476],
  Cell[53647, 1516, 1293, 29, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
   CellID->27892],
  Cell[54955, 1548, 264, 6, 70, "Text",
   CellTags->"b:3.3",
   CellID->24389],
  Cell[55244, 1558, 256, 7, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
   CellID->5075],
  Cell[55503, 1567, 1315, 36, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
   CellID->10712],
  Cell[56833, 1606, 135, 4, 70, "Text",
   CellTags->"b:3.3",
   CellID->2600],
  Cell[56993, 1614, 269, 8, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
   CellID->2510],
  Cell[57265, 1624, 418, 12, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
   CellID->21003],
  Cell[57698, 1639, 234, 9, 70, "Text",
   CellTags->"b:3.3",
   CellID->26869],
  Cell[57957, 1652, 241, 6, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
   CellID->17861],
  Cell[58201, 1660, 418, 12, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
   CellID->14688],
  Cell[58634, 1675, 510, 14, 70, "Text",
   CellTags->"b:3.3",
   CellID->13401],
  Cell[59169, 1693, 320, 9, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
   CellID->9789],
  Cell[59492, 1704, 215, 6, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
   CellID->15255],
  Cell[59722, 1713, 245, 9, 70, "Text",
   CellTags->"b:3.3",
   CellID->16423],
  Cell[59992, 1726, 232, 6, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
   CellID->5002],
  Cell[60227, 1734, 1316, 36, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
   CellID->10585],
  Cell[61558, 1773, 550, 19, 70, "Text",
   CellTags->"b:3.3",
   CellID->24182],
  Cell[63154, 1826, 536, 19, 70, "Caption",
   CellTags->"b:3.3",
   CellID->27088],
  Cell[63693, 1847, 359, 12, 70, "Text",
   CellTags->"b:3.3",
   CellID->31426],
  Cell[64077, 1863, 313, 8, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
   CellID->28617],
  Cell[64393, 1873, 1858, 37, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
   CellID->23757],
  Cell[66266, 1913, 78, 2, 70, "Text",
   CellTags->"b:3.3",
   CellID->9832],
  Cell[66347, 1917, 168, 4, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,460"},
   CellID->30932],
  Cell[66518, 1923, 302, 9, 70, "Text",
   CellTags->"b:3.3",
   CellID->4169],
  Cell[68061, 1977, 88, 2, 70, "Caption",
   CellTags->"b:3.3",
   CellID->31329],
  Cell[69236, 2017, 213, 8, 70, "Caption",
   CellTags->"b:3.3",
   CellID->21425]},
 "c:01"->{
  Cell[1743, 55, 72, 2, 70, "Section",
   CellTags->"c:01",
   CellID->20328]},
 "Ex--21943418559164291386,449"->{
  Cell[4879, 160, 319, 9, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,449"},
   CellID->29869]},
 "Ex--21943418559164291386,450"->{
  Cell[5647, 187, 163, 4, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
   CellID->23844],
  Cell[5813, 193, 43901, 1195, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
   CellID->1416]},
 "Ex--21943418559164291386,451"->{
  Cell[50052, 1402, 201, 5, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
   CellID->31998],
  Cell[50256, 1409, 418, 12, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
   CellID->10322]},
 "Ex--21943418559164291386,452"->{
  Cell[51720, 1457, 197, 5, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
   CellID->10021],
  Cell[51920, 1464, 1172, 27, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
   CellID->5699]},
 "Ex--21943418559164291386,453"->{
  Cell[53401, 1507, 243, 7, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
   CellID->28476],
  Cell[53647, 1516, 1293, 29, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
   CellID->27892]},
 "Ex--21943418559164291386,454"->{
  Cell[55244, 1558, 256, 7, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
   CellID->5075],
  Cell[55503, 1567, 1315, 36, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
   CellID->10712]},
 "Ex--21943418559164291386,455"->{
  Cell[56993, 1614, 269, 8, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
   CellID->2510],
  Cell[57265, 1624, 418, 12, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
   CellID->21003]},
 "Ex--21943418559164291386,456"->{
  Cell[57957, 1652, 241, 6, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
   CellID->17861],
  Cell[58201, 1660, 418, 12, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
   CellID->14688]},
 "Ex--21943418559164291386,457"->{
  Cell[59169, 1693, 320, 9, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
   CellID->9789],
  Cell[59492, 1704, 215, 6, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
   CellID->15255]},
 "Ex--21943418559164291386,458"->{
  Cell[59992, 1726, 232, 6, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
   CellID->5002],
  Cell[60227, 1734, 1316, 36, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
   CellID->10585]},
 "Ex--21943418559164291386,459"->{
  Cell[64077, 1863, 313, 8, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
   CellID->28617],
  Cell[64393, 1873, 1858, 37, 70, "Output",
   CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
   CellID->23757]},
 "Ex--21943418559164291386,460"->{
  Cell[66347, 1917, 168, 4, 70, "Input",
   CellTags->{"b:3.3", "Ex--21943418559164291386,460"},
   CellID->30932]},
 "xref:78"->{
  Cell[66857, 1937, 96, 2, 70, "Section",
   CellTags->{"xref:78", "c:38", "b:3.4"},
   CellID->2154]},
 "c:38"->{
  Cell[66857, 1937, 96, 2, 70, "Section",
   CellTags->{"xref:78", "c:38", "b:3.4"},
   CellID->2154]},
 "b:3.4"->{
  Cell[66857, 1937, 96, 2, 70, "Section",
   CellTags->{"xref:78", "c:38", "b:3.4"},
   CellID->2154],
  Cell[66956, 1941, 264, 8, 70, "Text",
   CellTags->"b:3.4",
   CellID->25721],
  Cell[69452, 2027, 397, 15, 70, "Text",
   CellTags->"b:3.4",
   CellID->10555],
  Cell[69852, 2044, 319, 9, 70, "Input",
   CellTags->{"b:3.4", "Ex--21943418559164291386,461"},
   CellID->3434],
  Cell[70174, 2055, 524, 16, 70, "Text",
   CellTags->"b:3.4",
   CellID->16549],
  Cell[70723, 2075, 200, 5, 70, "Input",
   CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
   CellID->7441],
  Cell[70926, 2082, 1172, 27, 70, "Output",
   CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
   CellID->9512],
  Cell[72113, 2112, 79, 2, 70, "Text",
   CellTags->"b:3.4",
   CellID->30145],
  Cell[72195, 2116, 167, 4, 70, "Input",
   CellTags->{"b:3.4", "Ex--21943418559164291386,463"},
   CellID->18060],
  Cell[72365, 2122, 660, 20, 70, "Text",
   CellTags->"b:3.4",
   CellID->21718]},
 "Ex--21943418559164291386,461"->{
  Cell[69852, 2044, 319, 9, 70, "Input",
   CellTags->{"b:3.4", "Ex--21943418559164291386,461"},
   CellID->3434]},
 "Ex--21943418559164291386,462"->{
  Cell[70723, 2075, 200, 5, 70, "Input",
   CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
   CellID->7441],
  Cell[70926, 2082, 1172, 27, 70, "Output",
   CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
   CellID->9512]},
 "Ex--21943418559164291386,463"->{
  Cell[72195, 2116, 167, 4, 70, "Input",
   CellTags->{"b:3.4", "Ex--21943418559164291386,463"},
   CellID->18060]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:26", 74668, 2185},
 {"c:37", 74779, 2189},
 {"b:3.3", 74891, 2193},
 {"c:01", 79114, 2320},
 {"Ex--21943418559164291386,449", 79229, 2324},
 {"Ex--21943418559164291386,450", 79379, 2328},
 {"Ex--21943418559164291386,451", 79648, 2335},
 {"Ex--21943418559164291386,452", 79918, 2342},
 {"Ex--21943418559164291386,453", 80188, 2349},
 {"Ex--21943418559164291386,454", 80459, 2356},
 {"Ex--21943418559164291386,455", 80729, 2363},
 {"Ex--21943418559164291386,456", 80998, 2370},
 {"Ex--21943418559164291386,457", 81268, 2377},
 {"Ex--21943418559164291386,458", 81536, 2384},
 {"Ex--21943418559164291386,459", 81806, 2391},
 {"Ex--21943418559164291386,460", 82077, 2398},
 {"xref:78", 82208, 2402},
 {"c:38", 82323, 2406},
 {"b:3.4", 82439, 2410},
 {"Ex--21943418559164291386,461", 83449, 2441},
 {"Ex--21943418559164291386,462", 83600, 2445},
 {"Ex--21943418559164291386,463", 83869, 2452}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1003, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1628, 49, 90, 2, 70, "Title",
 CellTags->{"xref:26", "c:37", "b:3.3"},
 CellID->20055],
Cell[CellGroupData[{
Cell[1743, 55, 72, 2, 70, "Section",
 CellTags->"c:01",
 CellID->20328],
Cell[1818, 59, 139, 5, 70, "Text",
 CellTags->"b:3.3",
 CellID->22646],
Cell[1960, 66, 442, 11, 70, "Text",
 CellID->26362],
Cell[2405, 79, 2130, 63, 70, "DefinitionBox",
 CellID->4886],
Cell[4538, 144, 106, 2, 70, "Caption",
 CellTags->"b:3.3",
 CellID->18875],
Cell[4647, 148, 229, 10, 70, "Text",
 CellTags->"b:3.3",
 CellID->28433],
Cell[4879, 160, 319, 9, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,449"},
 CellID->29869],
Cell[5201, 171, 421, 12, 70, "Text",
 CellTags->"b:3.3",
 CellID->20142],
Cell[CellGroupData[{
Cell[5647, 187, 163, 4, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
 CellID->23844],
Cell[5813, 193, 43901, 1195, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,450"},
 CellID->1416]
}, Open  ]],
Cell[49729, 1391, 298, 7, 70, "Text",
 CellTags->"b:3.3",
 CellID->21881],
Cell[CellGroupData[{
Cell[50052, 1402, 201, 5, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
 CellID->31998],
Cell[50256, 1409, 418, 12, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,451"},
 CellID->10322]
}, Open  ]],
Cell[50689, 1424, 1006, 29, 70, "Text",
 CellTags->"b:3.3",
 CellID->18651],
Cell[CellGroupData[{
Cell[51720, 1457, 197, 5, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
 CellID->10021],
Cell[51920, 1464, 1172, 27, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,452"},
 CellID->5699]
}, Open  ]],
Cell[53107, 1494, 269, 9, 70, "Text",
 CellTags->"b:3.3",
 CellID->3557],
Cell[CellGroupData[{
Cell[53401, 1507, 243, 7, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
 CellID->28476],
Cell[53647, 1516, 1293, 29, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,453"},
 CellID->27892]
}, Open  ]],
Cell[54955, 1548, 264, 6, 70, "Text",
 CellTags->"b:3.3",
 CellID->24389],
Cell[CellGroupData[{
Cell[55244, 1558, 256, 7, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
 CellID->5075],
Cell[55503, 1567, 1315, 36, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,454"},
 CellID->10712]
}, Open  ]],
Cell[56833, 1606, 135, 4, 70, "Text",
 CellTags->"b:3.3",
 CellID->2600],
Cell[CellGroupData[{
Cell[56993, 1614, 269, 8, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
 CellID->2510],
Cell[57265, 1624, 418, 12, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,455"},
 CellID->21003]
}, Open  ]],
Cell[57698, 1639, 234, 9, 70, "Text",
 CellTags->"b:3.3",
 CellID->26869],
Cell[CellGroupData[{
Cell[57957, 1652, 241, 6, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
 CellID->17861],
Cell[58201, 1660, 418, 12, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,456"},
 CellID->14688]
}, Open  ]],
Cell[58634, 1675, 510, 14, 70, "Text",
 CellTags->"b:3.3",
 CellID->13401],
Cell[CellGroupData[{
Cell[59169, 1693, 320, 9, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
 CellID->9789],
Cell[59492, 1704, 215, 6, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,457"},
 CellID->15255]
}, Open  ]],
Cell[59722, 1713, 245, 9, 70, "Text",
 CellTags->"b:3.3",
 CellID->16423],
Cell[CellGroupData[{
Cell[59992, 1726, 232, 6, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
 CellID->5002],
Cell[60227, 1734, 1316, 36, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,458"},
 CellID->10585]
}, Open  ]],
Cell[61558, 1773, 550, 19, 70, "Text",
 CellTags->"b:3.3",
 CellID->24182],
Cell[62111, 1794, 1040, 30, 70, "DefinitionBox3Col",
 CellID->10285],
Cell[63154, 1826, 536, 19, 70, "Caption",
 CellTags->"b:3.3",
 CellID->27088],
Cell[63693, 1847, 359, 12, 70, "Text",
 CellTags->"b:3.3",
 CellID->31426],
Cell[CellGroupData[{
Cell[64077, 1863, 313, 8, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
 CellID->28617],
Cell[64393, 1873, 1858, 37, 70, "Output",
 CellTags->{"b:3.3", "Ex--21943418559164291386,459"},
 CellID->23757]
}, Open  ]],
Cell[66266, 1913, 78, 2, 70, "Text",
 CellTags->"b:3.3",
 CellID->9832],
Cell[66347, 1917, 168, 4, 70, "Input",
 CellTags->{"b:3.3", "Ex--21943418559164291386,460"},
 CellID->30932],
Cell[66518, 1923, 302, 9, 70, "Text",
 CellTags->"b:3.3",
 CellID->4169]
}, Open  ]],
Cell[CellGroupData[{
Cell[66857, 1937, 96, 2, 70, "Section",
 CellTags->{"xref:78", "c:38", "b:3.4"},
 CellID->2154],
Cell[66956, 1941, 264, 8, 70, "Text",
 CellTags->"b:3.4",
 CellID->25721],
Cell[67223, 1951, 442, 11, 70, "Text",
 CellID->17189],
Cell[67668, 1964, 390, 11, 70, "DefinitionBox",
 CellID->19976],
Cell[68061, 1977, 88, 2, 70, "Caption",
 CellTags->"b:3.3",
 CellID->31329],
Cell[68152, 1981, 209, 7, 70, "Text",
 CellID->2368],
Cell[68364, 1990, 869, 25, 70, "DefinitionBox3Col",
 CellID->28692],
Cell[69236, 2017, 213, 8, 70, "Caption",
 CellTags->"b:3.3",
 CellID->21425],
Cell[69452, 2027, 397, 15, 70, "Text",
 CellTags->"b:3.4",
 CellID->10555],
Cell[69852, 2044, 319, 9, 70, "Input",
 CellTags->{"b:3.4", "Ex--21943418559164291386,461"},
 CellID->3434],
Cell[70174, 2055, 524, 16, 70, "Text",
 CellTags->"b:3.4",
 CellID->16549],
Cell[CellGroupData[{
Cell[70723, 2075, 200, 5, 70, "Input",
 CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
 CellID->7441],
Cell[70926, 2082, 1172, 27, 70, "Output",
 CellTags->{"b:3.4", "Ex--21943418559164291386,462"},
 CellID->9512]
}, Open  ]],
Cell[72113, 2112, 79, 2, 70, "Text",
 CellTags->"b:3.4",
 CellID->30145],
Cell[72195, 2116, 167, 4, 70, "Input",
 CellTags->{"b:3.4", "Ex--21943418559164291386,463"},
 CellID->18060],
Cell[72365, 2122, 660, 20, 70, "Text",
 CellTags->"b:3.4",
 CellID->21718]
}, Open  ]]
}, Open  ]],
Cell[73052, 2146, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

