(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21834,        690]
NotebookOptionsPosition[     15835,        483]
NotebookOutlinePosition[     19681,        603]
CellTagsIndexPosition[     19587,        597]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLCreateTable" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLCreateTable"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"SQLCreateTable\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Creating Tables", "Title",
 CellID->19187],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLCreateTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"]], "InlineFormula"],
 " creates a new table in a database. An alternative, using raw SQL, is \
described in ",
 ButtonBox["Creating Tables with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"],
 "."
}], "Text",
 CellTags->"b:4.1.2",
 CellID->22413],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->30974],

Cell[TextData[{
 "When creating a table, the result of ",
 Cell[BoxData[
  ButtonBox["SQLCreateTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query. If the \
table is created correctly, this integer will always be zero as no rows are \
affected when creating a new table."
}], "Text",
 CellTags->"b:4.1.2",
 CellID->14270],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLCreateTable",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["table", "TI"], ",", "{", 
     StyleBox["columns", "TI"], "}", ",", 
     StyleBox["opts", "TI"], "]"}], Cell["create an SQL table", "TableText"]}
  }]], "DefinitionBox",
 CellID->29170],

Cell["Creating a table in a database.", "Caption",
 CellTags->"b:4.1.2",
 CellID->235],

Cell["Here is an example that creates a table. ", "Text",
 CellTags->"b:4.1.2",
 CellID->30833],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:4.1.2",
 CellID->19711],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[1]:=",
 CellID->25760],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLCreateTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"]], "InlineFormula"],
 " creates a table. The columns are given as a list of ",
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " expressions. In the following example, a new table, ",
 StyleBox["DATATYPESTABLE",
  FontSlant->"Italic"],
 ", is created that has one column for each of the data types returned from \
",
 Cell[BoxData[
  ButtonBox["SQLDataTypeNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeNames"]], 
  "InlineFormula"],
 ". The column, ",
 StyleBox["TINYINTCOL",
  FontSlant->"Italic"],
 ", is configured so that it cannot be set to ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ".",
 " ",
 "However, each binary column can be set to ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". The database default for ",
 Cell[BoxData["\"\<Nullable\>\""], "InlineFormula"],
 " is used for every other column that does not specify the ",
 Cell[BoxData["\"\<Nullable\>\""], "InlineFormula"],
 " option. The character-based columns are limited to a specific data length; \
other columns use the default data length for their type."
}], "Text",
 CellTags->"b:4.1.2",
 CellID->18896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDataTypeNames", "[", "conn", "]"}]], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[3]:=",
 CellID->4667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TINYINT\"\>", ",", "\<\"BIGINT\"\>", 
   ",", "\<\"LONGVARBINARY\"\>", ",", "\<\"VARBINARY\"\>", 
   ",", "\<\"BINARY\"\>", ",", "\<\"LONGVARCHAR\"\>", ",", "\<\"CHAR\"\>", 
   ",", "\<\"NUMERIC\"\>", ",", "\<\"DECIMAL\"\>", ",", "\<\"INTEGER\"\>", 
   ",", "\<\"SMALLINT\"\>", ",", "\<\"FLOAT\"\>", ",", "\<\"REAL\"\>", 
   ",", "\<\"DOUBLE\"\>", ",", "\<\"VARCHAR\"\>", 
   ",", "\<\"VARCHAR_IGNORECASE\"\>", ",", "\<\"BOOLEAN\"\>", 
   ",", "\<\"DATE\"\>", ",", "\<\"TIME\"\>", ",", "\<\"TIMESTAMP\"\>", 
   ",", "\<\"OTHER\"\>"}], "}"}]], "Output",
 CellTags->"b:4.1.2",
 CellLabel->"Out[3]=",
 CellID->7285]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<DATATYPESTABLE\>\"", ",", " ", "\[IndentingNewLine]",
    
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TINYINTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TINYINT\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<SMALLINTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<SMALLINT\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<INTEGERCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<BIGINTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BIGINT\>\""}]}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<NUMERICCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<NUMERIC\>\""}]}], "]"}], 
     ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DECIMALCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DECIMAL\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<FLOATCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<FLOAT\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<REALCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<REAL\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DOUBLECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}], ",",
      
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<BITCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BIT\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<LONGVARBINARYCOL\>\"", ",", " ", 
       RowBox[{"DataTypeName", "->", "\"\<LONGVARBINARY\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "\[Rule]", "True"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<VARBINARYCOL\>\"", ",", " ", 
       RowBox[{"DataTypeName", "->", "\"\<VARBINARY\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "\[Rule]", "True"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<BINARYCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BINARY\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "\[Rule]", "True"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<LONGVARCHARCOL\>\"", ",", " ", 
       RowBox[{"DataTypeName", "->", "\"\<LONGVARCHAR\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<VARCHARCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARCHAR\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"\"\<DataLength\>\"", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<CHARCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<CHAR\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"\"\<DataLength\>\"", "\[Rule]", "3"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DATECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DATE\>\""}]}], "]"}], ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TIMECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TIME\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TIMESTAMPCOL\>\"", ",", " ", 
       RowBox[{"DataTypeName", "->", "\"\<TIMESTAMP\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<OBJECTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<OBJECT\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "\[Rule]", "True"}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[4]:=",
 CellID->12550],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.1.2",
 CellLabel->"Out[4]=",
 CellID->140]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTableNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"]], "InlineFormula"],
 " verifies that the table exists in the database."
}], "Text",
 CellTags->"b:4.1.2",
 CellID->13694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", "\"\<DATATYPESTABLE\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[5]:=",
 CellID->2695],

Cell[BoxData[
 RowBox[{"{", "\<\"DATATYPESTABLE\"\>", "}"}]], "Output",
 CellTags->"b:4.1.2",
 CellLabel->"Out[5]=",
 CellID->21624]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"]], "InlineFormula"],
 " verifies the columns in the table."
}], "Text",
 CellTags->"b:4.1.2",
 CellID->28019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<DATATYPESTABLE\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[6]:=",
 CellID->2125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"TINYINTCOL\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"SMALLINTCOL\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"INTEGERCOL\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"BIGINTCOL\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"NUMERICCOL\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"DECIMALCOL\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"FLOATCOL\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"REALCOL\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"DOUBLECOL\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"BITCOL\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"LONGVARBINARYCOL\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"VARBINARYCOL\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"BINARYCOL\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"LONGVARCHARCOL\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"VARCHARCOL\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"CHARCOL\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"DATECOL\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"TIMECOL\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"TIMESTAMPCOL\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"DATATYPESTABLE\"\>", ",", "\<\"OBJECTCOL\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.1.2",
 CellLabel->"Out[6]=",
 CellID->26576]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLCreateTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"]], "InlineFormula"],
 " accepts one option."
}], "Text",
 CellTags->"b:4.3",
 CellID->21694],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<Timeout\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the timeout for a query", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->22658],

Cell[TextData[{
 "Option of ",
 Cell[BoxData[
  ButtonBox["SQLCreateTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:4.3",
 CellID->26302],

Cell[TextData[{
 Cell[BoxData["\"\<Timeout\>\""], "InlineFormula"],
 " can be used to cancel a query if it takes too long to execute."
}], "Text",
 CellTags->"b:4.3",
 CellID->17371],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:4.1.2",
 CellID->22466],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<DATATYPESTABLE\>\""}], "]"}], ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[7]:=",
 CellID->4678],

Cell[TextData[{
 "Certain databases support further options for columns, such as whether a \
column is a key or whether it auto-increments. If these options are desired, \
then a raw SQL statement should be used to create the table. ",
 ButtonBox["Creating Tables with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"],
 " has some ideas and examples."
}], "Text",
 CellTags->"b:4.1.2",
 CellID->22593]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Creating Tables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 32.6872270}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "SQLCreateTable creates a new table in a database. An alternative, using \
raw SQL, is described in Creating Tables with Raw SQL. If you find that the \
examples in this tutorial do not work as shown, you may need to install or \
restore the example database with the DatabaseExamples` package, as described \
in Using the Example Databases. When creating a table, the result of \
SQLCreateTable is an integer specifying the number of rows affected by the \
query. If the table is created correctly, this integer will always be zero as \
no rows are affected when creating a new table.", "synonyms" -> {}, "title" -> 
    "Creating Tables", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/CreatingTables"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.1.2"->{
  Cell[1272, 45, 433, 13, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->22413],
  Cell[2154, 73, 445, 11, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->14270],
  Cell[3007, 99, 86, 2, 70, "Caption",
   CellTags->"b:4.1.2",
   CellID->235],
  Cell[3096, 103, 95, 2, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->30833],
  Cell[3194, 107, 231, 10, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->19711],
  Cell[3428, 119, 287, 9, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->25760],
  Cell[3718, 130, 1480, 43, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->18896],
  Cell[5223, 177, 132, 4, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->4667],
  Cell[5358, 183, 656, 13, 70, "Output",
   CellTags->"b:4.1.2",
   CellID->7285],
  Cell[6051, 201, 4508, 96, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->12550],
  Cell[10562, 299, 87, 3, 70, "Output",
   CellTags->"b:4.1.2",
   CellID->140],
  Cell[10664, 305, 259, 8, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->13694],
  Cell[10948, 317, 173, 5, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->2695],
  Cell[11124, 324, 132, 4, 70, "Output",
   CellTags->"b:4.1.2",
   CellID->21624],
  Cell[11271, 331, 248, 8, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->28019],
  Cell[11544, 343, 179, 5, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->2125],
  Cell[11726, 350, 2103, 59, 70, "Output",
   CellTags->"b:4.1.2",
   CellID->26576],
  Cell[14983, 455, 101, 2, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->22466],
  Cell[15087, 459, 256, 7, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->4678],
  Cell[15346, 468, 447, 10, 70, "Text",
   CellTags->"b:4.1.2",
   CellID->22593]},
 "b:4.3"->{
  Cell[13844, 412, 231, 8, 70, "Text",
   CellTags->"b:4.3",
   CellID->21694],
  Cell[14565, 437, 230, 9, 70, "Caption",
   CellTags->"b:4.3",
   CellID->26302],
  Cell[14798, 448, 182, 5, 70, "Text",
   CellTags->"b:4.3",
   CellID->17371]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.1.2", 17664, 523},
 {"b:4.3", 19320, 584}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 596, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1221, 42, 48, 1, 70, "Title",
 CellID->19187],
Cell[1272, 45, 433, 13, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->22413],
Cell[1708, 60, 443, 11, 70, "Text",
 CellID->30974],
Cell[2154, 73, 445, 11, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->14270],
Cell[2602, 86, 402, 11, 70, "DefinitionBox",
 CellID->29170],
Cell[3007, 99, 86, 2, 70, "Caption",
 CellTags->"b:4.1.2",
 CellID->235],
Cell[3096, 103, 95, 2, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->30833],
Cell[3194, 107, 231, 10, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->19711],
Cell[3428, 119, 287, 9, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->25760],
Cell[3718, 130, 1480, 43, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->18896],
Cell[CellGroupData[{
Cell[5223, 177, 132, 4, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->4667],
Cell[5358, 183, 656, 13, 70, "Output",
 CellTags->"b:4.1.2",
 CellID->7285]
}, Open  ]],
Cell[CellGroupData[{
Cell[6051, 201, 4508, 96, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->12550],
Cell[10562, 299, 87, 3, 70, "Output",
 CellTags->"b:4.1.2",
 CellID->140]
}, Open  ]],
Cell[10664, 305, 259, 8, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->13694],
Cell[CellGroupData[{
Cell[10948, 317, 173, 5, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->2695],
Cell[11124, 324, 132, 4, 70, "Output",
 CellTags->"b:4.1.2",
 CellID->21624]
}, Open  ]],
Cell[11271, 331, 248, 8, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->28019],
Cell[CellGroupData[{
Cell[11544, 343, 179, 5, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->2125],
Cell[11726, 350, 2103, 59, 70, "Output",
 CellTags->"b:4.1.2",
 CellID->26576]
}, Open  ]],
Cell[13844, 412, 231, 8, 70, "Text",
 CellTags->"b:4.3",
 CellID->21694],
Cell[14078, 422, 484, 13, 70, "DefinitionBox3Col",
 CellID->22658],
Cell[14565, 437, 230, 9, 70, "Caption",
 CellTags->"b:4.3",
 CellID->26302],
Cell[14798, 448, 182, 5, 70, "Text",
 CellTags->"b:4.3",
 CellID->17371],
Cell[14983, 455, 101, 2, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->22466],
Cell[15087, 459, 256, 7, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->4678],
Cell[15346, 468, 447, 10, 70, "Text",
 CellTags->"b:4.1.2",
 CellID->22593]
}, Open  ]],
Cell[15808, 481, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

