(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    150417,       3862]
NotebookOptionsPosition[    111351,       2675]
NotebookOutlinePosition[    137012,       3402]
CellTagsIndexPosition[    135063,       3348]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"CloseSQLConnection" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/CloseSQLConnection"], "DataSourceNames" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/DataSourceNames"], 
         "DataSources" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/DataSources"], 
         "JDBC" :> Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBC"], 
         "JDBCDriverNames" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDriverNames"], 
         "JDBCDrivers" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/JDBCDrivers"], 
         "OpenSQLConnection" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/OpenSQLConnection"], 
         "SQLConnectionInformation" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLConnectionInformation"], 
         "SQLConnections" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLConnections"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"CloseSQLConnection\"\>", 
      2->"\<\"DataSourceNames\"\>", 3->"\<\"DataSources\"\>", 
      4->"\<\"JDBC\"\>", 5->"\<\"JDBCDriverNames\"\>", 
      6->"\<\"JDBCDrivers\"\>", 7->"\<\"OpenSQLConnection\"\>", 
      8->"\<\"SQLConnectionInformation\"\>", 
      9->"\<\"SQLConnections\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Database Connections", "Title",
 CellTags->{"c:22", "xref:145"},
 CellID->3753],

Cell["\<\
The first step in using a database is making a connection. This part of the \
tutorial discusses how to do this.\
\>", "Text",
 CellTags->"b:2.0",
 CellID->12423],

Cell[TextData[{
 "If you are just starting to use ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 ", you might want to look at some of the basic examples in this ",
 "tutorial",
 ". Then, to learn if ",
 StyleBox["DatabaseLink ",
  FontSlant->"Italic"],
 "comes with a driver for your database, you might want to study ",
 ButtonBox["JDBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 ", which contains further information about adding new drivers. Finally, if \
you want to give your connection a name, you might want to study ",
 ButtonBox["Named Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"],
 "."
}], "Text",
 CellTags->"b:2.0",
 CellID->16279],

Cell[CellGroupData[{

Cell["Setting Up a Database", "Section",
 CellTags->{"xref:19", "c:23", "b:2.2.0"},
 CellID->353438053],

Cell[TextData[{
 "Many users of ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " will have an existing database they wish to connect to and use. If you \
have one, you should be able to read this documentation and modify it to \
connect to your own database. If you do not already have a database, you can \
use HSQLDB (included in ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 "). If you want to set up a different type of database, you will need to \
refer to the specific information for that database. Once you have set up \
your database, you can continue to use this tutorial to learn how to connect \
to it."
}], "Text",
 CellTags->"b:2.1",
 CellID->25996]
}, Open  ]],

Cell[CellGroupData[{

Cell["Establishing a Connection", "Section",
 CellTags->{"xref:19", "c:23", "b:2.2.0"},
 CellID->16139],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->16687],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["OpenSQLConnection",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"], "[", 
     StyleBox["name", "TI"], "]"}], Cell[
    "connect to a named SQL data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenSQLConnection",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"], "[", 
     ButtonBox["JDBC",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/JDBC"], "[", 
     StyleBox["driver", "TI"], ",", 
     StyleBox["url", "TI"], "]", "]"}], Cell[
    "connect to the data source URL using JDBC", "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenSQLConnection",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"], "[", 
     StyleBox["args", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "set options for the connection", "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenSQLConnection",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"], "[", "]"}], 
    Cell[TextData[{
     "use the ",
     StyleBox["Connection Tool", "DialogElementName"],
     " to open a connection"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CloseSQLConnection",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/CloseSQLConnection"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell["close a connection", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLConnections",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLConnections"], "[", "]"}], Cell[
    "list SQL connections", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLConnectionInformation",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLConnectionInformation"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "verbose information about an SQL connection", "TableText"]}
  }]], "DefinitionBox",
 CellID->12529],

Cell["Functions for working with database connections.", "Caption",
 CellTags->"b:2.2.0",
 CellID->22549],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:2.2.0",
 CellID->17437],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
 CellLabel->"In[1]:=",
 CellID->19866],

Cell[TextData[{
 "Now you can connect to a named database, called ",
 StyleBox["demo",
  FontSlant->"Italic"],
 ", that is provided by ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " for documentation. ",
 ButtonBox["Database Resources: Connection Configuration",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#21025"],
 " shows how to set up new named connections. You can learn about existing \
named connections in ",
 ButtonBox["Named Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"],
 "."
}], "Text",
 CellTags->"b:2.2.0",
 CellID->12949],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " returns a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression that refers to the connection. It can be used to make queries \
on the database. "
}], "Text",
 CellTags->"b:2.2.0",
 CellID->193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", " ", "=", " ", 
  RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellLabel->"In[2]:=",
 CellID->23195],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellLabel->"Out[2]=",
 CellID->3297]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLConnections",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLConnections"]], "InlineFormula"],
 " returns a list of all the open connections."
}], "Text",
 CellTags->"b:2.2.0",
 CellID->20416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLConnections", "[", "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
 CellLabel->"In[3]:=",
 CellID->28286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLConnection", "[", 
   RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}],
    "]"}], "}"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
 CellLabel->"Out[3]=",
 CellID->16105]
}, Open  ]],

Cell["\<\
In the following example, the tables that are found in the database are \
returned.\
\>", "Text",
 CellTags->"b:2.2.0",
 CellID->24488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", "conn", "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
 CellLabel->"In[4]:=",
 CellID->16282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLTable", "[", 
   RowBox[{"\<\"SAMPLETABLE1\"\>", ",", 
    RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], 
  "}"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
 CellLabel->"Out[4]=",
 CellID->12455]
}, Open  ]],

Cell[TextData[{
 "When you have finished with a connection, you can close it with ",
 Cell[BoxData[
  ButtonBox["CloseSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/CloseSQLConnection"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.2.0",
 CellID->25734],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,428"},
 CellLabel->"In[5]:=",
 CellID->18114],

Cell[CellGroupData[{

Cell[BoxData["conn"], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
 CellLabel->"In[6]:=",
 CellID->11701],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Closed\"\>", 
   ",", "\<\"<>\"\>"}], "]"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
 CellLabel->"Out[6]=",
 CellID->31316]
}, Open  ]],

Cell[TextData[{
 "There are a number of options that can be given to ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.2.0",
 CellID->20671],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<Description\>\"", "\"\<\>\"", Cell[
    "textual description of the connection", "TableText"]},
   {"\"\<Name\>\"", "\"\<\>\"", Cell["name of the connection", "TableText"]},
   {"\"\<Username\>\"", "\"\<\>\"", Cell[
    "username to use for connecting", "TableText"]},
   {"\"\<Password\>\"", "\"\<\>\"", Cell[
    "password to use for connecting", "TableText"]},
   {"\"\<Catalog\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "location of the database catalog", "TableText"]},
   {"\"\<ReadOnly\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[StyleBox[
    "set the connection to be read only", "TableText"]], "TableText"]},
   {"\"\<TransactionIsolationLevel\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set transaction isolation for  the connection", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->5786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " options."
}], "Caption",
 CellTags->"b:2.2.0",
 CellID->12263],

Cell["\<\
These options can be used when opening a connection. For instance, the \
following allows you to use a different username and password for the \
connection.\
\>", "Text",
 CellTags->"b:2.2.0",
 CellID->4313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<demo\>\"", ",", " ", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}], ",", " ", 
    RowBox[{"\"\<Password\>\"", "->", "\"\<\>\""}]}], "]"}]}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
 CellLabel->"In[7]:=",
 CellID->24355],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "2", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
 CellLabel->"Out[7]=",
 CellID->31185]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
 CellLabel->"In[8]:=",
 CellID->20053],

Cell[TextData[{
 "If you enter ",
 Cell[BoxData["\"\<$Prompt\>\""], "InlineFormula"],
 " as a password, a dialog box opens that will prompt you for the password. \
This helps keep the password more secure."
}], "Text",
 CellTags->"b:2.2.0",
 CellID->912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<demo\>\"", ",", " ", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}], ",", " ", 
    RowBox[{"\"\<Password\>\"", "->", "\"\<$Prompt\>\""}]}], "]"}]}]], "Input",\

 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellLabel->"In[9]:=",
 CellID->10808],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "3", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellLabel->"Out[9]=",
 CellID->1832]
}, Open  ]],

Cell[TextData[{
 "Once a connection has been created, certain options can be changed using ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 ".."
}], "Text",
 CellID->391368040],

Cell[BoxData[GridBox[{
   {"\"\<Catalog\>\"", Cell[
    "location of the database catalog", "TableText"]},
   {"\"\<ReadOnly\>\"", Cell["whether to open read only", "TableText"]},
   {"\"\<TransactionIsolationLevel\>\"", Cell[
    "whether to add transaction isolation", "TableText"]}
  }]], "DefinitionBox",
 CellID->83934075],

Cell["\<\
Connection options that can be changed after the connection is created.\
\>", "Caption",
 CellTags->"b:2.2.0",
 CellID->263651101],

Cell["\<\
This changes the connection to only allow read access to the database.\
\>", "Text",
 CellID->13408378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"ReadOnly", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellLabel->"In[10]:=",
 CellID->389106687],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "3", ",", "\<\"Open\"\>", ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellLabel->"Out[10]=",
 CellID->96076015]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
 CellLabel->"In[11]:=",
 CellID->431636696],

Cell[TextData[{
 "More information on the ",
 Cell[BoxData["TransactionIsolationLevel"], "InlineFormula"],
 " option is found in ",
 ButtonBox["Transaction Isolation",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#200404233"],
 "."
}], "Text",
 CellID->149843365]
}, Open  ]],

Cell[CellGroupData[{

Cell["Connection Information", "Section",
 CellTags->{"xref:19", "c:23", "b:2.2.0"},
 CellID->37361426],

Cell[TextData[{
 "Detailed information about a connection can be obtained from ",
 Cell[BoxData[
  ButtonBox["SQLConnectionInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLConnectionInformation"]], 
  "InlineFormula"],
 ". This can be demonstrated in the following sequence."
}], "Text",
 CellID->826538626],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
 CellLabel->"In[1]:=",
 CellID->462571295],

Cell["This opens a connection to one of the sample databases.", "Text",
 CellTags->"b:2.2.0",
 CellID->53197519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", " ", "=", " ", 
  RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellLabel->"In[2]:=",
 CellID->279939859],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>"}], "]"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellLabel->"Out[2]=",
 CellID->76385560]
}, Open  ]],

Cell["Here, information on the connection is created.", "Text",
 CellTags->"b:2.2.0",
 CellID->41762904],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"SQLConnectionInformation", "[", "conn", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->248529233],

Cell["This prints a tidier form of information on the connection.", "Text",
 CellID->133235564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Transpose", "[", "data", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->231267409],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"AllProceduresAreCallable\"\>", "True"},
    {"\<\"AllTablesAreSelectable\"\>", "True"},
    {"\<\"CatalogSeparator\"\>", "\<\"\"\>"},
    {"\<\"CatalogTerm\"\>", "\<\"\"\>"},
    {"\<\"DatabaseMajorVersion\"\>", "1"},
    {"\<\"DatabaseMinorVersion\"\>", "8"},
    {"\<\"DatabaseProductName\"\>", "\<\"HSQL Database Engine\"\>"},
    {"\<\"DatabaseProductVersion\"\>", "\<\"1.8.0\"\>"},
    {"\<\"DataDefinitionCausesTransactionCommit\"\>", "True"},
    {"\<\"DataDefinitionIgnoredInTransactions\"\>", "False"},
    {"\<\"DefaultTransactionIsolationLevel\"\>", "\<\"ReadUncommitted\"\>"},
    {"\<\"DeletesAreDetectedForForwardOnly\"\>", "False"},
    {"\<\"DeletesAreDetectedForScrollInsensitive\"\>", "False"},
    {"\<\"DeletesAreDetectedForScrollSensitive\"\>", "False"},
    {"\<\"DoesMaxRowSizeIncludeBlobs\"\>", "True"},
    {"\<\"DriverMajorVersion\"\>", "1"},
    {"\<\"DriverMinorVersion\"\>", "8"},
    {"\<\"DriverName\"\>", "\<\"HSQL Database Engine Driver\"\>"},
    {"\<\"DriverVersion\"\>", "\<\"1.8.0\"\>"},
    {"\<\"ExtraNameCharacters\"\>", "\<\"\"\>"},
    {"\<\"IdentifierQuoteString\"\>", "\<\"\\\"\"\>"},
    {"\<\"InsertsAreDetectedForForwardOnly\"\>", "False"},
    {"\<\"InsertsAreDetectedForScrollInsensitive\"\>", "False"},
    {"\<\"InsertsAreDetectedForScrollSensitive\"\>", "False"},
    {"\<\"IsCatalogAtStartOfTableName\"\>", "False"},
    {"\<\"JDBCMajorVersion\"\>", "3"},
    {"\<\"JDBCMinorVersion\"\>", "0"},
    {"\<\"LocatorsUpdateCopy\"\>", "False"},
    {"\<\"MaxBinaryLiteralLength\"\>", "0"},
    {"\<\"MaxCatalogNameLength\"\>", "0"},
    {"\<\"MaxCharLiteralLength\"\>", "0"},
    {"\<\"MaxColumnNameLength\"\>", "0"},
    {"\<\"MaxColumnsInGroupBy\"\>", "0"},
    {"\<\"MaxColumnsInIndex\"\>", "0"},
    {"\<\"MaxColumnsInOrderBy\"\>", "0"},
    {"\<\"MaxColumnsInSelect\"\>", "0"},
    {"\<\"MaxColumnsInTable\"\>", "0"},
    {"\<\"MaxConnections\"\>", "0"},
    {"\<\"MaxCursorNameLength\"\>", "0"},
    {"\<\"MaxIndexLength\"\>", "0"},
    {"\<\"MaxProcedureNameLength\"\>", "0"},
    {"\<\"MaxRowSize\"\>", "0"},
    {"\<\"MaxSchemaNameLength\"\>", "0"},
    {"\<\"MaxStatementLength\"\>", "0"},
    {"\<\"MaxStatements\"\>", "0"},
    {"\<\"MaxTableNameLength\"\>", "0"},
    {"\<\"MaxTablesInSelect\"\>", "0"},
    {"\<\"MaxUserNameLength\"\>", "0"},
    {"\<\"NullPlusNonNullIsNull\"\>", "True"},
    {"\<\"NullsAreSortedAtEnd\"\>", "False"},
    {"\<\"NullsAreSortedAtStart\"\>", "False"},
    {"\<\"NullsAreSortedHight\"\>", "False"},
    {"\<\"NullsAreSortedLow\"\>", "True"},
    {"\<\"NumericFunctions\"\>", \
"\<\"ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,\
PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE,BITAND,BITOR,BITXOR,\
ROUNDMAGIC\"\>"},
    {"\<\"OthersDeletesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OthersDeletesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OthersDeletesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OthersInsertsAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OthersInsertsAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OthersInsertsAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OthersUpdatesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OthersUpdatesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OthersUpdatesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OwnDeletesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OwnDeletesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OwnDeletesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OwnInsertsAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OwnInsertsAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OwnInsertsAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OwnUpdatesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OwnUpdatesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OwnUpdatesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"ProcedureTerm\"\>", "\<\"\"\>"},
    {"\<\"ReadOnly\"\>", "False"},
    {"\<\"SchemaTerm\"\>", "\<\"SCHEMA\"\>"},
    {"\<\"SearchStringEscape\"\>", "\<\"\\\\\"\>"},
    {"\<\"SQLKeywords\"\>", \
"\<\"BEFORE,BIGINT,BINARY,CACHED,DATETIME,LIMIT,LONGVARBINARY,LONGVARCHAR,\
OBJECT,OTHER,SAVEPOINT,TEMP,TEXT,TOP,TRIGGER,TINYINT,VARBINARY,VARCHAR_\
IGNORECASE\"\>"},
    {"\<\"SQLStateType\"\>", "\<\"XOpen\"\>"},
    {"\<\"StoresLowerCaseIdentifiers\"\>", "False"},
    {"\<\"StoresLowerCaseQuotedIdentifiers\"\>", "False"},
    {"\<\"StoresMixedCaseIdentifiers\"\>", "False"},
    {"\<\"StoresMixedCaseQuotedIdentifiers\"\>", "False"},
    {"\<\"StoresUpperCaseIdentifiers\"\>", "True"},
    {"\<\"StoresUpperCaseQuotedIdentifiers\"\>", "False"},
    {"\<\"StringFunctions\"\>", \
"\<\"ASCII,BIT_LENGTH,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,DIFFERENCE,\
HEXTORAW,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,OCTET_LENGTH,RAWTOHEX,REPEAT,\
REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTR,SUBSTRING,UCASE,LOWER,UPPER\"\>"},
    {"\<\"SupportsAlterTableWithAddColumn\"\>", "True"},
    {"\<\"SupportsAlterTableWithDropColumn\"\>", "True"},
    {"\<\"SupportsANSI92EntryLevelSQL\"\>", "False"},
    {"\<\"SupportsANSI92FullSQL\"\>", "False"},
    {"\<\"SupportsANSI92IntermediateSQL\"\>", "False"},
    {"\<\"SupportsBatchUpdates\"\>", "True"},
    {"\<\"SupportsCatalogsInDataManipulation\"\>", "False"},
    {"\<\"SupportsCatalogsInIndexDefinitions\"\>", "False"},
    {"\<\"SupportsCatalogsInPrivilegeDefinitions\"\>", "False"},
    {"\<\"SupportsCatalogsInProcedureCalls\"\>", "False"},
    {"\<\"SupportsCatalogsInTableDefinitions\"\>", "False"},
    {"\<\"SupportsColumnAliasing\"\>", "True"},
    {"\<\"SupportsConvert\"\>", "True"},
    {"\<\"SupportsCoreSQLGrammar\"\>", "True"},
    {"\<\"SupportsCorrelatedSubqueries\"\>", "True"},
    {"\<\"SupportsDataDefinitionAndDataManipulationTransactions\"\>", 
     "False"},
    {"\<\"SupportsDataManipulationTransactionsOnly\"\>", "True"},
    {"\<\"SupportsDifferentTableCorrelationNames\"\>", "True"},
    {"\<\"SupportsExpressionsInOrderBy\"\>", "True"},
    {"\<\"SupportsExtendedSQLGrammar\"\>", "False"},
    {"\<\"SupportsForwardOnlyResultSetReadOnlyConcurrency\"\>", "True"},
    {"\<\"SupportsForwardOnlyResultSetType\"\>", "True"},
    {"\<\"SupportsForwardOnlyResultSetUpdatableConcurrency\"\>", "False"},
    {"\<\"SupportsFullOuterJoins\"\>", "False"},
    {"\<\"SupportsGetGeneratedKeys\"\>", "False"},
    {"\<\"SupportsGroupBy\"\>", "True"},
    {"\<\"SupportsGroupByBeyondSelect\"\>", "True"},
    {"\<\"SupportsGroupByUnrelated\"\>", "True"},
    {"\<\"SupportsIntegrityEnhancementFacility\"\>", "True"},
    {"\<\"SupportsLikeEscapeClause\"\>", "True"},
    {"\<\"SupportsLimitedOuterJoins\"\>", "True"},
    {"\<\"SupportsMinimumSQLGrammar\"\>", "False"},
    {"\<\"SupportsMixedCaseIdentifiers\"\>", "False"},
    {"\<\"SupportsMixedCaseQuotedIdentifiers\"\>", "True"},
    {"\<\"SupportsMultipleOpenResults\"\>", "False"},
    {"\<\"SupportsMultipleResultSets\"\>", "False"},
    {"\<\"SupportsMultipleTransactions\"\>", "True"},
    {"\<\"SupportsNamedParameters\"\>", "True"},
    {"\<\"SupportsNonNullableColumns\"\>", "True"},
    {"\<\"SupportsOpenCursorsAcrossCommit\"\>", "False"},
    {"\<\"SupportsOpenCursorsAcrossRollback\"\>", "False"},
    {"\<\"SupportsOpenStatementsAcrossCommit\"\>", "True"},
    {"\<\"SupportsOpenStatementsAcrossRollback\"\>", "True"},
    {"\<\"SupportsOrderByUnrelated\"\>", "True"},
    {"\<\"SupportsOuterJoins\"\>", "True"},
    {"\<\"SupportsPositionedDelete\"\>", "False"},
    {"\<\"SupportsPositionedUpdate\"\>", "False"},
    {"\<\"SupportsResultSetHoldCursorsOverCommitHoldability\"\>", "True"},
    {"\<\"SupportsResultSetCloseCursorsAtCommitHoldability\"\>", "False"},
    {"\<\"SupportsSavepoints\"\>", "True"},
    {"\<\"SupportsSchemasInDataManipulation\"\>", "False"},
    {"\<\"SupportsSchemasInIndexDefinitions\"\>", "True"},
    {"\<\"SupportsSchemasInPrivilegeDefinitions\"\>", "True"},
    {"\<\"SupportsSchemasInProcedureCalls\"\>", "False"},
    {"\<\"SupportsSchemasInTableDefinitions\"\>", "True"},
    {"\<\"SupportsScrollInsensitiveResultSetReadOnlyConcurrency\"\>", 
     "True"},
    {"\<\"SupportsScrollInsensitiveResultSetType\"\>", "True"},
    {"\<\"SupportsScrollInsensitiveResultSetUpdatableConcurrency\"\>", 
     "False"},
    {"\<\"SupportsScrollSensitiveResultSetReadOnlyConcurrency\"\>", "False"},
    {"\<\"SupportsScrollSensitiveResultSetType\"\>", "False"},
    {"\<\"SupportsScrollSensitiveResultSetUpdatableConcurrency\"\>", 
     "False"},
    {"\<\"SupportsSelectForUpdate\"\>", "False"},
    {"\<\"SupportsStatementPooling\"\>", "False"},
    {"\<\"SupportsStoredProcedures\"\>", "True"},
    {"\<\"SupportsSubqueriesInComparisons\"\>", "True"},
    {"\<\"SupportsSubqueriesInExists\"\>", "True"},
    {"\<\"SupportsSubqueriesInIns\"\>", "True"},
    {"\<\"SupportsSubqueriesInQuantifieds\"\>", "True"},
    {"\<\"SupportsTableCorrelationNames\"\>", "True"},
    {"\<\"SupportsReadCommitedTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsReadUncommitedTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsRepeatableReadTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsSerializableTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsTransactions\"\>", "True"},
    {"\<\"SupportsUnion\"\>", "True"},
    {"\<\"SupportsUnionAll\"\>", "True"},
    {"\<\"SystemFunctions\"\>", "\<\"DATABASE,USER,IDENTITY\"\>"},
    {"\<\"TimeDateFunctions\"\>", \
"\<\"CURDATE,CURTIME,DATEDIFF,DAYNAME,DAY,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,\
MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,WEEK,YEAR,TO_CHAR\"\>"},
    {"\<\"UpdatesAreDetectedForForwardOnly\"\>", "False"},
    {"\<\"UpdatesAreDetectedForScrollInsensitive\"\>", "False"},
    {"\<\"UpdatesAreDetectedForScrollSensitive\"\>", "False"},
    {"\<\"URL\"\>", "\<\"jdbc:hsqldb:file:C:\\\\Documents and \
Settings\\\\twj.WRI\\\\Application Data\\\\Mathematica\\\\DatabaseResources\\\
\\Examples\\\\demo\"\>"},
    {"\<\"UserName\"\>", "\<\"SA\"\>"},
    {"\<\"UsesLocalFilePerTable\"\>", "False"},
    {"\<\"UsesLocalFiles\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[4]//TableForm=",
 CellID->891631461]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["JDBC Connections", "Section",
 CellTags->{"xref:20", "c:25", "b:2.2.1"},
 CellID->27756],

Cell["\<\
If you do not have a named database connection, you can still connect to the \
database by using a JDBC setting.\
\>", "Text",
 CellTags->"b:2.2.1",
 CellID->28321],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->19558],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JDBC",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/JDBC"], "[", 
     StyleBox["name", "TI"], ",", 
     StyleBox["url", "TI"], "]"}], Cell["a JDBC setting", "TableText"]},
   {
    RowBox[{
     ButtonBox["JDBC",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/JDBC"], "[", 
     StyleBox["classname", "TI"], ",", 
     StyleBox["url", "TI"], "]"}], Cell["\<\
a JDBC setting that gives the explicit class name for the driver\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["JDBCDriverNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/JDBCDriverNames"], "[", "]"}], 
    Cell["a list of the names of possible JDBC drivers", "TableText"]},
   {
    RowBox[{
     ButtonBox["JDBCDrivers",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"], "[", "]"}], Cell[
    "the details of all JDBC drivers", "TableText"]},
   {
    RowBox[{
     ButtonBox["JDBCDrivers",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"], "[", 
     StyleBox["name", "TI"], "]"}], Cell[TextData[{
     StyleBox["the details of the JDBC driver labeled ", "TableText"],
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->23646],

Cell["This loads the package.", "Text",
 CellTags->"b:2.2.1",
 CellID->27982],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,433"},
 CellLabel->"In[10]:=",
 CellID->481],

Cell[TextData[{
 "The following opens a connection to HSQLDB using the file ",
 StyleBox["$UserBaseDirectory/DatabaseResources/Examples/demo", 
  "InlineCode"],
 ". This works because the package knows what JDBC driver to use for \
connecting to HSQLDB. "
}], "Text",
 CellTags->"b:2.2.1",
 CellID->4144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{
    RowBox[{"JDBC", "[", 
     RowBox[{"\"\<hsqldb\>\"", ",", 
      RowBox[{"ToFileName", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "$UserBaseDirectory", ",", "\"\<DatabaseResources\>\"", ",", 
          "\"\<Examples\>\""}], "}"}], ",", "\"\<demo\>\""}], "]"}]}], " ", 
     "]"}], ",", " ", "\[IndentingNewLine]", "\t", 
    RowBox[{"\"\<Name\>\"", "->", "\"\<manualA\>\""}], ",", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}]}], "]"}]}]], "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
 CellLabel->"In[11]:=",
 CellID->23196],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"manualA\"\>", ",", "4", ",", "\<\"Open\"\>", 
   ",", "\<\"<>\"\>"}], "]"}]], "Output",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
 CellLabel->"Out[11]=",
 CellID->20222]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,435"},
 CellLabel->"In[12]:=",
 CellID->7129],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["JDBCDriverNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/JDBCDriverNames"]], "InlineFormula"],
 " command returns the list of built\[Hyphen]in drivers. ",
 StyleBox["hsqldb", "InlineCode"],
 " appears in this list and therefore you can use the setting ",
 StyleBox["hsqldb", "InlineCode"],
 " as an argument to ",
 Cell[BoxData[
  ButtonBox["JDBC",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/JDBC"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->2161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JDBCDriverNames", "[", "]"}]], "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
 CellLabel->"In[13]:=",
 CellID->5535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Microsoft Access(ODBC)\"\>", ",", "\<\"hsqldb\"\>", 
   ",", "\<\"HSQL(Memory)\"\>", ",", "\<\"HSQL(Server)\"\>", 
   ",", "\<\"HSQL(Server+TLS)\"\>", ",", "\<\"HSQL(Standalone)\"\>", 
   ",", "\<\"HSQL(Webserver)\"\>", ",", "\<\"HSQL(Webserver+TLS)\"\>", 
   ",", "\<\"jtds_sqlserver\"\>", ",", "\<\"jtds_sybase\"\>", 
   ",", "\<\"mysql\"\>", ",", "\<\"MySQL(Connector/J)\"\>", 
   ",", "\<\"ODBC(DSN)\"\>", ",", "\<\"odbc\"\>", ",", "\<\"Oracle(thin)\"\>",
    ",", "\<\"Microsoft SQL Server(jTDS)\"\>", ",", "\<\"Sybase(jTDS)\"\>"}], 
  "}"}]], "Output",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
 CellLabel->"Out[13]=",
 CellID->20450]
}, Open  ]],

Cell[TextData[{
 "You can get more complete information on all of the built-in drivers by \
using ",
 Cell[BoxData[
  ButtonBox["JDBCDrivers",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"]], "InlineFormula"],
 " without a parameter."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->11173],

Cell[TextData[{
 "If you want to get information on just one driver, you can do this by \
giving its name to ",
 Cell[BoxData[
  ButtonBox["JDBCDrivers",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"]], "InlineFormula"],
 ". Finding the protocol set for a driver can help to use ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->10466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JDBCDrivers", "[", "\"\<ODBC(DSN)\>\"", "]"}]], "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
 CellLabel->"In[14]:=",
 CellID->12044],

Cell[BoxData[
 RowBox[{"JDBCDriver", "[", 
  RowBox[{
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"ODBC(DSN)\"\>"}], ",", 
   RowBox[{"\<\"Driver\"\>", 
    "\[Rule]", "\<\"sun.jdbc.odbc.JdbcOdbcDriver\"\>"}], ",", 
   RowBox[{"\<\"Protocol\"\>", "\[Rule]", "\<\"jdbc:odbc:\"\>"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"JDBC-ODBC Bridge distributed with the Sun JVM.  This \
driver only works on Windows.\"\>"}], ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
odbcdsn.m\"\>"}]}], "]"}]], "Output",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
 CellLabel->"Out[14]=",
 CellID->21659]
}, Open  ]],

Cell[TextData[{
 "The details of how the built-in drivers are configured is described in ",
 ButtonBox["Database Resources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 "."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->26292],

Cell[TextData[{
 "If ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " does not already contain a driver for your database, you can add your own. \
The driver is a collection of Java classes, and they must be added to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the standard that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides for adding Java classes. Typically, this is done by adding the \
class file or a jar file to a Java subdirectory in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application. One possible location is inside ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " itself. A disadvantage is that if you update ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you may have to copy the new material. Another location would be in an \
application inside ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "; this would not need to be changed if you updated your software."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->26439],

Cell[TextData[{
 "As an example, you could create an application for connecting to the Oracle \
database. This could be done by creating an application called ",
 StyleBox["Oracle", "InlineCode"],
 " inside ",
 StyleBox["$UserBaseDirectory/Applications", "InlineCode"],
 " or ",
 StyleBox["$BaseDirectory/Applications", "InlineCode"],
 ". You might have to create some of the directories manually, but you would \
not need to change anything if you update your software. Another advantage is \
that you can use the same location to hold a ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directory, this could hold other configuration information as discussed in \
",
 ButtonBox["Database Resources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 ". "
}], "Text",
 CellTags->"b:2.2.1",
 CellID->17253],

Cell["\<\
The following table shows some possible locations that you could use to \
install drivers for connecting to Oracle.\
\>", "Text",
 CellTags->"b:2.2.1",
 CellID->20024],

Cell[BoxData[GridBox[{
   {
    RowBox[{
    "$UserBaseDirectory", "/", "Applications", "/", "Oracle", "/", "Java"}], 
    Cell["location for database driver class files", "TableText"]},
   {
    RowBox[{
    "$BaseDirectory", "/", "Applications", "/", "Oracle", "/", "Java"}], Cell[
    "location for database driver class files", "TableText"]}
  },
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.6], {
       Scaled[0.4]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "DefinitionBox",
 CellID->26154],

Cell["Possible locations for database driver class files.", "Caption",
 CellTags->"b:2.2.1",
 CellID->29510],

Cell["\<\
When you have installed the driver classes, you can make a connection. It \
should be noted that the URL argument you use depends on the server you are \
using. In the following example, which is not actually configured, a \
connection is made to an Oracle database using a driver installed in one of \
the locations previously suggested. The documentation for the JDBC driver \
will tell you what class and URL to use. \
\>", "Text",
 CellTags->"b:2.2.1",
 CellID->4745],

Cell[BoxData[
 RowBox[{"OpenSQLConnection", "[", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{
    "\"\<oracle.jdbc.driver.OracleDriver\>\"", ",", 
     "\"\<jdbc:oracle:thin:@server.business.com:1999\>\""}], "]"}], ",", 
   RowBox[{"\"\<Name\>\"", "\[Rule]", "\"\<manualOracle\>\""}], ",", 
   RowBox[{"\"\<Username\>\"", "\[Rule]", "\"\<server1\>\""}]}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"b:2.2.1",
 CellID->20649],

Cell[TextData[{
 "This is the most verbose form of ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 ". Typically, you would want to use information that had been stored \
previously. This is discussed in ",
 ButtonBox["Database Resources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 "."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->13186]
}, Open  ]],

Cell[CellGroupData[{

Cell["ODBC Connections", "Section",
 CellTags->"xref:152",
 CellID->8313],

Cell[TextData[{
 "Open Database Connectivity (ODBC) is a general way to connect to SQL \
databases that is supported in a number of operating systems, particularly \
Microsoft Windows. ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " comes configured with a driver for ODBC connections. This example, which \
works only on Windows, shows how to connect to a sample database using ODBC."
}], "Text",
 CellTags->"b:7.0.0",
 CellID->28022],

Cell[CellGroupData[{

Cell["Setting Up the Connection", "Subsection",
 CellTags->{"xref:154", "b:7.0.1"},
 CellID->2168],

Cell[TextData[{
 "This example uses a sample database file, ",
 StyleBox["publisher.mdb", "InlineCode"],
 ", which is located inside the ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " package structure. You can find the location by evaluating the following \
line on your computer."
}], "Text",
 CellTags->"b:7.0.1",
 CellID->14018],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"ToFileName", "[", " ", 
  RowBox[{
   RowBox[{"{", "$DatabaseLinkDirectory", "}"}], ",", " ", 
   "\"\<Examples\>\""}], "]"}]}], "Input",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
 CellLabel->"In[15]:=",
 CellID->18787],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\Examples\"\>"], \
"Output",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
 CellLabel->"Out[16]=",
 CellID->9905]
}, Open  ]],

Cell[TextData[{
 "Typically, it is not a good idea to modify files that are inside of ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 ", so you might want to copy it into some other location. One possible \
location would be inside the ",
 StyleBox["DatabaseResources/Examples", "InlineCode"],
 " directory inside ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " (it may be necessary to create these directories). You can find the \
location by evaluating the following on your computer."
}], "Text",
 CellTags->"b:7.0.1",
 CellID->17958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToFileName", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$UserBaseDirectory", ",", " ", "\"\<DatabaseResources\>\""}], 
    "}"}], ",", " ", "\"\<Examples\>\""}], "]"}]], "Input",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
 CellLabel->"In[17]:=",
 CellID->7391],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\"\>"], "Output",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
 CellLabel->"Out[17]=",
 CellID->10202]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["publisher.mdb", "InlineCode"],
 " file is found inside the ",
 StyleBox["Examples", "InlineCode"],
 " subdirectory."
}], "Text",
 CellTags->"b:7.0.1",
 CellID->3625],

Cell[TextData[{
 "Now, you need to use the ODBC control panel to register the data source. \
This is typically found in the ",
 StyleBox["Administrative Tools", "DialogElementName"],
 " folder of the Windows ",
 StyleBox["Control Panel", "DialogElementName"],
 ". When it is opened it looks something like the following."
}], "Text",
 CellTags->"b:7.0.1",
 CellID->26477],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{461, 377},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
 CellID->4414],

Cell[TextData[{
 "Click the ",
 StyleBox["Add", "DialogElementName"],
 " button, this will bring up the ",
 StyleBox["Create New Data Source", "DialogElementName"],
 " window."
}], "Text",
 CellTags->"b:7.0.1",
 CellID->9314],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{468, 345},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
 CellID->25824],

Cell[TextData[{
 "Select ",
 StyleBox["Microsoft Access Driver", "DialogElementName"],
 " and then click ",
 StyleBox["Finish", "DialogElementName"],
 ". This will bring up an ",
 StyleBox["ODBC Microsoft Access Setup", "DialogElementName"],
 " window."
}], "Text",
 CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
 CellID->29334],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Text",
 ImageSize->{471, 319},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:7.0.1",
 CellID->25874],

Cell[TextData[{
 "You should fill in the ",
 StyleBox["Data Source Name", "DialogElementName"],
 " text field, using the name \"publisher\" (this is the name that ODBC will \
use). Then, click the ",
 StyleBox["Select", "DialogElementName"],
 " button, which allows you to find and select the ",
 StyleBox["publisher.mdb", "InlineCode"],
 " file."
}], "Text",
 CellTags->"b:7.0.1",
 CellID->24372],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Text",
 ImageSize->{402, 250},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:7.0.1",
 CellID->20159],

Cell[TextData[{
 "Click ",
 StyleBox["OK", "DialogElementName"],
 " in each successive window until the control panel has been closed. Note \
that publisher and its driver now appear in the list of available files in \
the ",
 StyleBox["ODBC Data Source Administrator", "DialogElementName"],
 " window."
}], "Text",
 CellTags->"b:7.0.1",
 CellID->11833]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using the Connection", "Subsection",
 CellTags->{"xref:155", "b:7.0.2"},
 CellID->28070],

Cell[TextData[{
 "You should now be able to connect to the ODBC data source that was \
configured. The following loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ODBC data source ",
 StyleBox["publisher", "MR"],
 ". This will use the ODBC driver that is configured by the package."
}], "Text",
 CellTags->"b:7.0.2",
 CellID->7487],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DatabaseLink`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", 
    RowBox[{"JDBC", "[", 
     RowBox[{"\"\<odbc\>\"", ",", " ", "\"\<publisher\>\""}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,441"},
 CellLabel->"In[18]:=",
 CellID->28297],

Cell["You can use the connection to query the database.", "Text",
 CellTags->"b:7.0.2",
 CellID->7518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", "conn", "]"}]], "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
 CellLabel->"In[20]:=",
 CellID->8177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"authors\"\>", ",", "\<\"editors\"\>", 
   ",", "\<\"publishers\"\>", ",", "\<\"roysched\"\>", ",", "\<\"sales\"\>", 
   ",", "\<\"salesdetails\"\>", ",", "\<\"titleauthors\"\>", 
   ",", "\<\"titleditors\"\>", ",", "\<\"titles\"\>"}], "}"}]], "Output",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
 CellLabel->"Out[20]=",
 CellID->17773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<publishers\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
 CellLabel->"In[21]:=",
 CellID->32270],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"pub_id\"\>", "\<\"pub_name\"\>", "\<\"address\"\>", "\<\"city\"\>", \
"\<\"state\"\>"},
    {"\<\"0736\"\>", "\<\"Second Galaxy Books\"\>", "\<\"100 1st St.\"\>", \
"\<\"Boston\"\>", "\<\"MA\"\>"},
    {"\<\"0877\"\>", "\<\"Boskone & Helmuth\"\>", "\<\"201 2nd Ave.\"\>", "\<\
\"Washington\"\>", "\<\"DC\"\>"},
    {"\<\"1389\"\>", "\<\"NanoSoft Book Publishers\"\>", "\<\"302 3rd \
Dr.\"\>", "\<\"Berkeley\"\>", "\<\"CA\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
 CellLabel->"Out[21]//TableForm=",
 CellID->1763]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:7.0.2",
 CellID->2668],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,444"},
 CellLabel->"In[22]:=",
 CellID->17192]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Named Connections", "Section",
 CellTags->{"xref:162", "b:2.2.2"},
 CellID->13985],

Cell[TextData[{
 "If your work requires that you frequently connect to the same database, it \
might be beneficial to give this connection a name and use the name in ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 ". The details of how to set up a named connection are given in ",
 ButtonBox["Database Resources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 ". This section describes how to learn what named connections are \
available."
}], "Text",
 CellTags->"b:2.2.2",
 CellID->3102],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DataSourceNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/DataSourceNames"], "[", "]"}], 
    Cell["list of the names of all connections", "TableText"]},
   {
    RowBox[{
     ButtonBox["DataSources",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/DataSources"], "[", "]"}], Cell[
    "details of all named connections", "TableText"]},
   {
    RowBox[{
     ButtonBox["DataSources",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/DataSources"], "[", 
     StyleBox["name", "TI"], "]"}], Cell[TextData[{
     StyleBox["details of the connection called ", "TableText"],
     StyleBox["name", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->8480],

Cell["Functions for working with named connections.", "Caption",
 CellTags->"b:2.2.2",
 CellID->29213],

Cell["This loads the package.", "Text",
 CellTags->"b:2.2.2",
 CellID->7627],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,445"},
 CellLabel->"In[23]:=",
 CellID->4802],

Cell["\<\
The following lists all the named connections. If you have installed more \
connections, you may see a larger list.\
\>", "Text",
 CellTags->"b:2.2.2",
 CellID->4099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataSourceNames", "[", "]"}]], "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
 CellLabel->"In[24]:=",
 CellID->30527],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"demo\"\>", ",", "\<\"graphs\"\>", ",", "\<\"publisher\"\>"}], 
  "}"}]], "Output",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
 CellLabel->"Out[24]=",
 CellID->2625]
}, Open  ]],

Cell[TextData[{
 "You can get more complete information on all the connections by using ",
 Cell[BoxData[
  ButtonBox["DataSources",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/DataSources"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.2.2",
 CellID->1543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataSources", "[", "]"}]], "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
 CellLabel->"In[25]:=",
 CellID->1924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLConnection", "[", 
    RowBox[{
     RowBox[{"JDBC", "[", 
      RowBox[{"\<\"hsqldb\"\>", 
       ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\demo\"\>"}], "]"}], 
     ",", 
     RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"demo\"\>"}], ",", 
     RowBox[{"\<\"Description\"\>", 
      "\[Rule]", "\<\"Connection to hsql db for documention.\"\>"}], ",", 
     RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
     RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
     RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
     RowBox[{"\<\"Location\"\>", 
      "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All \
Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
demo.m\"\>"}]}], "]"}], ",", 
   RowBox[{"SQLConnection", "[", 
    RowBox[{
     RowBox[{"JDBC", "[", 
      RowBox[{"\<\"hsqldb\"\>", 
       ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\graphs\"\>"}], "]"}], 
     ",", 
     RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"graphs\"\>"}], ",", 
     RowBox[{"\<\"Description\"\>", 
      "\[Rule]", "\<\"Connection to the graph database.\"\>"}], ",", 
     RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
     RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
     RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
     RowBox[{"\<\"Location\"\>", 
      "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All \
Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
graphs.m\"\>"}]}], "]"}], ",", 
   RowBox[{"SQLConnection", "[", 
    RowBox[{
     RowBox[{"JDBC", "[", 
      RowBox[{"\<\"hsqldb\"\>", 
       ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
      "]"}], ",", 
     RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
     RowBox[{"\<\"Description\"\>", 
      "\[Rule]", "\<\"Connection to hsql db for demos.\"\>"}], ",", 
     RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
     RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
     RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
     RowBox[{"\<\"Location\"\>", 
      "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All \
Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
publisher.m\"\>"}]}], "]"}]}], "}"}]], "Output",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
 CellLabel->"Out[25]=",
 CellID->11023]
}, Open  ]],

Cell[TextData[{
 "You can get information on just one named connection by giving a ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " argument to ",
 Cell[BoxData[
  ButtonBox["DataSources",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/DataSources"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.2.2",
 CellID->29972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataSources", "[", "\"\<demo\>\"", "]"}]], "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
 CellLabel->"In[26]:=",
 CellID->13061],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"hsqldb\"\>", 
     ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\demo\"\>"}], "]"}], 
   ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"demo\"\>"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to hsql db for documention.\"\>"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"sa\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
demo.m\"\>"}]}], "]"}]], "Output",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
 CellLabel->"Out[26]=",
 CellID->14181]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Database Timeouts", "Section",
 CellTags->{"xref:138", "c:24", "b:2.2.3"},
 CellID->31003],

Cell[TextData[{
 "Database operations typically involve connecting to a server and the \
possibility of problems accessing the server must be taken into account. \
Consequently, there is a timeout for database operations such as connecting \
or executing queries. This timeout is controlled by the global variable ",
 Cell[BoxData[
  ButtonBox["$SQLTimeout",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/$SQLTimeout"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.2.3",
 CellID->27432],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["$SQLTimeout",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/$SQLTimeout"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "timeout for making a connection and executing queries", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->17505],

Cell["Specification of the timeout for working with the database.", "Caption",
 CellTags->"b:2.2.3",
 CellID->27593],

Cell[TextData[{
 "The default value, ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", means that the default value given by the driver will be used."
}], "Text",
 CellTags->"b:2.2.3",
 CellID->22725]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Connections", "Section",
 CellTags->{"xref:21", "c:32", "b:2.6"},
 CellID->13031],

Cell["\<\
This section shows some sample connection commands and explains how they \
work.\
\>", "Text",
 CellTags->"b:2.6",
 CellID->8492],

Cell[TextData[{
 "In this example, you connect to a MySQL database called ",
 StyleBox["conn_test", "InlineCode"],
 " running on the computer named ",
 StyleBox["databases", "InlineCode"],
 " on port 1234 using the built-in driver with the username ",
 StyleBox["test", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:2.6",
 CellID->142],

Cell["\<\
OpenSQLConnection[ JDBC[ \"mysql\",
\"databases:1234/conn_test\"], \"Username\" -> \"test\"]\
\>", "Program",
 CellTags->"b:2.6",
 CellID->17222],

Cell[TextData[{
 "In this example, you connect to the same MySQL database as in the previous \
example, but this time using the driver ",
 StyleBox["com.mysql.jdbc.Driver", "InlineCode"],
 ". "
}], "Text",
 CellTags->"b:2.6",
 CellID->31286],

Cell["\<\
OpenSQLConnection[ JDBC[ \"com.mysql.jdbc.Driver\",
\"databases:1234/conn_test\"], \"Username\" -> \"test\"]\
\>", "Program",
 CellTags->"b:2.6",
 CellID->13064],

Cell[TextData[{
 "The first example requires that a JDBC connection ",
 StyleBox["mysql", "InlineCode"],
 " has been configured, as described in ",
 ButtonBox["Database Resources: JDBC Configuration",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#15185"],
 ". The second does not require any ",
 StyleBox["DatabaseResources", "InlineCode"],
 " configuration. It does require that the JDBC driver, ",
 StyleBox["com.mysql.jdbc.Driver", "InlineCode"],
 ", is made available. More information on drivers is found in ",
 ButtonBox["JDBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 "."
}], "Text",
 CellTags->"b:2.6",
 CellID->7900]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Connection Tool", "Section",
 CellTags->{"xref:21", "c:32", "b:2.6"},
 CellID->78150545],

Cell[TextData[{
 "The Connection Tool is a graphical interface tool that simplifies opening a \
connection to a database. It is launched by executing the command ",
 StyleBox["OpenSQLConnection[]", "InlineCode"],
 ". It is described in ",
 ButtonBox["The Database Explorer: The Connection Tool",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer#9010"],
 "."
}], "Text",
 CellTags->"b:2.6",
 CellID->214827612]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Database Connections - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 33.5465965}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The first step in using a database is making a connection. This part of \
the tutorial discusses how to do this. If you are just starting to use \
DatabaseLink, you might want to look at some of the basic examples in this \
tutorial. Then, to learn if DatabaseLink comes with a driver for your \
database, you might want to study JDBC Connections, which contains further \
information about adding new drivers. Finally, if you want to give your \
connection a name, you might want to study Named Connections. Many users of \
DatabaseLink will have an existing database they wish to connect to and use. \
If you have one, you should be able to read this documentation and modify it \
to connect to your own database. If you do not already have a database, you \
can use HSQLDB (included in DatabaseLink). If you want to set up a different \
type of database, you will need to refer to the specific information for that \
database. Once you have set up your database, you can continue to use this \
tutorial to learn how to connect to it.", "synonyms" -> {}, "title" -> 
    "Database Connections", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/DatabaseConnections"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:22"->{
  Cell[2374, 64, 85, 2, 70, "Title",
   CellTags->{"c:22", "xref:145"},
   CellID->3753]},
 "xref:145"->{
  Cell[2374, 64, 85, 2, 70, "Title",
   CellTags->{"c:22", "xref:145"},
   CellID->3753]},
 "b:2.0"->{
  Cell[2462, 68, 172, 5, 70, "Text",
   CellTags->"b:2.0",
   CellID->12423],
  Cell[2637, 75, 778, 21, 70, "Text",
   CellTags->"b:2.0",
   CellID->16279]},
 "xref:19"->{
  Cell[3440, 100, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->353438053],
  Cell[4261, 125, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->16139],
  Cell[16611, 552, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->37361426]},
 "c:23"->{
  Cell[3440, 100, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->353438053],
  Cell[4261, 125, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->16139],
  Cell[16611, 552, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->37361426]},
 "b:2.2.0"->{
  Cell[3440, 100, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->353438053],
  Cell[4261, 125, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->16139],
  Cell[6802, 201, 105, 2, 70, "Caption",
   CellTags->"b:2.2.0",
   CellID->22549],
  Cell[6910, 205, 136, 7, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->17437],
  Cell[7049, 214, 173, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
   CellID->19866],
  Cell[7225, 220, 645, 19, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->12949],
  Cell[7873, 241, 378, 13, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->193],
  Cell[8276, 258, 217, 5, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->23195],
  Cell[8496, 265, 238, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->3297],
  Cell[8749, 274, 257, 8, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->20416],
  Cell[9031, 286, 157, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
   CellID->28286],
  Cell[9191, 292, 264, 7, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
   CellID->16105],
  Cell[9470, 302, 145, 5, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->24488],
  Cell[9640, 311, 160, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
   CellID->16282],
  Cell[9803, 317, 285, 8, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
   CellID->12455],
  Cell[10103, 328, 294, 10, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->25734],
  Cell[10400, 340, 169, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,428"},
   CellID->18114],
  Cell[10594, 348, 125, 3, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
   CellID->11701],
  Cell[10722, 353, 242, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
   CellID->31316],
  Cell[10979, 362, 279, 10, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->20671],
  Cell[12548, 406, 234, 9, 70, "Caption",
   CellTags->"b:2.2.0",
   CellID->12263],
  Cell[12785, 417, 217, 6, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->4313],
  Cell[13027, 427, 349, 8, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
   CellID->24355],
  Cell[13379, 437, 239, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
   CellID->31185],
  Cell[13633, 446, 174, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
   CellID->20053],
  Cell[13810, 452, 254, 7, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->912],
  Cell[14089, 463, 358, 9, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->10808],
  Cell[14450, 474, 238, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->1832],
  Cell[15290, 502, 140, 4, 70, "Caption",
   CellTags->"b:2.2.0",
   CellID->263651101],
  Cell[15571, 515, 229, 6, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->389106687],
  Cell[15803, 523, 279, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->96076015],
  Cell[16097, 532, 179, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
   CellID->431636696],
  Cell[16611, 552, 103, 2, 70, "Section",
   CellTags->{"xref:19", "c:23", "b:2.2.0"},
   CellID->37361426],
  Cell[17057, 567, 177, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
   CellID->462571295],
  Cell[17237, 573, 112, 2, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->53197519],
  Cell[17374, 579, 221, 5, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->279939859],
  Cell[17598, 586, 220, 5, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->76385560],
  Cell[17833, 594, 104, 2, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->41762904]},
 "b:2.1"->{
  Cell[3546, 104, 678, 16, 70, "Text",
   CellTags->"b:2.1",
   CellID->25996]},
 "Ex--21943418559164291386,424"->{
  Cell[7049, 214, 173, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
   CellID->19866],
  Cell[17057, 567, 177, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
   CellID->462571295]},
 "Ex--21943418559164291386,425"->{
  Cell[8276, 258, 217, 5, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->23195],
  Cell[8496, 265, 238, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->3297],
  Cell[17374, 579, 221, 5, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->279939859],
  Cell[17598, 586, 220, 5, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->76385560]},
 "Ex--21943418559164291386,426"->{
  Cell[9031, 286, 157, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
   CellID->28286],
  Cell[9191, 292, 264, 7, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
   CellID->16105]},
 "Ex--21943418559164291386,427"->{
  Cell[9640, 311, 160, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
   CellID->16282],
  Cell[9803, 317, 285, 8, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
   CellID->12455]},
 "Ex--21943418559164291386,428"->{
  Cell[10400, 340, 169, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,428"},
   CellID->18114]},
 "Ex--21943418559164291386,429"->{
  Cell[10594, 348, 125, 3, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
   CellID->11701],
  Cell[10722, 353, 242, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
   CellID->31316]},
 "Ex--21943418559164291386,430"->{
  Cell[13027, 427, 349, 8, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
   CellID->24355],
  Cell[13379, 437, 239, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
   CellID->31185]},
 "Ex--21943418559164291386,431"->{
  Cell[13633, 446, 174, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
   CellID->20053],
  Cell[16097, 532, 179, 4, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
   CellID->431636696]},
 "Ex--21943418559164291386,432"->{
  Cell[14089, 463, 358, 9, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->10808],
  Cell[14450, 474, 238, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->1832],
  Cell[15571, 515, 229, 6, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->389106687],
  Cell[15803, 523, 279, 6, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
   CellID->96076015]},
 "xref:20"->{
  Cell[29071, 825, 94, 2, 70, "Section",
   CellTags->{"xref:20", "c:25", "b:2.2.1"},
   CellID->27756]},
 "c:25"->{
  Cell[29071, 825, 94, 2, 70, "Section",
   CellTags->{"xref:20", "c:25", "b:2.2.1"},
   CellID->27756]},
 "b:2.2.1"->{
  Cell[29071, 825, 94, 2, 70, "Section",
   CellTags->{"xref:20", "c:25", "b:2.2.1"},
   CellID->27756],
  Cell[29168, 829, 174, 5, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->28321],
  Cell[31140, 891, 77, 2, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->27982],
  Cell[31220, 895, 172, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,433"},
   CellID->481],
  Cell[31395, 901, 304, 8, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->4144],
  Cell[31724, 913, 675, 17, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
   CellID->23196],
  Cell[32402, 932, 244, 6, 70, "Output",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
   CellID->20222],
  Cell[32661, 941, 169, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,435"},
   CellID->7129],
  Cell[32833, 947, 567, 18, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->2161],
  Cell[33425, 969, 158, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
   CellID->5535],
  Cell[33586, 975, 698, 13, 70, "Output",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
   CellID->20450],
  Cell[34299, 991, 313, 10, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->11173],
  Cell[34615, 1003, 518, 16, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->10466],
  Cell[35158, 1023, 176, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
   CellID->12044],
  Cell[35337, 1029, 819, 17, 70, "Output",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
   CellID->21659],
  Cell[36171, 1049, 265, 8, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->26292],
  Cell[36439, 1059, 1229, 35, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->26439],
  Cell[37671, 1096, 845, 20, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->17253],
  Cell[38519, 1118, 177, 5, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->20024],
  Cell[39234, 1141, 108, 2, 70, "Caption",
   CellTags->"b:2.2.1",
   CellID->29510],
  Cell[39345, 1145, 481, 9, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->4745],
  Cell[39829, 1156, 439, 12, 70, "Input",
   Evaluatable->False,
   CellTags->"b:2.2.1",
   CellID->20649],
  Cell[40271, 1170, 488, 15, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->13186]},
 "Ex--21943418559164291386,433"->{
  Cell[31220, 895, 172, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,433"},
   CellID->481]},
 "Ex--21943418559164291386,434"->{
  Cell[31724, 913, 675, 17, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
   CellID->23196],
  Cell[32402, 932, 244, 6, 70, "Output",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
   CellID->20222]},
 "Ex--21943418559164291386,435"->{
  Cell[32661, 941, 169, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,435"},
   CellID->7129]},
 "Ex--21943418559164291386,436"->{
  Cell[33425, 969, 158, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
   CellID->5535],
  Cell[33586, 975, 698, 13, 70, "Output",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
   CellID->20450]},
 "Ex--21943418559164291386,438"->{
  Cell[35158, 1023, 176, 4, 70, "Input",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
   CellID->12044],
  Cell[35337, 1029, 819, 17, 70, "Output",
   CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
   CellID->21659]},
 "xref:152"->{
  Cell[40796, 1190, 73, 2, 70, "Section",
   CellTags->"xref:152",
   CellID->8313]},
 "b:7.0.0"->{
  Cell[40872, 1194, 443, 10, 70, "Text",
   CellTags->"b:7.0.0",
   CellID->28022]},
 "xref:154"->{
  Cell[41340, 1208, 98, 2, 70, "Subsection",
   CellTags->{"xref:154", "b:7.0.1"},
   CellID->2168]},
 "b:7.0.1"->{
  Cell[41340, 1208, 98, 2, 70, "Subsection",
   CellTags->{"xref:154", "b:7.0.1"},
   CellID->2168],
  Cell[41441, 1212, 341, 10, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->14018],
  Cell[41807, 1226, 338, 9, 70, "Input",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
   CellID->18787],
  Cell[42148, 1237, 254, 5, 70, "Output",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
   CellID->9905],
  Cell[42417, 1245, 640, 16, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->17958],
  Cell[43082, 1265, 306, 8, 70, "Input",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
   CellID->7391],
  Cell[43391, 1275, 236, 4, 70, "Output",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
   CellID->10202],
  Cell[43642, 1282, 201, 8, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->3625],
  Cell[43846, 1292, 371, 9, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->26477],
  Cell[44220, 1303, 13073, 217, 70, "Picture",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->4414],
  Cell[57296, 1522, 225, 8, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->9314],
  Cell[57524, 1532, 14725, 244, 70, "Picture",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->25824],
  Cell[72252, 1778, 343, 10, 70, "Text",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->29334],
  Cell[72598, 1790, 10843, 181, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->25874],
  Cell[83444, 1973, 397, 11, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->24372],
  Cell[83844, 1986, 12502, 208, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->20159],
  Cell[96349, 2196, 353, 10, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->11833]},
 "Ex--21943418559164291386,439"->{
  Cell[41807, 1226, 338, 9, 70, "Input",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
   CellID->18787],
  Cell[42148, 1237, 254, 5, 70, "Output",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
   CellID->9905]},
 "Ex--21943418559164291386,440"->{
  Cell[43082, 1265, 306, 8, 70, "Input",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
   CellID->7391],
  Cell[43391, 1275, 236, 4, 70, "Output",
   CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
   CellID->10202]},
 "DBAK Chapter 2.1"->{
  Cell[44220, 1303, 13073, 217, 70, "Picture",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->4414],
  Cell[57524, 1532, 14725, 244, 70, "Picture",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->25824],
  Cell[72252, 1778, 343, 10, 70, "Text",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->29334]},
 "DBAK Chapter 2"->{
  Cell[44220, 1303, 13073, 217, 70, "Picture",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->4414],
  Cell[57524, 1532, 14725, 244, 70, "Picture",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->25824],
  Cell[72252, 1778, 343, 10, 70, "Text",
   CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
   CellID->29334]},
 "xref:155"->{
  Cell[96739, 2211, 94, 2, 70, "Subsection",
   CellTags->{"xref:155", "b:7.0.2"},
   CellID->28070]},
 "b:7.0.2"->{
  Cell[96739, 2211, 94, 2, 70, "Subsection",
   CellTags->{"xref:155", "b:7.0.2"},
   CellID->28070],
  Cell[96836, 2215, 363, 10, 70, "Text",
   CellTags->"b:7.0.2",
   CellID->7487],
  Cell[97202, 2227, 376, 11, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,441"},
   CellID->28297],
  Cell[97581, 2240, 102, 2, 70, "Text",
   CellTags->"b:7.0.2",
   CellID->7518],
  Cell[97708, 2246, 164, 4, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
   CellID->8177],
  Cell[97875, 2252, 392, 8, 70, "Output",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
   CellID->17773],
  Cell[98304, 2265, 316, 8, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
   CellID->32270],
  Cell[98623, 2275, 999, 25, 70, "Output",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
   CellID->1763],
  Cell[99637, 2303, 80, 2, 70, "Text",
   CellTags->"b:7.0.2",
   CellID->2668],
  Cell[99720, 2307, 170, 4, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,444"},
   CellID->17192]},
 "Ex--21943418559164291386,441"->{
  Cell[97202, 2227, 376, 11, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,441"},
   CellID->28297]},
 "Ex--21943418559164291386,442"->{
  Cell[97708, 2246, 164, 4, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
   CellID->8177],
  Cell[97875, 2252, 392, 8, 70, "Output",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
   CellID->17773]},
 "Ex--21943418559164291386,443"->{
  Cell[98304, 2265, 316, 8, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
   CellID->32270],
  Cell[98623, 2275, 999, 25, 70, "Output",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
   CellID->1763]},
 "Ex--21943418559164291386,444"->{
  Cell[99720, 2307, 170, 4, 70, "Input",
   CellTags->{"b:7.0.2", "Ex--21943418559164291386,444"},
   CellID->17192]},
 "xref:162"->{
  Cell[99939, 2317, 88, 2, 70, "Section",
   CellTags->{"xref:162", "b:2.2.2"},
   CellID->13985]},
 "b:2.2.2"->{
  Cell[99939, 2317, 88, 2, 70, "Section",
   CellTags->{"xref:162", "b:2.2.2"},
   CellID->13985],
  Cell[100030, 2321, 638, 16, 70, "Text",
   CellTags->"b:2.2.2",
   CellID->3102],
  Cell[101459, 2364, 102, 2, 70, "Caption",
   CellTags->"b:2.2.2",
   CellID->29213],
  Cell[101564, 2368, 76, 2, 70, "Text",
   CellTags->"b:2.2.2",
   CellID->7627],
  Cell[101643, 2372, 173, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,445"},
   CellID->4802],
  Cell[101819, 2378, 176, 5, 70, "Text",
   CellTags->"b:2.2.2",
   CellID->4099],
  Cell[102020, 2387, 159, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
   CellID->30527],
  Cell[102182, 2393, 221, 6, 70, "Output",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
   CellID->2625],
  Cell[102418, 2402, 282, 9, 70, "Text",
   CellTags->"b:2.2.2",
   CellID->1543],
  Cell[102725, 2415, 154, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
   CellID->1924],
  Cell[102882, 2421, 2737, 59, 70, "Output",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
   CellID->11023],
  Cell[105634, 2483, 356, 12, 70, "Text",
   CellTags->"b:2.2.2",
   CellID->29972],
  Cell[106015, 2499, 171, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
   CellID->13061],
  Cell[106189, 2505, 943, 20, 70, "Output",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
   CellID->14181]},
 "Ex--21943418559164291386,445"->{
  Cell[101643, 2372, 173, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,445"},
   CellID->4802]},
 "Ex--21943418559164291386,446"->{
  Cell[102020, 2387, 159, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
   CellID->30527],
  Cell[102182, 2393, 221, 6, 70, "Output",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
   CellID->2625]},
 "Ex--21943418559164291386,447"->{
  Cell[102725, 2415, 154, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
   CellID->1924],
  Cell[102882, 2421, 2737, 59, 70, "Output",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
   CellID->11023]},
 "Ex--21943418559164291386,448"->{
  Cell[106015, 2499, 171, 4, 70, "Input",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
   CellID->13061],
  Cell[106189, 2505, 943, 20, 70, "Output",
   CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
   CellID->14181]},
 "xref:138"->{
  Cell[107181, 2531, 96, 2, 70, "Section",
   CellTags->{"xref:138", "c:24", "b:2.2.3"},
   CellID->31003]},
 "c:24"->{
  Cell[107181, 2531, 96, 2, 70, "Section",
   CellTags->{"xref:138", "c:24", "b:2.2.3"},
   CellID->31003]},
 "b:2.2.3"->{
  Cell[107181, 2531, 96, 2, 70, "Section",
   CellTags->{"xref:138", "c:24", "b:2.2.3"},
   CellID->31003],
  Cell[107280, 2535, 509, 12, 70, "Text",
   CellTags->"b:2.2.3",
   CellID->27432],
  Cell[108397, 2567, 116, 2, 70, "Caption",
   CellTags->"b:2.2.3",
   CellID->27593],
  Cell[108516, 2571, 278, 9, 70, "Text",
   CellTags->"b:2.2.3",
   CellID->22725]},
 "xref:21"->{
  Cell[108831, 2585, 95, 2, 70, "Section",
   CellTags->{"xref:21", "c:32", "b:2.6"},
   CellID->13031],
  Cell[110751, 2654, 98, 2, 70, "Section",
   CellTags->{"xref:21", "c:32", "b:2.6"},
   CellID->78150545]},
 "c:32"->{
  Cell[108831, 2585, 95, 2, 70, "Section",
   CellTags->{"xref:21", "c:32", "b:2.6"},
   CellID->13031],
  Cell[110751, 2654, 98, 2, 70, "Section",
   CellTags->{"xref:21", "c:32", "b:2.6"},
   CellID->78150545]},
 "b:2.6"->{
  Cell[108831, 2585, 95, 2, 70, "Section",
   CellTags->{"xref:21", "c:32", "b:2.6"},
   CellID->13031],
  Cell[108929, 2589, 139, 5, 70, "Text",
   CellTags->"b:2.6",
   CellID->8492],
  Cell[109071, 2596, 335, 10, 70, "Text",
   CellTags->"b:2.6",
   CellID->142],
  Cell[109409, 2608, 155, 5, 70, "Program",
   CellTags->"b:2.6",
   CellID->17222],
  Cell[109567, 2615, 241, 7, 70, "Text",
   CellTags->"b:2.6",
   CellID->31286],
  Cell[109811, 2624, 171, 5, 70, "Program",
   CellTags->"b:2.6",
   CellID->13064],
  Cell[109985, 2631, 729, 18, 70, "Text",
   CellTags->"b:2.6",
   CellID->7900],
  Cell[110751, 2654, 98, 2, 70, "Section",
   CellTags->{"xref:21", "c:32", "b:2.6"},
   CellID->78150545],
  Cell[110852, 2658, 445, 11, 70, "Text",
   CellTags->"b:2.6",
   CellID->214827612]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:22", 113644, 2721},
 {"xref:145", 113750, 2725},
 {"b:2.0", 113853, 2729},
 {"xref:19", 114025, 2736},
 {"c:23", 114360, 2746},
 {"b:2.2.0", 114698, 2756},
 {"b:2.1", 118672, 2871},
 {"Ex--21943418559164291386,424", 118788, 2875},
 {"Ex--21943418559164291386,425", 119061, 2882},
 {"Ex--21943418559164291386,426", 119571, 2895},
 {"Ex--21943418559164291386,427", 119840, 2902},
 {"Ex--21943418559164291386,428", 120109, 2909},
 {"Ex--21943418559164291386,429", 120262, 2913},
 {"Ex--21943418559164291386,430", 120533, 2920},
 {"Ex--21943418559164291386,431", 120804, 2927},
 {"Ex--21943418559164291386,432", 121078, 2934},
 {"xref:20", 121569, 2947},
 {"c:25", 121686, 2951},
 {"b:2.2.1", 121806, 2955},
 {"Ex--21943418559164291386,433", 124075, 3026},
 {"Ex--21943418559164291386,434", 124226, 3030},
 {"Ex--21943418559164291386,435", 124498, 3037},
 {"Ex--21943418559164291386,436", 124650, 3041},
 {"Ex--21943418559164291386,438", 124921, 3048},
 {"xref:152", 125175, 3055},
 {"b:7.0.0", 125275, 3059},
 {"xref:154", 125375, 3063},
 {"b:7.0.1", 125491, 3067},
 {"Ex--21943418559164291386,439", 127240, 3119},
 {"Ex--21943418559164291386,440", 127512, 3126},
 {"DBAK Chapter 2.1", 127772, 3133},
 {"DBAK Chapter 2", 128177, 3143},
 {"xref:155", 128576, 3153},
 {"b:7.0.2", 128693, 3157},
 {"Ex--21943418559164291386,441", 129787, 3188},
 {"Ex--21943418559164291386,442", 129942, 3192},
 {"Ex--21943418559164291386,443", 130214, 3199},
 {"Ex--21943418559164291386,444", 130487, 3206},
 {"xref:162", 130621, 3210},
 {"b:2.2.2", 130735, 3214},
 {"Ex--21943418559164291386,445", 132210, 3257},
 {"Ex--21943418559164291386,446", 132364, 3261},
 {"Ex--21943418559164291386,447", 132638, 3268},
 {"Ex--21943418559164291386,448", 132914, 3275},
 {"xref:138", 133170, 3282},
 {"c:24", 133290, 3286},
 {"b:2.2.3", 133413, 3290},
 {"xref:21", 133792, 3303},
 {"c:32", 134017, 3310},
 {"b:2.6", 134243, 3317}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1749, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2374, 64, 85, 2, 70, "Title",
 CellTags->{"c:22", "xref:145"},
 CellID->3753],
Cell[2462, 68, 172, 5, 70, "Text",
 CellTags->"b:2.0",
 CellID->12423],
Cell[2637, 75, 778, 21, 70, "Text",
 CellTags->"b:2.0",
 CellID->16279],
Cell[CellGroupData[{
Cell[3440, 100, 103, 2, 70, "Section",
 CellTags->{"xref:19", "c:23", "b:2.2.0"},
 CellID->353438053],
Cell[3546, 104, 678, 16, 70, "Text",
 CellTags->"b:2.1",
 CellID->25996]
}, Open  ]],
Cell[CellGroupData[{
Cell[4261, 125, 103, 2, 70, "Section",
 CellTags->{"xref:19", "c:23", "b:2.2.0"},
 CellID->16139],
Cell[4367, 129, 442, 11, 70, "Text",
 CellID->16687],
Cell[4812, 142, 1987, 57, 70, "DefinitionBox",
 CellID->12529],
Cell[6802, 201, 105, 2, 70, "Caption",
 CellTags->"b:2.2.0",
 CellID->22549],
Cell[6910, 205, 136, 7, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->17437],
Cell[7049, 214, 173, 4, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
 CellID->19866],
Cell[7225, 220, 645, 19, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->12949],
Cell[7873, 241, 378, 13, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->193],
Cell[CellGroupData[{
Cell[8276, 258, 217, 5, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellID->23195],
Cell[8496, 265, 238, 6, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellID->3297]
}, Open  ]],
Cell[8749, 274, 257, 8, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->20416],
Cell[CellGroupData[{
Cell[9031, 286, 157, 4, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
 CellID->28286],
Cell[9191, 292, 264, 7, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,426"},
 CellID->16105]
}, Open  ]],
Cell[9470, 302, 145, 5, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->24488],
Cell[CellGroupData[{
Cell[9640, 311, 160, 4, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
 CellID->16282],
Cell[9803, 317, 285, 8, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,427"},
 CellID->12455]
}, Open  ]],
Cell[10103, 328, 294, 10, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->25734],
Cell[10400, 340, 169, 4, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,428"},
 CellID->18114],
Cell[CellGroupData[{
Cell[10594, 348, 125, 3, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
 CellID->11701],
Cell[10722, 353, 242, 6, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,429"},
 CellID->31316]
}, Open  ]],
Cell[10979, 362, 279, 10, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->20671],
Cell[11261, 374, 1284, 30, 70, "DefinitionBox3Col",
 CellID->5786],
Cell[12548, 406, 234, 9, 70, "Caption",
 CellTags->"b:2.2.0",
 CellID->12263],
Cell[12785, 417, 217, 6, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->4313],
Cell[CellGroupData[{
Cell[13027, 427, 349, 8, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
 CellID->24355],
Cell[13379, 437, 239, 6, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,430"},
 CellID->31185]
}, Open  ]],
Cell[13633, 446, 174, 4, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
 CellID->20053],
Cell[13810, 452, 254, 7, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->912],
Cell[CellGroupData[{
Cell[14089, 463, 358, 9, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellID->10808],
Cell[14450, 474, 238, 6, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellID->1832]
}, Open  ]],
Cell[14703, 483, 254, 8, 70, "Text",
 CellID->391368040],
Cell[14960, 493, 327, 7, 70, "DefinitionBox",
 CellID->83934075],
Cell[15290, 502, 140, 4, 70, "Caption",
 CellTags->"b:2.2.0",
 CellID->263651101],
Cell[15433, 508, 113, 3, 70, "Text",
 CellID->13408378],
Cell[CellGroupData[{
Cell[15571, 515, 229, 6, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellID->389106687],
Cell[15803, 523, 279, 6, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,432"},
 CellID->96076015]
}, Open  ]],
Cell[16097, 532, 179, 4, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,431"},
 CellID->431636696],
Cell[16279, 538, 295, 9, 70, "Text",
 CellID->149843365]
}, Open  ]],
Cell[CellGroupData[{
Cell[16611, 552, 103, 2, 70, "Section",
 CellTags->{"xref:19", "c:23", "b:2.2.0"},
 CellID->37361426],
Cell[16717, 556, 337, 9, 70, "Text",
 CellID->826538626],
Cell[17057, 567, 177, 4, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,424"},
 CellID->462571295],
Cell[17237, 573, 112, 2, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->53197519],
Cell[CellGroupData[{
Cell[17374, 579, 221, 5, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellID->279939859],
Cell[17598, 586, 220, 5, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellID->76385560]
}, Open  ]],
Cell[17833, 594, 104, 2, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->41762904],
Cell[17940, 598, 168, 5, 70, "Input",
 CellID->248529233],
Cell[18111, 605, 95, 1, 70, "Text",
 CellID->133235564],
Cell[CellGroupData[{
Cell[18231, 610, 144, 4, 70, "Input",
 CellID->231267409],
Cell[18378, 616, 10644, 203, 70, "Output",
 CellID->891631461]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29071, 825, 94, 2, 70, "Section",
 CellTags->{"xref:20", "c:25", "b:2.2.1"},
 CellID->27756],
Cell[29168, 829, 174, 5, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->28321],
Cell[29345, 836, 426, 11, 70, "Text",
 CellID->19558],
Cell[29774, 849, 1363, 40, 70, "DefinitionBox",
 CellID->23646],
Cell[31140, 891, 77, 2, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->27982],
Cell[31220, 895, 172, 4, 70, "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,433"},
 CellID->481],
Cell[31395, 901, 304, 8, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->4144],
Cell[CellGroupData[{
Cell[31724, 913, 675, 17, 70, "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
 CellID->23196],
Cell[32402, 932, 244, 6, 70, "Output",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,434"},
 CellID->20222]
}, Open  ]],
Cell[32661, 941, 169, 4, 70, "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,435"},
 CellID->7129],
Cell[32833, 947, 567, 18, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->2161],
Cell[CellGroupData[{
Cell[33425, 969, 158, 4, 70, "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
 CellID->5535],
Cell[33586, 975, 698, 13, 70, "Output",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,436"},
 CellID->20450]
}, Open  ]],
Cell[34299, 991, 313, 10, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->11173],
Cell[34615, 1003, 518, 16, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->10466],
Cell[CellGroupData[{
Cell[35158, 1023, 176, 4, 70, "Input",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
 CellID->12044],
Cell[35337, 1029, 819, 17, 70, "Output",
 CellTags->{"b:2.2.1", "Ex--21943418559164291386,438"},
 CellID->21659]
}, Open  ]],
Cell[36171, 1049, 265, 8, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->26292],
Cell[36439, 1059, 1229, 35, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->26439],
Cell[37671, 1096, 845, 20, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->17253],
Cell[38519, 1118, 177, 5, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->20024],
Cell[38699, 1125, 532, 14, 70, "DefinitionBox",
 CellID->26154],
Cell[39234, 1141, 108, 2, 70, "Caption",
 CellTags->"b:2.2.1",
 CellID->29510],
Cell[39345, 1145, 481, 9, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->4745],
Cell[39829, 1156, 439, 12, 70, "Input",
 Evaluatable->False,
 CellTags->"b:2.2.1",
 CellID->20649],
Cell[40271, 1170, 488, 15, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->13186]
}, Open  ]],
Cell[CellGroupData[{
Cell[40796, 1190, 73, 2, 70, "Section",
 CellTags->"xref:152",
 CellID->8313],
Cell[40872, 1194, 443, 10, 70, "Text",
 CellTags->"b:7.0.0",
 CellID->28022],
Cell[CellGroupData[{
Cell[41340, 1208, 98, 2, 70, "Subsection",
 CellTags->{"xref:154", "b:7.0.1"},
 CellID->2168],
Cell[41441, 1212, 341, 10, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->14018],
Cell[CellGroupData[{
Cell[41807, 1226, 338, 9, 70, "Input",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
 CellID->18787],
Cell[42148, 1237, 254, 5, 70, "Output",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,439"},
 CellID->9905]
}, Open  ]],
Cell[42417, 1245, 640, 16, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->17958],
Cell[CellGroupData[{
Cell[43082, 1265, 306, 8, 70, "Input",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
 CellID->7391],
Cell[43391, 1275, 236, 4, 70, "Output",
 CellTags->{"b:7.0.1", "Ex--21943418559164291386,440"},
 CellID->10202]
}, Open  ]],
Cell[43642, 1282, 201, 8, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->3625],
Cell[43846, 1292, 371, 9, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->26477],
Cell[44220, 1303, 13073, 217, 70, "Picture",
 CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
 CellID->4414],
Cell[57296, 1522, 225, 8, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->9314],
Cell[57524, 1532, 14725, 244, 70, "Picture",
 CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
 CellID->25824],
Cell[72252, 1778, 343, 10, 70, "Text",
 CellTags->{"DBAK Chapter 2.1", "DBAK Chapter 2", "b:7.0.1"},
 CellID->29334],
Cell[72598, 1790, 10843, 181, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->25874],
Cell[83444, 1973, 397, 11, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->24372],
Cell[83844, 1986, 12502, 208, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->20159],
Cell[96349, 2196, 353, 10, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->11833]
}, Open  ]],
Cell[CellGroupData[{
Cell[96739, 2211, 94, 2, 70, "Subsection",
 CellTags->{"xref:155", "b:7.0.2"},
 CellID->28070],
Cell[96836, 2215, 363, 10, 70, "Text",
 CellTags->"b:7.0.2",
 CellID->7487],
Cell[97202, 2227, 376, 11, 70, "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,441"},
 CellID->28297],
Cell[97581, 2240, 102, 2, 70, "Text",
 CellTags->"b:7.0.2",
 CellID->7518],
Cell[CellGroupData[{
Cell[97708, 2246, 164, 4, 70, "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
 CellID->8177],
Cell[97875, 2252, 392, 8, 70, "Output",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,442"},
 CellID->17773]
}, Open  ]],
Cell[CellGroupData[{
Cell[98304, 2265, 316, 8, 70, "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
 CellID->32270],
Cell[98623, 2275, 999, 25, 70, "Output",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,443"},
 CellID->1763]
}, Open  ]],
Cell[99637, 2303, 80, 2, 70, "Text",
 CellTags->"b:7.0.2",
 CellID->2668],
Cell[99720, 2307, 170, 4, 70, "Input",
 CellTags->{"b:7.0.2", "Ex--21943418559164291386,444"},
 CellID->17192]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99939, 2317, 88, 2, 70, "Section",
 CellTags->{"xref:162", "b:2.2.2"},
 CellID->13985],
Cell[100030, 2321, 638, 16, 70, "Text",
 CellTags->"b:2.2.2",
 CellID->3102],
Cell[100671, 2339, 785, 23, 70, "DefinitionBox",
 CellID->8480],
Cell[101459, 2364, 102, 2, 70, "Caption",
 CellTags->"b:2.2.2",
 CellID->29213],
Cell[101564, 2368, 76, 2, 70, "Text",
 CellTags->"b:2.2.2",
 CellID->7627],
Cell[101643, 2372, 173, 4, 70, "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,445"},
 CellID->4802],
Cell[101819, 2378, 176, 5, 70, "Text",
 CellTags->"b:2.2.2",
 CellID->4099],
Cell[CellGroupData[{
Cell[102020, 2387, 159, 4, 70, "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
 CellID->30527],
Cell[102182, 2393, 221, 6, 70, "Output",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,446"},
 CellID->2625]
}, Open  ]],
Cell[102418, 2402, 282, 9, 70, "Text",
 CellTags->"b:2.2.2",
 CellID->1543],
Cell[CellGroupData[{
Cell[102725, 2415, 154, 4, 70, "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
 CellID->1924],
Cell[102882, 2421, 2737, 59, 70, "Output",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,447"},
 CellID->11023]
}, Open  ]],
Cell[105634, 2483, 356, 12, 70, "Text",
 CellTags->"b:2.2.2",
 CellID->29972],
Cell[CellGroupData[{
Cell[106015, 2499, 171, 4, 70, "Input",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
 CellID->13061],
Cell[106189, 2505, 943, 20, 70, "Output",
 CellTags->{"b:2.2.2", "Ex--21943418559164291386,448"},
 CellID->14181]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107181, 2531, 96, 2, 70, "Section",
 CellTags->{"xref:138", "c:24", "b:2.2.3"},
 CellID->31003],
Cell[107280, 2535, 509, 12, 70, "Text",
 CellTags->"b:2.2.3",
 CellID->27432],
Cell[107792, 2549, 602, 16, 70, "DefinitionBox3Col",
 CellID->17505],
Cell[108397, 2567, 116, 2, 70, "Caption",
 CellTags->"b:2.2.3",
 CellID->27593],
Cell[108516, 2571, 278, 9, 70, "Text",
 CellTags->"b:2.2.3",
 CellID->22725]
}, Open  ]],
Cell[CellGroupData[{
Cell[108831, 2585, 95, 2, 70, "Section",
 CellTags->{"xref:21", "c:32", "b:2.6"},
 CellID->13031],
Cell[108929, 2589, 139, 5, 70, "Text",
 CellTags->"b:2.6",
 CellID->8492],
Cell[109071, 2596, 335, 10, 70, "Text",
 CellTags->"b:2.6",
 CellID->142],
Cell[109409, 2608, 155, 5, 70, "Program",
 CellTags->"b:2.6",
 CellID->17222],
Cell[109567, 2615, 241, 7, 70, "Text",
 CellTags->"b:2.6",
 CellID->31286],
Cell[109811, 2624, 171, 5, 70, "Program",
 CellTags->"b:2.6",
 CellID->13064],
Cell[109985, 2631, 729, 18, 70, "Text",
 CellTags->"b:2.6",
 CellID->7900]
}, Open  ]],
Cell[CellGroupData[{
Cell[110751, 2654, 98, 2, 70, "Section",
 CellTags->{"xref:21", "c:32", "b:2.6"},
 CellID->78150545],
Cell[110852, 2658, 445, 11, 70, "Text",
 CellTags->"b:2.6",
 CellID->214827612]
}, Open  ]]
}, Open  ]],
Cell[111324, 2673, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

