(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31439,       1048]
NotebookOptionsPosition[     16138,        549]
NotebookOutlinePosition[     26886,        876]
CellTagsIndexPosition[     25992,        843]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Database Reference", "Title",
 CellTags->{"xref:58", "c:136"},
 CellID->13985],

Cell[CellGroupData[{

Cell["HSQLDB", "Section",
 CellTags->{"xref:59", "c:137", "b:9.0.0"},
 CellID->28289],

Cell[TextData[{
 "HSQLDB is a relational database engine written in Java that is bundled with \
",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 ", which also contains a JDBC driver and necessary configuration. It offers \
a small (about 100k), fast database engine, which can run in a variety of \
ways, including server, in\[Hyphen]process, and in\[Hyphen]memory modes. ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " is configured to use an in\[Hyphen]process stand-alone mode. This makes it \
very simple to run and use (no special configuration is required). However, \
it means that nothing else can connect to the database and only one \
connection to a particular database can be made at any one time (even by \
multiple copies of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellTags->"b:9.0.0",
 CellID->15944],

Cell[TextData[{
 "To create a new database with HSQLDB, you just need to make a connection to \
a database that does not already exist, and HSQLDB will create it for you. \
You could use the Connection Tool, which will deploy a wizard and write a \
named connection. This is described in ",
 ButtonBox["The Database Explorer: The Connection Tool",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer#9010"],
 ". You could also write a connection file and place this in a ",
 StyleBox["DatabaseResources", "MR"],
 " directory, as described in ",
 ButtonBox["Database Resources: Connection Configuration",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#21025"],
 ". Finally, you can use ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " as follows. All of these issues are described in ",
 ButtonBox["Database Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
 "."
}], "Text",
 CellTags->"b:9.0.0",
 CellID->2865],

Cell[TextData[{
 "The following is a sample command that will create a new database called ",
 StyleBox["example", "MR"],
 "."
}], "Text",
 CellTags->"b:9.0.0",
 CellID->18540],

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", 
   RowBox[{
    RowBox[{"JDBC", "[", 
     RowBox[{"\"\<HSQL(Standalone)\>\"", ",", 
      RowBox[{"ToFileName", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "$UserAddOnsDirectory", ",", "\"\<Applications\>\"", ",", 
          "\"\<DatabaseLink\>\"", ",", "\"\<Examples\>\""}], "}"}], ",", 
        "\"\<example\>\""}], "]"}]}], "]"}], ",", 
    RowBox[{"\"\<Name\>\"", "\[Rule]", "\"\<manualA\>\""}], ",", 
    RowBox[{"\"\<Username\>\"", "\[Rule]", "\"\<sa\>\""}]}], "]"}]}]], "Input",\

 Evaluatable->False,
 CellTags->"b:9.0.0",
 CellID->23245],

Cell[TextData[{
 "The details of the HSQLDB driver in ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " can be seen as follows."
}], "Text",
 CellTags->"b:9.0.0",
 CellID->25508],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"JDBCDrivers", "[", "\"\<HSQL(Standalone)\>\"", "]"}]}], "Input",
 CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
 CellLabel->"In[1]:=",
 CellID->28318],

Cell[BoxData[
 RowBox[{"JDBCDriver", "[", 
  RowBox[{
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"HSQL(Standalone)\"\>"}], ",", 
   RowBox[{"\<\"Driver\"\>", "\[Rule]", "\<\"org.hsqldb.jdbcDriver\"\>"}], 
   ",", 
   RowBox[{"\<\"Protocol\"\>", "\[Rule]", "\<\"jdbc:hsqldb:file:\"\>"}], ",", 
   
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"HSQL Database Engine (In-Process Mode) - Version 1.8.0.0 \
-  This mode runs the database engine as part of your application program in \
the same Java Virtual Machine. The main drawback is that it is not possible \
by default to connect to the database from outside your application.\"\>"}], 
   ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
hsqldbstandalone.m\"\>"}]}], "]"}]], "Output",
 CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
 CellLabel->"Out[2]=",
 CellID->27870]
}, Open  ]],

Cell["\<\
To connect to an HSQLDB database you would typically give the filename, \
username, and password as in the following example.\
\>", "Text",
 CellTags->"b:9.0.0",
 CellID->9601],

Cell[BoxData[
 RowBox[{"OpenSQLConnection", "[", " ", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\"\<HSQL(Standalone)\>\"", ",", "\"\<file\>\""}], "]"}], ",", 
   " ", 
   RowBox[{"\"\<Username\>\"", "->", "\"\<user\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"\"\<Password\>\"", "->", "\"\<password\>\""}]}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"b:9.0.0",
 CellID->28323],

Cell[TextData[{
 "For more information, see ",
 ButtonBox[" hsqldb.sourceforge.net/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://hsqldb.sourceforge.net/"], None}],
 "."
}], "Text",
 CellTags->"b:9.2.2",
 CellID->25128]
}, Open  ]],

Cell[CellGroupData[{

Cell["MySQL", "Section",
 CellTags->{"xref:60", "c:138", "b:9.0.1"},
 CellID->24472],

Cell[TextData[{
 "The MySQL database server is an extremely popular open source database. It \
is used in many different types of applications. ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " comes configured with a driver for MySQL."
}], "Text",
 CellTags->"b:9.0.1",
 CellID->27152],

Cell["\<\
If you want to create a new database for MySQL, you should contact the server \
administrator.\
\>", "Text",
 CellTags->"b:9.0.1",
 CellID->25087],

Cell[TextData[{
 "The details of the MySQL driver in ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " can be seen as follows."
}], "Text",
 CellTags->"b:9.0.1",
 CellID->28570],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"JDBCDrivers", "[", "\"\<MySQL(Connector/J)\>\"", "]"}]}], "Input",
 CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
 CellLabel->"In[1]:=",
 CellID->29763],

Cell[BoxData[
 RowBox[{"JDBCDriver", "[", 
  RowBox[{
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"MySQL(Connector/J)\"\>"}], ",", 
   RowBox[{"\<\"Driver\"\>", "\[Rule]", "\<\"com.mysql.jdbc.Driver\"\>"}], 
   ",", 
   RowBox[{"\<\"Protocol\"\>", "\[Rule]", "\<\"jdbc:mysql://\"\>"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"MySQL using Connector/J - Version 3.1.10 - This supports \
all known MySQL server versions.\"\>"}], ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
mysql.m\"\>"}]}], "]"}]], "Output",
 CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
 CellLabel->"Out[2]=",
 CellID->29901]
}, Open  ]],

Cell["\<\
To connect to a MySQL database you would typically set the server, database, \
username, and password as in the following example.\
\>", "Text",
 CellTags->"b:9.0.1",
 CellID->17103],

Cell[BoxData[
 RowBox[{"OpenSQLConnection", "[", " ", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\"\<MySQL(Connector/J)\>\"", ",", "\"\<server/database\>\""}], 
    "]"}], ",", " ", 
   RowBox[{"\"\<Username\>\"", "->", "\"\<user\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"\"\<Password\>\"", "->", "\"\<password\>\""}]}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"b:9.0.1",
 CellID->14423],

Cell[TextData[{
 "For more information, see ",
 ButtonBox["www.mysql.com/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.mysql.com/"], None}],
 "."
}], "Text",
 CellTags->"b:9.2.3",
 CellID->3527]
}, Open  ]],

Cell[CellGroupData[{

Cell["ODBC", "Section",
 CellTags->{"xref:61", "c:139", "b:9.0.2"},
 CellID->11600],

Cell[TextData[{
 "Open Database Connectivity (ODBC) is a general way to connect to SQL \
databases that is supported in a number of operating systems, particularly \
Microsoft Windows. ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " comes configured with a driver for ODBC connections."
}], "Text",
 CellTags->"b:9.0.2",
 CellID->26969],

Cell[TextData[{
 "Under Windows, there is an ODBC Data Source Administrator that can be used \
to connect to a variety of different databases. ",
 ButtonBox["Database Connections: ODBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#8313"],
 " shows how to connect to a database using ODBC."
}], "Text",
 CellTags->"b:9.0.2",
 CellID->14015],

Cell[TextData[{
 "The details of the ODBC driver in ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " can be seen as follows."
}], "Text",
 CellTags->"b:9.0.2",
 CellID->5565],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"JDBCDrivers", "[", "\"\<ODBC(DSN)\>\"", "]"}]}], "Input",
 CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
 CellLabel->"In[1]:=",
 CellID->28],

Cell[BoxData[
 RowBox[{"JDBCDriver", "[", 
  RowBox[{
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"ODBC(DSN)\"\>"}], ",", 
   RowBox[{"\<\"Driver\"\>", 
    "\[Rule]", "\<\"sun.jdbc.odbc.JdbcOdbcDriver\"\>"}], ",", 
   RowBox[{"\<\"Protocol\"\>", "\[Rule]", "\<\"jdbc:odbc:\"\>"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "1.1`"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"JDBC-ODBC Bridge distributed with the Sun JVM.  This \
driver only works on Windows.\"\>"}], ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\
odbcdsn.m\"\>"}]}], "]"}]], "Output",
 CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
 CellLabel->"Out[2]=",
 CellID->21543]
}, Open  ]],

Cell["\<\
To connect to an ODBC database you would typically use a data source name as \
in the following example.\
\>", "Text",
 CellTags->"b:9.0.2",
 CellID->25347],

Cell[BoxData[
 RowBox[{"OpenSQLConnection", "[", " ", 
  RowBox[{"JDBC", "[", 
   RowBox[{"\"\<ODBC(DSN)\>\"", ",", "\"\<datasource\>\""}], "]"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"b:9.0.2",
 CellID->2088]
}, Open  ]],

Cell[CellGroupData[{

Cell["SQL Server", "Section",
 CellTags->{"xref:181", "b:9.0.3"},
 CellID->2943],

Cell["\<\
Support for Microsoft SQL Server is provided by the jTDS driver.\
\>", "Text",
 CellTags->"b:9.0.3",
 CellID->12637],

Cell[TextData[{
 "The details of the SQL Server driver in ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " can be seen as follows."
}], "Text",
 CellTags->"b:9.0.3",
 CellID->22409],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"JDBCDrivers", "[", "\"\<Microsoft SQL Server (jTDS)\>\"", 
  "]"}]}], "Input",
 CellTags->{"b:9.0.3", "Ex--21943492438155078303,195"},
 CellLabel->"In[1]:=",
 CellID->26463],

Cell["\<\
To connect to a Microsoft SQL Server database you would typically set the \
server, database, username, and password as in the following example.\
\>", "Text",
 CellTags->"b:9.0.3",
 CellID->5049],

Cell[BoxData[
 RowBox[{"OpenSQLConnection", "[", " ", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{
    "\"\<Microsoft SQL Server (jTDS)\>\"", ",", "\"\<server/database\>\""}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<Username\>\"", "->", "\"\<user\>\""}], ",", 
   RowBox[{"\"\<Password\>\"", "->", "\"\<password\>\""}]}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"b:9.0.3",
 CellID->4681],

Cell[TextData[{
 "For more information, see: ",
 ButtonBox["jtds.sourceforge.net/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://jtds.sourceforge.net/"], None}],
 " an open source driver for Microsoft SQL Server and Sybase."
}], "Text",
 CellTags->"b:9.2.4",
 CellID->11192]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sybase", "Section",
 CellTags->{"xref:182", "b:9.0.4"},
 CellID->11342],

Cell["Support for Sybase is provided by the jTDS driver.", "Text",
 CellTags->"b:9.0.4",
 CellID->608],

Cell[TextData[{
 "The details of the Sybase driver in ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " can be seen as follows."
}], "Text",
 CellTags->"b:9.0.4",
 CellID->32060],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"JDBCDrivers", "[", "\"\<Sybase (jTDS)\>\"", "]"}]}], "Input",
 CellTags->{"b:9.0.4", "Ex--21943492438155078303,196"},
 CellLabel->"In[1]:=",
 CellID->21221],

Cell["\<\
To connect to a Microsoft SQL Server database you would typically set the \
server, database, username, and password as in the following example.\
\>", "Text",
 CellTags->"b:9.0.4",
 CellID->1758],

Cell[BoxData[
 RowBox[{"OpenSQLConnection", "[", " ", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\"\<Sybase (jTDS)\>\"", ",", "\"\<server/database\>\""}], "]"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<Username\>\"", "->", "\"\<user\>\""}], ",", 
   RowBox[{"\"\<Password\>\"", "->", "\"\<password\>\""}]}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"b:9.0.4",
 CellID->29954],

Cell[TextData[{
 "For more information, see: ",
 ButtonBox["jtds.sourceforge.net/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://jtds.sourceforge.net/"], None}],
 " an open source driver for Microsoft SQL Server and Sybase."
}], "Text",
 CellTags->"b:9.2.4",
 CellID->41]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other Databases", "Section",
 CellTags->{"xref:137", "c:140", "b:9.0.5"},
 CellID->14146],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " can connect to any other type of database with a JDBC driver. You can \
install the driver by following the instructions in ",
 ButtonBox["Database Connections: JDBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 " and ",
 ButtonBox["Database Resources: JDBC Configuration",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#15185"],
 ". "
}], "Text",
 CellTags->"b:9.0.5",
 CellID->690],

Cell[TextData[{
 "Information on how to obtain and install drivers as well as configuring \
connection information for a number of databases is available at ",
 ButtonBox["www.wolfram.com/solutions/connections/database/vendors.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/connections/database/vendors.html"],
     None}],
 "."
}], "Text",
 CellTags->"b:9.0.5",
 CellID->7949]
}, Open  ]],

Cell[CellGroupData[{

Cell["JDBC", "Section",
 CellTags->{"xref:69", "c:143", "b:9.2.1"},
 CellID->21313],

Cell[TextData[{
 "The Java Database Connectivity API: ",
 ButtonBox["java.sun.com/products/jdbc/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://java.sun.com/products/jdbc/"], None}],
 "."
}], "Text",
 CellTags->"b:9.2.1",
 CellID->22501]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Database Reference - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 35.4215845}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "HSQLDB is a relational database engine written in Java that is bundled \
with DatabaseLink, which also contains a JDBC driver and necessary \
configuration. It offers a small (about 100k), fast database engine, which \
can run in a variety of ways, including server, in-process, and in-memory \
modes. DatabaseLink is configured to use an in-process stand-alone mode. This \
makes it very simple to run and use (no special configuration is required). \
However, it means that nothing else can connect to the database and only one \
connection to a particular database can be made at any one time (even by \
multiple copies of Mathematica). To create a new database with HSQLDB, you \
just need to make a connection to a database that does not already exist, and \
HSQLDB will create it for you. You could use the Connection Tool, which will \
deploy a wizard and write a named connection. This is described in The \
Database Explorer: The Connection Tool. You could also write a connection \
file and place this in a DatabaseResources directory, as described in \
Database Resources: Connection Configuration. Finally, you can use \
OpenSQLConnection as follows. All of these issues are described in Database \
Connections. The following is a sample command that will create a new \
database called example.", "synonyms" -> {}, "title" -> "Database Reference", 
    "type" -> "Tutorial", "uri" -> "DatabaseLink/tutorial/DatabaseReference"},
   "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:58"->{
  Cell[729, 29, 84, 2, 70, "Title",
   CellTags->{"xref:58", "c:136"},
   CellID->13985]},
 "c:136"->{
  Cell[729, 29, 84, 2, 70, "Title",
   CellTags->{"xref:58", "c:136"},
   CellID->13985]},
 "xref:59"->{
  Cell[838, 35, 85, 2, 70, "Section",
   CellTags->{"xref:59", "c:137", "b:9.0.0"},
   CellID->28289]},
 "c:137"->{
  Cell[838, 35, 85, 2, 70, "Section",
   CellTags->{"xref:59", "c:137", "b:9.0.0"},
   CellID->28289]},
 "b:9.0.0"->{
  Cell[838, 35, 85, 2, 70, "Section",
   CellTags->{"xref:59", "c:137", "b:9.0.0"},
   CellID->28289],
  Cell[926, 39, 859, 20, 70, "Text",
   CellTags->"b:9.0.0",
   CellID->15944],
  Cell[1788, 61, 1141, 27, 70, "Text",
   CellTags->"b:9.0.0",
   CellID->2865],
  Cell[2932, 90, 176, 6, 70, "Text",
   CellTags->"b:9.0.0",
   CellID->18540],
  Cell[3111, 98, 648, 18, 70, "Input",
   Evaluatable->False,
   CellTags->"b:9.0.0",
   CellID->23245],
  Cell[3762, 118, 184, 7, 70, "Text",
   CellTags->"b:9.0.0",
   CellID->25508],
  Cell[3971, 129, 264, 6, 70, "Input",
   CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
   CellID->28318],
  Cell[4238, 137, 1041, 21, 70, "Output",
   CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
   CellID->27870],
  Cell[5294, 161, 186, 5, 70, "Text",
   CellTags->"b:9.0.0",
   CellID->9601],
  Cell[5483, 168, 400, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"b:9.0.0",
   CellID->28323]},
 "Ex--21943492438155078303,192"->{
  Cell[3971, 129, 264, 6, 70, "Input",
   CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
   CellID->28318],
  Cell[4238, 137, 1041, 21, 70, "Output",
   CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
   CellID->27870]},
 "b:9.2.2"->{
  Cell[5886, 181, 233, 9, 70, "Text",
   CellTags->"b:9.2.2",
   CellID->25128]},
 "xref:60"->{
  Cell[6156, 195, 84, 2, 70, "Section",
   CellTags->{"xref:60", "c:138", "b:9.0.1"},
   CellID->24472]},
 "c:138"->{
  Cell[6156, 195, 84, 2, 70, "Section",
   CellTags->{"xref:60", "c:138", "b:9.0.1"},
   CellID->24472]},
 "b:9.0.1"->{
  Cell[6156, 195, 84, 2, 70, "Section",
   CellTags->{"xref:60", "c:138", "b:9.0.1"},
   CellID->24472],
  Cell[6243, 199, 292, 8, 70, "Text",
   CellTags->"b:9.0.1",
   CellID->27152],
  Cell[6538, 209, 156, 5, 70, "Text",
   CellTags->"b:9.0.1",
   CellID->25087],
  Cell[6697, 216, 183, 7, 70, "Text",
   CellTags->"b:9.0.1",
   CellID->28570],
  Cell[6905, 227, 266, 6, 70, "Input",
   CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
   CellID->29763],
  Cell[7174, 235, 827, 17, 70, "Output",
   CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
   CellID->29901],
  Cell[8016, 255, 192, 5, 70, "Text",
   CellTags->"b:9.0.1",
   CellID->17103],
  Cell[8211, 262, 414, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"b:9.0.1",
   CellID->14423]},
 "Ex--21943492438155078303,193"->{
  Cell[6905, 227, 266, 6, 70, "Input",
   CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
   CellID->29763],
  Cell[7174, 235, 827, 17, 70, "Output",
   CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
   CellID->29901]},
 "b:9.2.3"->{
  Cell[8628, 275, 213, 9, 70, "Text",
   CellTags->"b:9.2.3",
   CellID->3527]},
 "xref:61"->{
  Cell[8878, 289, 83, 2, 70, "Section",
   CellTags->{"xref:61", "c:139", "b:9.0.2"},
   CellID->11600]},
 "c:139"->{
  Cell[8878, 289, 83, 2, 70, "Section",
   CellTags->{"xref:61", "c:139", "b:9.0.2"},
   CellID->11600]},
 "b:9.0.2"->{
  Cell[8878, 289, 83, 2, 70, "Section",
   CellTags->{"xref:61", "c:139", "b:9.0.2"},
   CellID->11600],
  Cell[8964, 293, 344, 9, 70, "Text",
   CellTags->"b:9.0.2",
   CellID->26969],
  Cell[9311, 304, 392, 9, 70, "Text",
   CellTags->"b:9.0.2",
   CellID->14015],
  Cell[9706, 315, 181, 7, 70, "Text",
   CellTags->"b:9.0.2",
   CellID->5565],
  Cell[9912, 326, 254, 6, 70, "Input",
   CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
   CellID->28],
  Cell[10169, 334, 818, 17, 70, "Output",
   CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
   CellID->21543],
  Cell[11002, 354, 166, 5, 70, "Text",
   CellTags->"b:9.0.2",
   CellID->25347],
  Cell[11171, 361, 224, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"b:9.0.2",
   CellID->2088]},
 "Ex--21943492438155078303,194"->{
  Cell[9912, 326, 254, 6, 70, "Input",
   CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
   CellID->28],
  Cell[10169, 334, 818, 17, 70, "Output",
   CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
   CellID->21543]},
 "xref:181"->{
  Cell[11432, 373, 80, 2, 70, "Section",
   CellTags->{"xref:181", "b:9.0.3"},
   CellID->2943]},
 "b:9.0.3"->{
  Cell[11432, 373, 80, 2, 70, "Section",
   CellTags->{"xref:181", "b:9.0.3"},
   CellID->2943],
  Cell[11515, 377, 126, 4, 70, "Text",
   CellTags->"b:9.0.3",
   CellID->12637],
  Cell[11644, 383, 188, 7, 70, "Text",
   CellTags->"b:9.0.3",
   CellID->22409],
  Cell[11835, 392, 278, 7, 70, "Input",
   CellTags->{"b:9.0.3", "Ex--21943492438155078303,195"},
   CellID->26463],
  Cell[12116, 401, 206, 5, 70, "Text",
   CellTags->"b:9.0.3",
   CellID->5049],
  Cell[12325, 408, 418, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"b:9.0.3",
   CellID->4681]},
 "Ex--21943492438155078303,195"->{
  Cell[11835, 392, 278, 7, 70, "Input",
   CellTags->{"b:9.0.3", "Ex--21943492438155078303,195"},
   CellID->26463]},
 "b:9.2.4"->{
  Cell[12746, 421, 287, 9, 70, "Text",
   CellTags->"b:9.2.4",
   CellID->11192],
  Cell[14317, 479, 284, 9, 70, "Text",
   CellTags->"b:9.2.4",
   CellID->41]},
 "xref:182"->{
  Cell[13070, 435, 77, 2, 70, "Section",
   CellTags->{"xref:182", "b:9.0.4"},
   CellID->11342]},
 "b:9.0.4"->{
  Cell[13070, 435, 77, 2, 70, "Section",
   CellTags->{"xref:182", "b:9.0.4"},
   CellID->11342],
  Cell[13150, 439, 102, 2, 70, "Text",
   CellTags->"b:9.0.4",
   CellID->608],
  Cell[13255, 443, 184, 7, 70, "Text",
   CellTags->"b:9.0.4",
   CellID->32060],
  Cell[13442, 452, 261, 6, 70, "Input",
   CellTags->{"b:9.0.4", "Ex--21943492438155078303,196"},
   CellID->21221],
  Cell[13706, 460, 206, 5, 70, "Text",
   CellTags->"b:9.0.4",
   CellID->1758],
  Cell[13915, 467, 399, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"b:9.0.4",
   CellID->29954]},
 "Ex--21943492438155078303,196"->{
  Cell[13442, 452, 261, 6, 70, "Input",
   CellTags->{"b:9.0.4", "Ex--21943492438155078303,196"},
   CellID->21221]},
 "xref:137"->{
  Cell[14638, 493, 95, 2, 70, "Section",
   CellTags->{"xref:137", "c:140", "b:9.0.5"},
   CellID->14146]},
 "c:140"->{
  Cell[14638, 493, 95, 2, 70, "Section",
   CellTags->{"xref:137", "c:140", "b:9.0.5"},
   CellID->14146]},
 "b:9.0.5"->{
  Cell[14638, 493, 95, 2, 70, "Section",
   CellTags->{"xref:137", "c:140", "b:9.0.5"},
   CellID->14146],
  Cell[14736, 497, 551, 15, 70, "Text",
   CellTags->"b:9.0.5",
   CellID->690],
  Cell[15290, 514, 421, 11, 70, "Text",
   CellTags->"b:9.0.5",
   CellID->7949]},
 "xref:69"->{
  Cell[15748, 530, 83, 2, 70, "Section",
   CellTags->{"xref:69", "c:143", "b:9.2.1"},
   CellID->21313]},
 "c:143"->{
  Cell[15748, 530, 83, 2, 70, "Section",
   CellTags->{"xref:69", "c:143", "b:9.2.1"},
   CellID->21313]},
 "b:9.2.1"->{
  Cell[15748, 530, 83, 2, 70, "Section",
   CellTags->{"xref:69", "c:143", "b:9.2.1"},
   CellID->21313],
  Cell[15834, 534, 250, 9, 70, "Text",
   CellTags->"b:9.2.1",
   CellID->22501]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:58", 18694, 598},
 {"c:136", 18797, 602},
 {"xref:59", 18902, 606},
 {"c:137", 19018, 610},
 {"b:9.0.0", 19136, 614},
 {"Ex--21943492438155078303,192", 20123, 647},
 {"b:9.2.2", 20373, 654},
 {"xref:60", 20469, 658},
 {"c:138", 20587, 662},
 {"b:9.0.1", 20707, 666},
 {"Ex--21943492438155078303,193", 21512, 692},
 {"b:9.2.3", 21761, 699},
 {"xref:61", 21856, 703},
 {"c:139", 21974, 707},
 {"b:9.0.2", 22094, 711},
 {"Ex--21943492438155078303,194", 22896, 737},
 {"xref:181", 23144, 744},
 {"b:9.0.3", 23256, 748},
 {"Ex--21943492438155078303,195", 23857, 768},
 {"b:9.2.4", 23989, 772},
 {"xref:182", 24166, 779},
 {"b:9.0.4", 24279, 783},
 {"Ex--21943492438155078303,196", 24880, 803},
 {"xref:137", 25013, 807},
 {"c:140", 25133, 811},
 {"b:9.0.5", 25255, 815},
 {"xref:69", 25540, 825},
 {"c:143", 25659, 829},
 {"b:9.2.1", 25780, 833}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 84, 2, 70, "Title",
 CellTags->{"xref:58", "c:136"},
 CellID->13985],
Cell[CellGroupData[{
Cell[838, 35, 85, 2, 70, "Section",
 CellTags->{"xref:59", "c:137", "b:9.0.0"},
 CellID->28289],
Cell[926, 39, 859, 20, 70, "Text",
 CellTags->"b:9.0.0",
 CellID->15944],
Cell[1788, 61, 1141, 27, 70, "Text",
 CellTags->"b:9.0.0",
 CellID->2865],
Cell[2932, 90, 176, 6, 70, "Text",
 CellTags->"b:9.0.0",
 CellID->18540],
Cell[3111, 98, 648, 18, 70, "Input",
 Evaluatable->False,
 CellTags->"b:9.0.0",
 CellID->23245],
Cell[3762, 118, 184, 7, 70, "Text",
 CellTags->"b:9.0.0",
 CellID->25508],
Cell[CellGroupData[{
Cell[3971, 129, 264, 6, 70, "Input",
 CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
 CellID->28318],
Cell[4238, 137, 1041, 21, 70, "Output",
 CellTags->{"b:9.0.0", "Ex--21943492438155078303,192"},
 CellID->27870]
}, Open  ]],
Cell[5294, 161, 186, 5, 70, "Text",
 CellTags->"b:9.0.0",
 CellID->9601],
Cell[5483, 168, 400, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"b:9.0.0",
 CellID->28323],
Cell[5886, 181, 233, 9, 70, "Text",
 CellTags->"b:9.2.2",
 CellID->25128]
}, Open  ]],
Cell[CellGroupData[{
Cell[6156, 195, 84, 2, 70, "Section",
 CellTags->{"xref:60", "c:138", "b:9.0.1"},
 CellID->24472],
Cell[6243, 199, 292, 8, 70, "Text",
 CellTags->"b:9.0.1",
 CellID->27152],
Cell[6538, 209, 156, 5, 70, "Text",
 CellTags->"b:9.0.1",
 CellID->25087],
Cell[6697, 216, 183, 7, 70, "Text",
 CellTags->"b:9.0.1",
 CellID->28570],
Cell[CellGroupData[{
Cell[6905, 227, 266, 6, 70, "Input",
 CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
 CellID->29763],
Cell[7174, 235, 827, 17, 70, "Output",
 CellTags->{"b:9.0.1", "Ex--21943492438155078303,193"},
 CellID->29901]
}, Open  ]],
Cell[8016, 255, 192, 5, 70, "Text",
 CellTags->"b:9.0.1",
 CellID->17103],
Cell[8211, 262, 414, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"b:9.0.1",
 CellID->14423],
Cell[8628, 275, 213, 9, 70, "Text",
 CellTags->"b:9.2.3",
 CellID->3527]
}, Open  ]],
Cell[CellGroupData[{
Cell[8878, 289, 83, 2, 70, "Section",
 CellTags->{"xref:61", "c:139", "b:9.0.2"},
 CellID->11600],
Cell[8964, 293, 344, 9, 70, "Text",
 CellTags->"b:9.0.2",
 CellID->26969],
Cell[9311, 304, 392, 9, 70, "Text",
 CellTags->"b:9.0.2",
 CellID->14015],
Cell[9706, 315, 181, 7, 70, "Text",
 CellTags->"b:9.0.2",
 CellID->5565],
Cell[CellGroupData[{
Cell[9912, 326, 254, 6, 70, "Input",
 CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
 CellID->28],
Cell[10169, 334, 818, 17, 70, "Output",
 CellTags->{"b:9.0.2", "Ex--21943492438155078303,194"},
 CellID->21543]
}, Open  ]],
Cell[11002, 354, 166, 5, 70, "Text",
 CellTags->"b:9.0.2",
 CellID->25347],
Cell[11171, 361, 224, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"b:9.0.2",
 CellID->2088]
}, Open  ]],
Cell[CellGroupData[{
Cell[11432, 373, 80, 2, 70, "Section",
 CellTags->{"xref:181", "b:9.0.3"},
 CellID->2943],
Cell[11515, 377, 126, 4, 70, "Text",
 CellTags->"b:9.0.3",
 CellID->12637],
Cell[11644, 383, 188, 7, 70, "Text",
 CellTags->"b:9.0.3",
 CellID->22409],
Cell[11835, 392, 278, 7, 70, "Input",
 CellTags->{"b:9.0.3", "Ex--21943492438155078303,195"},
 CellID->26463],
Cell[12116, 401, 206, 5, 70, "Text",
 CellTags->"b:9.0.3",
 CellID->5049],
Cell[12325, 408, 418, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"b:9.0.3",
 CellID->4681],
Cell[12746, 421, 287, 9, 70, "Text",
 CellTags->"b:9.2.4",
 CellID->11192]
}, Open  ]],
Cell[CellGroupData[{
Cell[13070, 435, 77, 2, 70, "Section",
 CellTags->{"xref:182", "b:9.0.4"},
 CellID->11342],
Cell[13150, 439, 102, 2, 70, "Text",
 CellTags->"b:9.0.4",
 CellID->608],
Cell[13255, 443, 184, 7, 70, "Text",
 CellTags->"b:9.0.4",
 CellID->32060],
Cell[13442, 452, 261, 6, 70, "Input",
 CellTags->{"b:9.0.4", "Ex--21943492438155078303,196"},
 CellID->21221],
Cell[13706, 460, 206, 5, 70, "Text",
 CellTags->"b:9.0.4",
 CellID->1758],
Cell[13915, 467, 399, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"b:9.0.4",
 CellID->29954],
Cell[14317, 479, 284, 9, 70, "Text",
 CellTags->"b:9.2.4",
 CellID->41]
}, Open  ]],
Cell[CellGroupData[{
Cell[14638, 493, 95, 2, 70, "Section",
 CellTags->{"xref:137", "c:140", "b:9.0.5"},
 CellID->14146],
Cell[14736, 497, 551, 15, 70, "Text",
 CellTags->"b:9.0.5",
 CellID->690],
Cell[15290, 514, 421, 11, 70, "Text",
 CellTags->"b:9.0.5",
 CellID->7949]
}, Open  ]],
Cell[CellGroupData[{
Cell[15748, 530, 83, 2, 70, "Section",
 CellTags->{"xref:69", "c:143", "b:9.2.1"},
 CellID->21313],
Cell[15834, 534, 250, 9, 70, "Text",
 CellTags->"b:9.2.1",
 CellID->22501]
}, Open  ]]
}, Open  ]],
Cell[16111, 547, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

