(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32498,       1103]
NotebookOptionsPosition[     21279,        728]
NotebookOutlinePosition[     28083,        940]
CellTagsIndexPosition[     27720,        925]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DatabaseResourcesPath" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/DatabaseResourcesPath"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"DatabaseResourcesPath\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Database Resources", "Title",
 CellTags->{"c:26", "xref:146"},
 CellID->12843],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " allows other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications to hold resource information for database connections in ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directories. There are a number of possible locations of ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directories inside ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:2.3.0",
 CellID->25620],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DatabaseResourcesPath",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"], "[", 
     "]"}], Cell[TextData[{
     StyleBox["DatabaseResources", "InlineCode"],
     " directories to search for resources"
    }], "TableText"]},
   {
    RowBox[{
    "$InstallationDirectory", "/", "AddOns", "/", "ExtraPackages", "/", "*"}],
     Cell[TextData[{
     "possible locations for ",
     StyleBox["DatabaseResources", "InlineCode"],
     " directories"
    }], "TableText"]},
   {
    RowBox[{
    "$InstallationDirectory", "/", "AddOns", "/", "StandardPackages", "/", 
     "*"}], Cell[" ", "TableText"]},
   {
    RowBox[{
    "$InstallationDirectory", "/", "AddOns", "/", "Autoload", "/", "*"}], 
    Cell[" ", "TableText"]},
   {
    RowBox[{
    "$InstallationDirectory", "/", "AddOns", "/", "Applications", "/", "*"}], 
    Cell[" ", "TableText"]},
   {
    RowBox[{"$BaseDirectory", "/", "Autoload", "/", "*"}], Cell[
    " ", "TableText"]},
   {
    RowBox[{"$BaseDirectory", "/", "Applications", "/", "*"}], Cell[
    " ", "TableText"]},
   {
    RowBox[{"$UserBaseDirectory", "/", "Autoload", "/", "*"}], Cell[
    " ", "TableText"]},
   {
    RowBox[{"$UserBaseDirectory", "/", "Applications", "/", "*"}], Cell[
    " ", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.25], {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->748],

Cell[TextData[{
 "The command ",
 Cell[BoxData[
  ButtonBox["DatabaseResourcesPath",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"]], 
  "InlineFormula"],
 " shows the current locations of ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directories."
}], "Text",
 CellTags->"b:2.3.0",
 CellID->27067],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Ex--21943492438155078303,40",
 CellLabel->"In[1]:=",
 CellID->4536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatabaseResourcesPath", "[", "]"}]], "Input",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellLabel->"In[2]:=",
 CellID->20783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\WRI\\\\Application \
Data\\\\Mathematica\\\\Applications\\\\DatabaseLink\\\\DatabaseResources\\\\\"\
\>"}], "}"}]], "Output",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellLabel->"Out[2]=",
 CellID->18035]
}, Open  ]],

Cell[TextData[{
 StyleBox["DatabaseResources", "InlineCode"],
 " directories can hold two sorts of files: those that contain JDBC settings \
and those that contain connection settings."
}], "Text",
 CellTags->"b:2.3.0",
 CellID->32226],

Cell[CellGroupData[{

Cell["JDBC Configuration", "Section",
 CellTags->{"xref:65", "c:28", "b:2.3.1"},
 CellID->15185],

Cell[TextData[{
 "Any file that is in a ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directory with an extension of ",
 ".m",
 " will be inspected to see if it contains possible JDBC configuration \
information. Here is the format of a JDBC configuration file."
}], "Text",
 CellTags->"b:2.3.1",
 CellID->7038],

Cell["\<\
JDBCDriver[
\t\"Name\" -> \"name\",
\t\"Driver\" -> \"driverclass\",
\t\"Protocol\" -> \"protocol\",
\t\"Version\" -> 1
]\
\>", "Program",
 CellTags->"b:2.3.1",
 CellID->9853],

Cell[TextData[{
 "In this format ",
 StyleBox["name", "InlineCode"],
 " is the name of the connection (as might be used in ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 "), ",
 StyleBox["driverclass", "InlineCode"],
 " is the class file of the JDBC driver, and ",
 StyleBox["protocol", "InlineCode"],
 " is the JDBC protocol. The version of the configuration file is specified \
by the ",
 Cell[BoxData["Version"], "InlineFormula"],
 " setting. "
}], "Text",
 CellTags->"b:2.3.1",
 CellID->25629],

Cell["Here is an example file (configured for HSQLDB).", "Text",
 CellTags->"b:2.3.1",
 CellID->11224],

Cell["\<\
JDBCDriver[
\t\"Name\" -> \"hsqldb\",
\t\"Driver\" -> \"org.hsqldb.jdbcDriver\",
\t\"Protocol\" -> \"jdbc:hsqldb:\",
\t\"Version\" -> 1
]\
\>", "Program",
 CellTags->"b:2.3.1",
 CellID->15748],

Cell[TextData[{
 "This file specifies the driver and protocol to use when ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " is invoked for an ",
 StyleBox["hsqldb", "InlineCode"],
 " connection, such as the following command."
}], "Text",
 CellTags->"b:2.3.1",
 CellID->19923],

Cell["\<\
OpenSQLConnection[JDBC[\"hsqldb\",ToFileName[{\"DatabaseLink\",\"Examples\"},\
\"example\"]]\
\>", "Program",
 CellTags->"b:2.3.1",
 CellID->3359],

Cell["Here is another example file (configured for Oracle).", "Text",
 CellTags->"b:2.3.1",
 CellID->32257],

Cell["\<\
JDBCDriver[
\t\"Name\" -> \"oracle\",
\t\"Driver\" -> \"oracle.jdbc.driver.OracleDriver\",
\t\"Protocol\" -> \"jdbc:oracle:thin:@\",
\t\"Version\" -> 1
]\
\>", "Program",
 CellTags->"b:2.3.1",
 CellID->24766],

Cell[TextData[{
 "This specifies the driver and protocol to use when ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " is invoked for an ",
 StyleBox["oracle", "InlineCode"],
 " connection, such as the following command."
}], "Text",
 CellTags->"b:2.3.1",
 CellID->4944],

Cell["\<\
OpenSQLConnection[JDBC[\"oracle\",\"server.business.com:1999\"],
\t\"Username\" -> \"server1\"]\
\>", "Program",
 CellTags->"b:2.3.1",
 CellID->14955],

Cell[TextData[{
 "Note that if you added an application to hold JDBC driver classes (as shown \
in ",
 ButtonBox["Database Connections: JDBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 "), you could create a ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directory in the same application to hold JDBC configuration information. \
The following table shows the layout of an application, named ",
 StyleBox["Oracle", "InlineCode"],
 ", that could be used for connecting to the Oracle database."
}], "Text",
 CellTags->"b:2.3.1",
 CellID->23318],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      RowBox[{"$UserBaseDirectory", "/", "Applications"}], "/", "Oracle"}], 
     "/", "Java"}], Cell[
    "location for database driver class files", "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"$UserBaseDirectory", "/", "Applications"}], "/", "Oracle"}], 
     "/", "DatabaseResources"}], Cell[
    "location for JDBC configuration files", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.71], {
      Scaled[0.29]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->32726],

Cell[TextData[{
 "When you have installed a new JDBC driver, you might want to confirm that \
your new driver is accessible to the system. This is described in ",
 ButtonBox["Database Connections: JDBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 "."
}], "Text",
 CellTags->"b:2.3.1",
 CellID->25411]
}, Open  ]],

Cell[CellGroupData[{

Cell["Connection Configuration", "Section",
 CellTags->{"xref:66", "c:29", "b:2.3.2"},
 CellID->21025],

Cell[TextData[{
 "Any file that is in a ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directory with an extension of ",
 ".m",
 " will be inspected to see if it contains possible connection configuration \
information. Here is the format of a connection configuration file."
}], "Text",
 CellTags->"b:2.3.2",
 CellID->20355],

Cell["\<\
SQLConnection[
  connectdata,
  \"Name\" -> \"name\", 
  \"Description\" -> \"text\", 
  \"Username\" -> \"user\", 
  \"Password\" -> \"pass\",
  \"RelativePath\" -> True|False,
  \"Version\" -> 1
]\
\>", "Program",
 CellTags->"b:2.3.2",
 CellID->31001],

Cell[TextData[{
 "Here ",
 StyleBox["connectdata", "InlineCode"],
 " holds connection data (typically a JDBC setting), ",
 StyleBox["name", "InlineCode"],
 " is the name of the connection (as might be used in ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 "), ",
 StyleBox["text", "InlineCode"],
 " is a textual description of the connection, and ",
 StyleBox["user", "InlineCode"],
 " and ",
 StyleBox["pass", "InlineCode"],
 " are the username and password to use when connecting to the database. A \
password of ",
 StyleBox["$Prompt", "InlineCode"],
 " causes a GUI to appear to enter the password. If the connection data \
involves a relative path, this is specified with the ",
 StyleBox["RelativePath", "InlineCode"],
 " setting. The version of the configuration file is specified by the ",
 Cell[BoxData["Version"], "InlineFormula"],
 " setting."
}], "Text",
 CellTags->"b:2.3.2",
 CellID->22549],

Cell["Here is an example file (configured for HSQLDB).", "Text",
 CellTags->"b:2.3.2",
 CellID->9496],

Cell["\<\
SQLConnection[
\tJDBC[\"hsqldb\", \"../Examples/example\"], 
 \t\"Name\" -> \"example\", 
 \t\"Description\" -> \"Connection to hsql db for documention.\", 
 \t\"Username\" -> \"sa\", 
 \t\"Password\" -> \"\", 
    \"RelativePath\" -> True,
 \t\"Version\" -> 1]\
\>", "Program",
 CellTags->"b:2.3.2",
 CellID->18584],

Cell[TextData[{
 "This file specifies that HSQLDB should be used to connect to the file ",
 StyleBox["Examples/example", "InlineCode"],
 ", which is found relative to the location of the configuration file. The \
username ",
 StyleBox["sa", "InlineCode"],
 " and a blank password are also given. This connection information is given \
the name ",
 StyleBox["\"example\"", "InlineCode"],
 ". This configuration file supports the following ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " command."
}], "Text",
 CellTags->"b:2.3.2",
 CellID->9515],

Cell["OpenSQLConnection[\"example\"]", "Program",
 CellTags->"b:2.3.2",
 CellID->17964],

Cell["Here is another example file (configured for Oracle).", "Text",
 CellTags->"b:2.3.2",
 CellID->23342],

Cell["\<\
SQLConnection[
\tJDBC[\"oracle\", \"server.business.com:1999\"], 
 \t\"Name\" -> \"businessDB\", 
 \t\"Description\" -> \"Connection to Oracle db.\", 
 \t\"Username\" -> \"server1\", 
 \t\"Version\" -> 1]\
\>", "Program",
 CellTags->"b:2.3.2",
 CellID->8075],

Cell[TextData[{
 "This specifies connection information to use when ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " is invoked with ",
 StyleBox["businessDB", "InlineCode"],
 ", such as the following command."
}], "Text",
 CellTags->"b:2.3.2",
 CellID->17913],

Cell["OpenSQLConnection[\"businessDB\"]", "Program",
 CellTags->"b:2.3.2",
 CellID->16142],

Cell[TextData[{
 "Note that if you added an application to hold JDBC driver classes (as shown \
in ",
 ButtonBox["Database Connections: JDBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 "), and JDBC configuration information (as shown ",
 ButtonBox["previously",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#15185"],
 "), you could use the same location for holding the Oracle connection \
information. The following table shows the layout of an application that \
could be used for connecting to Oracle."
}], "Text",
 CellTags->"b:2.3.2",
 CellID->31196],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      RowBox[{"$UserBaseDirectory", "/", "Applications"}], "/", "Oracle"}], 
     "/", "Java"}], Cell[
    "location for database driver class files", "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"$UserBaseDirectory", "/", "Applications"}], "/", "Oracle"}], 
     "/", "DatabaseResources"}], Cell[
    "location for JDBC configuration files", "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"$UserBaseDirectory", "/", "Applications"}], "/", "Oracle"}], 
     "/", "DatabaseResources"}], Cell[
    "location for connection configuration files", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.71], {
      Scaled[0.29]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->21948],

Cell[TextData[{
 "To help you to write the connection configuration file, you can use the \
command ",
 Cell[BoxData[
  ButtonBox["WriteDataSource",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/WriteDataSource"]]],
 "."
}], "Text",
 CellID->618267192],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Ex--21943492438155078303,40",
 CellLabel->"In[1]:=",
 CellID->149569975],

Cell[TextData[{
 "This creates a data source named ",
 StyleBox["testSource", "InlineCode"],
 ", it will use the ",
 Cell[BoxData[
  ButtonBox["HSQL",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/DatabaseReference#28289"]]],
 " database."
}], "Text",
 CellID->43490168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteDataSource", "[", "\"\<testSource\>\"", "]"}]], "Input",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellLabel->"In[2]:=",
 CellID->76893794],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", ",", "\<\"testSource\"\>"}], "]"}], 
   ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"testSource\"\>"}], ",", 
   RowBox[{"\<\"Description\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellLabel->"Out[2]=",
 CellID->272111991]
}, Open  ]],

Cell[TextData[{
 "The new data source shows up in the listing from ",
 Cell[BoxData[
  ButtonBox["DataSourceNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/DataSourceNames"]]],
 "."
}], "Text",
 CellID->11435528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataSourceNames", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->106813213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"demo\"\>", ",", "\<\"graphs\"\>", ",", "\<\"publisher\"\>", 
   ",", "\<\"testSource\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->332976646]
}, Open  ]],

Cell[TextData[{
 "You can connect to the data source and start to work with it. One benefit \
of the ",
 Cell[BoxData[
  ButtonBox["HSQL",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/DatabaseReference#28289"]]],
 " database is that it will create the database if it does not exist."
}], "Text",
 CellID->315692737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", "\"\<testSource\>\"", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->229525026],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"testSource\"\>", ",", "3", ",", "\<\"Open\"\>"}], 
  "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->601293888]
}, Open  ]],

Cell["It is typically a good practice to close the connection.", "Text",
 CellID->308925162],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->16010760],

Cell[TextData[{
 "If you want to connect to a database other than ",
 Cell[BoxData[
  ButtonBox["HSQL",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/DatabaseReference#28289"]]],
 " you can give a second argument to ",
 Cell[BoxData[
  ButtonBox["WriteDataSource",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/WriteDataSource"]]],
 ". For example, the following will write a data source file that uses ",
 Cell[BoxData[
  ButtonBox["MySQL",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/DatabaseReference#24472"]]],
 " database."
}], "Text",
 CellID->177909636],

Cell[BoxData[
 RowBox[{"WriteDataSource", "[", 
  RowBox[{"\"\<test\>\"", ",", " ", "\"\<MySQL(Connector/J)\>\"", ",", " ", 
   RowBox[{"URL", " ", "\[Rule]", " ", "\"\<main/test\>\""}], ",", " ", 
   RowBox[{"Username", " ", "\[Rule]", " ", "\"\<user\>\""}], ",", " ", 
   RowBox[{"Password", " ", "\[Rule]", " ", "\"\<password\>\""}], ",", " ", 
   RowBox[{"Location", " ", "\[Rule]", " ", "\"\<User\>\""}]}], 
  "]"}]], "Input",
 CellID->335873303],

Cell[TextData[{
 "Note that this does not communicate with the MySQL server to create the \
database, ",
 StyleBox["main/test", "InlineCode"],
 ". It is assumed that the database already exists. However, this is still a \
convenient way to create a named connection. Note how the parameters such as \
",
 StyleBox["Username", "InlineCode"],
 ", ",
 StyleBox["Password", "InlineCode"],
 ", and ",
 StyleBox["Location", "InlineCode"],
 " are set. The choices for ",
 StyleBox["Location", "InlineCode"],
 " are \"",
 StyleBox["User\"", "InlineCode"],
 " and ",
 StyleBox["\"System\"", "InlineCode"],
 ". "
}], "Text",
 CellID->714151483],

Cell[TextData[{
 "If you did not wish to write the connection configuration file yourself, \
you could use the New Connection Wizard, described in ",
 ButtonBox["The Database Explorer: New Connection Wizard",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer#13584"],
 "."
}], "Text",
 CellTags->"b:2.3.2",
 CellID->25072],

Cell[TextData[{
 "When you have made a new named connection, you might want to confirm that \
the new connection is accessible to the system. This is described in ",
 ButtonBox["Database Connections: Named Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#13985"],
 "."
}], "Text",
 CellTags->"b:2.3.2",
 CellID->20426]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Database Resources - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 36.1872046}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "DatabaseLink allows other Mathematica applications to hold resource \
information for database connections in DatabaseResources directories. There \
are a number of possible locations of DatabaseResources directories inside \
$InstallationDirectory, $BaseDirectory, and $UserBaseDirectory. The command \
DatabaseResourcesPath shows the current locations of DatabaseResources \
directories. DatabaseResources directories can hold two sorts of files: those \
that contain JDBC settings and those that contain connection settings.", 
    "synonyms" -> {}, "title" -> "Database Resources", "type" -> "Tutorial", 
    "uri" -> "DatabaseLink/tutorial/DatabaseResources"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:26"->{
  Cell[1249, 43, 84, 2, 70, "Title",
   CellTags->{"c:26", "xref:146"},
   CellID->12843]},
 "xref:146"->{
  Cell[1249, 43, 84, 2, 70, "Title",
   CellTags->{"c:26", "xref:146"},
   CellID->12843]},
 "b:2.3.0"->{
  Cell[1336, 47, 879, 28, 70, "Text",
   CellTags->"b:2.3.0",
   CellID->25620],
  Cell[3919, 130, 343, 12, 70, "Text",
   CellTags->"b:2.3.0",
   CellID->27067],
  Cell[4466, 153, 164, 4, 70, "Input",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->20783],
  Cell[4633, 159, 538, 11, 70, "Output",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->18035],
  Cell[5186, 173, 235, 6, 70, "Text",
   CellTags->"b:2.3.0",
   CellID->32226],
  Cell[16073, 560, 183, 4, 70, "Input",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->76893794],
  Cell[16259, 566, 1005, 21, 70, "Output",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->272111991]},
 "Ex--21943492438155078303,40"->{
  Cell[4265, 144, 176, 5, 70, "Input",
   CellTags->"Ex--21943492438155078303,40",
   CellID->4536],
  Cell[15573, 539, 181, 5, 70, "Input",
   CellTags->"Ex--21943492438155078303,40",
   CellID->149569975]},
 "Ex--21943492438155078303,191"->{
  Cell[4466, 153, 164, 4, 70, "Input",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->20783],
  Cell[4633, 159, 538, 11, 70, "Output",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->18035],
  Cell[16073, 560, 183, 4, 70, "Input",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->76893794],
  Cell[16259, 566, 1005, 21, 70, "Output",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->272111991]},
 "xref:65"->{
  Cell[5446, 183, 96, 2, 70, "Section",
   CellTags->{"xref:65", "c:28", "b:2.3.1"},
   CellID->15185]},
 "c:28"->{
  Cell[5446, 183, 96, 2, 70, "Section",
   CellTags->{"xref:65", "c:28", "b:2.3.1"},
   CellID->15185]},
 "b:2.3.1"->{
  Cell[5446, 183, 96, 2, 70, "Section",
   CellTags->{"xref:65", "c:28", "b:2.3.1"},
   CellID->15185],
  Cell[5545, 187, 317, 9, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->7038],
  Cell[5865, 198, 185, 9, 70, "Program",
   CellTags->"b:2.3.1",
   CellID->9853],
  Cell[6053, 209, 607, 19, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->25629],
  Cell[6663, 230, 102, 2, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->11224],
  Cell[6768, 234, 202, 9, 70, "Program",
   CellTags->"b:2.3.1",
   CellID->15748],
  Cell[6973, 245, 385, 12, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->19923],
  Cell[7361, 259, 156, 5, 70, "Program",
   CellTags->"b:2.3.1",
   CellID->3359],
  Cell[7520, 266, 107, 2, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->32257],
  Cell[7630, 270, 218, 9, 70, "Program",
   CellTags->"b:2.3.1",
   CellID->24766],
  Cell[7851, 281, 379, 12, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->4944],
  Cell[8233, 295, 160, 5, 70, "Program",
   CellTags->"b:2.3.1",
   CellID->14955],
  Cell[8396, 302, 613, 14, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->23318],
  Cell[9645, 338, 364, 9, 70, "Text",
   CellTags->"b:2.3.1",
   CellID->25411]},
 "xref:66"->{
  Cell[10046, 352, 102, 2, 70, "Section",
   CellTags->{"xref:66", "c:29", "b:2.3.2"},
   CellID->21025]},
 "c:29"->{
  Cell[10046, 352, 102, 2, 70, "Section",
   CellTags->{"xref:66", "c:29", "b:2.3.2"},
   CellID->21025]},
 "b:2.3.2"->{
  Cell[10046, 352, 102, 2, 70, "Section",
   CellTags->{"xref:66", "c:29", "b:2.3.2"},
   CellID->21025],
  Cell[10151, 356, 330, 9, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->20355],
  Cell[10484, 367, 263, 12, 70, "Program",
   CellTags->"b:2.3.2",
   CellID->31001],
  Cell[10750, 381, 1014, 28, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->22549],
  Cell[11767, 411, 101, 2, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->9496],
  Cell[11871, 415, 326, 11, 70, "Program",
   CellTags->"b:2.3.2",
   CellID->18584],
  Cell[12200, 428, 655, 18, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->9515],
  Cell[12858, 448, 87, 2, 70, "Program",
   CellTags->"b:2.3.2",
   CellID->17964],
  Cell[12948, 452, 107, 2, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->23342],
  Cell[13058, 456, 268, 9, 70, "Program",
   CellTags->"b:2.3.2",
   CellID->8075],
  Cell[13329, 467, 370, 12, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->17913],
  Cell[13702, 481, 90, 2, 70, "Program",
   CellTags->"b:2.3.2",
   CellID->16142],
  Cell[13795, 485, 657, 15, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->31196],
  Cell[20497, 702, 357, 9, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->25072],
  Cell[20857, 713, 368, 9, 70, "Text",
   CellTags->"b:2.3.2",
   CellID->20426]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:26", 23057, 767},
 {"xref:146", 23164, 771},
 {"b:2.3.0", 23270, 775},
 {"Ex--21943492438155078303,40", 24027, 797},
 {"Ex--21943492438155078303,191", 24271, 804},
 {"xref:65", 24764, 817},
 {"c:28", 24880, 821},
 {"b:2.3.1", 24999, 825},
 {"xref:66", 26186, 868},
 {"c:29", 26304, 872},
 {"b:2.3.2", 26425, 876}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 624, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1249, 43, 84, 2, 70, "Title",
 CellTags->{"c:26", "xref:146"},
 CellID->12843],
Cell[1336, 47, 879, 28, 70, "Text",
 CellTags->"b:2.3.0",
 CellID->25620],
Cell[2218, 77, 1698, 51, 70, "DefinitionBox",
 CellID->748],
Cell[3919, 130, 343, 12, 70, "Text",
 CellTags->"b:2.3.0",
 CellID->27067],
Cell[4265, 144, 176, 5, 70, "Input",
 CellTags->"Ex--21943492438155078303,40",
 CellID->4536],
Cell[CellGroupData[{
Cell[4466, 153, 164, 4, 70, "Input",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellID->20783],
Cell[4633, 159, 538, 11, 70, "Output",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellID->18035]
}, Open  ]],
Cell[5186, 173, 235, 6, 70, "Text",
 CellTags->"b:2.3.0",
 CellID->32226],
Cell[CellGroupData[{
Cell[5446, 183, 96, 2, 70, "Section",
 CellTags->{"xref:65", "c:28", "b:2.3.1"},
 CellID->15185],
Cell[5545, 187, 317, 9, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->7038],
Cell[5865, 198, 185, 9, 70, "Program",
 CellTags->"b:2.3.1",
 CellID->9853],
Cell[6053, 209, 607, 19, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->25629],
Cell[6663, 230, 102, 2, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->11224],
Cell[6768, 234, 202, 9, 70, "Program",
 CellTags->"b:2.3.1",
 CellID->15748],
Cell[6973, 245, 385, 12, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->19923],
Cell[7361, 259, 156, 5, 70, "Program",
 CellTags->"b:2.3.1",
 CellID->3359],
Cell[7520, 266, 107, 2, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->32257],
Cell[7630, 270, 218, 9, 70, "Program",
 CellTags->"b:2.3.1",
 CellID->24766],
Cell[7851, 281, 379, 12, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->4944],
Cell[8233, 295, 160, 5, 70, "Program",
 CellTags->"b:2.3.1",
 CellID->14955],
Cell[8396, 302, 613, 14, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->23318],
Cell[9012, 318, 630, 18, 70, "DefinitionBox",
 CellID->32726],
Cell[9645, 338, 364, 9, 70, "Text",
 CellTags->"b:2.3.1",
 CellID->25411]
}, Open  ]],
Cell[CellGroupData[{
Cell[10046, 352, 102, 2, 70, "Section",
 CellTags->{"xref:66", "c:29", "b:2.3.2"},
 CellID->21025],
Cell[10151, 356, 330, 9, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->20355],
Cell[10484, 367, 263, 12, 70, "Program",
 CellTags->"b:2.3.2",
 CellID->31001],
Cell[10750, 381, 1014, 28, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->22549],
Cell[11767, 411, 101, 2, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->9496],
Cell[11871, 415, 326, 11, 70, "Program",
 CellTags->"b:2.3.2",
 CellID->18584],
Cell[12200, 428, 655, 18, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->9515],
Cell[12858, 448, 87, 2, 70, "Program",
 CellTags->"b:2.3.2",
 CellID->17964],
Cell[12948, 452, 107, 2, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->23342],
Cell[13058, 456, 268, 9, 70, "Program",
 CellTags->"b:2.3.2",
 CellID->8075],
Cell[13329, 467, 370, 12, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->17913],
Cell[13702, 481, 90, 2, 70, "Program",
 CellTags->"b:2.3.2",
 CellID->16142],
Cell[13795, 485, 657, 15, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->31196],
Cell[14455, 502, 844, 24, 70, "DefinitionBox",
 CellID->21948],
Cell[15302, 528, 268, 9, 70, "Text",
 CellID->618267192],
Cell[15573, 539, 181, 5, 70, "Input",
 CellTags->"Ex--21943492438155078303,40",
 CellID->149569975],
Cell[15757, 546, 291, 10, 70, "Text",
 CellID->43490168],
Cell[CellGroupData[{
Cell[16073, 560, 183, 4, 70, "Input",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellID->76893794],
Cell[16259, 566, 1005, 21, 70, "Output",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellID->272111991]
}, Open  ]],
Cell[17279, 590, 234, 8, 70, "Text",
 CellID->11435528],
Cell[CellGroupData[{
Cell[17538, 602, 106, 3, 70, "Input",
 CellID->106813213],
Cell[17647, 607, 197, 5, 70, "Output",
 CellID->332976646]
}, Open  ]],
Cell[17859, 615, 337, 9, 70, "Text",
 CellID->315692737],
Cell[CellGroupData[{
Cell[18221, 628, 156, 4, 70, "Input",
 CellID->229525026],
Cell[18380, 634, 174, 5, 70, "Output",
 CellID->601293888]
}, Open  ]],
Cell[18569, 642, 92, 1, 70, "Text",
 CellID->308925162],
Cell[18664, 645, 116, 3, 70, "Input",
 CellID->16010760],
Cell[18783, 650, 620, 18, 70, "Text",
 CellID->177909636],
Cell[19406, 670, 451, 8, 70, "Input",
 CellID->335873303],
Cell[19860, 680, 634, 20, 70, "Text",
 CellID->714151483],
Cell[20497, 702, 357, 9, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->25072],
Cell[20857, 713, 368, 9, 70, "Text",
 CellTags->"b:2.3.2",
 CellID->20426]
}, Open  ]]
}, Open  ]],
Cell[21252, 726, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

