(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11795,        430]
NotebookOptionsPosition[      6852,        259]
NotebookOutlinePosition[     10113,        362]
CellTagsIndexPosition[     10021,        356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLDropTable" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDropTable"]}, #,
         2]& , Evaluator -> Automatic], {
      1->"\<\"SQLDropTable\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dropping Tables", "Title",
 CellID->24948],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDropTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDropTable"]], "InlineFormula"],
 " drops tables from a database. An alternative, using raw SQL, is \
demonstrated in ",
 ButtonBox["Dropping Tables with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDroppingTables"],
 "."
}], "Text",
 CellTags->"b:4.1.6",
 CellID->13653],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->30674],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["SQLDropTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDropTable"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query."
}], "Text",
 CellTags->"b:4.1.6",
 CellID->2220],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLDropTable",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLDropTable"], "[", 
     StyleBox["table", "TI"], "]"}], Cell[
    "drop a table from a database", "TableText"]}
  }]], "DefinitionBox",
 CellID->5402],

Cell["Dropping a table from a database.", "Caption",
 CellTags->"b:4.1.6",
 CellID->6923],

Cell[TextData[{
 "Here is an example that drops a table. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:4.1.6",
 CellID->3831],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.1.6",
 CellLabel->"In[1]:=",
 CellID->19369],

Cell[TextData[{
 "A new table, ",
 StyleBox["TEST",
  FontSlant->"Italic"],
 ", is created and data is inserted."
}], "Text",
 CellTags->"b:4.1.6",
 CellID->3878],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{
   "conn", ",", " ", "\"\<TEST\>\"", ",", " ", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL1\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL2\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
    RowBox[{"{", 
     RowBox[{"10", ",", " ", "10.5"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellTags->"b:4.1.6",
 CellLabel->"In[3]:=",
 CellID->20259],

Cell["This drops the table.", "Text",
 CellTags->"b:4.1.6",
 CellID->19008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDropTable", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.6",
 CellLabel->"In[5]:=",
 CellID->22619],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.1.6",
 CellLabel->"Out[5]=",
 CellID->23971]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTableNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"]], "InlineFormula"],
 " verifies that the table is removed from the database."
}], "Text",
 CellTags->"b:4.1.6",
 CellID->30003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.6",
 CellLabel->"In[6]:=",
 CellID->21945],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellTags->"b:4.1.6",
 CellLabel->"Out[6]=",
 CellID->9781]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDropTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDropTable"]], "InlineFormula"],
 " accepts one option."
}], "Text",
 CellTags->"b:4.3",
 CellID->26504],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<Timeout\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the timeout for a query", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->12392],

Cell[TextData[{
 "Option of ",
 Cell[BoxData[
  ButtonBox["SQLDropTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDropTable"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:4.3",
 CellID->32685],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<Timeout\>\""], "InlineFormula"],
 " can be used to cancel a query if it takes too long to execute."
}], "Text",
 CellTags->"b:4.3",
 CellID->25313],

Cell["This closes the connection.", "Text",
 CellTags->"b:4.1.6",
 CellID->6698],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->"b:4.1.6",
 CellLabel->"In[7]:=",
 CellID->5589]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dropping Tables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 39.4528087}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "SQLDropTable drops tables from a database. An alternative, using raw \
SQL, is demonstrated in Dropping Tables with Raw SQL. If you find that the \
examples in this tutorial do not work as shown, you may need to install or \
restore the example database with the DatabaseExamples` package, as described \
in Using the Example Databases. The result of SQLDropTable is an integer \
specifying the number of rows affected by the query.", "synonyms" -> {}, 
    "title" -> "Dropping Tables", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/DroppingTables"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.1.6"->{
  Cell[1263, 45, 427, 13, 70, "Text",
   CellTags->"b:4.1.6",
   CellID->13653],
  Cell[2139, 73, 294, 9, 70, "Text",
   CellTags->"b:4.1.6",
   CellID->2220],
  Cell[2732, 95, 89, 2, 70, "Caption",
   CellTags->"b:4.1.6",
   CellID->6923],
  Cell[2824, 99, 269, 10, 70, "Text",
   CellTags->"b:4.1.6",
   CellID->3831],
  Cell[3096, 111, 287, 9, 70, "Input",
   CellTags->"b:4.1.6",
   CellID->19369],
  Cell[3386, 122, 162, 7, 70, "Text",
   CellTags->"b:4.1.6",
   CellID->3878],
  Cell[3551, 131, 935, 24, 70, "Input",
   CellTags->"b:4.1.6",
   CellID->20259],
  Cell[4489, 157, 75, 2, 70, "Text",
   CellTags->"b:4.1.6",
   CellID->19008],
  Cell[4589, 163, 168, 5, 70, "Input",
   CellTags->"b:4.1.6",
   CellID->22619],
  Cell[4760, 170, 89, 3, 70, "Output",
   CellTags->"b:4.1.6",
   CellID->23971],
  Cell[4864, 176, 265, 8, 70, "Text",
   CellTags->"b:4.1.6",
   CellID->30003],
  Cell[5154, 188, 169, 5, 70, "Input",
   CellTags->"b:4.1.6",
   CellID->21945],
  Cell[5326, 195, 105, 4, 70, "Output",
   CellTags->"b:4.1.6",
   CellID->9781],
  Cell[6593, 246, 80, 2, 70, "Text",
   CellTags->"b:4.1.6",
   CellID->6698],
  Cell[6676, 250, 134, 4, 70, "Input",
   CellTags->"b:4.1.6",
   CellID->5589]},
 "b:4.3"->{
  Cell[5446, 202, 227, 8, 70, "Text",
   CellTags->"b:4.3",
   CellID->26504],
  Cell[6163, 227, 226, 9, 70, "Caption",
   CellTags->"b:4.3",
   CellID->32685],
  Cell[6392, 238, 198, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->25313]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.1.6", 8529, 297},
 {"b:4.3", 9757, 343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 587, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1212, 42, 48, 1, 70, "Title",
 CellID->24948],
Cell[1263, 45, 427, 13, 70, "Text",
 CellTags->"b:4.1.6",
 CellID->13653],
Cell[1693, 60, 443, 11, 70, "Text",
 CellID->30674],
Cell[2139, 73, 294, 9, 70, "Text",
 CellTags->"b:4.1.6",
 CellID->2220],
Cell[2436, 84, 293, 9, 70, "DefinitionBox",
 CellID->5402],
Cell[2732, 95, 89, 2, 70, "Caption",
 CellTags->"b:4.1.6",
 CellID->6923],
Cell[2824, 99, 269, 10, 70, "Text",
 CellTags->"b:4.1.6",
 CellID->3831],
Cell[3096, 111, 287, 9, 70, "Input",
 CellTags->"b:4.1.6",
 CellID->19369],
Cell[3386, 122, 162, 7, 70, "Text",
 CellTags->"b:4.1.6",
 CellID->3878],
Cell[3551, 131, 935, 24, 70, "Input",
 CellTags->"b:4.1.6",
 CellID->20259],
Cell[4489, 157, 75, 2, 70, "Text",
 CellTags->"b:4.1.6",
 CellID->19008],
Cell[CellGroupData[{
Cell[4589, 163, 168, 5, 70, "Input",
 CellTags->"b:4.1.6",
 CellID->22619],
Cell[4760, 170, 89, 3, 70, "Output",
 CellTags->"b:4.1.6",
 CellID->23971]
}, Open  ]],
Cell[4864, 176, 265, 8, 70, "Text",
 CellTags->"b:4.1.6",
 CellID->30003],
Cell[CellGroupData[{
Cell[5154, 188, 169, 5, 70, "Input",
 CellTags->"b:4.1.6",
 CellID->21945],
Cell[5326, 195, 105, 4, 70, "Output",
 CellTags->"b:4.1.6",
 CellID->9781]
}, Open  ]],
Cell[5446, 202, 227, 8, 70, "Text",
 CellTags->"b:4.3",
 CellID->26504],
Cell[5676, 212, 484, 13, 70, "DefinitionBox3Col",
 CellID->12392],
Cell[6163, 227, 226, 9, 70, "Caption",
 CellTags->"b:4.3",
 CellID->32685],
Cell[6392, 238, 198, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->25313],
Cell[6593, 246, 80, 2, 70, "Text",
 CellTags->"b:4.1.6",
 CellID->6698],
Cell[6676, 250, 134, 4, 70, "Input",
 CellTags->"b:4.1.6",
 CellID->5589]
}, Open  ]],
Cell[6825, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

