(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     99154,       2828]
NotebookOptionsPosition[     62452,       1706]
NotebookOutlinePosition[     87573,       2427]
CellTagsIndexPosition[     85306,       2360]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Getting Started", "Title",
 CellTags->{"xref:1", "c:1"},
 CellID->21196],

Cell[CellGroupData[{

Cell["Using This Tutorial", "Subsection",
 CellTags->{"xref:8", "c:8", "b:1.0"},
 CellID->22336],

Cell[TextData[{
 "This tutorial contains simple examples of ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " that give an overview of its functionality and some ideas of how to get \
started. It uses a lightweight database, HSQLDB, that is installed as part of \
",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 ". This allows you to try examples in the documentation without having to \
install your own database. The other ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " tutorials give detailed reference information."
}], "Text",
 CellTags->"b:1.0",
 CellID->18397],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " provides two styles of interface for working with a database. A command\
\[Hyphen]line interface, which is more flexible and is useful for using \
database commands inside programs, and a graphical interface, which is \
simpler to use. Both interfaces are discussed here."
}], "Text",
 CellTags->"b:1.0",
 CellID->31418],

Cell[TextData[{
 "When you have finished trying these examples, you may wish to restore the \
example database, by using the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellTags->"b:1.0",
 CellID->19897]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Command\[Hyphen]Line Interface", "Section",
 CellTags->{"xref:133", "c:9"},
 CellID->25828],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->{"xref:144", "b:1.1.0"},
 CellID->13851],

Cell["\<\
The command\[Hyphen]line interface is a powerful and flexible interface that \
is particularly appropriate if you want to write programs that use database \
functionality. This section discusses a number of different operations that \
use a demonstration database.\
\>", "Text",
 CellTags->"b:1.1.0",
 CellID->26816],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->24230]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading the Package", "Subsection",
 CellTags->{"xref:7", "c:10", "b:1.1.1"},
 CellID->4449],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " add-on application. Before any functions from the package can be used, it \
must be loaded as follows."
}], "Text",
 CellTags->"b:1.1.1",
 CellID->16925],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input",
 CellTags->{"b:1.1.1", "Ex--21943492438155078303,164"},
 CellLabel->"In[1]:=",
 CellID->658]
}, Open  ]],

Cell[CellGroupData[{

Cell["Connecting to the Database", "Subsection",
 CellTags->{"xref:9", "c:11", "b:1.1.2"},
 CellID->229],

Cell[TextData[{
 "The details of connecting to a database are described in ",
 ButtonBox["Database Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
 ". The command\[Hyphen]line method uses the function ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 ", which returns a handle that can be used to work with a database. The \
following opens a connection to an included sample database. "
}], "Text",
 CellTags->"b:1.1.2",
 CellID->24520],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->10940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}]], "Input",
 CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
 CellLabel->"In[2]:=",
 CellID->29560],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
 CellLabel->"Out[2]=",
 CellID->15147]
}, Open  ]],

Cell[TextData[{
 "There is also a GUI method to connect to the database that is invoked by \
executing ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " with no arguments. When this is done, the Connection Tool appears; at this \
point a connection must be opened or the tool canceled before operations can \
continue."
}], "Text",
 CellTags->"b:1.1.2",
 CellID->25162],

Cell[BoxData[
 RowBox[{
  RowBox[{"conn1", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", "]"}]}], ";"}]], "Input",
 CellTags->{"b:1.1.2", "Ex--21943492438155078303,166"},
 CellLabel->"In[3]:=",
 CellID->1655],

Cell[TextData[{
 "You can use the Connection Tool to connect to the ",
 StyleBox["example", "MR"],
 " database. Further information on how to open a connection to a database is \
provided in ",
 ButtonBox["Database Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
 "."
}], "Text",
 CellTags->"b:1.1.2",
 CellID->20675]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fetching Data", "Subsection",
 CellTags->{"xref:10", "c:12", "b:1.1.3"},
 CellID->792],

Cell["\<\
A relational database consists of a set of tables; each table contains data \
in various categories (typically called columns). Each row of a table \
contains data values for the different categories. The database application \
provides functions for managing this data by supporting features such as \
querying, inserting, updating, or dropping data.\
\>", "Text",
 CellTags->"b:1.1.3",
 CellID->22361],

Cell[TextData[{
 "Tables are fundamental to relational databases, and it is important to have \
a convenient way to list them. You can do this with the ",
 Cell[BoxData[
  ButtonBox["SQLTables",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTables"]], "InlineFormula"],
 " command as follows."
}], "Text",
 CellTags->"b:1.1.3",
 CellID->31754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", "conn", "]"}]], "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
 CellLabel->"In[4]:=",
 CellID->16398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLTable", "[", 
   RowBox[{"\<\"SAMPLETABLE1\"\>", ",", 
    RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], 
  "}"}]], "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
 CellLabel->"Out[4]=",
 CellID->23146]
}, Open  ]],

Cell[TextData[{
 "You can see information on the specific columns in a table with the ",
 Cell[BoxData[
  ButtonBox["SQLColumns",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumns"]], "InlineFormula"],
 " command. An example that provides information on the columns in the ",
 StyleBox["SAMPLETABLE1",
  FontSlant->"Italic"],
 " table follows."
}], "Text",
 CellTags->"b:1.1.3",
 CellID->8714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", " ", "\"\<SAMPLETABLE1\>\""}], "]"}]], "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
 CellLabel->"In[5]:=",
 CellID->26946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
 CellLabel->"Out[5]=",
 CellID->21188]
}, Open  ]],

Cell[TextData[{
 "You can retrieve the data in the ",
 StyleBox["SAMPLETABLE1",
  FontSlant->"Italic"],
 " table by executing an ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " command as follows. "
}], "Text",
 CellTags->"b:1.1.3",
 CellID->19569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"SQLSelect", "[", "  ", 
   RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\""}], "]"}]}]], "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
 CellLabel->"In[6]:=",
 CellID->8638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5.9`", ",", "\<\"Day2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7.2`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6.2`", ",", "\<\"Day4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6.`", ",", "\<\"Day5\"\>"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
 CellLabel->"Out[6]=",
 CellID->27663]
}, Open  ]],

Cell[TextData[{
 "The result of the database query is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list, which can be used in any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command. In the following example the last element of each row is \
plotted."
}], "Text",
 CellTags->"b:1.1.3",
 CellID->15075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"data", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
 CellLabel->"In[7]:=",
 CellID->24515],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 5.6}, {2., 5.9}, {3., 7.2}, {4., 6.2}, {5., 6.}}]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
 CellLabel->"Out[7]=",
 CellID->11521]
}, Open  ]],

Cell[TextData[{
 "The following example retrieves data from the ",
 StyleBox["SALES",
  FontSlant->"Italic"],
 " table, but adds column headings and outputs the result in a tabular form."
}], "Text",
 CellTags->"b:1.1.3",
 CellID->475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", "  ", 
   RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
 CellLabel->"In[8]:=",
 CellID->15615],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
    {"1", "5.6`", "\<\"Day1\"\>"},
    {"2", "5.9`", "\<\"Day2\"\>"},
    {"3", "7.2`", "\<\"Day3\"\>"},
    {"4", "6.2`", "\<\"Day4\"\>"},
    {"5", "6.`", "\<\"Day5\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
 CellLabel->"Out[8]//TableForm=",
 CellID->20528]
}, Open  ]],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " also allows you to enter raw SQL commands; this might be useful if you are \
already familiar with SQL and do not want to learn a new language. Here is an \
example that shows how to obtain all the data in the ",
 StyleBox["SALES",
  FontSlant->"Italic"],
 " table."
}], "Text",
 CellTags->"b:1.1.3",
 CellID->13234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
 CellLabel->"In[9]:=",
 CellID->12570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5.9`", ",", "\<\"Day2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7.2`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6.2`", ",", "\<\"Day4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6.`", ",", "\<\"Day5\"\>"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
 CellLabel->"Out[9]=",
 CellID->905]
}, Open  ]],

Cell[TextData[{
 "More information on fetching data is available in ",
 ButtonBox["Selecting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 "."
}], "Text",
 CellTags->"b:1.1.3",
 CellID->9464]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inserting Data", "Subsection",
 CellTags->{"xref:11", "c:13", "b:1.1.4"},
 CellID->19557],

Cell[TextData[{
 "You can use the ",
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 " command to insert data in the table. For example, this adds a new row to \
the ",
 StyleBox["SAMPLETABLE1",
  FontSlant->"Italic"],
 " table."
}], "Text",
 CellTags->"b:1.1.4",
 CellID->28962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", " ", 
  RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<ENTRY\>\"", ",", "\"\<VALUE\>\"", ",", "\"\<NAME\>\""}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8.2", ",", "\"\<Day6\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
 CellLabel->"In[10]:=",
 CellID->14161],

Cell[BoxData["1"], "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
 CellLabel->"Out[10]=",
 CellID->30524]
}, Open  ]],

Cell["You can see the extra row that has been added.", "Text",
 CellTags->"b:1.1.4",
 CellID->12549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", "  ", 
   RowBox[{"conn", ",", " ", "\"\<SAMPLETABLE1\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
 CellLabel->"In[11]:=",
 CellID->17469],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
    {"1", "5.6`", "\<\"Day1\"\>"},
    {"2", "5.9`", "\<\"Day2\"\>"},
    {"3", "7.2`", "\<\"Day3\"\>"},
    {"4", "6.2`", "\<\"Day4\"\>"},
    {"5", "6.`", "\<\"Day5\"\>"},
    {"6", "8.2`", "\<\"Day6\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
 CellLabel->"Out[11]//TableForm=",
 CellID->330]
}, Open  ]],

Cell[TextData[{
 "It is also possible to use a raw SQL command to insert more data. Note how \
the string being inserted, ",
 StyleBox["Day7", "MR"],
 ", uses single-quote characters ('). It is also possible to use double-quote \
characters (\"), though these need to be preceded with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string escape backslash character (\\)."
}], "Text",
 CellTags->"b:1.1.4",
 CellID->31923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<INSERT INTO SAMPLETABLE1(ENTRY, VALUE, NAME) VALUES (7, 6.9, \
'Day7')\>\""}], "]"}]], "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
 CellLabel->"In[12]:=",
 CellID->28350],

Cell[BoxData["1"], "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
 CellLabel->"Out[12]=",
 CellID->14333]
}, Open  ]],

Cell[TextData[{
 "Another version of raw SQL commands involves using placeholders to \
represent where the arguments will go and then giving ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " a list argument that contains the actual arguments. This is particularly \
useful since it avoids the need to concatenate strings to form the raw \
command."
}], "Text",
 CellTags->"b:1.1.4",
 CellID->22925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<INSERT INTO SAMPLETABLE1(ENTRY, VALUE, NAME) VALUES (`1`, `2`, `3`)\>\
\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10.5", ",", "\"\<Day8\>\""}], "}"}]}], "]"}]], "Input",\

 CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
 CellLabel->"In[13]:=",
 CellID->10910],

Cell[BoxData["1"], "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
 CellLabel->"Out[13]=",
 CellID->19737]
}, Open  ]],

Cell["This shows the data that is currently in the table.", "Text",
 CellTags->"b:1.1.4",
 CellID->16336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
 CellLabel->"In[14]:=",
 CellID->18337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5.9`", ",", "\<\"Day2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7.2`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6.2`", ",", "\<\"Day4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6.`", ",", "\<\"Day5\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8.2`", ",", "\<\"Day6\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6.9`", ",", "\<\"Day7\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10.5`", ",", "\<\"Day8\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
 CellLabel->"Out[14]=",
 CellID->1278]
}, Open  ]],

Cell[TextData[{
 "More information on inserting data is available in ",
 ButtonBox["Inserting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/InsertingData"],
 "."
}], "Text",
 CellTags->"b:1.1.4",
 CellID->12393]
}, Open  ]],

Cell[CellGroupData[{

Cell["Updating Data", "Subsection",
 CellTags->{"xref:12", "c:14", "b:1.1.5"},
 CellID->7636],

Cell[TextData[{
 "You can use the ",
 Cell[BoxData[
  ButtonBox["SQLUpdate",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"],
 " command to update data in the table. Often this is combined with a \
condition, so that only some of the data is modified. For example, this sets \
all entries of the ",
 StyleBox["VALUE",
  FontSlant->"Italic"],
 " column that are greater than 8 to 7."
}], "Text",
 CellTags->"b:1.1.5",
 CellID->30714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLUpdate", "[", "  ", 
  RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\"", ",", " ", 
   RowBox[{"{", "\"\<VALUE\>\"", "}"}], ",", " ", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<VALUE\>\"", "]"}], ">", "8"}]}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
 CellLabel->"In[15]:=",
 CellID->28164],

Cell[BoxData["2"], "Output",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
 CellLabel->"Out[15]=",
 CellID->31591]
}, Open  ]],

Cell["You can see the changes that have been made.", "Text",
 CellTags->"b:1.1.5",
 CellID->19949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", "  ", 
   RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
 CellLabel->"In[16]:=",
 CellID->19135],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
    {"1", "5.6`", "\<\"Day1\"\>"},
    {"2", "5.9`", "\<\"Day2\"\>"},
    {"3", "7.2`", "\<\"Day3\"\>"},
    {"4", "6.2`", "\<\"Day4\"\>"},
    {"5", "6.`", "\<\"Day5\"\>"},
    {"7", "6.9`", "\<\"Day7\"\>"},
    {"6", "7.`", "\<\"Day6\"\>"},
    {"8", "7.`", "\<\"Day8\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
 CellLabel->"Out[16]//TableForm=",
 CellID->2505]
}, Open  ]],

Cell[TextData[{
 "It is also possible to use a raw SQL command to update data. This sets all \
rows for which the ",
 StyleBox["VALUE",
  FontSlant->"Italic"],
 " entry is greater than or equal to 6 to 7."
}], "Text",
 CellTags->"b:1.1.5",
 CellID->13337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<UPDATE SAMPLETABLE1 SET VALUE = `1` WHERE VALUE >= `2`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
 CellLabel->"In[17]:=",
 CellID->10004],

Cell[BoxData["6"], "Output",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
 CellLabel->"Out[17]=",
 CellID->16337]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
 CellLabel->"In[18]:=",
 CellID->2623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5.9`", ",", "\<\"Day2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7.`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "7.`", ",", "\<\"Day4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7.`", ",", "\<\"Day5\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "7.`", ",", "\<\"Day7\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7.`", ",", "\<\"Day6\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7.`", ",", "\<\"Day8\"\>"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
 CellLabel->"Out[18]=",
 CellID->28664]
}, Open  ]],

Cell[TextData[{
 "More information on updating data is available in ",
 ButtonBox["Updating Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UpdatingData"],
 "."
}], "Text",
 CellTags->"b:1.1.5",
 CellID->9970]
}, Open  ]],

Cell[CellGroupData[{

Cell["Deleting Data", "Subsection",
 CellTags->{"xref:13", "c:15", "b:1.1.6"},
 CellID->25608],

Cell[TextData[{
 "You can use the ",
 Cell[BoxData[
  ButtonBox["SQLDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"],
 " command to delete data in the table. Often this is combined with a \
condition, so that only some of the data is modified. For example, this \
deletes all rows for which the ",
 StyleBox["ENTRY",
  FontSlant->"Italic"],
 " entry is 7 or greater."
}], "Text",
 CellTags->"b:1.1.6",
 CellID->30568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDelete", "[", "  ", 
  RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\"", ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<VALUE\>\"", "]"}], "\[GreaterEqual]", 
    "7"}]}], "]"}]], "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
 CellLabel->"In[19]:=",
 CellID->19281],

Cell[BoxData["6"], "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
 CellLabel->"Out[19]=",
 CellID->7085]
}, Open  ]],

Cell["You can see the changes that have been made.", "Text",
 CellTags->"b:1.1.6",
 CellID->9152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", "  ", 
   RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
 CellLabel->"In[20]:=",
 CellID->18373],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
    {"1", "5.6`", "\<\"Day1\"\>"},
    {"2", "5.9`", "\<\"Day2\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
 CellLabel->"Out[20]//TableForm=",
 CellID->28652]
}, Open  ]],

Cell[TextData[{
 "It is also possible to use a raw SQL command to delete data. This deletes \
all entries for which the ",
 StyleBox["VALUE",
  FontSlant->"Italic"],
 " entry is greater than 5.7."
}], "Text",
 CellTags->"b:1.1.6",
 CellID->8194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{
  "conn", ",", " ", "\"\<DELETE FROM SAMPLETABLE1 WHERE VALUE > 5.7\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
 CellLabel->"In[21]:=",
 CellID->9876],

Cell[BoxData["1"], "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
 CellLabel->"Out[21]=",
 CellID->23826]
}, Open  ]],

Cell["There is only one row left in the database now.", "Text",
 CellTags->"b:1.1.6",
 CellID->28396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
 CellLabel->"In[22]:=",
 CellID->7572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], "}"}]], "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
 CellLabel->"Out[22]=",
 CellID->6249]
}, Open  ]],

Cell[TextData[{
 "More information on deleting data is available in ",
 ButtonBox["Deleting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DeletingData"],
 "."
}], "Text",
 CellTags->"b:1.1.6",
 CellID->14640]
}, Open  ]],

Cell[CellGroupData[{

Cell["Batch Commands", "Subsection",
 CellTags->{"xref:72", "c:16", "b:1.1.7"},
 CellID->29174],

Cell["\<\
If you want to repeat the same command many times, you can do this by \
providing repeated arguments in a list. Carrying out the same command like \
this is much faster than doing each command separately.\
\>", "Text",
 CellTags->"b:1.1.7",
 CellID->18819],

Cell["The following command inserts two rows.", "Text",
 CellTags->"b:1.1.7",
 CellID->943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", " ", 
  RowBox[{"conn", ",", "\"\<SAMPLETABLE1\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<ENTRY\>\"", ",", "\"\<VALUE\>\"", ",", "\"\<NAME\>\""}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "5.9", ",", "\"\<Day2\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7.2", ",", "\"\<Day3\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
 CellLabel->"In[23]:=",
 CellID->32611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
 CellLabel->"Out[23]=",
 CellID->1941]
}, Open  ]],

Cell["This uses a raw SQL command to insert two more rows.", "Text",
 CellTags->"b:1.1.7",
 CellID->20289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{
  "conn", ",", 
   "\"\<INSERT INTO SAMPLETABLE1(ENTRY, VALUE, NAME) VALUES (`1`, `2`, `3`)\>\
\"", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "6.2", ",", "\"\<Day4\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6.", ",", "\"\<Day5\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
 CellLabel->"In[24]:=",
 CellID->8419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
 CellLabel->"Out[24]=",
 CellID->5565]
}, Open  ]],

Cell["The result of the insert commands can be seen as follows.", "Text",
 CellTags->"b:1.1.7",
 CellID->3805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
 CellLabel->"In[25]:=",
 CellID->7585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5.9`", ",", "\<\"Day2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7.2`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6.2`", ",", "\<\"Day4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6.`", ",", "\<\"Day5\"\>"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
 CellLabel->"Out[25]=",
 CellID->16216]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Closing the Connection", "Subsection",
 CellTags->{"xref:14", "c:17", "b:1.1.8"},
 CellID->31450],

Cell["\<\
When you have finished with the connection, you can close it.\
\>", "Text",
 CellTags->"b:1.1.8",
 CellID->1615],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:1.1.8", "Ex--21943492438155078303,189"},
 CellLabel->"In[26]:=",
 CellID->2609],

Cell[TextData[{
 "More information on working with connections is provided in ",
 ButtonBox["Database Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
 ". If you have modified the database and want to restore it, you can use the \
",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellTags->"b:1.1.8",
 CellID->11064]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Database Explorer", "Section",
 CellTags->{"xref:15", "c:18", "b:1.2"},
 CellID->9166],

Cell[TextData[{
 "The Database Explorer is a graphical interface to database functionality. \
It can be launched by loading ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and executing the command ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DatabaseExplorer",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/DatabaseExplorer"], "[", "]"}]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:1.2",
 CellID->16893],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"DatabaseExplorer", "[", "]"}]}], "Input",
 CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
 CellLabel->"In[27]:=",
 CellID->16074],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject275290005700609, 
   JLink`Objects`JavaObject367987580207105]]], "Output",
 CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
 CellLabel->"Out[28]=",
 CellID->13509]
}, Open  ]],

Cell["\<\
When the Database Explorer opens, you can connect to the different databases \
that are configured for your system. You can also create new connections. \
After you connect to a database, you can view the tables and columns; as seen \
in the following example.
\
\>", "Text",
 CellTags->"b:1.2",
 CellID->30300],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{488.75, 443.688},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2",
 CellID->19695],

Cell[TextData[{
 "\nYou can then see the data in the database by clicking the ",
 StyleBox["Result", "SR"],
 " tab. Here is an example view.\n"
}], "Text",
 CellTags->"b:1.2",
 CellID->9573],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{489.5, 444.438},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2",
 CellID->15589],

Cell[TextData[{
 "\nThe Database Explorer supports many more features, such as forming more \
complicated queries, saving queries, and creating reports with the result of \
a query (saved as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook). These are described in ",
 ButtonBox["The Database Explorer",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer"],
 "."
}], "Text",
 CellTags->"b:1.2",
 CellID->13161]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Getting Started - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 41.1715477}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "This tutorial contains simple examples of DatabaseLink that give an \
overview of its functionality and some ideas of how to get started. It uses a \
lightweight database, HSQLDB, that is installed as part of DatabaseLink. This \
allows you to try examples in the documentation without having to install \
your own database. The other DatabaseLink tutorials give detailed reference \
information. DatabaseLink provides two styles of interface for working with a \
database. A command-line interface, which is more flexible and is useful for \
using database commands inside programs, and a graphical interface, which is \
simpler to use. Both interfaces are discussed here. When you have finished \
trying these examples, you may wish to restore the example database, by using \
the DatabaseExamples` package, as described in Using the Example Databases.", 
    "synonyms" -> {}, "title" -> "Getting Started", "type" -> "Tutorial", 
    "uri" -> "DatabaseLink/tutorial/GettingStarted"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:1"->{
  Cell[729, 29, 78, 2, 70, "Title",
   CellTags->{"xref:1", "c:1"},
   CellID->21196]},
 "c:1"->{
  Cell[729, 29, 78, 2, 70, "Title",
   CellTags->{"xref:1", "c:1"},
   CellID->21196]},
 "xref:8"->{
  Cell[832, 35, 96, 2, 70, "Subsection",
   CellTags->{"xref:8", "c:8", "b:1.0"},
   CellID->22336]},
 "c:8"->{
  Cell[832, 35, 96, 2, 70, "Subsection",
   CellTags->{"xref:8", "c:8", "b:1.0"},
   CellID->22336]},
 "b:1.0"->{
  Cell[832, 35, 96, 2, 70, "Subsection",
   CellTags->{"xref:8", "c:8", "b:1.0"},
   CellID->22336],
  Cell[931, 39, 588, 16, 70, "Text",
   CellTags->"b:1.0",
   CellID->18397],
  Cell[1522, 57, 389, 9, 70, "Text",
   CellTags->"b:1.0",
   CellID->31418],
  Cell[1914, 68, 384, 11, 70, "Text",
   CellTags->"b:1.0",
   CellID->19897]},
 "xref:133"->{
  Cell[2335, 84, 101, 2, 70, "Section",
   CellTags->{"xref:133", "c:9"},
   CellID->25828]},
 "c:9"->{
  Cell[2335, 84, 101, 2, 70, "Section",
   CellTags->{"xref:133", "c:9"},
   CellID->25828]},
 "xref:144"->{
  Cell[2461, 90, 86, 2, 70, "Subsection",
   CellTags->{"xref:144", "b:1.1.0"},
   CellID->13851]},
 "b:1.1.0"->{
  Cell[2461, 90, 86, 2, 70, "Subsection",
   CellTags->{"xref:144", "b:1.1.0"},
   CellID->13851],
  Cell[2550, 94, 326, 7, 70, "Text",
   CellTags->"b:1.1.0",
   CellID->26816]},
 "xref:7"->{
  Cell[3342, 119, 98, 2, 70, "Subsection",
   CellTags->{"xref:7", "c:10", "b:1.1.1"},
   CellID->4449]},
 "c:10"->{
  Cell[3342, 119, 98, 2, 70, "Subsection",
   CellTags->{"xref:7", "c:10", "b:1.1.1"},
   CellID->4449]},
 "b:1.1.1"->{
  Cell[3342, 119, 98, 2, 70, "Subsection",
   CellTags->{"xref:7", "c:10", "b:1.1.1"},
   CellID->4449],
  Cell[3443, 123, 282, 10, 70, "Text",
   CellTags->"b:1.1.1",
   CellID->16925],
  Cell[3728, 135, 171, 4, 70, "Input",
   CellTags->{"b:1.1.1", "Ex--21943492438155078303,164"},
   CellID->658]},
 "Ex--21943492438155078303,164"->{
  Cell[3728, 135, 171, 4, 70, "Input",
   CellTags->{"b:1.1.1", "Ex--21943492438155078303,164"},
   CellID->658]},
 "xref:9"->{
  Cell[3936, 144, 104, 2, 70, "Subsection",
   CellTags->{"xref:9", "c:11", "b:1.1.2"},
   CellID->229]},
 "c:11"->{
  Cell[3936, 144, 104, 2, 70, "Subsection",
   CellTags->{"xref:9", "c:11", "b:1.1.2"},
   CellID->229]},
 "b:1.1.2"->{
  Cell[3936, 144, 104, 2, 70, "Subsection",
   CellTags->{"xref:9", "c:11", "b:1.1.2"},
   CellID->229],
  Cell[4043, 148, 598, 15, 70, "Text",
   CellTags->"b:1.1.2",
   CellID->24520],
  Cell[5095, 180, 202, 5, 70, "Input",
   CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
   CellID->29560],
  Cell[5300, 187, 239, 6, 70, "Output",
   CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
   CellID->15147],
  Cell[5554, 196, 478, 13, 70, "Text",
   CellTags->"b:1.1.2",
   CellID->25162],
  Cell[6035, 211, 215, 6, 70, "Input",
   CellTags->{"b:1.1.2", "Ex--21943492438155078303,166"},
   CellID->1655],
  Cell[6253, 219, 371, 11, 70, "Text",
   CellTags->"b:1.1.2",
   CellID->20675]},
 "Ex--21943492438155078303,165"->{
  Cell[5095, 180, 202, 5, 70, "Input",
   CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
   CellID->29560],
  Cell[5300, 187, 239, 6, 70, "Output",
   CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
   CellID->15147]},
 "Ex--21943492438155078303,166"->{
  Cell[6035, 211, 215, 6, 70, "Input",
   CellTags->{"b:1.1.2", "Ex--21943492438155078303,166"},
   CellID->1655]},
 "xref:10"->{
  Cell[6661, 235, 92, 2, 70, "Subsection",
   CellTags->{"xref:10", "c:12", "b:1.1.3"},
   CellID->792]},
 "c:12"->{
  Cell[6661, 235, 92, 2, 70, "Subsection",
   CellTags->{"xref:10", "c:12", "b:1.1.3"},
   CellID->792]},
 "b:1.1.3"->{
  Cell[6661, 235, 92, 2, 70, "Subsection",
   CellTags->{"xref:10", "c:12", "b:1.1.3"},
   CellID->792],
  Cell[6756, 239, 413, 8, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->22361],
  Cell[7172, 249, 362, 10, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->31754],
  Cell[7559, 263, 160, 4, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
   CellID->16398],
  Cell[7722, 269, 285, 8, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
   CellID->23146],
  Cell[8022, 280, 416, 12, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->8714],
  Cell[8463, 296, 208, 5, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
   CellID->26946],
  Cell[8674, 303, 1175, 27, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
   CellID->21188],
  Cell[9864, 333, 340, 12, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->19569],
  Cell[10229, 349, 234, 6, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
   CellID->8638],
  Cell[10466, 357, 564, 16, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
   CellID->27663],
  Cell[11045, 376, 324, 11, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->15075],
  Cell[11394, 391, 242, 7, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
   CellID->24515],
  Cell[11639, 400, 411, 13, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
   CellID->11521],
  Cell[12065, 416, 235, 7, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->475],
  Cell[12325, 427, 318, 8, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
   CellID->15615],
  Cell[12646, 437, 791, 23, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
   CellID->20528],
  Cell[13452, 463, 385, 11, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->13234],
  Cell[13862, 478, 230, 6, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
   CellID->12570],
  Cell[14095, 486, 562, 16, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
   CellID->905],
  Cell[14672, 505, 235, 8, 70, "Text",
   CellTags->"b:1.1.3",
   CellID->9464]},
 "Ex--21943492438155078303,167"->{
  Cell[7559, 263, 160, 4, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
   CellID->16398],
  Cell[7722, 269, 285, 8, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
   CellID->23146]},
 "Ex--21943492438155078303,168"->{
  Cell[8463, 296, 208, 5, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
   CellID->26946],
  Cell[8674, 303, 1175, 27, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
   CellID->21188]},
 "Ex--21943492438155078303,169"->{
  Cell[10229, 349, 234, 6, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
   CellID->8638],
  Cell[10466, 357, 564, 16, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
   CellID->27663]},
 "Ex--21943492438155078303,170"->{
  Cell[11394, 391, 242, 7, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
   CellID->24515],
  Cell[11639, 400, 411, 13, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
   CellID->11521]},
 "Ex--21943492438155078303,171"->{
  Cell[12325, 427, 318, 8, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
   CellID->15615],
  Cell[12646, 437, 791, 23, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
   CellID->20528]},
 "Ex--21943492438155078303,172"->{
  Cell[13862, 478, 230, 6, 70, "Input",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
   CellID->12570],
  Cell[14095, 486, 562, 16, 70, "Output",
   CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
   CellID->905]},
 "xref:11"->{
  Cell[14944, 518, 95, 2, 70, "Subsection",
   CellTags->{"xref:11", "c:13", "b:1.1.4"},
   CellID->19557]},
 "c:13"->{
  Cell[14944, 518, 95, 2, 70, "Subsection",
   CellTags->{"xref:11", "c:13", "b:1.1.4"},
   CellID->19557]},
 "b:1.1.4"->{
  Cell[14944, 518, 95, 2, 70, "Subsection",
   CellTags->{"xref:11", "c:13", "b:1.1.4"},
   CellID->19557],
  Cell[15042, 522, 366, 13, 70, "Text",
   CellTags->"b:1.1.4",
   CellID->28962],
  Cell[15433, 539, 404, 10, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
   CellID->14161],
  Cell[15840, 551, 124, 3, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
   CellID->30524],
  Cell[15979, 557, 100, 2, 70, "Text",
   CellTags->"b:1.1.4",
   CellID->12549],
  Cell[16104, 563, 324, 8, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
   CellID->17469],
  Cell[16431, 573, 825, 24, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
   CellID->330],
  Cell[17271, 600, 432, 11, 70, "Text",
   CellTags->"b:1.1.4",
   CellID->31923],
  Cell[17728, 615, 279, 8, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
   CellID->28350],
  Cell[18010, 625, 124, 3, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
   CellID->14333],
  Cell[18149, 631, 490, 12, 70, "Text",
   CellTags->"b:1.1.4",
   CellID->22925],
  Cell[18664, 647, 368, 11, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
   CellID->10910],
  Cell[19035, 660, 124, 3, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
   CellID->19737],
  Cell[19174, 666, 105, 2, 70, "Text",
   CellTags->"b:1.1.4",
   CellID->16336],
  Cell[19304, 672, 231, 6, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
   CellID->18337],
  Cell[19538, 680, 815, 22, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
   CellID->1278],
  Cell[20368, 705, 237, 8, 70, "Text",
   CellTags->"b:1.1.4",
   CellID->12393]},
 "Ex--21943492438155078303,173"->{
  Cell[15433, 539, 404, 10, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
   CellID->14161],
  Cell[15840, 551, 124, 3, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
   CellID->30524]},
 "Ex--21943492438155078303,174"->{
  Cell[16104, 563, 324, 8, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
   CellID->17469],
  Cell[16431, 573, 825, 24, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
   CellID->330]},
 "Ex--21943492438155078303,175"->{
  Cell[17728, 615, 279, 8, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
   CellID->28350],
  Cell[18010, 625, 124, 3, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
   CellID->14333]},
 "Ex--21943492438155078303,176"->{
  Cell[18664, 647, 368, 11, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
   CellID->10910],
  Cell[19035, 660, 124, 3, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
   CellID->19737]},
 "Ex--21943492438155078303,177"->{
  Cell[19304, 672, 231, 6, 70, "Input",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
   CellID->18337],
  Cell[19538, 680, 815, 22, 70, "Output",
   CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
   CellID->1278]},
 "xref:12"->{
  Cell[20642, 718, 93, 2, 70, "Subsection",
   CellTags->{"xref:12", "c:14", "b:1.1.5"},
   CellID->7636]},
 "c:14"->{
  Cell[20642, 718, 93, 2, 70, "Subsection",
   CellTags->{"xref:12", "c:14", "b:1.1.5"},
   CellID->7636]},
 "b:1.1.5"->{
  Cell[20642, 718, 93, 2, 70, "Subsection",
   CellTags->{"xref:12", "c:14", "b:1.1.5"},
   CellID->7636],
  Cell[20738, 722, 477, 14, 70, "Text",
   CellTags->"b:1.1.5",
   CellID->30714],
  Cell[21240, 740, 386, 10, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
   CellID->28164],
  Cell[21629, 752, 124, 3, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
   CellID->31591],
  Cell[21768, 758, 98, 2, 70, "Text",
   CellTags->"b:1.1.5",
   CellID->19949],
  Cell[21891, 764, 319, 8, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
   CellID->19135],
  Cell[22213, 774, 894, 26, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
   CellID->2505],
  Cell[23122, 803, 255, 8, 70, "Text",
   CellTags->"b:1.1.5",
   CellID->13337],
  Cell[23402, 815, 322, 9, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
   CellID->10004],
  Cell[23727, 826, 124, 3, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
   CellID->16337],
  Cell[23888, 834, 230, 6, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
   CellID->2623],
  Cell[24121, 842, 809, 22, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
   CellID->28664],
  Cell[24945, 867, 233, 8, 70, "Text",
   CellTags->"b:1.1.5",
   CellID->9970]},
 "Ex--21943492438155078303,178"->{
  Cell[21240, 740, 386, 10, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
   CellID->28164],
  Cell[21629, 752, 124, 3, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
   CellID->31591]},
 "Ex--21943492438155078303,179"->{
  Cell[21891, 764, 319, 8, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
   CellID->19135],
  Cell[22213, 774, 894, 26, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
   CellID->2505]},
 "Ex--21943492438155078303,180"->{
  Cell[23402, 815, 322, 9, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
   CellID->10004],
  Cell[23727, 826, 124, 3, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
   CellID->16337]},
 "Ex--21943492438155078303,181"->{
  Cell[23888, 834, 230, 6, 70, "Input",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
   CellID->2623],
  Cell[24121, 842, 809, 22, 70, "Output",
   CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
   CellID->28664]},
 "xref:13"->{
  Cell[25215, 880, 94, 2, 70, "Subsection",
   CellTags->{"xref:13", "c:15", "b:1.1.6"},
   CellID->25608]},
 "c:15"->{
  Cell[25215, 880, 94, 2, 70, "Subsection",
   CellTags->{"xref:13", "c:15", "b:1.1.6"},
   CellID->25608]},
 "b:1.1.6"->{
  Cell[25215, 880, 94, 2, 70, "Subsection",
   CellTags->{"xref:13", "c:15", "b:1.1.6"},
   CellID->25608],
  Cell[25312, 884, 470, 14, 70, "Text",
   CellTags->"b:1.1.6",
   CellID->30568],
  Cell[25807, 902, 312, 8, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
   CellID->19281],
  Cell[26122, 912, 123, 3, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
   CellID->7085],
  Cell[26260, 918, 97, 2, 70, "Text",
   CellTags->"b:1.1.6",
   CellID->9152],
  Cell[26382, 924, 319, 8, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
   CellID->18373],
  Cell[26704, 934, 688, 20, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
   CellID->28652],
  Cell[27407, 957, 245, 8, 70, "Text",
   CellTags->"b:1.1.6",
   CellID->8194],
  Cell[27677, 969, 249, 7, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
   CellID->9876],
  Cell[27929, 978, 124, 3, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
   CellID->23826],
  Cell[28068, 984, 101, 2, 70, "Text",
   CellTags->"b:1.1.6",
   CellID->28396],
  Cell[28194, 990, 230, 6, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
   CellID->7572],
  Cell[28427, 998, 216, 6, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
   CellID->6249],
  Cell[28658, 1007, 234, 8, 70, "Text",
   CellTags->"b:1.1.6",
   CellID->14640]},
 "Ex--21943492438155078303,182"->{
  Cell[25807, 902, 312, 8, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
   CellID->19281],
  Cell[26122, 912, 123, 3, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
   CellID->7085]},
 "Ex--21943492438155078303,183"->{
  Cell[26382, 924, 319, 8, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
   CellID->18373],
  Cell[26704, 934, 688, 20, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
   CellID->28652]},
 "Ex--21943492438155078303,184"->{
  Cell[27677, 969, 249, 7, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
   CellID->9876],
  Cell[27929, 978, 124, 3, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
   CellID->23826]},
 "Ex--21943492438155078303,185"->{
  Cell[28194, 990, 230, 6, 70, "Input",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
   CellID->7572],
  Cell[28427, 998, 216, 6, 70, "Output",
   CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
   CellID->6249]},
 "xref:72"->{
  Cell[28929, 1020, 95, 2, 70, "Subsection",
   CellTags->{"xref:72", "c:16", "b:1.1.7"},
   CellID->29174]},
 "c:16"->{
  Cell[28929, 1020, 95, 2, 70, "Subsection",
   CellTags->{"xref:72", "c:16", "b:1.1.7"},
   CellID->29174]},
 "b:1.1.7"->{
  Cell[28929, 1020, 95, 2, 70, "Subsection",
   CellTags->{"xref:72", "c:16", "b:1.1.7"},
   CellID->29174],
  Cell[29027, 1024, 266, 6, 70, "Text",
   CellTags->"b:1.1.7",
   CellID->18819],
  Cell[29296, 1032, 91, 2, 70, "Text",
   CellTags->"b:1.1.7",
   CellID->943],
  Cell[29412, 1038, 536, 15, 70, "Input",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
   CellID->32611],
  Cell[29951, 1055, 168, 5, 70, "Output",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
   CellID->1941],
  Cell[30134, 1063, 106, 2, 70, "Text",
   CellTags->"b:1.1.7",
   CellID->20289],
  Cell[30265, 1069, 508, 15, 70, "Input",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
   CellID->8419],
  Cell[30776, 1086, 168, 5, 70, "Output",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
   CellID->5565],
  Cell[30959, 1094, 110, 2, 70, "Text",
   CellTags->"b:1.1.7",
   CellID->3805],
  Cell[31094, 1100, 230, 6, 70, "Input",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
   CellID->7585],
  Cell[31327, 1108, 565, 16, 70, "Output",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
   CellID->16216]},
 "Ex--21943492438155078303,186"->{
  Cell[29412, 1038, 536, 15, 70, "Input",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
   CellID->32611],
  Cell[29951, 1055, 168, 5, 70, "Output",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
   CellID->1941]},
 "Ex--21943492438155078303,187"->{
  Cell[30265, 1069, 508, 15, 70, "Input",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
   CellID->8419],
  Cell[30776, 1086, 168, 5, 70, "Output",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
   CellID->5565]},
 "Ex--21943492438155078303,188"->{
  Cell[31094, 1100, 230, 6, 70, "Input",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
   CellID->7585],
  Cell[31327, 1108, 565, 16, 70, "Output",
   CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
   CellID->16216]},
 "xref:14"->{
  Cell[31941, 1130, 103, 2, 70, "Subsection",
   CellTags->{"xref:14", "c:17", "b:1.1.8"},
   CellID->31450]},
 "c:17"->{
  Cell[31941, 1130, 103, 2, 70, "Subsection",
   CellTags->{"xref:14", "c:17", "b:1.1.8"},
   CellID->31450]},
 "b:1.1.8"->{
  Cell[31941, 1130, 103, 2, 70, "Subsection",
   CellTags->{"xref:14", "c:17", "b:1.1.8"},
   CellID->31450],
  Cell[32047, 1134, 122, 4, 70, "Text",
   CellTags->"b:1.1.8",
   CellID->1615],
  Cell[32172, 1140, 169, 4, 70, "Input",
   CellTags->{"b:1.1.8", "Ex--21943492438155078303,189"},
   CellID->2609],
  Cell[32344, 1146, 545, 15, 70, "Text",
   CellTags->"b:1.1.8",
   CellID->11064]},
 "Ex--21943492438155078303,189"->{
  Cell[32172, 1140, 169, 4, 70, "Input",
   CellTags->{"b:1.1.8", "Ex--21943492438155078303,189"},
   CellID->2609]},
 "xref:15"->{
  Cell[32938, 1167, 96, 2, 70, "Section",
   CellTags->{"xref:15", "c:18", "b:1.2"},
   CellID->9166]},
 "c:18"->{
  Cell[32938, 1167, 96, 2, 70, "Section",
   CellTags->{"xref:15", "c:18", "b:1.2"},
   CellID->9166]},
 "b:1.2"->{
  Cell[32938, 1167, 96, 2, 70, "Section",
   CellTags->{"xref:15", "c:18", "b:1.2"},
   CellID->9166],
  Cell[33037, 1171, 438, 15, 70, "Text",
   CellTags->"b:1.2",
   CellID->16893],
  Cell[33500, 1190, 240, 6, 70, "Input",
   CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
   CellID->16074],
  Cell[33743, 1198, 321, 8, 70, "Output",
   CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
   CellID->13509],
  Cell[34079, 1209, 321, 8, 70, "Text",
   CellTags->"b:1.2",
   CellID->30300],
  Cell[34403, 1219, 13544, 226, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:1.2",
   CellID->19695],
  Cell[47950, 1447, 190, 6, 70, "Text",
   CellTags->"b:1.2",
   CellID->9573],
  Cell[48143, 1455, 13791, 230, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:1.2",
   CellID->15589],
  Cell[61937, 1687, 461, 13, 70, "Text",
   CellTags->"b:1.2",
   CellID->13161]},
 "Ex--21943492438155078303,190"->{
  Cell[33500, 1190, 240, 6, 70, "Input",
   CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
   CellID->16074],
  Cell[33743, 1198, 321, 8, 70, "Output",
   CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
   CellID->13509]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:1", 64550, 1749},
 {"c:1", 64648, 1753},
 {"xref:8", 64749, 1757},
 {"c:8", 64861, 1761},
 {"b:1.0", 64975, 1765},
 {"xref:133", 65327, 1778},
 {"c:9", 65431, 1782},
 {"xref:144", 65540, 1786},
 {"b:1.1.0", 65654, 1790},
 {"xref:7", 65847, 1797},
 {"c:10", 65964, 1801},
 {"b:1.1.1", 66084, 1805},
 {"Ex--21943492438155078303,164", 66421, 1815},
 {"xref:9", 66549, 1819},
 {"c:11", 66666, 1823},
 {"b:1.1.2", 66786, 1827},
 {"Ex--21943492438155078303,165", 67521, 1849},
 {"Ex--21943492438155078303,166", 67790, 1856},
 {"xref:10", 67920, 1860},
 {"c:12", 68037, 1864},
 {"b:1.1.3", 68157, 1868},
 {"Ex--21943492438155078303,167", 70360, 1932},
 {"Ex--21943492438155078303,168", 70629, 1939},
 {"Ex--21943492438155078303,169", 70900, 1946},
 {"Ex--21943492438155078303,170", 71171, 1953},
 {"Ex--21943492438155078303,171", 71443, 1960},
 {"Ex--21943492438155078303,172", 71715, 1967},
 {"xref:11", 71964, 1974},
 {"c:13", 72084, 1978},
 {"b:1.1.4", 72207, 1982},
 {"Ex--21943492438155078303,173", 74022, 2034},
 {"Ex--21943492438155078303,174", 74294, 2041},
 {"Ex--21943492438155078303,175", 74564, 2048},
 {"Ex--21943492438155078303,176", 74835, 2055},
 {"Ex--21943492438155078303,177", 75107, 2062},
 {"xref:12", 75357, 2069},
 {"c:14", 75476, 2073},
 {"b:1.1.5", 75598, 2077},
 {"Ex--21943492438155078303,178", 77009, 2117},
 {"Ex--21943492438155078303,179", 77281, 2124},
 {"Ex--21943492438155078303,180", 77552, 2131},
 {"Ex--21943492438155078303,181", 77823, 2138},
 {"xref:13", 78073, 2145},
 {"c:15", 78193, 2149},
 {"b:1.1.6", 78316, 2153},
 {"Ex--21943492438155078303,182", 79806, 2196},
 {"Ex--21943492438155078303,183", 80076, 2203},
 {"Ex--21943492438155078303,184", 80348, 2210},
 {"Ex--21943492438155078303,185", 80618, 2217},
 {"xref:72", 80866, 2224},
 {"c:16", 80987, 2228},
 {"b:1.1.7", 81111, 2232},
 {"Ex--21943492438155078303,186", 82294, 2266},
 {"Ex--21943492438155078303,187", 82567, 2273},
 {"Ex--21943492438155078303,188", 82839, 2280},
 {"xref:14", 83091, 2287},
 {"c:17", 83213, 2291},
 {"b:1.1.8", 83338, 2295},
 {"Ex--21943492438155078303,189", 83767, 2308},
 {"xref:15", 83899, 2312},
 {"c:18", 84014, 2316},
 {"b:1.2", 84130, 2320},
 {"Ex--21943492438155078303,190", 85049, 2350}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 78, 2, 70, "Title",
 CellTags->{"xref:1", "c:1"},
 CellID->21196],
Cell[CellGroupData[{
Cell[832, 35, 96, 2, 70, "Subsection",
 CellTags->{"xref:8", "c:8", "b:1.0"},
 CellID->22336],
Cell[931, 39, 588, 16, 70, "Text",
 CellTags->"b:1.0",
 CellID->18397],
Cell[1522, 57, 389, 9, 70, "Text",
 CellTags->"b:1.0",
 CellID->31418],
Cell[1914, 68, 384, 11, 70, "Text",
 CellTags->"b:1.0",
 CellID->19897]
}, Open  ]],
Cell[CellGroupData[{
Cell[2335, 84, 101, 2, 70, "Section",
 CellTags->{"xref:133", "c:9"},
 CellID->25828],
Cell[CellGroupData[{
Cell[2461, 90, 86, 2, 70, "Subsection",
 CellTags->{"xref:144", "b:1.1.0"},
 CellID->13851],
Cell[2550, 94, 326, 7, 70, "Text",
 CellTags->"b:1.1.0",
 CellID->26816],
Cell[2879, 103, 426, 11, 70, "Text",
 CellID->24230]
}, Open  ]],
Cell[CellGroupData[{
Cell[3342, 119, 98, 2, 70, "Subsection",
 CellTags->{"xref:7", "c:10", "b:1.1.1"},
 CellID->4449],
Cell[3443, 123, 282, 10, 70, "Text",
 CellTags->"b:1.1.1",
 CellID->16925],
Cell[3728, 135, 171, 4, 70, "Input",
 CellTags->{"b:1.1.1", "Ex--21943492438155078303,164"},
 CellID->658]
}, Open  ]],
Cell[CellGroupData[{
Cell[3936, 144, 104, 2, 70, "Subsection",
 CellTags->{"xref:9", "c:11", "b:1.1.2"},
 CellID->229],
Cell[4043, 148, 598, 15, 70, "Text",
 CellTags->"b:1.1.2",
 CellID->24520],
Cell[4644, 165, 426, 11, 70, "Text",
 CellID->10940],
Cell[CellGroupData[{
Cell[5095, 180, 202, 5, 70, "Input",
 CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
 CellID->29560],
Cell[5300, 187, 239, 6, 70, "Output",
 CellTags->{"b:1.1.2", "Ex--21943492438155078303,165"},
 CellID->15147]
}, Open  ]],
Cell[5554, 196, 478, 13, 70, "Text",
 CellTags->"b:1.1.2",
 CellID->25162],
Cell[6035, 211, 215, 6, 70, "Input",
 CellTags->{"b:1.1.2", "Ex--21943492438155078303,166"},
 CellID->1655],
Cell[6253, 219, 371, 11, 70, "Text",
 CellTags->"b:1.1.2",
 CellID->20675]
}, Open  ]],
Cell[CellGroupData[{
Cell[6661, 235, 92, 2, 70, "Subsection",
 CellTags->{"xref:10", "c:12", "b:1.1.3"},
 CellID->792],
Cell[6756, 239, 413, 8, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->22361],
Cell[7172, 249, 362, 10, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->31754],
Cell[CellGroupData[{
Cell[7559, 263, 160, 4, 70, "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
 CellID->16398],
Cell[7722, 269, 285, 8, 70, "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,167"},
 CellID->23146]
}, Open  ]],
Cell[8022, 280, 416, 12, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->8714],
Cell[CellGroupData[{
Cell[8463, 296, 208, 5, 70, "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
 CellID->26946],
Cell[8674, 303, 1175, 27, 70, "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,168"},
 CellID->21188]
}, Open  ]],
Cell[9864, 333, 340, 12, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->19569],
Cell[CellGroupData[{
Cell[10229, 349, 234, 6, 70, "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
 CellID->8638],
Cell[10466, 357, 564, 16, 70, "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,169"},
 CellID->27663]
}, Open  ]],
Cell[11045, 376, 324, 11, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->15075],
Cell[CellGroupData[{
Cell[11394, 391, 242, 7, 70, "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
 CellID->24515],
Cell[11639, 400, 411, 13, 70, "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,170"},
 CellID->11521]
}, Open  ]],
Cell[12065, 416, 235, 7, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->475],
Cell[CellGroupData[{
Cell[12325, 427, 318, 8, 70, "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
 CellID->15615],
Cell[12646, 437, 791, 23, 70, "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,171"},
 CellID->20528]
}, Open  ]],
Cell[13452, 463, 385, 11, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->13234],
Cell[CellGroupData[{
Cell[13862, 478, 230, 6, 70, "Input",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
 CellID->12570],
Cell[14095, 486, 562, 16, 70, "Output",
 CellTags->{"b:1.1.3", "Ex--21943492438155078303,172"},
 CellID->905]
}, Open  ]],
Cell[14672, 505, 235, 8, 70, "Text",
 CellTags->"b:1.1.3",
 CellID->9464]
}, Open  ]],
Cell[CellGroupData[{
Cell[14944, 518, 95, 2, 70, "Subsection",
 CellTags->{"xref:11", "c:13", "b:1.1.4"},
 CellID->19557],
Cell[15042, 522, 366, 13, 70, "Text",
 CellTags->"b:1.1.4",
 CellID->28962],
Cell[CellGroupData[{
Cell[15433, 539, 404, 10, 70, "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
 CellID->14161],
Cell[15840, 551, 124, 3, 70, "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,173"},
 CellID->30524]
}, Open  ]],
Cell[15979, 557, 100, 2, 70, "Text",
 CellTags->"b:1.1.4",
 CellID->12549],
Cell[CellGroupData[{
Cell[16104, 563, 324, 8, 70, "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
 CellID->17469],
Cell[16431, 573, 825, 24, 70, "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,174"},
 CellID->330]
}, Open  ]],
Cell[17271, 600, 432, 11, 70, "Text",
 CellTags->"b:1.1.4",
 CellID->31923],
Cell[CellGroupData[{
Cell[17728, 615, 279, 8, 70, "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
 CellID->28350],
Cell[18010, 625, 124, 3, 70, "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,175"},
 CellID->14333]
}, Open  ]],
Cell[18149, 631, 490, 12, 70, "Text",
 CellTags->"b:1.1.4",
 CellID->22925],
Cell[CellGroupData[{
Cell[18664, 647, 368, 11, 70, "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
 CellID->10910],
Cell[19035, 660, 124, 3, 70, "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,176"},
 CellID->19737]
}, Open  ]],
Cell[19174, 666, 105, 2, 70, "Text",
 CellTags->"b:1.1.4",
 CellID->16336],
Cell[CellGroupData[{
Cell[19304, 672, 231, 6, 70, "Input",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
 CellID->18337],
Cell[19538, 680, 815, 22, 70, "Output",
 CellTags->{"b:1.1.4", "Ex--21943492438155078303,177"},
 CellID->1278]
}, Open  ]],
Cell[20368, 705, 237, 8, 70, "Text",
 CellTags->"b:1.1.4",
 CellID->12393]
}, Open  ]],
Cell[CellGroupData[{
Cell[20642, 718, 93, 2, 70, "Subsection",
 CellTags->{"xref:12", "c:14", "b:1.1.5"},
 CellID->7636],
Cell[20738, 722, 477, 14, 70, "Text",
 CellTags->"b:1.1.5",
 CellID->30714],
Cell[CellGroupData[{
Cell[21240, 740, 386, 10, 70, "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
 CellID->28164],
Cell[21629, 752, 124, 3, 70, "Output",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,178"},
 CellID->31591]
}, Open  ]],
Cell[21768, 758, 98, 2, 70, "Text",
 CellTags->"b:1.1.5",
 CellID->19949],
Cell[CellGroupData[{
Cell[21891, 764, 319, 8, 70, "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
 CellID->19135],
Cell[22213, 774, 894, 26, 70, "Output",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,179"},
 CellID->2505]
}, Open  ]],
Cell[23122, 803, 255, 8, 70, "Text",
 CellTags->"b:1.1.5",
 CellID->13337],
Cell[CellGroupData[{
Cell[23402, 815, 322, 9, 70, "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
 CellID->10004],
Cell[23727, 826, 124, 3, 70, "Output",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,180"},
 CellID->16337]
}, Open  ]],
Cell[CellGroupData[{
Cell[23888, 834, 230, 6, 70, "Input",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
 CellID->2623],
Cell[24121, 842, 809, 22, 70, "Output",
 CellTags->{"b:1.1.5", "Ex--21943492438155078303,181"},
 CellID->28664]
}, Open  ]],
Cell[24945, 867, 233, 8, 70, "Text",
 CellTags->"b:1.1.5",
 CellID->9970]
}, Open  ]],
Cell[CellGroupData[{
Cell[25215, 880, 94, 2, 70, "Subsection",
 CellTags->{"xref:13", "c:15", "b:1.1.6"},
 CellID->25608],
Cell[25312, 884, 470, 14, 70, "Text",
 CellTags->"b:1.1.6",
 CellID->30568],
Cell[CellGroupData[{
Cell[25807, 902, 312, 8, 70, "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
 CellID->19281],
Cell[26122, 912, 123, 3, 70, "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,182"},
 CellID->7085]
}, Open  ]],
Cell[26260, 918, 97, 2, 70, "Text",
 CellTags->"b:1.1.6",
 CellID->9152],
Cell[CellGroupData[{
Cell[26382, 924, 319, 8, 70, "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
 CellID->18373],
Cell[26704, 934, 688, 20, 70, "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,183"},
 CellID->28652]
}, Open  ]],
Cell[27407, 957, 245, 8, 70, "Text",
 CellTags->"b:1.1.6",
 CellID->8194],
Cell[CellGroupData[{
Cell[27677, 969, 249, 7, 70, "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
 CellID->9876],
Cell[27929, 978, 124, 3, 70, "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,184"},
 CellID->23826]
}, Open  ]],
Cell[28068, 984, 101, 2, 70, "Text",
 CellTags->"b:1.1.6",
 CellID->28396],
Cell[CellGroupData[{
Cell[28194, 990, 230, 6, 70, "Input",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
 CellID->7572],
Cell[28427, 998, 216, 6, 70, "Output",
 CellTags->{"b:1.1.6", "Ex--21943492438155078303,185"},
 CellID->6249]
}, Open  ]],
Cell[28658, 1007, 234, 8, 70, "Text",
 CellTags->"b:1.1.6",
 CellID->14640]
}, Open  ]],
Cell[CellGroupData[{
Cell[28929, 1020, 95, 2, 70, "Subsection",
 CellTags->{"xref:72", "c:16", "b:1.1.7"},
 CellID->29174],
Cell[29027, 1024, 266, 6, 70, "Text",
 CellTags->"b:1.1.7",
 CellID->18819],
Cell[29296, 1032, 91, 2, 70, "Text",
 CellTags->"b:1.1.7",
 CellID->943],
Cell[CellGroupData[{
Cell[29412, 1038, 536, 15, 70, "Input",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
 CellID->32611],
Cell[29951, 1055, 168, 5, 70, "Output",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,186"},
 CellID->1941]
}, Open  ]],
Cell[30134, 1063, 106, 2, 70, "Text",
 CellTags->"b:1.1.7",
 CellID->20289],
Cell[CellGroupData[{
Cell[30265, 1069, 508, 15, 70, "Input",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
 CellID->8419],
Cell[30776, 1086, 168, 5, 70, "Output",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,187"},
 CellID->5565]
}, Open  ]],
Cell[30959, 1094, 110, 2, 70, "Text",
 CellTags->"b:1.1.7",
 CellID->3805],
Cell[CellGroupData[{
Cell[31094, 1100, 230, 6, 70, "Input",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
 CellID->7585],
Cell[31327, 1108, 565, 16, 70, "Output",
 CellTags->{"b:1.1.7", "Ex--21943492438155078303,188"},
 CellID->16216]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31941, 1130, 103, 2, 70, "Subsection",
 CellTags->{"xref:14", "c:17", "b:1.1.8"},
 CellID->31450],
Cell[32047, 1134, 122, 4, 70, "Text",
 CellTags->"b:1.1.8",
 CellID->1615],
Cell[32172, 1140, 169, 4, 70, "Input",
 CellTags->{"b:1.1.8", "Ex--21943492438155078303,189"},
 CellID->2609],
Cell[32344, 1146, 545, 15, 70, "Text",
 CellTags->"b:1.1.8",
 CellID->11064]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32938, 1167, 96, 2, 70, "Section",
 CellTags->{"xref:15", "c:18", "b:1.2"},
 CellID->9166],
Cell[33037, 1171, 438, 15, 70, "Text",
 CellTags->"b:1.2",
 CellID->16893],
Cell[CellGroupData[{
Cell[33500, 1190, 240, 6, 70, "Input",
 CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
 CellID->16074],
Cell[33743, 1198, 321, 8, 70, "Output",
 CellTags->{"b:1.2", "Ex--21943492438155078303,190"},
 CellID->13509]
}, Open  ]],
Cell[34079, 1209, 321, 8, 70, "Text",
 CellTags->"b:1.2",
 CellID->30300],
Cell[34403, 1219, 13544, 226, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:1.2",
 CellID->19695],
Cell[47950, 1447, 190, 6, 70, "Text",
 CellTags->"b:1.2",
 CellID->9573],
Cell[48143, 1455, 13791, 230, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:1.2",
 CellID->15589],
Cell[61937, 1687, 461, 13, 70, "Text",
 CellTags->"b:1.2",
 CellID->13161]
}, Open  ]]
}, Open  ]],
Cell[62425, 1704, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

