(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16604,        608]
NotebookOptionsPosition[     10128,        381]
NotebookOutlinePosition[     14211,        510]
CellTagsIndexPosition[     14117,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLInsert" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLInsert"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"SQLInsert\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inserting Data", "Title",
 CellID->26153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 " inserts data into a database. An alternative, using raw SQL, is described \
in ",
 ButtonBox["Inserting Data with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLInsertingData"],
 "."
}], "Text",
 CellTags->"b:4.1.3",
 CellID->32168],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->20825],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query. For a \
single insert this will be one, since you can only insert one row at a time. \
",
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 " also supports a batch insert, as demonstrated in ",
 ButtonBox["Performance: Batch Operation",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Performance#17968"],
 "."
}], "Text",
 CellTags->"b:4.1.3",
 CellID->9676],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLInsert",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLInsert"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["table", "TI"], ",", "{", 
     StyleBox["columns", "TI"], "}", ",", "{", 
     StyleBox["values", "TI"], "}", ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "insert data into a database", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLInsert",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLInsert"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["table", "TI"], ",", "{", 
     StyleBox["columns", "TI"], "}", ",", "{", "{", 
     StyleBox["values", "TI"], "}", "}", ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "batch insert data into a database", "TableText"]}
  }]], "DefinitionBox",
 CellID->15629],

Cell["Inserting data into a database.", "Caption",
 CellTags->"b:4.1.3",
 CellID->28650],

Cell[TextData[{
 "Here is an example that inserts data. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:4.1.3",
 CellID->2598],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.1.3",
 CellLabel->"In[1]:=",
 CellID->3309],

Cell[TextData[{
 "A new table, ",
 StyleBox["TEST",
  FontSlant->"Italic"],
 ", is created. The details of this command are described in ",
 ButtonBox["Creating Tables with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 ". "
}], "Text",
 CellTags->"b:4.1.3",
 CellID->4693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", "\[IndentingNewLine]", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<COL1\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<COL2\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1.3",
 CellLabel->"In[3]:=",
 CellID->4686],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.1.3",
 CellLabel->"Out[3]=",
 CellID->30080]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 " inserts data into this table."
}], "Text",
 CellTags->"b:4.1.3",
 CellID->10116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
   RowBox[{"{", 
    RowBox[{"10", ",", " ", "10.5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1.3",
 CellLabel->"In[4]:=",
 CellID->12249],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.1.3",
 CellLabel->"Out[4]=",
 CellID->26667]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " verifies the data stored in the database."
}], "Text",
 CellTags->"b:4.1.3",
 CellID->1528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.3",
 CellLabel->"In[5]:=",
 CellID->26679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"10", ",", "10.5`"}], "}"}], "}"}]], "Output",
 CellTags->"b:4.1.3",
 CellLabel->"Out[5]=",
 CellID->7864]
}, Open  ]],

Cell["\<\
Finally, a batch insert is carried out. The result is a list of the number of \
lines that are modified.\
\>", "Text",
 CellTags->"b:4.1.3",
 CellID->29421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", " ", "10.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "55.1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1.3",
 CellLabel->"In[6]:=",
 CellID->8405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellTags->"b:4.1.3",
 CellLabel->"Out[6]=",
 CellID->8826]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " shows that there are now three rows in this table."
}], "Text",
 CellTags->"b:4.1.3",
 CellID->6816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.3",
 CellLabel->"In[7]:=",
 CellID->7516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "10.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "55.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.3",
 CellLabel->"Out[7]=",
 CellID->27726]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 " accepts one option."
}], "Text",
 CellTags->"b:4.3",
 CellID->28666],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<Timeout\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the timeout for a query", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->29087],

Cell[TextData[{
 "Option of ",
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:4.3",
 CellID->27681],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<Timeout\>\""], "InlineFormula"],
 " can be used to cancel a query if it takes too long to execute."
}], "Text",
 CellTags->"b:4.3",
 CellID->19964],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:4.1.3",
 CellID->1340],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.1.3",
 CellLabel->"In[8]:=",
 CellID->5686],

Cell[TextData[{
 "The details of how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are mapped to types stored in the database is discussed in ",
 ButtonBox["Data Type Mapping",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"],
 "."
}], "Text",
 CellTags->"b:4.1.3",
 CellID->6021]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inserting Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 42.5777887}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "SQLInsert inserts data into a database. An alternative, using raw SQL, \
is described in Inserting Data with Raw SQL. If you find that the examples in \
this tutorial do not work as shown, you may need to install or restore the \
example database with the DatabaseExamples` package, as described in Using \
the Example Databases. The result of SQLInsert is an integer specifying the \
number of rows affected by the query. For a single insert this will be one, \
since you can only insert one row at a time. SQLInsert also supports a batch \
insert, as demonstrated in Performance: Batch Operation.", "synonyms" -> {}, 
    "title" -> "Inserting Data", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/InsertingData"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.1.3"->{
  Cell[1253, 45, 416, 13, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->32168],
  Cell[2118, 73, 700, 20, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->9676],
  Cell[3683, 121, 88, 2, 70, "Caption",
   CellTags->"b:4.1.3",
   CellID->28650],
  Cell[3774, 125, 268, 10, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->2598],
  Cell[4045, 137, 286, 9, 70, "Input",
   CellTags->"b:4.1.3",
   CellID->3309],
  Cell[4334, 148, 320, 11, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->4693],
  Cell[4679, 163, 623, 15, 70, "Input",
   CellTags->"b:4.1.3",
   CellID->4686],
  Cell[5305, 180, 89, 3, 70, "Output",
   CellTags->"b:4.1.3",
   CellID->30080],
  Cell[5409, 186, 233, 8, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->10116],
  Cell[5667, 198, 330, 9, 70, "Input",
   CellTags->"b:4.1.3",
   CellID->12249],
  Cell[6000, 209, 89, 3, 70, "Output",
   CellTags->"b:4.1.3",
   CellID->26667],
  Cell[6104, 215, 244, 8, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->1528],
  Cell[6373, 227, 165, 5, 70, "Input",
   CellTags->"b:4.1.3",
   CellID->26679],
  Cell[6541, 234, 162, 6, 70, "Output",
   CellTags->"b:4.1.3",
   CellID->7864],
  Cell[6718, 243, 166, 5, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->29421],
  Cell[6909, 252, 438, 13, 70, "Input",
   CellTags->"b:4.1.3",
   CellID->8405],
  Cell[7350, 267, 133, 5, 70, "Output",
   CellTags->"b:4.1.3",
   CellID->8826],
  Cell[7498, 275, 253, 8, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->6816],
  Cell[7776, 287, 164, 5, 70, "Input",
   CellTags->"b:4.1.3",
   CellID->7516],
  Cell[7943, 294, 306, 11, 70, "Output",
   CellTags->"b:4.1.3",
   CellID->27726],
  Cell[9399, 352, 100, 2, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->1340],
  Cell[9502, 356, 246, 7, 70, "Input",
   CellTags->"b:4.1.3",
   CellID->5686],
  Cell[9751, 365, 335, 11, 70, "Text",
   CellTags->"b:4.1.3",
   CellID->6021]},
 "b:4.3"->{
  Cell[8264, 308, 221, 8, 70, "Text",
   CellTags->"b:4.3",
   CellID->28666],
  Cell[8975, 333, 220, 9, 70, "Caption",
   CellTags->"b:4.3",
   CellID->27681],
  Cell[9198, 344, 198, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->19964]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.1.3", 11968, 421},
 {"b:4.3", 13853, 491}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 578, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1203, 42, 47, 1, 70, "Title",
 CellID->26153],
Cell[1253, 45, 416, 13, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->32168],
Cell[1672, 60, 443, 11, 70, "Text",
 CellID->20825],
Cell[2118, 73, 700, 20, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->9676],
Cell[2821, 95, 859, 24, 70, "DefinitionBox",
 CellID->15629],
Cell[3683, 121, 88, 2, 70, "Caption",
 CellTags->"b:4.1.3",
 CellID->28650],
Cell[3774, 125, 268, 10, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->2598],
Cell[4045, 137, 286, 9, 70, "Input",
 CellTags->"b:4.1.3",
 CellID->3309],
Cell[4334, 148, 320, 11, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->4693],
Cell[CellGroupData[{
Cell[4679, 163, 623, 15, 70, "Input",
 CellTags->"b:4.1.3",
 CellID->4686],
Cell[5305, 180, 89, 3, 70, "Output",
 CellTags->"b:4.1.3",
 CellID->30080]
}, Open  ]],
Cell[5409, 186, 233, 8, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->10116],
Cell[CellGroupData[{
Cell[5667, 198, 330, 9, 70, "Input",
 CellTags->"b:4.1.3",
 CellID->12249],
Cell[6000, 209, 89, 3, 70, "Output",
 CellTags->"b:4.1.3",
 CellID->26667]
}, Open  ]],
Cell[6104, 215, 244, 8, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->1528],
Cell[CellGroupData[{
Cell[6373, 227, 165, 5, 70, "Input",
 CellTags->"b:4.1.3",
 CellID->26679],
Cell[6541, 234, 162, 6, 70, "Output",
 CellTags->"b:4.1.3",
 CellID->7864]
}, Open  ]],
Cell[6718, 243, 166, 5, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->29421],
Cell[CellGroupData[{
Cell[6909, 252, 438, 13, 70, "Input",
 CellTags->"b:4.1.3",
 CellID->8405],
Cell[7350, 267, 133, 5, 70, "Output",
 CellTags->"b:4.1.3",
 CellID->8826]
}, Open  ]],
Cell[7498, 275, 253, 8, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->6816],
Cell[CellGroupData[{
Cell[7776, 287, 164, 5, 70, "Input",
 CellTags->"b:4.1.3",
 CellID->7516],
Cell[7943, 294, 306, 11, 70, "Output",
 CellTags->"b:4.1.3",
 CellID->27726]
}, Open  ]],
Cell[8264, 308, 221, 8, 70, "Text",
 CellTags->"b:4.3",
 CellID->28666],
Cell[8488, 318, 484, 13, 70, "DefinitionBox3Col",
 CellID->29087],
Cell[8975, 333, 220, 9, 70, "Caption",
 CellTags->"b:4.3",
 CellID->27681],
Cell[9198, 344, 198, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->19964],
Cell[9399, 352, 100, 2, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->1340],
Cell[9502, 356, 246, 7, 70, "Input",
 CellTags->"b:4.1.3",
 CellID->5686],
Cell[9751, 365, 335, 11, 70, "Text",
 CellTags->"b:4.1.3",
 CellID->6021]
}, Open  ]],
Cell[10101, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

