(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14436,        522]
NotebookOptionsPosition[      8511,        317]
NotebookOutlinePosition[     12362,        435]
CellTagsIndexPosition[     12292,        430]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Creating Tables with Raw SQL", "Title",
 CellID->19187],

Cell[TextData[{
 "The raw SQL command CREATE TABLE creates tables in a database. An \
alternative is to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["SQLCreateTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"]], "InlineFormula"],
 ", described in ",
 ButtonBox["Creating Tables",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 ". "
}], "Text",
 CellTags->"b:4.2.3",
 CellID->25484],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->1018],

Cell[TextData[{
 "When creating a table, the result of ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query.",
 " ",
 "If the table is created correctly, this integer will always be zero as no \
rows are affected when creating a new table."
}], "Text",
 CellTags->"b:4.2.3",
 CellID->28464],

Cell[TextData[{
 "Here is an example that creates a table. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:4.2.3",
 CellID->21119],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[1]:=",
 CellID->23152],

Cell[TextData[{
 "When a table is created, options can be given to restrict how data is \
stored within the database. In the following, a table is created with four \
columns. The ",
 StyleBox["USERNAME",
  FontSlant->"Italic"],
 " is a string-based column that cannot be ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " and is the primary key. (A primary key is important to a table as it \
uniquely identifies a row within the table.)",
 " ",
 "The other three columns (",
 StyleBox["ADDRESS",
  FontSlant->"Italic"],
 ", ",
 StyleBox["CITY",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["ZIPCODE",
  FontSlant->"Italic"],
 ") are regular string-based columns. However, they must be unique among all \
rows."
}], "Text",
 CellTags->"b:4.2.3",
 CellID->2800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", 
   "\"\<CREATE TABLE ADDRESSES (\n    USERNAME VARCHAR NOT NULL PRIMARY KEY, \
\n    ADDRESS VARCHAR,\n    CITY VARCHAR, \n    ZIPCODE VARCHAR, \n    UNIQUE \
(ADDRESS, CITY, ZIPCODE))\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[3]:=",
 CellID->18087],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[3]=",
 CellID->31060]
}, Open  ]],

Cell[TextData[{
 "In this example, a table with three columns is created. The first column is \
an integer that is an identity. This means that it is the primary key for the \
table and its value will be automatically incremented in each row. In other \
words, the value is not required when data is inserted; instead, the value \
will be the next available increment. The ",
 StyleBox["USERNAME",
  FontSlant->"Italic"],
 " is a string-based column that is the foreign key to the ",
 StyleBox["ADDRESSES",
  FontSlant->"Italic"],
 " table. The third column is a bit that has a default of 1 (i.e. if a value \
is not supplied when data is inserted it will be set to 1)."
}], "Text",
 CellTags->"b:4.2.3",
 CellID->1926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<CREATE TABLE MAILER (\n  MAILERID INT IDENTITY, \n  USERNAME VARCHAR \
NOT NULL, \n  SENDMAILER BIT DEFAULT '1' NOT NULL,\n  FOREIGN KEY (USERNAME) \
REFERENCES ADDRESSES (USERNAME))\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[4]:=",
 CellID->9010],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[4]=",
 CellID->4757]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTableNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"]], "InlineFormula"],
 " verifies the tables exist in the database."
}], "Text",
 CellTags->"b:4.2.3",
 CellID->32170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", "\"\<ADDRESSES\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[5]:=",
 CellID->20315],

Cell[BoxData[
 RowBox[{"{", "\<\"ADDRESSES\"\>", "}"}]], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[5]=",
 CellID->9576]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", "\"\<MAILER\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[6]:=",
 CellID->30227],

Cell[BoxData[
 RowBox[{"{", "\<\"MAILER\"\>", "}"}]], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[6]=",
 CellID->12043]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"]], "InlineFormula"],
 " verifies the columns were created in the database."
}], "Text",
 CellTags->"b:4.2.3",
 CellID->22758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<ADDRESSES\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[7]:=",
 CellID->7164],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"ADDRESSES\"\>", ",", "\<\"USERNAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ADDRESSES\"\>", ",", "\<\"ADDRESS\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ADDRESSES\"\>", ",", "\<\"CITY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ADDRESSES\"\>", ",", "\<\"ZIPCODE\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[7]=",
 CellID->5109]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<MAILER\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[8]:=",
 CellID->7882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"MAILER\"\>", ",", "\<\"MAILERID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"MAILER\"\>", ",", "\<\"USERNAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"MAILER\"\>", ",", "\<\"SENDMAILER\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[8]=",
 CellID->17086]
}, Open  ]],

Cell["This deletes the tables and closes the connection.", "Text",
 CellTags->"b:4.2.3",
 CellID->29565],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE MAILER\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE ADDRESSES\>\""}], "]"}], 
  ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[9]:=",
 CellID->3487],

Cell["\<\
Other options may be available to you when creating tables depending on the \
database being used. See your database documentation for information on what \
options are specifically available.\
\>", "Text",
 CellTags->"b:4.2.3",
 CellID->29577]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Creating Tables with Raw SQL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 49.9058668}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The raw SQL command CREATE TABLE creates tables in a database. An \
alternative is to use the Mathematica command SQLCreateTable, described in \
Creating Tables. If you find that the examples in this tutorial do not work \
as shown, you may need to install or restore the example database with the \
DatabaseExamples` package, as described in Using the Example Databases. When \
creating a table, the result of SQLExecute is an integer specifying the \
number of rows affected by the query. If the table is created correctly, this \
integer will always be zero as no rows are affected when creating a new \
table.", "synonyms" -> {}, "title" -> "Creating Tables with Raw SQL", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/SQLCreatingTables"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.2.3"->{
  Cell[793, 32, 510, 17, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->25484],
  Cell[1745, 66, 445, 12, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->28464],
  Cell[2193, 80, 254, 10, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->21119],
  Cell[2450, 92, 287, 9, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->23152],
  Cell[2740, 103, 827, 27, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->2800],
  Cell[3592, 134, 368, 9, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->18087],
  Cell[3963, 145, 89, 3, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->31060],
  Cell[4067, 151, 719, 15, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->1926],
  Cell[4811, 170, 350, 9, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->9010],
  Cell[5164, 181, 88, 3, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->4757],
  Cell[5267, 187, 254, 8, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->32170],
  Cell[5546, 199, 169, 5, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->20315],
  Cell[5718, 206, 126, 4, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->9576],
  Cell[5881, 215, 166, 5, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->30227],
  Cell[6050, 222, 124, 4, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->12043],
  Cell[6189, 229, 264, 8, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->22758],
  Cell[6478, 241, 174, 5, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->7164],
  Cell[6655, 248, 470, 14, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->5109],
  Cell[7162, 267, 171, 5, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->7882],
  Cell[7336, 274, 380, 12, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->17086],
  Cell[7731, 289, 104, 2, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->29565],
  Cell[7838, 293, 374, 11, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->3487],
  Cell[8215, 306, 254, 6, 70, "Text",
   CellTags->"b:4.2.3",
   CellID->29577]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.2.3", 10393, 357}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 61, 1, 70, "Title",
 CellID->19187],
Cell[793, 32, 510, 17, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->25484],
Cell[1306, 51, 436, 13, 70, "Text",
 CellID->1018],
Cell[1745, 66, 445, 12, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->28464],
Cell[2193, 80, 254, 10, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->21119],
Cell[2450, 92, 287, 9, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->23152],
Cell[2740, 103, 827, 27, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->2800],
Cell[CellGroupData[{
Cell[3592, 134, 368, 9, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->18087],
Cell[3963, 145, 89, 3, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->31060]
}, Open  ]],
Cell[4067, 151, 719, 15, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->1926],
Cell[CellGroupData[{
Cell[4811, 170, 350, 9, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->9010],
Cell[5164, 181, 88, 3, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->4757]
}, Open  ]],
Cell[5267, 187, 254, 8, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->32170],
Cell[CellGroupData[{
Cell[5546, 199, 169, 5, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->20315],
Cell[5718, 206, 126, 4, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->9576]
}, Open  ]],
Cell[CellGroupData[{
Cell[5881, 215, 166, 5, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->30227],
Cell[6050, 222, 124, 4, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->12043]
}, Open  ]],
Cell[6189, 229, 264, 8, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->22758],
Cell[CellGroupData[{
Cell[6478, 241, 174, 5, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->7164],
Cell[6655, 248, 470, 14, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->5109]
}, Open  ]],
Cell[CellGroupData[{
Cell[7162, 267, 171, 5, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->7882],
Cell[7336, 274, 380, 12, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->17086]
}, Open  ]],
Cell[7731, 289, 104, 2, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->29565],
Cell[7838, 293, 374, 11, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->3487],
Cell[8215, 306, 254, 6, 70, "Text",
 CellTags->"b:4.2.3",
 CellID->29577]
}, Open  ]],
Cell[8484, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

