(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18558,        682]
NotebookOptionsPosition[     11457,        429]
NotebookOutlinePosition[     15830,        569]
CellTagsIndexPosition[     15760,        564]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Deleting Data with Raw SQL", "Title",
 CellID->14606],

Cell[TextData[{
 "The raw SQL command DELETE deletes data from a database. An alternative is \
to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["SQLDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"],
 ", described in ",
 ButtonBox["Deleting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DeletingData"],
 ". "
}], "Text",
 CellTags->"b:4.2.6",
 CellID->10353],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->21416],

Cell[TextData[{
 "When deleting data, the result of ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->13452],

Cell[TextData[{
 "Here is an example that removes data. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->14008],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[1]:=",
 CellID->7262],

Cell[TextData[{
 "As discussed in ",
 ButtonBox["Creating Tables with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"],
 ", the ",
 StyleBox["ADDRESSES",
  FontSlant->"Italic"],
 " and ",
 StyleBox["MAILER",
  FontSlant->"Italic"],
 " tables should be created."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->22233],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", "\[IndentingNewLine]", 
    "\"\<CREATE TABLE ADDRESSES (\n    USERNAME VARCHAR NOT NULL PRIMARY KEY, \
\n    ADDRESS VARCHAR,\n    CITY VARCHAR, \n    ZIPCODE VARCHAR, \n    UNIQUE \
(ADDRESS, CITY, ZIPCODE))\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", 
    "\"\<CREATE TABLE MAILER (\n  MAILERID INT IDENTITY, \n  USERNAME VARCHAR \
NOT NULL, \n  SENDMAILER BIT DEFAULT '1' NOT NULL,\n  FOREIGN KEY (USERNAME) \
REFERENCES ADDRESSES (USERNAME))\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", 
    "\"\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) VALUES \
(`1`)\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{
        "\"\<user1\>\"", ",", "\"\<100 Trade Center\>\"", ",", 
         "\"\<Champaign, IL\>\"", ",", "\"\<61820\>\""}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{
        "\"\<user2\>\"", ",", "\"\<200 Trade Center\>\"", ",", 
         "\"\<Champaign, IL\>\"", ",", "\"\<61820\>\""}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{
        "\"\<user3\>\"", ",", "\"\<300 Trade Center\>\"", ",", 
         "\"\<Champaign, IL\>\"", ",", "\"\<61820\>\""}], "]"}], "}"}]}], 
     "}"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", 
    "\"\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES \
(`1`)\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{"Null", ",", "\"\<user1\>\"", ",", "False"}], "]"}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{"Null", ",", "\"\<user2\>\"", ",", "True"}], "]"}], "}"}]}], 
     "}"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[3]:=",
 CellID->5454],

Cell[TextData[{
 "Here are the contents of the ",
 StyleBox["ADDRESSES",
  FontSlant->"Italic"],
 " table."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->16303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM ADDRESSES\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[7]:=",
 CellID->16634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"user1\"\>", ",", "\<\"100 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user2\"\>", ",", "\<\"200 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user3\"\>", ",", "\<\"300 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[7]=",
 CellID->26303]
}, Open  ]],

Cell[TextData[{
 "Here are the contents of the ",
 StyleBox["MAILER",
  FontSlant->"Italic"],
 " table."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->14256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM MAILER\>\""}], "]"}]], "Input",\

 CellTags->"b:4.2.6",
 CellLabel->"In[8]:=",
 CellID->148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "\<\"user1\"\>", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"user2\"\>", ",", "True"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[8]=",
 CellID->11124]
}, Open  ]],

Cell[TextData[{
 "This executes an SQL statement that deletes a row in the ",
 StyleBox["MAILER",
  FontSlant->"Italic"],
 " table. It deletes any rows for which the value in the ",
 StyleBox["SENDMAILER",
  FontSlant->"Italic"],
 " column is 0 (or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "). Delete statements can be created using conditions that depend on the \
values in columns. Since one row has been deleted, the result is 1."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->12317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<DELETE FROM MAILER WHERE SENDMAILER = 0\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[9]:=",
 CellID->4213],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[9]=",
 CellID->27109]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
 CellTags->"b:4.2.6",
 CellID->24028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM MAILER\>\""}], "]"}]], "Input",\

 CellTags->"b:4.2.6",
 CellLabel->"In[10]:=",
 CellID->29200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "\<\"user2\"\>", ",", "True"}], "}"}], "}"}]], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[10]=",
 CellID->21080]
}, Open  ]],

Cell[TextData[{
 "Using prepared statements, you can dynamically create SQL statements that \
delete data within the database. You can combine this with a simple ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function. This example deletes an address for a particular user."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->21318],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteAddress", "[", "username_String", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", "\[IndentingNewLine]", "  ", 
    "\"\<DELETE FROM ADDRESSES WHERE USERNAME = `1`\>\"", ",", " ", 
    RowBox[{"{", "username", "}"}]}], "]"}]}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[11]:=",
 CellID->16858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteAddress", "[", "\"\<user3\>\"", "]"}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[12]:=",
 CellID->24050],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[12]=",
 CellID->24155]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
 CellTags->"b:4.2.6",
 CellID->31361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM ADDRESSES\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[13]:=",
 CellID->15264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"user1\"\>", ",", "\<\"100 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user2\"\>", ",", "\<\"200 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[13]=",
 CellID->11903]
}, Open  ]],

Cell[TextData[{
 "Any restrictions on the values in tables also apply when data is deleted. \
Thus, if you try to delete an ",
 StyleBox["ADDRESS",
  FontSlant->"Italic"],
 " value that is referenced by an item in the ",
 StyleBox["MAILER",
  FontSlant->"Italic"],
 " table, an error occurs."
}], "Text",
 CellTags->"b:4.2.6",
 CellID->3676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteAddress", "[", "\"\<user2\>\"", "]"}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[14]:=",
 CellID->29643],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"JDBC error: \\!\\(\\\"Integrity constraint violation SYS_\\\"\
\[Ellipsis]\\\"E FROM ADDRESSES WHERE USERNAME = ?]\\\"\\)\"\>"}]], "Message",\
 "MSG",
 CellTags->"b:4.2.6",
 CellLabel->"From In[14]:=",
 CellID->26909],

Cell[BoxData["$Failed"], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[14]=",
 CellID->14902]
}, Open  ]],

Cell["This deletes the tables and closes the connection.", "Text",
 CellTags->"b:4.2.6",
 CellID->3561],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE MAILER\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE ADDRESSES\>\""}], "]"}], 
  ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[15]:=",
 CellID->28489]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Deleting Data with Raw SQL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 50.7808612}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The raw SQL command DELETE deletes data from a database. An alternative \
is to use the Mathematica command SQLDelete, described in Deleting Data. If \
you find that the examples in this tutorial do not work as shown, you may \
need to install or restore the example database with the DatabaseExamples` \
package, as described in Using the Example Databases. When deleting data, the \
result of SQLExecute is an integer specifying the number of rows affected by \
the query.", "synonyms" -> {}, "title" -> "Deleting Data with Raw SQL", 
    "type" -> "Tutorial", "uri" -> "DatabaseLink/tutorial/SQLDeletingData"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.2.6"->{
  Cell[791, 32, 490, 17, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->10353],
  Cell[1724, 66, 311, 9, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->13452],
  Cell[2038, 77, 251, 10, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->14008],
  Cell[2292, 89, 286, 9, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->7262],
  Cell[2581, 100, 357, 14, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->22233],
  Cell[2941, 116, 2174, 57, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->5454],
  Cell[5118, 175, 157, 7, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->16303],
  Cell[5300, 186, 188, 6, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->16634],
  Cell[5491, 194, 573, 15, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->26303],
  Cell[6079, 212, 154, 7, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->14256],
  Cell[6258, 223, 182, 6, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->148],
  Cell[6443, 231, 286, 10, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->11124],
  Cell[6744, 244, 559, 16, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->12317],
  Cell[7328, 264, 236, 7, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->4213],
  Cell[7567, 273, 89, 3, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->27109],
  Cell[7671, 279, 134, 4, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->24028],
  Cell[7830, 287, 185, 6, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->29200],
  Cell[8018, 295, 184, 6, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->21080],
  Cell[8217, 304, 332, 8, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->21318],
  Cell[8552, 314, 395, 11, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->16858],
  Cell[8972, 329, 140, 4, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->24050],
  Cell[9115, 335, 90, 3, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->24155],
  Cell[9220, 341, 134, 4, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->31361],
  Cell[9379, 349, 189, 6, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->15264],
  Cell[9571, 357, 422, 12, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->11903],
  Cell[10008, 372, 341, 11, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->3676],
  Cell[10374, 387, 140, 4, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->29643],
  Cell[10517, 393, 302, 8, 70, "Message",
   CellTags->"b:4.2.6",
   CellID->26909],
  Cell[10822, 403, 96, 3, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->14902],
  Cell[10933, 409, 103, 2, 70, "Text",
   CellTags->"b:4.2.6",
   CellID->3561],
  Cell[11039, 413, 376, 11, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->28489]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.2.6", 13194, 467}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 59, 1, 70, "Title",
 CellID->14606],
Cell[791, 32, 490, 17, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->10353],
Cell[1284, 51, 437, 13, 70, "Text",
 CellID->21416],
Cell[1724, 66, 311, 9, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->13452],
Cell[2038, 77, 251, 10, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->14008],
Cell[2292, 89, 286, 9, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->7262],
Cell[2581, 100, 357, 14, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->22233],
Cell[2941, 116, 2174, 57, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->5454],
Cell[5118, 175, 157, 7, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->16303],
Cell[CellGroupData[{
Cell[5300, 186, 188, 6, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->16634],
Cell[5491, 194, 573, 15, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->26303]
}, Open  ]],
Cell[6079, 212, 154, 7, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->14256],
Cell[CellGroupData[{
Cell[6258, 223, 182, 6, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->148],
Cell[6443, 231, 286, 10, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->11124]
}, Open  ]],
Cell[6744, 244, 559, 16, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->12317],
Cell[CellGroupData[{
Cell[7328, 264, 236, 7, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->4213],
Cell[7567, 273, 89, 3, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->27109]
}, Open  ]],
Cell[7671, 279, 134, 4, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->24028],
Cell[CellGroupData[{
Cell[7830, 287, 185, 6, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->29200],
Cell[8018, 295, 184, 6, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->21080]
}, Open  ]],
Cell[8217, 304, 332, 8, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->21318],
Cell[8552, 314, 395, 11, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->16858],
Cell[CellGroupData[{
Cell[8972, 329, 140, 4, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->24050],
Cell[9115, 335, 90, 3, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->24155]
}, Open  ]],
Cell[9220, 341, 134, 4, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->31361],
Cell[CellGroupData[{
Cell[9379, 349, 189, 6, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->15264],
Cell[9571, 357, 422, 12, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->11903]
}, Open  ]],
Cell[10008, 372, 341, 11, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->3676],
Cell[CellGroupData[{
Cell[10374, 387, 140, 4, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->29643],
Cell[10517, 393, 302, 8, 70, "Message",
 CellTags->"b:4.2.6",
 CellID->26909],
Cell[10822, 403, 96, 3, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->14902]
}, Open  ]],
Cell[10933, 409, 103, 2, 70, "Text",
 CellTags->"b:4.2.6",
 CellID->3561],
Cell[11039, 413, 376, 11, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->28489]
}, Open  ]],
Cell[11430, 427, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

